/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public final class EntityKey
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Object identifier;
    private final @UnknownKeyFor @NonNull @Initialized int hashCode;
    private final @UnknownKeyFor @NonNull @Initialized EntityPersister persister;

    public EntityKey(@Nullable @UnknownKeyFor @Initialized Object id, @UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        this.persister = persister;
        if (id == null) {
            throw new AssertionFailure("null identifier (" + persister.getEntityName() + ")");
        }
        this.identifier = id;
        this.hashCode = this.generateHashCode();
    }

    private @UnknownKeyFor @NonNull @Initialized int generateHashCode() {
        int result = 17;
        String rootEntityName = this.persister.getRootEntityName();
        result = 37 * result + rootEntityName.hashCode();
        result = 37 * result + this.persister.getIdentifierType().getHashCode(this.identifier, this.persister.getFactory());
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isBatchLoadable(@UnknownKeyFor @NonNull @Initialized LoadQueryInfluencers influencers) {
        return influencers.effectivelyBatchLoadable(this.persister);
    }

    public @UnknownKeyFor @NonNull @Initialized Object getIdentifierValue() {
        return this.identifier;
    }

    public @UnknownKeyFor @NonNull @Initialized Object getIdentifier() {
        return this.identifier;
    }

    public @UnknownKeyFor @NonNull @Initialized String getEntityName() {
        return this.persister.getEntityName();
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getPersister() {
        return this.persister;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || EntityKey.class != other.getClass()) {
            return false;
        }
        EntityKey otherKey = (EntityKey)other;
        return this.samePersistentType(otherKey) && this.sameIdentifier(otherKey);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean sameIdentifier(@UnknownKeyFor @NonNull @Initialized EntityKey otherKey) {
        return this.identifier == otherKey.identifier || this.persister.getIdentifierType().isEqual(otherKey.identifier, this.identifier, this.persister.getFactory());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean samePersistentType(@UnknownKeyFor @NonNull @Initialized EntityKey otherKey) {
        return otherKey.persister == this.persister || otherKey.persister.getRootEntityName().equals(this.persister.getRootEntityName());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "EntityKey" + MessageHelper.infoString(this.persister, this.identifier, this.persister.getFactory());
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        oos.writeObject(this.identifier);
        oos.writeObject(this.persister.getEntityName());
    }

    public static @UnknownKeyFor @NonNull @Initialized EntityKey deserialize(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        Object id = ois.readObject();
        String entityName = (String)ois.readObject();
        EntityPersister entityPersister = sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        return new EntityKey(id, entityPersister);
    }
}

