/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.CollectionFetch;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;

public class EagerCollectionFetch
extends CollectionFetch {
    private final PluralTableGroup collectionTableGroup;
    private final @Nullable DomainResult<?> collectionKeyResult;
    private final DomainResult<?> collectionValueKeyResult;
    private final Fetch elementFetch;
    private final Fetch indexFetch;
    private final ImmutableFetchList fetches;
    private final CollectionInitializerProducer initializerProducer;

    public EagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, TableGroup collectionTableGroup, boolean needsCollectionKeyResult, FetchParent fetchParent, DomainResultCreationState creationState) {
        super(fetchedPath, fetchedAttribute, fetchParent);
        this.collectionTableGroup = (PluralTableGroup)collectionTableGroup;
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        NavigablePath parentPath = fetchedPath.getParent();
        TableGroup parentTableGroup = fromClauseAccess.findTableGroup(parentPath);
        ForeignKeyDescriptor keyDescriptor = fetchedAttribute.getKeyDescriptor();
        this.collectionKeyResult = needsCollectionKeyResult ? keyDescriptor.createTargetDomainResult(fetchedPath, parentTableGroup, fetchParent, creationState) : null;
        this.collectionValueKeyResult = keyDescriptor.createKeyDomainResult(fetchedPath, collectionTableGroup, ForeignKeyDescriptor.Nature.TARGET, fetchParent, creationState);
        this.fetches = creationState.visitFetches(this);
        if (fetchedAttribute.getIndexDescriptor() != null) {
            assert (this.fetches.size() == 2);
            this.indexFetch = this.fetches.get(fetchedAttribute.getIndexDescriptor());
            this.elementFetch = this.fetches.get(fetchedAttribute.getElementDescriptor());
        } else if (!this.fetches.isEmpty()) {
            assert (this.fetches.size() == 1);
            this.indexFetch = null;
            this.elementFetch = this.fetches.get(fetchedAttribute.getElementDescriptor());
        } else {
            this.indexFetch = null;
            this.elementFetch = null;
        }
        CollectionSemantics<?, ?> collectionSemantics = this.getFetchedMapping().getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(fetchedPath, fetchedAttribute, fetchParent, true, null, this.indexFetch, this.elementFetch, creationState);
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        return this.getNavigablePath().append(fetchable.getFetchableName());
    }

    public CollectionInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return this.initializerProducer.produceInitializer(this.getNavigablePath(), this.getFetchedMapping(), parent, null, this.collectionKeyResult, this.collectionValueKeyResult, false, creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        if (CollectionPart.Nature.ELEMENT.getName().equals(fetchable.getFetchableName())) {
            return this.elementFetch;
        }
        if (CollectionPart.Nature.INDEX.getName().equals(fetchable.getFetchableName())) {
            return this.indexFetch;
        }
        throw new IllegalArgumentException("Unknown fetchable [" + this.getFetchedMapping().getCollectionDescriptor().getRole() + " -> " + fetchable.getFetchableName() + "]");
    }

    @Override
    public boolean hasJoinFetches() {
        return true;
    }

    @Override
    public boolean containsCollectionFetches() {
        return true;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getFetchedMapping().getJavaType();
    }

    @Override
    public FetchParent asFetchParent() {
        return this;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        if (this.collectionKeyResult != null) {
            this.collectionKeyResult.collectValueIndexesToCache(valueIndexes);
        }
        if (!this.getFetchedMapping().getCollectionDescriptor().useShallowQueryCacheLayout()) {
            this.collectionValueKeyResult.collectValueIndexesToCache(valueIndexes);
            for (Fetch fetch : this.fetches) {
                fetch.collectValueIndexesToCache(valueIndexes);
            }
        }
    }
}

