/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.lang.reflect.Type;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.AggregateEmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class AggregateEmbeddableResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
EmbeddableResult<T>,
InitializerProducer<AggregateEmbeddableResultImpl<T>> {
    private final String resultVariable;
    private final boolean containsAnyNonScalars;
    private final SqlSelection aggregateSelection;
    private final EmbeddableMappingType fetchContainer;
    private final BasicFetch<?> discriminatorFetch;

    public AggregateEmbeddableResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart embeddedPartDescriptor, String resultVariable, DomainResultCreationState creationState) {
        super(navigablePath.append("{embeddable_result}"));
        this.fetchContainer = embeddedPartDescriptor.getEmbeddableTypeDescriptor();
        this.resultVariable = resultVariable;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.resolveTableGroup(this.getNavigablePath(), np -> {
            EmbeddableValuedModelPart embeddedValueMapping = embeddedPartDescriptor.getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
            TableGroup tg = fromClauseAccess.findTableGroup(NullnessUtil.castNonNull(np.getParent()).getParent());
            TableGroupJoin tableGroupJoin = embeddedValueMapping.createTableGroupJoin((NavigablePath)np, tg, resultVariable, null, SqlAstJoinType.INNER, true, false, sqlAstCreationState);
            tg.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        SelectableMapping selectableMapping = embeddedPartDescriptor.getEmbeddableTypeDescriptor().getAggregateMapping();
        Expression expression = sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping);
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration();
        this.aggregateSelection = sqlExpressionResolver.resolveSqlSelection(expression, typeConfiguration.getJavaTypeRegistry().resolveDescriptor((Type)((Object)Object[].class)), null, typeConfiguration);
        this.discriminatorFetch = creationState.visitEmbeddableDiscriminatorFetch(this, true);
        this.resetFetches(creationState.visitNestedFetches(this));
        this.containsAnyNonScalars = AggregateEmbeddableResultImpl.determineIfContainedAnyScalars(this.getFetches());
    }

    private static boolean determineIfContainedAnyScalars(ImmutableFetchList fetches) {
        for (Fetch fetch : fetches) {
            if (!fetch.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return this.containsAnyNonScalars;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getReferencedMappingType().getJavaType();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableAssembler(creationState.resolveInitializer(this, parent, this).asEmbeddableInitializer());
    }

    @Override
    public Initializer<?> createInitializer(AggregateEmbeddableResultImpl<T> resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parent, creationState);
    }

    @Override
    public Initializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new AggregateEmbeddableInitializerImpl(this, this.discriminatorFetch, parent, creationState, true, this.aggregateSelection);
    }
}

