/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EmbeddableInitializerImpl
extends AbstractInitializer<EmbeddableInitializerData>
implements EmbeddableInitializer<EmbeddableInitializerData> {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embedded;
    private final InitializerParent<InitializerData> parent;
    private final boolean isResultInitializer;
    private final boolean isPartOfKey;
    private final boolean createEmptyCompositesEnabled;
    private final SessionFactoryImplementor sessionFactory;
    protected final DomainResultAssembler<?>[][] assemblers;
    private final BasicResultAssembler<?> discriminatorAssembler;
    protected final Initializer<InitializerData>[][] subInitializers;

    public EmbeddableInitializerImpl(EmbeddableResultGraphNode resultDescriptor, BasicFetch<?> discriminatorFetch, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        super(creationState);
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = resultDescriptor.getReferencedMappingContainer();
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        EmbeddableMappingType embeddableTypeDescriptor = this.embedded.getEmbeddableTypeDescriptor();
        this.isPartOfKey = this.embedded.isEntityIdentifierMapping() || Initializer.isPartOfKey(this.navigablePath, parent);
        this.createEmptyCompositesEnabled = !this.isPartOfKey && embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = this.createAssemblers(resultDescriptor, creationState, embeddableTypeDescriptor);
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        this.subInitializers = EmbeddableInitializerImpl.createInitializers(this.assemblers);
    }

    protected DomainResultAssembler<?>[][] createAssemblers(EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] overallAssemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor);
            overallAssemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
        }
        if (embeddableTypeDescriptor.isPolymorphic()) {
            Collection<EmbeddableMappingType.ConcreteEmbeddableType> concreteEmbeddableTypes = embeddableTypeDescriptor.getConcreteEmbeddableTypes();
            DomainResultAssembler[][] assemblers = new DomainResultAssembler[concreteEmbeddableTypes.size()][];
            for (EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType : concreteEmbeddableTypes) {
                DomainResultAssembler[] subAssemblers = new DomainResultAssembler[overallAssemblers.length];
                for (int i = 0; i < overallAssemblers.length; ++i) {
                    if (!concreteEmbeddableType.declaresAttribute(i)) continue;
                    subAssemblers[i] = overallAssemblers[i];
                }
                assemblers[concreteEmbeddableType.getSubclassId()] = subAssemblers;
            }
            return assemblers;
        }
        return new DomainResultAssembler[][]{overallAssemblers};
    }

    protected static Initializer<InitializerData>[][] createInitializers(DomainResultAssembler<?>[][] assemblers) {
        Initializer[][] subInitializers = new Initializer[assemblers.length][];
        for (int i = 0; i < assemblers.length; ++i) {
            DomainResultAssembler<?>[] subAssemblers = assemblers[i];
            if (subAssemblers != null) {
                ArrayList initializers = new ArrayList(subAssemblers.length);
                for (DomainResultAssembler<?> assembler : subAssemblers) {
                    Initializer<?> initializer;
                    if (assembler == null || (initializer = assembler.getInitializer()) == null) continue;
                    initializers.add(initializer);
                }
                subInitializers[i] = initializers.isEmpty() ? Initializer.EMPTY_ARRAY : initializers.toArray(EMPTY_ARRAY);
                continue;
            }
            subInitializers[i] = Initializer.EMPTY_ARRAY;
        }
        return subInitializers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    @Override
    public Object getCompositeInstance(EmbeddableInitializerData data) {
        Initializer.State state = data.getState();
        return state == Initializer.State.RESOLVED || state == Initializer.State.INITIALIZED ? data.getInstance() : null;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EmbeddableInitializerData(this, rowProcessingState);
    }

    @Override
    public void resolveKey(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setInstance(null);
        if (this.discriminatorAssembler != null) {
            assert (this.embedded.getEmbeddableTypeDescriptor().getDiscriminatorMapping() != null);
            Object discriminatorValue = this.discriminatorAssembler.extractRawValue(data.getRowProcessingState());
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = data.concreteEmbeddableType = discriminatorValue == null ? null : this.embedded.getEmbeddableTypeDescriptor().findSubtypeByDiscriminator(discriminatorValue);
        }
        if (this.isPartOfKey) {
            data.setState(Initializer.State.KEY_RESOLVED);
            if (this.subInitializers.length == 0) {
                this.resolveInstance(data);
            } else {
                this.resolveKeySubInitializers(data);
            }
        } else {
            super.resolveKey(data);
        }
    }

    private void resolveKeySubInitializers(EmbeddableInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
            InitializerData subData = initializer.getData(rowProcessingState);
            initializer.resolveKey(subData);
            if (subData.getState() != Initializer.State.MISSING) continue;
            data.setState(Initializer.State.MISSING);
            return;
        }
    }

    @Override
    public void resolveInstance(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        data.setState(Initializer.State.RESOLVED);
        this.extractRowState(data);
        this.prepareCompositeInstance(data);
    }

    @Override
    public void resolveInstance(@Nullable Object instance, EmbeddableInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
                Object subInstance = initializer.getInitializedPart().asAttributeMapping().getValue(instance);
                if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                    initializer.resolveKey(rowProcessingState);
                    continue;
                }
                initializer.resolveInstance(subInstance, rowProcessingState);
            }
            if (rowProcessingState.needsResolveState()) {
                for (DomainResultAssembler<?> assembler : this.assemblers[data.getSubclassId()]) {
                    assembler.resolveState(rowProcessingState);
                }
            }
        }
    }

    @Override
    public void initializeInstance(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        if (this.embedded.getParentInjectionAttributePropertyAccess() != null || this.embedded instanceof VirtualModelPart) {
            this.handleParentInjection(data);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
            if (lazyInitializer != null) {
                if (this.parent != null) {
                    this.embedded.getEmbeddableTypeDescriptor().setValues(lazyInitializer.getImplementation(), data.rowState);
                } else {
                    Object target = this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(data, this.sessionFactory);
                    lazyInitializer.setImplementation(target);
                }
            } else {
                this.embedded.getEmbeddableTypeDescriptor().setValues(data.getInstance(), data.rowState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        EmbeddableInitializerData embeddableInitializerData = (EmbeddableInitializerData)data;
        RowProcessingState rowProcessingState = embeddableInitializerData.getRowProcessingState();
        if (embeddableInitializerData.concreteEmbeddableType == null) {
            Initializer<InitializerData>[][] initializerArray = this.subInitializers;
            int n = initializerArray.length;
            for (int i = 0; i < n; ++i) {
                Initializer<InitializerData>[] initializers;
                for (Initializer<InitializerData> initializer : initializers = initializerArray[i]) {
                    consumer.accept(initializer, rowProcessingState);
                }
            }
        } else {
            for (Initializer<InitializerData> initializer : this.subInitializers[embeddableInitializerData.getSubclassId()]) {
                consumer.accept(initializer, rowProcessingState);
            }
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, EmbeddableInitializerData data) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        data.setInstance(instance);
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
                initializer.initializeInstanceFromParent(instance, data.getRowProcessingState());
            }
        }
    }

    private void prepareCompositeInstance(EmbeddableInitializerData data) {
        if (this.parent != null && this.embedded instanceof VirtualModelPart && !this.isPartOfKey) {
            Object subData = this.parent.getData(data.getRowProcessingState());
            this.parent.resolveInstance((InitializerData)subData);
            data.setInstance(this.parent.getResolvedInstance((InitializerData)subData));
            if (data.getState() == Initializer.State.INITIALIZED) {
                return;
            }
        }
        if (data.getInstance() == null) {
            data.setInstance(this.createCompositeInstance(data));
        }
    }

    private void extractRowState(EmbeddableInitializerData data) {
        boolean stateAllNull = true;
        DomainResultAssembler<?>[] subAssemblers = this.assemblers[data.getSubclassId()];
        for (int i = 0; i < subAssemblers.length; ++i) {
            DomainResultAssembler<?> assembler = subAssemblers[i];
            Object contributorValue = assembler == null ? null : assembler.assemble(data.getRowProcessingState());
            data.rowState[i] = contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY ? null : contributorValue;
            if (contributorValue != null) {
                stateAllNull = false;
                continue;
            }
            if (!this.isPartOfKey) continue;
            stateAllNull = true;
            break;
        }
        if (stateAllNull) {
            data.setState(Initializer.State.MISSING);
        }
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        EmbeddableInitializerData data = (EmbeddableInitializerData)this.getData(rowProcessingState);
        for (DomainResultAssembler<?> assembler : this.assemblers[data.getSubclassId()]) {
            assembler.resolveState(rowProcessingState);
        }
    }

    private Object createCompositeInstance(EmbeddableInitializerData data) {
        if (data.getState() == Initializer.State.MISSING && !this.createEmptyCompositesEnabled) {
            return null;
        }
        EmbeddableInstantiator instantiator = data.concreteEmbeddableType == null ? this.embedded.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator() : data.concreteEmbeddableType.getInstantiator();
        Object instance = instantiator.instantiate(data, this.sessionFactory);
        data.setState(Initializer.State.RESOLVED);
        return instance;
    }

    private void handleParentInjection(EmbeddableInitializerData data) {
        PropertyAccess parentInjectionAccess = this.embedded.getParentInjectionAttributePropertyAccess();
        if (parentInjectionAccess == null) {
            return;
        }
        Initializer<?> owningInitializer = this.determineOwningInitializer();
        Object parent = this.determineParentInstance(owningInitializer, data.getRowProcessingState());
        if (parent == null) {
            return;
        }
        Setter setter = parentInjectionAccess.getSetter();
        assert (setter != null);
        setter.set(data.getInstance(), parent);
    }

    private Initializer<?> determineOwningInitializer() {
        for (InitializerParent<InitializerData> parent = this.parent; parent != null; parent = parent.getParent()) {
            if (parent.isEmbeddableInitializer()) continue;
            return parent;
        }
        throw new UnsupportedOperationException("Injection of parent instance into embeddable result is not possible");
    }

    private Object determineParentInstance(Initializer<?> parentInitializer, RowProcessingState rowProcessingState) {
        if (parentInitializer == null) {
            throw new UnsupportedOperationException("Cannot determine Embeddable: " + this.navigablePath + " parent instance, parent initializer is null");
        }
        CollectionInitializer<?> collectionInitializer = parentInitializer.asCollectionInitializer();
        if (collectionInitializer != null) {
            return collectionInitializer.getCollectionInstance(rowProcessingState).getOwner();
        }
        EntityInitializer<?> parentEntityInitializer = parentInitializer.asEntityInitializer();
        if (parentEntityInitializer != null) {
            return parentEntityInitializer.getTargetInstance(rowProcessingState);
        }
        throw new UnsupportedOperationException("The Embeddable: " + this.navigablePath + " parent initializer is neither an instance of an EntityInitializer nor of a CollectionInitializer");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    public static class EmbeddableInitializerData
    extends InitializerData
    implements ValueAccess {
        protected final InitializerData parentData;
        protected final Object[] rowState;
        protected EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType;

        public EmbeddableInitializerData(EmbeddableInitializerImpl initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            this.parentData = initializer.parent == null ? null : initializer.parent.getData(rowProcessingState);
            EmbeddableMappingType embeddableTypeDescriptor = initializer.embedded.getEmbeddableTypeDescriptor();
            int size = embeddableTypeDescriptor.getNumberOfFetchables();
            this.rowState = new Object[size];
        }

        @Override
        public Object[] getValues() {
            return this.getState() == Initializer.State.MISSING ? null : this.rowState;
        }

        @Override
        public <T> T getValue(int i, Class<T> clazz) {
            return this.getState() == Initializer.State.MISSING ? null : (T)clazz.cast(this.rowState[i]);
        }

        @Override
        public Object getOwner() {
            return this.parentData == null ? null : this.parentData.getInstance();
        }

        public int getSubclassId() {
            return this.concreteEmbeddableType == null ? 0 : this.concreteEmbeddableType.getSubclassId();
        }
    }
}

