/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicInstantiationAssemblerMapImpl
implements DomainResultAssembler<Map<?, ?>> {
    private final JavaType<Map<?, ?>> mapJavaType;
    private final List<ArgumentReader<?>> argumentReaders;

    public DynamicInstantiationAssemblerMapImpl(JavaType<Map<?, ?>> mapJavaType, List<ArgumentReader<?>> argumentReaders) {
        this.mapJavaType = mapJavaType;
        this.argumentReaders = argumentReaders;
        HashSet<String> aliases = new HashSet<String>();
        for (ArgumentReader<?> argumentReader : argumentReaders) {
            if (argumentReader.getAlias() == null) {
                throw new IllegalStateException("alias for Map dynamic instantiation argument cannot be null");
            }
            if (aliases.add(argumentReader.getAlias())) continue;
            throw new IllegalStateException("Encountered duplicate alias for Map dynamic instantiation argument [" + argumentReader.getAlias() + "]");
        }
    }

    private DynamicInstantiationAssemblerMapImpl(List<ArgumentReader<?>> argumentReaders, JavaType<Map<?, ?>> mapJavaType) {
        this.mapJavaType = mapJavaType;
        this.argumentReaders = argumentReaders;
    }

    @Override
    public JavaType<Map<?, ?>> getAssembledJavaType() {
        return this.mapJavaType;
    }

    @Override
    public Map<?, ?> assemble(RowProcessingState rowProcessingState) {
        HashMap result = new HashMap();
        for (ArgumentReader<?> argumentReader : this.argumentReaders) {
            result.put(argumentReader.getAlias(), argumentReader.assemble(rowProcessingState));
        }
        return result;
    }

    @Override
    public <X> void forEachResultAssembler(BiConsumer<Initializer<?>, X> consumer, X arg) {
        for (ArgumentReader<?> argumentReader : this.argumentReaders) {
            argumentReader.forEachResultAssembler(consumer, arg);
        }
    }
}

