/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.type.descriptor.WrapperOptions;

@Internal
public final class IdentifierGeneratorHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IdentifierGeneratorHelper.class);
    @Deprecated(forRemoval=true, since="6.2")
    public static final Serializable SHORT_CIRCUIT_INDICATOR = new Serializable(){

        public String toString() {
            return "SHORT_CIRCUIT_INDICATOR";
        }
    };
    @Deprecated(forRemoval=true, since="6.2")
    public static final Serializable POST_INSERT_INDICATOR = new Serializable(){

        public String toString() {
            return "POST_INSERT_INDICATOR";
        }
    };

    @Deprecated(since="6.5", forRemoval=true)
    public static Object getGeneratedIdentity(String path, ResultSet resultSet, PostInsertIdentityPersister persister, WrapperOptions wrapperOptions) throws SQLException {
        if (!resultSet.next()) {
            throw new HibernateException("The database returned no natively generated identity value : " + path);
        }
        JdbcMapping identifierType = ((SqlTypedMapping)((Object)persister.getIdentifierMapping())).getJdbcMapping();
        Object id = identifierType.getJdbcValueExtractor().extract(resultSet, IdentifierGeneratorHelper.columnIndex(resultSet, persister), wrapperOptions);
        LOG.debugf("Natively generated identity (%s) : %s", path, id);
        return id;
    }

    private static int columnIndex(ResultSet resultSet, PostInsertIdentityPersister persister) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            String keyColumnName = persister.getRootTableKeyColumnNames()[0];
            Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!IdentifierGeneratorHelper.equal(keyColumnName, metaData.getColumnName(i), dialect)) continue;
                return i;
            }
        }
        catch (SQLException e) {
            LOG.debugf("Could not determine column index from JDBC metadata", e);
        }
        return 1;
    }

    private static boolean equal(String keyColumnName, String alias, Dialect dialect) {
        return alias.equalsIgnoreCase(keyColumnName) || alias.equalsIgnoreCase(StringHelper.unquote(keyColumnName, dialect));
    }

    public static IntegralDataTypeHolder getIntegralDataTypeHolder(Class<?> integralType) {
        if (integralType == Long.class || integralType == Integer.class || integralType == Short.class) {
            return new BasicHolder(integralType);
        }
        if (integralType == BigInteger.class) {
            return new BigIntegerHolder();
        }
        if (integralType == BigDecimal.class) {
            return new BigDecimalHolder();
        }
        throw new IdentifierGenerationException("Unknown integral data type for ids : " + integralType.getName());
    }

    public static long extractLong(IntegralDataTypeHolder holder) {
        if (holder.getClass() == BasicHolder.class) {
            ((BasicHolder)holder).checkInitialized();
            return ((BasicHolder)holder).value;
        }
        if (holder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)holder).checkInitialized();
            return ((BigIntegerHolder)holder).value.longValue();
        }
        if (holder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)holder).checkInitialized();
            return ((BigDecimalHolder)holder).value.longValue();
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + holder + "]");
    }

    public static BigInteger extractBigInteger(IntegralDataTypeHolder holder) {
        if (holder.getClass() == BasicHolder.class) {
            ((BasicHolder)holder).checkInitialized();
            return BigInteger.valueOf(((BasicHolder)holder).value);
        }
        if (holder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)holder).checkInitialized();
            return ((BigIntegerHolder)holder).value;
        }
        if (holder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)holder).checkInitialized();
            return ((BigDecimalHolder)holder).value.toBigInteger();
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + holder + "]");
    }

    public static BigDecimal extractBigDecimal(IntegralDataTypeHolder holder) {
        if (holder.getClass() == BasicHolder.class) {
            ((BasicHolder)holder).checkInitialized();
            return BigDecimal.valueOf(((BasicHolder)holder).value);
        }
        if (holder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)holder).checkInitialized();
            return new BigDecimal(((BigIntegerHolder)holder).value);
        }
        if (holder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)holder).checkInitialized();
            return ((BigDecimalHolder)holder).value;
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + holder + "]");
    }

    private IdentifierGeneratorHelper() {
    }

    @Internal
    public static class BasicHolder
    implements IntegralDataTypeHolder {
        private final Class<?> exactType;
        private long value = Long.MIN_VALUE;

        public BasicHolder(Class<?> exactType) {
            this.exactType = exactType;
            if (exactType != Long.class && exactType != Integer.class && exactType != Short.class) {
                throw new IdentifierGenerationException("Invalid type for basic integral holder : " + exactType);
            }
        }

        public long getActualLongValue() {
            return this.value;
        }

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = value;
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            long value = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                value = defaultValue;
            }
            return this.initialize(value);
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            LOG.tracef("binding parameter [%s] - [%s]", position, this.value);
            preparedStatement.setLong(position, this.value);
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            ++this.value;
            return this;
        }

        private void checkInitialized() {
            if (this.value == Long.MIN_VALUE) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long addend) {
            this.checkInitialized();
            this.value += addend;
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            --this.value;
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value -= subtrahend;
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            return this.multiplyBy(IdentifierGeneratorHelper.extractLong(factor));
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value *= factor;
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            return this.eq(IdentifierGeneratorHelper.extractLong(other));
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value == value;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            return this.lt(IdentifierGeneratorHelper.extractLong(other));
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value < value;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            return this.gt(IdentifierGeneratorHelper.extractLong(other));
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value > value;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BasicHolder copy = new BasicHolder(this.exactType);
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            if (this.exactType == Long.class) {
                return this.value;
            }
            if (this.exactType == Integer.class) {
                return (int)this.value;
            }
            return (short)this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            ++this.value;
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value += addend;
            return result;
        }

        public String toString() {
            return "BasicHolder[" + this.exactType.getName() + "[" + this.value + "]]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicHolder that = (BasicHolder)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class BigIntegerHolder
    implements IntegralDataTypeHolder {
        private BigInteger value;

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = BigInteger.valueOf(value);
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            BigDecimal rsValue = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(defaultValue);
            }
            this.value = rsValue.setScale(0, RoundingMode.UNNECESSARY).toBigInteger();
            return this;
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            preparedStatement.setBigDecimal(position, new BigDecimal(this.value));
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long increment) {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.valueOf(increment));
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.ONE);
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.valueOf(subtrahend));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            this.checkInitialized();
            this.value = this.value.multiply(IdentifierGeneratorHelper.extractBigInteger(factor));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value = this.value.multiply(BigInteger.valueOf(factor));
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(other)) == 0;
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) == 0;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(other)) < 0;
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) < 0;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(other)) > 0;
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(value)) > 0;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BigIntegerHolder copy = new BigIntegerHolder();
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            this.value = this.value.add(BigInteger.ONE);
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value = this.value.add(BigInteger.valueOf(addend));
            return result;
        }

        public String toString() {
            return "BigIntegerHolder[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigIntegerHolder that = (BigIntegerHolder)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }

    public static class BigDecimalHolder
    implements IntegralDataTypeHolder {
        private BigDecimal value;

        @Override
        public IntegralDataTypeHolder initialize(long value) {
            this.value = BigDecimal.valueOf(value);
            return this;
        }

        @Override
        public IntegralDataTypeHolder initialize(ResultSet resultSet, long defaultValue) throws SQLException {
            BigDecimal rsValue = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(defaultValue);
            }
            this.value = rsValue.setScale(0, RoundingMode.UNNECESSARY);
            return this;
        }

        @Override
        public void bind(PreparedStatement preparedStatement, int position) throws SQLException {
            preparedStatement.setBigDecimal(position, this.value);
        }

        @Override
        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        @Override
        public IntegralDataTypeHolder add(long increment) {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.valueOf(increment));
            return this;
        }

        @Override
        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.ONE);
            return this;
        }

        @Override
        public IntegralDataTypeHolder subtract(long subtrahend) {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.valueOf(subtrahend));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder factor) {
            this.checkInitialized();
            this.value = this.value.multiply(IdentifierGeneratorHelper.extractBigDecimal(factor));
            return this;
        }

        @Override
        public IntegralDataTypeHolder multiplyBy(long factor) {
            this.checkInitialized();
            this.value = this.value.multiply(BigDecimal.valueOf(factor));
            return this;
        }

        @Override
        public boolean eq(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(other)) == 0;
        }

        @Override
        public boolean eq(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) == 0;
        }

        @Override
        public boolean lt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(other)) < 0;
        }

        @Override
        public boolean lt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) < 0;
        }

        @Override
        public boolean gt(IntegralDataTypeHolder other) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(other)) > 0;
        }

        @Override
        public boolean gt(long value) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(value)) > 0;
        }

        @Override
        public IntegralDataTypeHolder copy() {
            BigDecimalHolder copy = new BigDecimalHolder();
            copy.value = this.value;
            return copy;
        }

        @Override
        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        @Override
        public Number makeValueThenIncrement() {
            Number result = this.makeValue();
            this.value = this.value.add(BigDecimal.ONE);
            return result;
        }

        @Override
        public Number makeValueThenAdd(long addend) {
            Number result = this.makeValue();
            this.value = this.value.add(BigDecimal.valueOf(addend));
            return result;
        }

        public String toString() {
            return "BigDecimalHolder[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigDecimalHolder that = (BigDecimalHolder)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

