/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.tuple.TupleResult;
import org.hibernate.type.descriptor.java.JavaType;

public class SqlTuple
implements Expression,
SqlTupleContainer,
DomainResultProducer,
Assignable {
    private final List<? extends Expression> expressions;
    private final MappingModelExpressible valueMapping;

    public SqlTuple(List<? extends Expression> expressions, MappingModelExpressible valueMapping) {
        int size;
        this.expressions = expressions;
        this.valueMapping = valueMapping;
        if (SqlTreeCreationLogger.LOGGER.isDebugEnabled() && (size = expressions.size()) < 2) {
            SqlTreeCreationLogger.LOGGER.debugf("SqlTuple created with `%s` expression(s)", size);
        }
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this.valueMapping;
    }

    public List<? extends Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return this.expressions;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTuple(this);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        JavaType javaType = ((SqmExpressible)((Object)this.valueMapping)).getExpressibleJavaType();
        int[] valuesArrayPositions = new int[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = this.expressions.get(i);
            valuesArrayPositions[i] = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(expression, expression.getExpressionType().getSingleJdbcMapping().getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration()).getValuesArrayPosition();
        }
        return new TupleResult(valuesArrayPositions, resultVariable, javaType);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private final MappingModelExpressible valueMapping;
        private List<Expression> expressions;

        public Builder(MappingModelExpressible valueMapping) {
            this.valueMapping = valueMapping;
        }

        public Builder(MappingModelExpressible valueMapping, int jdbcTypeCount) {
            this(valueMapping);
            this.expressions = new ArrayList<Expression>(jdbcTypeCount);
        }

        public void addSubExpression(Expression expression) {
            if (this.expressions == null) {
                this.expressions = new ArrayList<Expression>();
            }
            this.expressions.add(expression);
        }

        public SqlTuple buildTuple() {
            return new SqlTuple(this.expressions == null ? Collections.emptyList() : this.expressions, this.valueMapping);
        }
    }
}

