
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.hibernate.boot.jaxb.mapping.DiscriminatedAssociation.Key;


/**
 * 
 *                 Describes the "foreign key" of a discriminated association (any, many-to-any).
 *             
 * 
 * <p>Java class for hbm-any-key complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="hbm-any-key">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="type" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="column" type="{http://www.hibernate.org/xsd/orm/mapping}column" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "hbm-any-key", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "type",
    "columns"
})
public class JaxbHbmAnyKey
    implements Serializable, Key
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String type;
    @XmlElement(name = "column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbColumn> columns;

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the columns property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the columns property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getColumns().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbColumn }
     * 
     * 
     * @return
     *     The value of the columns property.
     */
    public List<JaxbColumn> getColumns() {
        if (columns == null) {
            columns = new ArrayList<>();
        }
        return this.columns;
    }

}
