
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.hql;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast", "CheckReturnValue"})
public class HqlParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.13.0", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COMMENT=2, INTEGER_LITERAL=3, LONG_LITERAL=4, FLOAT_LITERAL=5, DOUBLE_LITERAL=6, 
		BIG_INTEGER_LITERAL=7, BIG_DECIMAL_LITERAL=8, HEX_LITERAL=9, STRING_LITERAL=10, 
		JAVA_STRING_LITERAL=11, BINARY_LITERAL=12, TIMESTAMP_ESCAPE_START=13, 
		DATE_ESCAPE_START=14, TIME_ESCAPE_START=15, EQUAL=16, NOT_EQUAL=17, GREATER=18, 
		GREATER_EQUAL=19, LESS=20, LESS_EQUAL=21, COMMA=22, DOT=23, LEFT_PAREN=24, 
		RIGHT_PAREN=25, LEFT_BRACKET=26, RIGHT_BRACKET=27, LEFT_BRACE=28, RIGHT_BRACE=29, 
		PLUS=30, MINUS=31, ASTERISK=32, SLASH=33, PERCENT_OP=34, AMPERSAND=35, 
		SEMICOLON=36, COLON=37, PIPE=38, DOUBLE_PIPE=39, QUESTION_MARK=40, ARROW=41, 
		ID=42, VERSION=43, VERSIONED=44, NATURALID=45, FK=46, ALL=47, AND=48, 
		ANY=49, AS=50, ASC=51, AVG=52, BETWEEN=53, BOTH=54, BREADTH=55, BY=56, 
		CASE=57, CAST=58, COLLATE=59, COLUMN=60, CONFLICT=61, CONSTRAINT=62, CONTAINS=63, 
		COUNT=64, CROSS=65, CUBE=66, CURRENT=67, CURRENT_DATE=68, CURRENT_INSTANT=69, 
		CURRENT_TIME=70, CURRENT_TIMESTAMP=71, CYCLE=72, DATE=73, DATETIME=74, 
		DAY=75, DEFAULT=76, DELETE=77, DEPTH=78, DESC=79, DISTINCT=80, DO=81, 
		ELEMENT=82, ELEMENTS=83, ELSE=84, EMPTY=85, END=86, ENTRY=87, EPOCH=88, 
		ERROR=89, ESCAPE=90, EVERY=91, EXCEPT=92, EXCLUDE=93, EXISTS=94, EXTRACT=95, 
		FETCH=96, FILTER=97, FIRST=98, FOLLOWING=99, FOR=100, FORMAT=101, FROM=102, 
		FULL=103, FUNCTION=104, GROUP=105, GROUPS=106, HAVING=107, HOUR=108, IGNORE=109, 
		ILIKE=110, IN=111, INCLUDES=112, INDEX=113, INDICES=114, INNER=115, INSERT=116, 
		INSTANT=117, INTERSECT=118, INTERSECTS=119, INTO=120, IS=121, JOIN=122, 
		KEY=123, KEYS=124, LAST=125, LATERAL=126, LEADING=127, LEFT=128, LIKE=129, 
		LIMIT=130, LIST=131, LISTAGG=132, LOCAL=133, LOCAL_DATE=134, LOCAL_DATETIME=135, 
		LOCAL_TIME=136, MAP=137, MATERIALIZED=138, MAX=139, MAXELEMENT=140, MAXINDEX=141, 
		MEMBER=142, MICROSECOND=143, MILLISECOND=144, MIN=145, MINELEMENT=146, 
		MININDEX=147, MINUTE=148, MONTH=149, NANOSECOND=150, NEW=151, NEXT=152, 
		NO=153, NOT=154, NOTHING=155, NULLS=156, OBJECT=157, OF=158, OFFSET=159, 
		OFFSET_DATETIME=160, ON=161, ONLY=162, OR=163, ORDER=164, OTHERS=165, 
		OUTER=166, OVER=167, OVERFLOW=168, OVERLAY=169, PAD=170, PARTITION=171, 
		PERCENT=172, PLACING=173, POSITION=174, PRECEDING=175, QUARTER=176, RANGE=177, 
		RESPECT=178, RIGHT=179, ROLLUP=180, ROW=181, ROWS=182, SEARCH=183, SECOND=184, 
		SELECT=185, SET=186, SIZE=187, SOME=188, SUBSTRING=189, SUM=190, THEN=191, 
		TIES=192, TIME=193, TIMESTAMP=194, TIMEZONE_HOUR=195, TIMEZONE_MINUTE=196, 
		TO=197, TRAILING=198, TREAT=199, TRIM=200, TRUNC=201, TRUNCATE=202, TYPE=203, 
		UNBOUNDED=204, UNION=205, UPDATE=206, USING=207, VALUE=208, VALUES=209, 
		WEEK=210, WHEN=211, WHERE=212, WITH=213, WITHIN=214, WITHOUT=215, YEAR=216, 
		ZONED=217, TRUE=218, FALSE=219, NULL=220, IDENTIFIER=221, QUOTED_IDENTIFIER=222;
	public static final int
		RULE_statement = 0, RULE_selectStatement = 1, RULE_subquery = 2, RULE_targetEntity = 3, 
		RULE_deleteStatement = 4, RULE_updateStatement = 5, RULE_setClause = 6, 
		RULE_assignment = 7, RULE_insertStatement = 8, RULE_targetFields = 9, 
		RULE_valuesList = 10, RULE_values = 11, RULE_conflictClause = 12, RULE_conflictTarget = 13, 
		RULE_conflictAction = 14, RULE_withClause = 15, RULE_cte = 16, RULE_cteAttributes = 17, 
		RULE_searchClause = 18, RULE_searchSpecifications = 19, RULE_searchSpecification = 20, 
		RULE_cycleClause = 21, RULE_queryExpression = 22, RULE_orderedQuery = 23, 
		RULE_setOperator = 24, RULE_queryOrder = 25, RULE_query = 26, RULE_fromClause = 27, 
		RULE_entityWithJoins = 28, RULE_fromRoot = 29, RULE_entityName = 30, RULE_variable = 31, 
		RULE_crossJoin = 32, RULE_jpaCollectionJoin = 33, RULE_join = 34, RULE_joinType = 35, 
		RULE_joinTarget = 36, RULE_joinRestriction = 37, RULE_selectClause = 38, 
		RULE_selectionList = 39, RULE_selection = 40, RULE_selectExpression = 41, 
		RULE_mapEntrySelection = 42, RULE_instantiation = 43, RULE_instantiationTarget = 44, 
		RULE_instantiationArguments = 45, RULE_instantiationArgument = 46, RULE_instantiationArgumentExpression = 47, 
		RULE_jpaSelectObjectSyntax = 48, RULE_simplePath = 49, RULE_simplePathElement = 50, 
		RULE_path = 51, RULE_pathContinuation = 52, RULE_syntacticDomainPath = 53, 
		RULE_generalPathFragment = 54, RULE_indexedPathAccessFragment = 55, RULE_slicedPathAccessFragment = 56, 
		RULE_treatedNavigablePath = 57, RULE_collectionValueNavigablePath = 58, 
		RULE_mapKeyNavigablePath = 59, RULE_groupByClause = 60, RULE_groupByExpression = 61, 
		RULE_havingClause = 62, RULE_orderByClause = 63, RULE_orderByFragment = 64, 
		RULE_sortSpecification = 65, RULE_nullsPrecedence = 66, RULE_sortExpression = 67, 
		RULE_sortDirection = 68, RULE_collateFunction = 69, RULE_collation = 70, 
		RULE_limitClause = 71, RULE_offsetClause = 72, RULE_fetchClause = 73, 
		RULE_fetchCountOrPercent = 74, RULE_parameterOrIntegerLiteral = 75, RULE_parameterOrNumberLiteral = 76, 
		RULE_whereClause = 77, RULE_predicate = 78, RULE_comparisonOperator = 79, 
		RULE_inList = 80, RULE_likeEscape = 81, RULE_expression = 82, RULE_primaryExpression = 83, 
		RULE_expressionOrPredicate = 84, RULE_collectionQuantifier = 85, RULE_elementValueQuantifier = 86, 
		RULE_indexKeyQuantifier = 87, RULE_elementsValuesQuantifier = 88, RULE_indicesKeysQuantifier = 89, 
		RULE_multiplicativeOperator = 90, RULE_additiveOperator = 91, RULE_signOperator = 92, 
		RULE_entityTypeReference = 93, RULE_entityIdReference = 94, RULE_entityVersionReference = 95, 
		RULE_entityNaturalIdReference = 96, RULE_toOneFkReference = 97, RULE_caseList = 98, 
		RULE_simpleCaseList = 99, RULE_simpleCaseWhen = 100, RULE_caseOtherwise = 101, 
		RULE_searchedCaseList = 102, RULE_searchedCaseWhen = 103, RULE_literal = 104, 
		RULE_booleanLiteral = 105, RULE_numericLiteral = 106, RULE_binaryLiteral = 107, 
		RULE_temporalLiteral = 108, RULE_dateTimeLiteral = 109, RULE_localDateTimeLiteral = 110, 
		RULE_zonedDateTimeLiteral = 111, RULE_offsetDateTimeLiteral = 112, RULE_dateLiteral = 113, 
		RULE_timeLiteral = 114, RULE_dateTime = 115, RULE_localDateTime = 116, 
		RULE_zonedDateTime = 117, RULE_offsetDateTime = 118, RULE_offsetDateTimeWithMinutes = 119, 
		RULE_date = 120, RULE_time = 121, RULE_offset = 122, RULE_offsetWithMinutes = 123, 
		RULE_year = 124, RULE_month = 125, RULE_day = 126, RULE_hour = 127, RULE_minute = 128, 
		RULE_second = 129, RULE_zoneId = 130, RULE_jdbcTimestampLiteral = 131, 
		RULE_jdbcDateLiteral = 132, RULE_jdbcTimeLiteral = 133, RULE_genericTemporalLiteralText = 134, 
		RULE_arrayLiteral = 135, RULE_generalizedLiteral = 136, RULE_generalizedLiteralType = 137, 
		RULE_generalizedLiteralText = 138, RULE_parameter = 139, RULE_function = 140, 
		RULE_jpaNonstandardFunction = 141, RULE_jpaNonstandardFunctionName = 142, 
		RULE_columnFunction = 143, RULE_genericFunction = 144, RULE_genericFunctionName = 145, 
		RULE_genericFunctionArguments = 146, RULE_collectionSizeFunction = 147, 
		RULE_collectionAggregateFunction = 148, RULE_collectionFunctionMisuse = 149, 
		RULE_aggregateFunction = 150, RULE_everyFunction = 151, RULE_anyFunction = 152, 
		RULE_everyAllQuantifier = 153, RULE_anySomeQuantifier = 154, RULE_listaggFunction = 155, 
		RULE_onOverflowClause = 156, RULE_withinGroupClause = 157, RULE_filterClause = 158, 
		RULE_nullsClause = 159, RULE_nthSideClause = 160, RULE_overClause = 161, 
		RULE_partitionClause = 162, RULE_frameClause = 163, RULE_frameStart = 164, 
		RULE_frameEnd = 165, RULE_frameExclusion = 166, RULE_standardFunction = 167, 
		RULE_castFunction = 168, RULE_castTarget = 169, RULE_castTargetType = 170, 
		RULE_substringFunction = 171, RULE_substringFunctionStartArgument = 172, 
		RULE_substringFunctionLengthArgument = 173, RULE_trimFunction = 174, RULE_trimSpecification = 175, 
		RULE_trimCharacter = 176, RULE_padFunction = 177, RULE_padSpecification = 178, 
		RULE_padCharacter = 179, RULE_padLength = 180, RULE_overlayFunction = 181, 
		RULE_overlayFunctionStringArgument = 182, RULE_overlayFunctionReplacementArgument = 183, 
		RULE_overlayFunctionStartArgument = 184, RULE_overlayFunctionLengthArgument = 185, 
		RULE_currentDateFunction = 186, RULE_currentTimeFunction = 187, RULE_currentTimestampFunction = 188, 
		RULE_instantFunction = 189, RULE_localDateTimeFunction = 190, RULE_offsetDateTimeFunction = 191, 
		RULE_localDateFunction = 192, RULE_localTimeFunction = 193, RULE_formatFunction = 194, 
		RULE_format = 195, RULE_extractFunction = 196, RULE_truncFunction = 197, 
		RULE_extractField = 198, RULE_datetimeField = 199, RULE_dayField = 200, 
		RULE_weekField = 201, RULE_timeZoneField = 202, RULE_dateOrTimeField = 203, 
		RULE_positionFunction = 204, RULE_positionFunctionPatternArgument = 205, 
		RULE_positionFunctionStringArgument = 206, RULE_cube = 207, RULE_rollup = 208, 
		RULE_nakedIdentifier = 209, RULE_identifier = 210;
	private static String[] makeRuleNames() {
		return new String[] {
			"statement", "selectStatement", "subquery", "targetEntity", "deleteStatement", 
			"updateStatement", "setClause", "assignment", "insertStatement", "targetFields", 
			"valuesList", "values", "conflictClause", "conflictTarget", "conflictAction", 
			"withClause", "cte", "cteAttributes", "searchClause", "searchSpecifications", 
			"searchSpecification", "cycleClause", "queryExpression", "orderedQuery", 
			"setOperator", "queryOrder", "query", "fromClause", "entityWithJoins", 
			"fromRoot", "entityName", "variable", "crossJoin", "jpaCollectionJoin", 
			"join", "joinType", "joinTarget", "joinRestriction", "selectClause", 
			"selectionList", "selection", "selectExpression", "mapEntrySelection", 
			"instantiation", "instantiationTarget", "instantiationArguments", "instantiationArgument", 
			"instantiationArgumentExpression", "jpaSelectObjectSyntax", "simplePath", 
			"simplePathElement", "path", "pathContinuation", "syntacticDomainPath", 
			"generalPathFragment", "indexedPathAccessFragment", "slicedPathAccessFragment", 
			"treatedNavigablePath", "collectionValueNavigablePath", "mapKeyNavigablePath", 
			"groupByClause", "groupByExpression", "havingClause", "orderByClause", 
			"orderByFragment", "sortSpecification", "nullsPrecedence", "sortExpression", 
			"sortDirection", "collateFunction", "collation", "limitClause", "offsetClause", 
			"fetchClause", "fetchCountOrPercent", "parameterOrIntegerLiteral", "parameterOrNumberLiteral", 
			"whereClause", "predicate", "comparisonOperator", "inList", "likeEscape", 
			"expression", "primaryExpression", "expressionOrPredicate", "collectionQuantifier", 
			"elementValueQuantifier", "indexKeyQuantifier", "elementsValuesQuantifier", 
			"indicesKeysQuantifier", "multiplicativeOperator", "additiveOperator", 
			"signOperator", "entityTypeReference", "entityIdReference", "entityVersionReference", 
			"entityNaturalIdReference", "toOneFkReference", "caseList", "simpleCaseList", 
			"simpleCaseWhen", "caseOtherwise", "searchedCaseList", "searchedCaseWhen", 
			"literal", "booleanLiteral", "numericLiteral", "binaryLiteral", "temporalLiteral", 
			"dateTimeLiteral", "localDateTimeLiteral", "zonedDateTimeLiteral", "offsetDateTimeLiteral", 
			"dateLiteral", "timeLiteral", "dateTime", "localDateTime", "zonedDateTime", 
			"offsetDateTime", "offsetDateTimeWithMinutes", "date", "time", "offset", 
			"offsetWithMinutes", "year", "month", "day", "hour", "minute", "second", 
			"zoneId", "jdbcTimestampLiteral", "jdbcDateLiteral", "jdbcTimeLiteral", 
			"genericTemporalLiteralText", "arrayLiteral", "generalizedLiteral", "generalizedLiteralType", 
			"generalizedLiteralText", "parameter", "function", "jpaNonstandardFunction", 
			"jpaNonstandardFunctionName", "columnFunction", "genericFunction", "genericFunctionName", 
			"genericFunctionArguments", "collectionSizeFunction", "collectionAggregateFunction", 
			"collectionFunctionMisuse", "aggregateFunction", "everyFunction", "anyFunction", 
			"everyAllQuantifier", "anySomeQuantifier", "listaggFunction", "onOverflowClause", 
			"withinGroupClause", "filterClause", "nullsClause", "nthSideClause", 
			"overClause", "partitionClause", "frameClause", "frameStart", "frameEnd", 
			"frameExclusion", "standardFunction", "castFunction", "castTarget", "castTargetType", 
			"substringFunction", "substringFunctionStartArgument", "substringFunctionLengthArgument", 
			"trimFunction", "trimSpecification", "trimCharacter", "padFunction", 
			"padSpecification", "padCharacter", "padLength", "overlayFunction", "overlayFunctionStringArgument", 
			"overlayFunctionReplacementArgument", "overlayFunctionStartArgument", 
			"overlayFunctionLengthArgument", "currentDateFunction", "currentTimeFunction", 
			"currentTimestampFunction", "instantFunction", "localDateTimeFunction", 
			"offsetDateTimeFunction", "localDateFunction", "localTimeFunction", "formatFunction", 
			"format", "extractFunction", "truncFunction", "extractField", "datetimeField", 
			"dayField", "weekField", "timeZoneField", "dateOrTimeField", "positionFunction", 
			"positionFunctionPatternArgument", "positionFunctionStringArgument", 
			"cube", "rollup", "nakedIdentifier", "identifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, "'{ts'", "'{d'", "'{t'", "'='", null, "'>'", "'>='", "'<'", "'<='", 
			"','", "'.'", "'('", "')'", "'['", "']'", "'{'", "'}'", "'+'", "'-'", 
			"'*'", "'/'", "'%'", "'&'", "';'", "':'", "'|'", "'||'", "'?'", "'->'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COMMENT", "INTEGER_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", 
			"DOUBLE_LITERAL", "BIG_INTEGER_LITERAL", "BIG_DECIMAL_LITERAL", "HEX_LITERAL", 
			"STRING_LITERAL", "JAVA_STRING_LITERAL", "BINARY_LITERAL", "TIMESTAMP_ESCAPE_START", 
			"DATE_ESCAPE_START", "TIME_ESCAPE_START", "EQUAL", "NOT_EQUAL", "GREATER", 
			"GREATER_EQUAL", "LESS", "LESS_EQUAL", "COMMA", "DOT", "LEFT_PAREN", 
			"RIGHT_PAREN", "LEFT_BRACKET", "RIGHT_BRACKET", "LEFT_BRACE", "RIGHT_BRACE", 
			"PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT_OP", "AMPERSAND", "SEMICOLON", 
			"COLON", "PIPE", "DOUBLE_PIPE", "QUESTION_MARK", "ARROW", "ID", "VERSION", 
			"VERSIONED", "NATURALID", "FK", "ALL", "AND", "ANY", "AS", "ASC", "AVG", 
			"BETWEEN", "BOTH", "BREADTH", "BY", "CASE", "CAST", "COLLATE", "COLUMN", 
			"CONFLICT", "CONSTRAINT", "CONTAINS", "COUNT", "CROSS", "CUBE", "CURRENT", 
			"CURRENT_DATE", "CURRENT_INSTANT", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
			"CYCLE", "DATE", "DATETIME", "DAY", "DEFAULT", "DELETE", "DEPTH", "DESC", 
			"DISTINCT", "DO", "ELEMENT", "ELEMENTS", "ELSE", "EMPTY", "END", "ENTRY", 
			"EPOCH", "ERROR", "ESCAPE", "EVERY", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", 
			"FETCH", "FILTER", "FIRST", "FOLLOWING", "FOR", "FORMAT", "FROM", "FULL", 
			"FUNCTION", "GROUP", "GROUPS", "HAVING", "HOUR", "IGNORE", "ILIKE", "IN", 
			"INCLUDES", "INDEX", "INDICES", "INNER", "INSERT", "INSTANT", "INTERSECT", 
			"INTERSECTS", "INTO", "IS", "JOIN", "KEY", "KEYS", "LAST", "LATERAL", 
			"LEADING", "LEFT", "LIKE", "LIMIT", "LIST", "LISTAGG", "LOCAL", "LOCAL_DATE", 
			"LOCAL_DATETIME", "LOCAL_TIME", "MAP", "MATERIALIZED", "MAX", "MAXELEMENT", 
			"MAXINDEX", "MEMBER", "MICROSECOND", "MILLISECOND", "MIN", "MINELEMENT", 
			"MININDEX", "MINUTE", "MONTH", "NANOSECOND", "NEW", "NEXT", "NO", "NOT", 
			"NOTHING", "NULLS", "OBJECT", "OF", "OFFSET", "OFFSET_DATETIME", "ON", 
			"ONLY", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "OVERFLOW", "OVERLAY", 
			"PAD", "PARTITION", "PERCENT", "PLACING", "POSITION", "PRECEDING", "QUARTER", 
			"RANGE", "RESPECT", "RIGHT", "ROLLUP", "ROW", "ROWS", "SEARCH", "SECOND", 
			"SELECT", "SET", "SIZE", "SOME", "SUBSTRING", "SUM", "THEN", "TIES", 
			"TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", 
			"TREAT", "TRIM", "TRUNC", "TRUNCATE", "TYPE", "UNBOUNDED", "UNION", "UPDATE", 
			"USING", "VALUE", "VALUES", "WEEK", "WHEN", "WHERE", "WITH", "WITHIN", 
			"WITHOUT", "YEAR", "ZONED", "TRUE", "FALSE", "NULL", "IDENTIFIER", "QUOTED_IDENTIFIER"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "HqlParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


		protected void logUseOfReservedWordAsIdentifier(Token token) {
		}

	public HqlParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	@SuppressWarnings("CheckReturnValue")
	public static class StatementContext extends ParserRuleContext {
		public TerminalNode EOF() { return getToken(HqlParser.EOF, 0); }
		public SelectStatementContext selectStatement() {
			return getRuleContext(SelectStatementContext.class,0);
		}
		public UpdateStatementContext updateStatement() {
			return getRuleContext(UpdateStatementContext.class,0);
		}
		public DeleteStatementContext deleteStatement() {
			return getRuleContext(DeleteStatementContext.class,0);
		}
		public InsertStatementContext insertStatement() {
			return getRuleContext(InsertStatementContext.class,0);
		}
		public StatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_statement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StatementContext statement() throws RecognitionException {
		StatementContext _localctx = new StatementContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_statement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(426);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case ORDER:
			case SELECT:
			case WHERE:
			case WITH:
				{
				setState(422);
				selectStatement();
				}
				break;
			case UPDATE:
				{
				setState(423);
				updateStatement();
				}
				break;
			case DELETE:
				{
				setState(424);
				deleteStatement();
				}
				break;
			case INSERT:
				{
				setState(425);
				insertStatement();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(428);
			match(EOF);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectStatementContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SelectStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectStatementContext selectStatement() throws RecognitionException {
		SelectStatementContext _localctx = new SelectStatementContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_selectStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(430);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SubqueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subquery; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubqueryContext subquery() throws RecognitionException {
		SubqueryContext _localctx = new SubqueryContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_subquery);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(432);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TargetEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public TargetEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetEntityContext targetEntity() throws RecognitionException {
		TargetEntityContext _localctx = new TargetEntityContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_targetEntity);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(434);
			entityName();
			setState(436);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -2305843009213693953L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -1152921504611041793L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 7036874417765887L) != 0)) {
				{
				setState(435);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DeleteStatementContext extends ParserRuleContext {
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public EntityWithJoinsContext entityWithJoins() {
			return getRuleContext(EntityWithJoinsContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public DeleteStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_deleteStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDeleteStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDeleteStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDeleteStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DeleteStatementContext deleteStatement() throws RecognitionException {
		DeleteStatementContext _localctx = new DeleteStatementContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_deleteStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(438);
			match(DELETE);
			setState(440);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,2,_ctx) ) {
			case 1:
				{
				setState(439);
				match(FROM);
				}
				break;
			}
			setState(442);
			entityWithJoins();
			setState(444);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(443);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class UpdateStatementContext extends ParserRuleContext {
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public EntityWithJoinsContext entityWithJoins() {
			return getRuleContext(EntityWithJoinsContext.class,0);
		}
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public UpdateStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_updateStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUpdateStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUpdateStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUpdateStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final UpdateStatementContext updateStatement() throws RecognitionException {
		UpdateStatementContext _localctx = new UpdateStatementContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_updateStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(446);
			match(UPDATE);
			setState(448);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				{
				setState(447);
				match(VERSIONED);
				}
				break;
			}
			setState(450);
			entityWithJoins();
			setState(451);
			setClause();
			setState(453);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(452);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SetClauseContext extends ParserRuleContext {
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<AssignmentContext> assignment() {
			return getRuleContexts(AssignmentContext.class);
		}
		public AssignmentContext assignment(int i) {
			return getRuleContext(AssignmentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetClauseContext setClause() throws RecognitionException {
		SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_setClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(455);
			match(SET);
			setState(456);
			assignment();
			setState(461);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(457);
				match(COMMA);
				setState(458);
				assignment();
				}
				}
				setState(463);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AssignmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public AssignmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_assignment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAssignment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAssignment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAssignment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AssignmentContext assignment() throws RecognitionException {
		AssignmentContext _localctx = new AssignmentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_assignment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(464);
			simplePath();
			setState(465);
			match(EQUAL);
			setState(466);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InsertStatementContext extends ParserRuleContext {
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TargetFieldsContext targetFields() {
			return getRuleContext(TargetFieldsContext.class,0);
		}
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public ValuesListContext valuesList() {
			return getRuleContext(ValuesListContext.class,0);
		}
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public ConflictClauseContext conflictClause() {
			return getRuleContext(ConflictClauseContext.class,0);
		}
		public InsertStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_insertStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInsertStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInsertStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInsertStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InsertStatementContext insertStatement() throws RecognitionException {
		InsertStatementContext _localctx = new InsertStatementContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_insertStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(468);
			match(INSERT);
			setState(470);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,7,_ctx) ) {
			case 1:
				{
				setState(469);
				match(INTO);
				}
				break;
			}
			setState(472);
			targetEntity();
			setState(473);
			targetFields();
			setState(476);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case ORDER:
			case SELECT:
			case WHERE:
			case WITH:
				{
				setState(474);
				queryExpression();
				}
				break;
			case VALUES:
				{
				setState(475);
				valuesList();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(479);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(478);
				conflictClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TargetFieldsContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TargetFieldsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetFields; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetFields(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetFields(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetFields(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetFieldsContext targetFields() throws RecognitionException {
		TargetFieldsContext _localctx = new TargetFieldsContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_targetFields);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(481);
			match(LEFT_PAREN);
			setState(482);
			simplePath();
			setState(487);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(483);
				match(COMMA);
				setState(484);
				simplePath();
				}
				}
				setState(489);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(490);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ValuesListContext extends ParserRuleContext {
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public List<ValuesContext> values() {
			return getRuleContexts(ValuesContext.class);
		}
		public ValuesContext values(int i) {
			return getRuleContext(ValuesContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_valuesList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValuesList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValuesList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValuesList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesListContext valuesList() throws RecognitionException {
		ValuesListContext _localctx = new ValuesListContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_valuesList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(492);
			match(VALUES);
			setState(493);
			values();
			setState(498);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(494);
				match(COMMA);
				setState(495);
				values();
				}
				}
				setState(500);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ValuesContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_values; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValues(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValues(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValues(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesContext values() throws RecognitionException {
		ValuesContext _localctx = new ValuesContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_values);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(501);
			match(LEFT_PAREN);
			setState(502);
			expressionOrPredicate();
			setState(507);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(503);
				match(COMMA);
				setState(504);
				expressionOrPredicate();
				}
				}
				setState(509);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(510);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode CONFLICT() { return getToken(HqlParser.CONFLICT, 0); }
		public TerminalNode DO() { return getToken(HqlParser.DO, 0); }
		public ConflictActionContext conflictAction() {
			return getRuleContext(ConflictActionContext.class,0);
		}
		public ConflictTargetContext conflictTarget() {
			return getRuleContext(ConflictTargetContext.class,0);
		}
		public ConflictClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictClauseContext conflictClause() throws RecognitionException {
		ConflictClauseContext _localctx = new ConflictClauseContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_conflictClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(512);
			match(ON);
			setState(513);
			match(CONFLICT);
			setState(515);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN || _la==ON) {
				{
				setState(514);
				conflictTarget();
				}
			}

			setState(517);
			match(DO);
			setState(518);
			conflictAction();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictTargetContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode CONSTRAINT() { return getToken(HqlParser.CONSTRAINT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ConflictTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictTargetContext conflictTarget() throws RecognitionException {
		ConflictTargetContext _localctx = new ConflictTargetContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_conflictTarget);
		int _la;
		try {
			setState(534);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ON:
				enterOuterAlt(_localctx, 1);
				{
				setState(520);
				match(ON);
				setState(521);
				match(CONSTRAINT);
				setState(522);
				identifier();
				}
				break;
			case LEFT_PAREN:
				enterOuterAlt(_localctx, 2);
				{
				setState(523);
				match(LEFT_PAREN);
				setState(524);
				simplePath();
				setState(529);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(525);
					match(COMMA);
					setState(526);
					simplePath();
					}
					}
					setState(531);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(532);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictActionContext extends ParserRuleContext {
		public TerminalNode NOTHING() { return getToken(HqlParser.NOTHING, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public ConflictActionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictAction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictAction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictAction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictAction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictActionContext conflictAction() throws RecognitionException {
		ConflictActionContext _localctx = new ConflictActionContext(_ctx, getState());
		enterRule(_localctx, 28, RULE_conflictAction);
		int _la;
		try {
			setState(542);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case NOTHING:
				enterOuterAlt(_localctx, 1);
				{
				setState(536);
				match(NOTHING);
				}
				break;
			case UPDATE:
				enterOuterAlt(_localctx, 2);
				{
				setState(537);
				match(UPDATE);
				setState(538);
				setClause();
				setState(540);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(539);
					whereClause();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WithClauseContext extends ParserRuleContext {
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public List<CteContext> cte() {
			return getRuleContexts(CteContext.class);
		}
		public CteContext cte(int i) {
			return getRuleContext(CteContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public WithClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithClauseContext withClause() throws RecognitionException {
		WithClauseContext _localctx = new WithClauseContext(_ctx, getState());
		enterRule(_localctx, 30, RULE_withClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(544);
			match(WITH);
			setState(545);
			cte();
			setState(550);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(546);
				match(COMMA);
				setState(547);
				cte();
				}
				}
				setState(552);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CteContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public SearchClauseContext searchClause() {
			return getRuleContext(SearchClauseContext.class,0);
		}
		public CycleClauseContext cycleClause() {
			return getRuleContext(CycleClauseContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public CteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cte; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCte(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCte(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCte(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteContext cte() throws RecognitionException {
		CteContext _localctx = new CteContext(_ctx, getState());
		enterRule(_localctx, 32, RULE_cte);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(553);
			identifier();
			setState(554);
			match(AS);
			setState(559);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==MATERIALIZED || _la==NOT) {
				{
				setState(556);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(555);
					match(NOT);
					}
				}

				setState(558);
				match(MATERIALIZED);
				}
			}

			setState(561);
			match(LEFT_PAREN);
			setState(562);
			queryExpression();
			setState(563);
			match(RIGHT_PAREN);
			setState(565);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==SEARCH) {
				{
				setState(564);
				searchClause();
				}
			}

			setState(568);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==CYCLE) {
				{
				setState(567);
				cycleClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CteAttributesContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CteAttributesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cteAttributes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCteAttributes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCteAttributes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCteAttributes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteAttributesContext cteAttributes() throws RecognitionException {
		CteAttributesContext _localctx = new CteAttributesContext(_ctx, getState());
		enterRule(_localctx, 34, RULE_cteAttributes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(570);
			identifier();
			setState(575);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(571);
				match(COMMA);
				setState(572);
				identifier();
				}
				}
				setState(577);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchClauseContext extends ParserRuleContext {
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public SearchSpecificationsContext searchSpecifications() {
			return getRuleContext(SearchSpecificationsContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public SearchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchClauseContext searchClause() throws RecognitionException {
		SearchClauseContext _localctx = new SearchClauseContext(_ctx, getState());
		enterRule(_localctx, 36, RULE_searchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(578);
			match(SEARCH);
			setState(579);
			_la = _input.LA(1);
			if ( !(_la==BREADTH || _la==DEPTH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(580);
			match(FIRST);
			setState(581);
			match(BY);
			setState(582);
			searchSpecifications();
			setState(583);
			match(SET);
			setState(584);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchSpecificationsContext extends ParserRuleContext {
		public List<SearchSpecificationContext> searchSpecification() {
			return getRuleContexts(SearchSpecificationContext.class);
		}
		public SearchSpecificationContext searchSpecification(int i) {
			return getRuleContext(SearchSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SearchSpecificationsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecifications; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecifications(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecifications(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecifications(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationsContext searchSpecifications() throws RecognitionException {
		SearchSpecificationsContext _localctx = new SearchSpecificationsContext(_ctx, getState());
		enterRule(_localctx, 38, RULE_searchSpecifications);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(586);
			searchSpecification();
			setState(591);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(587);
				match(COMMA);
				setState(588);
				searchSpecification();
				}
				}
				setState(593);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchSpecificationContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SearchSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationContext searchSpecification() throws RecognitionException {
		SearchSpecificationContext _localctx = new SearchSpecificationContext(_ctx, getState());
		enterRule(_localctx, 40, RULE_searchSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(594);
			identifier();
			setState(596);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(595);
				sortDirection();
				}
			}

			setState(599);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(598);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CycleClauseContext extends ParserRuleContext {
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public CteAttributesContext cteAttributes() {
			return getRuleContext(CteAttributesContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public List<LiteralContext> literal() {
			return getRuleContexts(LiteralContext.class);
		}
		public LiteralContext literal(int i) {
			return getRuleContext(LiteralContext.class,i);
		}
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public CycleClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cycleClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCycleClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCycleClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCycleClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CycleClauseContext cycleClause() throws RecognitionException {
		CycleClauseContext _localctx = new CycleClauseContext(_ctx, getState());
		enterRule(_localctx, 42, RULE_cycleClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(601);
			match(CYCLE);
			setState(602);
			cteAttributes();
			setState(603);
			match(SET);
			setState(604);
			identifier();
			setState(610);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==TO) {
				{
				setState(605);
				match(TO);
				setState(606);
				literal();
				setState(607);
				match(DEFAULT);
				setState(608);
				literal();
				}
			}

			setState(614);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==USING) {
				{
				setState(612);
				match(USING);
				setState(613);
				identifier();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryExpressionContext extends ParserRuleContext {
		public QueryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryExpression; }
	 
		public QueryExpressionContext() { }
		public void copyFrom(QueryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SetQueryGroupContext extends QueryExpressionContext {
		public List<OrderedQueryContext> orderedQuery() {
			return getRuleContexts(OrderedQueryContext.class);
		}
		public OrderedQueryContext orderedQuery(int i) {
			return getRuleContext(OrderedQueryContext.class,i);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public List<SetOperatorContext> setOperator() {
			return getRuleContexts(SetOperatorContext.class);
		}
		public SetOperatorContext setOperator(int i) {
			return getRuleContext(SetOperatorContext.class,i);
		}
		public SetQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SimpleQueryGroupContext extends QueryExpressionContext {
		public OrderedQueryContext orderedQuery() {
			return getRuleContext(OrderedQueryContext.class,0);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public SimpleQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryExpressionContext queryExpression() throws RecognitionException {
		QueryExpressionContext _localctx = new QueryExpressionContext(_ctx, getState());
		enterRule(_localctx, 44, RULE_queryExpression);
		int _la;
		try {
			setState(631);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,32,_ctx) ) {
			case 1:
				_localctx = new SimpleQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(617);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(616);
					withClause();
					}
				}

				setState(619);
				orderedQuery();
				}
				break;
			case 2:
				_localctx = new SetQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(621);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(620);
					withClause();
					}
				}

				setState(623);
				orderedQuery();
				setState(627); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(624);
					setOperator();
					setState(625);
					orderedQuery();
					}
					}
					setState(629); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==EXCEPT || _la==INTERSECT || _la==UNION );
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderedQueryContext extends ParserRuleContext {
		public OrderedQueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderedQuery; }
	 
		public OrderedQueryContext() { }
		public void copyFrom(OrderedQueryContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class QueryOrderExpressionContext extends OrderedQueryContext {
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QueryOrderExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrderExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrderExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrderExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class QuerySpecExpressionContext extends OrderedQueryContext {
		public QueryContext query() {
			return getRuleContext(QueryContext.class,0);
		}
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QuerySpecExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuerySpecExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuerySpecExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuerySpecExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NestedQueryExpressionContext extends OrderedQueryContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public NestedQueryExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNestedQueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNestedQueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNestedQueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderedQueryContext orderedQuery() throws RecognitionException {
		OrderedQueryContext _localctx = new OrderedQueryContext(_ctx, getState());
		enterRule(_localctx, 46, RULE_orderedQuery);
		int _la;
		try {
			setState(644);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case FROM:
			case SELECT:
			case WHERE:
				_localctx = new QuerySpecExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(633);
				query();
				setState(635);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(634);
					queryOrder();
					}
				}

				}
				break;
			case LEFT_PAREN:
				_localctx = new NestedQueryExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(637);
				match(LEFT_PAREN);
				setState(638);
				queryExpression();
				setState(639);
				match(RIGHT_PAREN);
				setState(641);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(640);
					queryOrder();
					}
				}

				}
				break;
			case ORDER:
				_localctx = new QueryOrderExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(643);
				queryOrder();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SetOperatorContext extends ParserRuleContext {
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public SetOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetOperatorContext setOperator() throws RecognitionException {
		SetOperatorContext _localctx = new SetOperatorContext(_ctx, getState());
		enterRule(_localctx, 48, RULE_setOperator);
		int _la;
		try {
			setState(658);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case UNION:
				enterOuterAlt(_localctx, 1);
				{
				setState(646);
				match(UNION);
				setState(648);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(647);
					match(ALL);
					}
				}

				}
				break;
			case INTERSECT:
				enterOuterAlt(_localctx, 2);
				{
				setState(650);
				match(INTERSECT);
				setState(652);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(651);
					match(ALL);
					}
				}

				}
				break;
			case EXCEPT:
				enterOuterAlt(_localctx, 3);
				{
				setState(654);
				match(EXCEPT);
				setState(656);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(655);
					match(ALL);
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryOrderContext extends ParserRuleContext {
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public LimitClauseContext limitClause() {
			return getRuleContext(LimitClauseContext.class,0);
		}
		public OffsetClauseContext offsetClause() {
			return getRuleContext(OffsetClauseContext.class,0);
		}
		public FetchClauseContext fetchClause() {
			return getRuleContext(FetchClauseContext.class,0);
		}
		public QueryOrderContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryOrder; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrder(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrder(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrder(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryOrderContext queryOrder() throws RecognitionException {
		QueryOrderContext _localctx = new QueryOrderContext(_ctx, getState());
		enterRule(_localctx, 50, RULE_queryOrder);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(660);
			orderByClause();
			setState(662);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LIMIT) {
				{
				setState(661);
				limitClause();
				}
			}

			setState(665);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==OFFSET) {
				{
				setState(664);
				offsetClause();
				}
			}

			setState(668);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FETCH) {
				{
				setState(667);
				fetchClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryContext extends ParserRuleContext {
		public SelectClauseContext selectClause() {
			return getRuleContext(SelectClauseContext.class,0);
		}
		public FromClauseContext fromClause() {
			return getRuleContext(FromClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public GroupByClauseContext groupByClause() {
			return getRuleContext(GroupByClauseContext.class,0);
		}
		public HavingClauseContext havingClause() {
			return getRuleContext(HavingClauseContext.class,0);
		}
		public QueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_query; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryContext query() throws RecognitionException {
		QueryContext _localctx = new QueryContext(_ctx, getState());
		enterRule(_localctx, 52, RULE_query);
		int _la;
		try {
			setState(697);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case SELECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(670);
				selectClause();
				setState(672);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FROM) {
					{
					setState(671);
					fromClause();
					}
				}

				setState(675);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(674);
					whereClause();
					}
				}

				setState(681);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(677);
					groupByClause();
					setState(679);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(678);
						havingClause();
						}
					}

					}
				}

				}
				break;
			case FROM:
				enterOuterAlt(_localctx, 2);
				{
				setState(683);
				fromClause();
				setState(685);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(684);
					whereClause();
					}
				}

				setState(691);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(687);
					groupByClause();
					setState(689);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(688);
						havingClause();
						}
					}

					}
				}

				setState(694);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==SELECT) {
					{
					setState(693);
					selectClause();
					}
				}

				}
				break;
			case WHERE:
				enterOuterAlt(_localctx, 3);
				{
				setState(696);
				whereClause();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FromClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public List<EntityWithJoinsContext> entityWithJoins() {
			return getRuleContexts(EntityWithJoinsContext.class);
		}
		public EntityWithJoinsContext entityWithJoins(int i) {
			return getRuleContext(EntityWithJoinsContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public FromClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromClauseContext fromClause() throws RecognitionException {
		FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
		enterRule(_localctx, 54, RULE_fromClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(699);
			match(FROM);
			setState(700);
			entityWithJoins();
			setState(705);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(701);
				match(COMMA);
				setState(702);
				entityWithJoins();
				}
				}
				setState(707);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityWithJoinsContext extends ParserRuleContext {
		public FromRootContext fromRoot() {
			return getRuleContext(FromRootContext.class,0);
		}
		public List<JoinContext> join() {
			return getRuleContexts(JoinContext.class);
		}
		public JoinContext join(int i) {
			return getRuleContext(JoinContext.class,i);
		}
		public List<CrossJoinContext> crossJoin() {
			return getRuleContexts(CrossJoinContext.class);
		}
		public CrossJoinContext crossJoin(int i) {
			return getRuleContext(CrossJoinContext.class,i);
		}
		public List<JpaCollectionJoinContext> jpaCollectionJoin() {
			return getRuleContexts(JpaCollectionJoinContext.class);
		}
		public JpaCollectionJoinContext jpaCollectionJoin(int i) {
			return getRuleContext(JpaCollectionJoinContext.class,i);
		}
		public EntityWithJoinsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityWithJoins; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityWithJoins(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityWithJoins(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityWithJoins(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityWithJoinsContext entityWithJoins() throws RecognitionException {
		EntityWithJoinsContext _localctx = new EntityWithJoinsContext(_ctx, getState());
		enterRule(_localctx, 56, RULE_entityWithJoins);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(708);
			fromRoot();
			setState(714);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,54,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					setState(712);
					_errHandler.sync(this);
					switch (_input.LA(1)) {
					case FULL:
					case INNER:
					case JOIN:
					case LEFT:
					case OUTER:
					case RIGHT:
						{
						setState(709);
						join();
						}
						break;
					case CROSS:
						{
						setState(710);
						crossJoin();
						}
						break;
					case COMMA:
						{
						setState(711);
						jpaCollectionJoin();
						}
						break;
					default:
						throw new NoViableAltException(this);
					}
					} 
				}
				setState(716);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,54,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FromRootContext extends ParserRuleContext {
		public FromRootContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromRoot; }
	 
		public FromRootContext() { }
		public void copyFrom(FromRootContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class RootSubqueryContext extends FromRootContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootSubqueryContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootSubquery(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class RootEntityContext extends FromRootContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootEntityContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromRootContext fromRoot() throws RecognitionException {
		FromRootContext _localctx = new FromRootContext(_ctx, getState());
		enterRule(_localctx, 58, RULE_fromRoot);
		try {
			setState(727);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new RootEntityContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(717);
				entityName();
				setState(719);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,55,_ctx) ) {
				case 1:
					{
					setState(718);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
				_localctx = new RootSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(721);
				match(LEFT_PAREN);
				setState(722);
				subquery();
				setState(723);
				match(RIGHT_PAREN);
				setState(725);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,56,_ctx) ) {
				case 1:
					{
					setState(724);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityNameContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public EntityNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNameContext entityName() throws RecognitionException {
		EntityNameContext _localctx = new EntityNameContext(_ctx, getState());
		enterRule(_localctx, 60, RULE_entityName);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(729);
			identifier();
			setState(734);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(730);
				match(DOT);
				setState(731);
				identifier();
				}
				}
				setState(736);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class VariableContext extends ParserRuleContext {
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public VariableContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_variable; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterVariable(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitVariable(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitVariable(this);
			else return visitor.visitChildren(this);
		}
	}

	public final VariableContext variable() throws RecognitionException {
		VariableContext _localctx = new VariableContext(_ctx, getState());
		enterRule(_localctx, 62, RULE_variable);
		try {
			setState(740);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,59,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(737);
				match(AS);
				setState(738);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(739);
				nakedIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CrossJoinContext extends ParserRuleContext {
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public CrossJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_crossJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCrossJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCrossJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCrossJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CrossJoinContext crossJoin() throws RecognitionException {
		CrossJoinContext _localctx = new CrossJoinContext(_ctx, getState());
		enterRule(_localctx, 64, RULE_crossJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(742);
			match(CROSS);
			setState(743);
			match(JOIN);
			setState(744);
			entityName();
			setState(746);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,60,_ctx) ) {
			case 1:
				{
				setState(745);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaCollectionJoinContext extends ParserRuleContext {
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JpaCollectionJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaCollectionJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaCollectionJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaCollectionJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaCollectionJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaCollectionJoinContext jpaCollectionJoin() throws RecognitionException {
		JpaCollectionJoinContext _localctx = new JpaCollectionJoinContext(_ctx, getState());
		enterRule(_localctx, 66, RULE_jpaCollectionJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(748);
			match(COMMA);
			setState(749);
			match(IN);
			setState(750);
			match(LEFT_PAREN);
			setState(751);
			path();
			setState(752);
			match(RIGHT_PAREN);
			setState(754);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,61,_ctx) ) {
			case 1:
				{
				setState(753);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinContext extends ParserRuleContext {
		public JoinTypeContext joinType() {
			return getRuleContext(JoinTypeContext.class,0);
		}
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public JoinTargetContext joinTarget() {
			return getRuleContext(JoinTargetContext.class,0);
		}
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public JoinRestrictionContext joinRestriction() {
			return getRuleContext(JoinRestrictionContext.class,0);
		}
		public JoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_join; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinContext join() throws RecognitionException {
		JoinContext _localctx = new JoinContext(_ctx, getState());
		enterRule(_localctx, 68, RULE_join);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(756);
			joinType();
			setState(757);
			match(JOIN);
			setState(759);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,62,_ctx) ) {
			case 1:
				{
				setState(758);
				match(FETCH);
				}
				break;
			}
			setState(761);
			joinTarget();
			setState(763);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,63,_ctx) ) {
			case 1:
				{
				setState(762);
				joinRestriction();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinTypeContext extends ParserRuleContext {
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public JoinTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTypeContext joinType() throws RecognitionException {
		JoinTypeContext _localctx = new JoinTypeContext(_ctx, getState());
		enterRule(_localctx, 70, RULE_joinType);
		int _la;
		try {
			setState(774);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,67,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(766);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==INNER) {
					{
					setState(765);
					match(INNER);
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(769);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FULL || _la==LEFT || _la==RIGHT) {
					{
					setState(768);
					_la = _input.LA(1);
					if ( !(_la==FULL || _la==LEFT || _la==RIGHT) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				setState(772);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OUTER) {
					{
					setState(771);
					match(OUTER);
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinTargetContext extends ParserRuleContext {
		public JoinTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinTarget; }
	 
		public JoinTargetContext() { }
		public void copyFrom(JoinTargetContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class JoinPathContext extends JoinTargetContext {
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinPathContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinPath(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class JoinSubqueryContext extends JoinTargetContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinSubqueryContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTargetContext joinTarget() throws RecognitionException {
		JoinTargetContext _localctx = new JoinTargetContext(_ctx, getState());
		enterRule(_localctx, 72, RULE_joinTarget);
		int _la;
		try {
			setState(789);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,71,_ctx) ) {
			case 1:
				_localctx = new JoinPathContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(776);
				path();
				setState(778);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,68,_ctx) ) {
				case 1:
					{
					setState(777);
					variable();
					}
					break;
				}
				}
				break;
			case 2:
				_localctx = new JoinSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(781);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LATERAL) {
					{
					setState(780);
					match(LATERAL);
					}
				}

				setState(783);
				match(LEFT_PAREN);
				setState(784);
				subquery();
				setState(785);
				match(RIGHT_PAREN);
				setState(787);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,70,_ctx) ) {
				case 1:
					{
					setState(786);
					variable();
					}
					break;
				}
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinRestrictionContext extends ParserRuleContext {
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public JoinRestrictionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinRestriction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinRestriction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinRestriction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinRestriction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinRestrictionContext joinRestriction() throws RecognitionException {
		JoinRestrictionContext _localctx = new JoinRestrictionContext(_ctx, getState());
		enterRule(_localctx, 74, RULE_joinRestriction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(791);
			_la = _input.LA(1);
			if ( !(_la==ON || _la==WITH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(792);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectClauseContext extends ParserRuleContext {
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public SelectionListContext selectionList() {
			return getRuleContext(SelectionListContext.class,0);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public SelectClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectClauseContext selectClause() throws RecognitionException {
		SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
		enterRule(_localctx, 76, RULE_selectClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(794);
			match(SELECT);
			setState(796);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,72,_ctx) ) {
			case 1:
				{
				setState(795);
				match(DISTINCT);
				}
				break;
			}
			setState(798);
			selectionList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectionListContext extends ParserRuleContext {
		public List<SelectionContext> selection() {
			return getRuleContexts(SelectionContext.class);
		}
		public SelectionContext selection(int i) {
			return getRuleContext(SelectionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SelectionListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectionList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectionList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectionList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectionList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionListContext selectionList() throws RecognitionException {
		SelectionListContext _localctx = new SelectionListContext(_ctx, getState());
		enterRule(_localctx, 78, RULE_selectionList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(800);
			selection();
			setState(805);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(801);
				match(COMMA);
				setState(802);
				selection();
				}
				}
				setState(807);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectionContext extends ParserRuleContext {
		public SelectExpressionContext selectExpression() {
			return getRuleContext(SelectExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public SelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionContext selection() throws RecognitionException {
		SelectionContext _localctx = new SelectionContext(_ctx, getState());
		enterRule(_localctx, 80, RULE_selection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(808);
			selectExpression();
			setState(810);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,74,_ctx) ) {
			case 1:
				{
				setState(809);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectExpressionContext extends ParserRuleContext {
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public MapEntrySelectionContext mapEntrySelection() {
			return getRuleContext(MapEntrySelectionContext.class,0);
		}
		public JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() {
			return getRuleContext(JpaSelectObjectSyntaxContext.class,0);
		}
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectExpressionContext selectExpression() throws RecognitionException {
		SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
		enterRule(_localctx, 82, RULE_selectExpression);
		try {
			setState(816);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,75,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(812);
				instantiation();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(813);
				mapEntrySelection();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(814);
				jpaSelectObjectSyntax();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(815);
				expressionOrPredicate();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MapEntrySelectionContext extends ParserRuleContext {
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public MapEntrySelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapEntrySelection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapEntrySelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapEntrySelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapEntrySelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapEntrySelectionContext mapEntrySelection() throws RecognitionException {
		MapEntrySelectionContext _localctx = new MapEntrySelectionContext(_ctx, getState());
		enterRule(_localctx, 84, RULE_mapEntrySelection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(818);
			match(ENTRY);
			setState(819);
			match(LEFT_PAREN);
			setState(820);
			path();
			setState(821);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationContext extends ParserRuleContext {
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public InstantiationTargetContext instantiationTarget() {
			return getRuleContext(InstantiationTargetContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public InstantiationArgumentsContext instantiationArguments() {
			return getRuleContext(InstantiationArgumentsContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public InstantiationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationContext instantiation() throws RecognitionException {
		InstantiationContext _localctx = new InstantiationContext(_ctx, getState());
		enterRule(_localctx, 86, RULE_instantiation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(823);
			match(NEW);
			setState(824);
			instantiationTarget();
			setState(825);
			match(LEFT_PAREN);
			setState(826);
			instantiationArguments();
			setState(827);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationTargetContext extends ParserRuleContext {
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public InstantiationTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationTargetContext instantiationTarget() throws RecognitionException {
		InstantiationTargetContext _localctx = new InstantiationTargetContext(_ctx, getState());
		enterRule(_localctx, 88, RULE_instantiationTarget);
		try {
			setState(832);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,76,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(829);
				match(LIST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(830);
				match(MAP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(831);
				simplePath();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentsContext extends ParserRuleContext {
		public List<InstantiationArgumentContext> instantiationArgument() {
			return getRuleContexts(InstantiationArgumentContext.class);
		}
		public InstantiationArgumentContext instantiationArgument(int i) {
			return getRuleContext(InstantiationArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public InstantiationArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentsContext instantiationArguments() throws RecognitionException {
		InstantiationArgumentsContext _localctx = new InstantiationArgumentsContext(_ctx, getState());
		enterRule(_localctx, 90, RULE_instantiationArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(834);
			instantiationArgument();
			setState(839);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(835);
				match(COMMA);
				setState(836);
				instantiationArgument();
				}
				}
				setState(841);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentContext extends ParserRuleContext {
		public InstantiationArgumentExpressionContext instantiationArgumentExpression() {
			return getRuleContext(InstantiationArgumentExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public InstantiationArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentContext instantiationArgument() throws RecognitionException {
		InstantiationArgumentContext _localctx = new InstantiationArgumentContext(_ctx, getState());
		enterRule(_localctx, 92, RULE_instantiationArgument);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(842);
			instantiationArgumentExpression();
			setState(844);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -2305843009213693953L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -1152921504611041793L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 7036874417765887L) != 0)) {
				{
				setState(843);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentExpressionContext extends ParserRuleContext {
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public InstantiationArgumentExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgumentExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgumentExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgumentExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgumentExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentExpressionContext instantiationArgumentExpression() throws RecognitionException {
		InstantiationArgumentExpressionContext _localctx = new InstantiationArgumentExpressionContext(_ctx, getState());
		enterRule(_localctx, 94, RULE_instantiationArgumentExpression);
		try {
			setState(848);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,79,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(846);
				expressionOrPredicate();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(847);
				instantiation();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaSelectObjectSyntaxContext extends ParserRuleContext {
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public JpaSelectObjectSyntaxContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaSelectObjectSyntax; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaSelectObjectSyntax(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaSelectObjectSyntax(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaSelectObjectSyntax(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() throws RecognitionException {
		JpaSelectObjectSyntaxContext _localctx = new JpaSelectObjectSyntaxContext(_ctx, getState());
		enterRule(_localctx, 96, RULE_jpaSelectObjectSyntax);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(850);
			match(OBJECT);
			setState(851);
			match(LEFT_PAREN);
			setState(852);
			identifier();
			setState(853);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimplePathContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public List<SimplePathElementContext> simplePathElement() {
			return getRuleContexts(SimplePathElementContext.class);
		}
		public SimplePathElementContext simplePathElement(int i) {
			return getRuleContext(SimplePathElementContext.class,i);
		}
		public SimplePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathContext simplePath() throws RecognitionException {
		SimplePathContext _localctx = new SimplePathContext(_ctx, getState());
		enterRule(_localctx, 98, RULE_simplePath);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(855);
			identifier();
			setState(859);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,80,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					{
					setState(856);
					simplePathElement();
					}
					} 
				}
				setState(861);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,80,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimplePathElementContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SimplePathElementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePathElement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePathElement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePathElement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePathElement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathElementContext simplePathElement() throws RecognitionException {
		SimplePathElementContext _localctx = new SimplePathElementContext(_ctx, getState());
		enterRule(_localctx, 100, RULE_simplePathElement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(862);
			match(DOT);
			setState(863);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PathContext extends ParserRuleContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public PathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_path; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContext path() throws RecognitionException {
		PathContext _localctx = new PathContext(_ctx, getState());
		enterRule(_localctx, 102, RULE_path);
		try {
			setState(870);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,82,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(865);
				syntacticDomainPath();
				setState(867);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,81,_ctx) ) {
				case 1:
					{
					setState(866);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(869);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PathContinuationContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public PathContinuationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_pathContinuation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPathContinuation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPathContinuation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPathContinuation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContinuationContext pathContinuation() throws RecognitionException {
		PathContinuationContext _localctx = new PathContinuationContext(_ctx, getState());
		enterRule(_localctx, 104, RULE_pathContinuation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(872);
			match(DOT);
			setState(873);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SyntacticDomainPathContext extends ParserRuleContext {
		public TreatedNavigablePathContext treatedNavigablePath() {
			return getRuleContext(TreatedNavigablePathContext.class,0);
		}
		public CollectionValueNavigablePathContext collectionValueNavigablePath() {
			return getRuleContext(CollectionValueNavigablePathContext.class,0);
		}
		public MapKeyNavigablePathContext mapKeyNavigablePath() {
			return getRuleContext(MapKeyNavigablePathContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public SlicedPathAccessFragmentContext slicedPathAccessFragment() {
			return getRuleContext(SlicedPathAccessFragmentContext.class,0);
		}
		public ToOneFkReferenceContext toOneFkReference() {
			return getRuleContext(ToOneFkReferenceContext.class,0);
		}
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticDomainPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_syntacticDomainPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticDomainPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticDomainPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticDomainPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SyntacticDomainPathContext syntacticDomainPath() throws RecognitionException {
		SyntacticDomainPathContext _localctx = new SyntacticDomainPathContext(_ctx, getState());
		enterRule(_localctx, 106, RULE_syntacticDomainPath);
		try {
			setState(896);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,84,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(875);
				treatedNavigablePath();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(876);
				collectionValueNavigablePath();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(877);
				mapKeyNavigablePath();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(878);
				simplePath();
				setState(879);
				indexedPathAccessFragment();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(881);
				simplePath();
				setState(882);
				slicedPathAccessFragment();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(884);
				toOneFkReference();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(885);
				function();
				setState(886);
				pathContinuation();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(888);
				function();
				setState(889);
				indexedPathAccessFragment();
				setState(891);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,83,_ctx) ) {
				case 1:
					{
					setState(890);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(893);
				function();
				setState(894);
				slicedPathAccessFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralPathFragmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public GeneralPathFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalPathFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralPathFragmentContext generalPathFragment() throws RecognitionException {
		GeneralPathFragmentContext _localctx = new GeneralPathFragmentContext(_ctx, getState());
		enterRule(_localctx, 108, RULE_generalPathFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(898);
			simplePath();
			setState(900);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,85,_ctx) ) {
			case 1:
				{
				setState(899);
				indexedPathAccessFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndexedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public IndexedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexedPathAccessFragmentContext indexedPathAccessFragment() throws RecognitionException {
		IndexedPathAccessFragmentContext _localctx = new IndexedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 110, RULE_indexedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(902);
			match(LEFT_BRACKET);
			setState(903);
			expression(0);
			setState(904);
			match(RIGHT_BRACKET);
			setState(907);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,86,_ctx) ) {
			case 1:
				{
				setState(905);
				match(DOT);
				setState(906);
				generalPathFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SlicedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public SlicedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_slicedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSlicedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSlicedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSlicedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SlicedPathAccessFragmentContext slicedPathAccessFragment() throws RecognitionException {
		SlicedPathAccessFragmentContext _localctx = new SlicedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 112, RULE_slicedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(909);
			match(LEFT_BRACKET);
			setState(910);
			expression(0);
			setState(911);
			match(COLON);
			setState(912);
			expression(0);
			setState(913);
			match(RIGHT_BRACKET);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TreatedNavigablePathContext extends ParserRuleContext {
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public TreatedNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_treatedNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTreatedNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTreatedNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTreatedNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TreatedNavigablePathContext treatedNavigablePath() throws RecognitionException {
		TreatedNavigablePathContext _localctx = new TreatedNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 114, RULE_treatedNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(915);
			match(TREAT);
			setState(916);
			match(LEFT_PAREN);
			setState(917);
			path();
			setState(918);
			match(AS);
			setState(919);
			simplePath();
			setState(920);
			match(RIGHT_PAREN);
			setState(922);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,87,_ctx) ) {
			case 1:
				{
				setState(921);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionValueNavigablePathContext extends ParserRuleContext {
		public ElementValueQuantifierContext elementValueQuantifier() {
			return getRuleContext(ElementValueQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public CollectionValueNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionValueNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionValueNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionValueNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionValueNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionValueNavigablePathContext collectionValueNavigablePath() throws RecognitionException {
		CollectionValueNavigablePathContext _localctx = new CollectionValueNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 116, RULE_collectionValueNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(924);
			elementValueQuantifier();
			setState(925);
			match(LEFT_PAREN);
			setState(926);
			path();
			setState(927);
			match(RIGHT_PAREN);
			setState(929);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,88,_ctx) ) {
			case 1:
				{
				setState(928);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MapKeyNavigablePathContext extends ParserRuleContext {
		public IndexKeyQuantifierContext indexKeyQuantifier() {
			return getRuleContext(IndexKeyQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public MapKeyNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapKeyNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapKeyNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapKeyNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapKeyNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapKeyNavigablePathContext mapKeyNavigablePath() throws RecognitionException {
		MapKeyNavigablePathContext _localctx = new MapKeyNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 118, RULE_mapKeyNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(931);
			indexKeyQuantifier();
			setState(932);
			match(LEFT_PAREN);
			setState(933);
			path();
			setState(934);
			match(RIGHT_PAREN);
			setState(936);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,89,_ctx) ) {
			case 1:
				{
				setState(935);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GroupByClauseContext extends ParserRuleContext {
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<GroupByExpressionContext> groupByExpression() {
			return getRuleContexts(GroupByExpressionContext.class);
		}
		public GroupByExpressionContext groupByExpression(int i) {
			return getRuleContext(GroupByExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GroupByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByClauseContext groupByClause() throws RecognitionException {
		GroupByClauseContext _localctx = new GroupByClauseContext(_ctx, getState());
		enterRule(_localctx, 120, RULE_groupByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(938);
			match(GROUP);
			setState(939);
			match(BY);
			setState(940);
			groupByExpression();
			setState(945);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(941);
				match(COMMA);
				setState(942);
				groupByExpression();
				}
				}
				setState(947);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GroupByExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByExpressionContext groupByExpression() throws RecognitionException {
		GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
		enterRule(_localctx, 122, RULE_groupByExpression);
		try {
			setState(951);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,91,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(948);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(949);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(950);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class HavingClauseContext extends ParserRuleContext {
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public HavingClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_havingClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHavingClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHavingClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHavingClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HavingClauseContext havingClause() throws RecognitionException {
		HavingClauseContext _localctx = new HavingClauseContext(_ctx, getState());
		enterRule(_localctx, 124, RULE_havingClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(953);
			match(HAVING);
			setState(954);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderByClauseContext extends ParserRuleContext {
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByClauseContext orderByClause() throws RecognitionException {
		OrderByClauseContext _localctx = new OrderByClauseContext(_ctx, getState());
		enterRule(_localctx, 126, RULE_orderByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(956);
			match(ORDER);
			setState(957);
			match(BY);
			setState(958);
			sortSpecification();
			setState(963);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(959);
				match(COMMA);
				setState(960);
				sortSpecification();
				}
				}
				setState(965);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 128, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(966);
			sortSpecification();
			setState(971);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(967);
				match(COMMA);
				setState(968);
				sortSpecification();
				}
				}
				setState(973);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortSpecificationContext extends ParserRuleContext {
		public SortExpressionContext sortExpression() {
			return getRuleContext(SortExpressionContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 130, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(974);
			sortExpression();
			setState(976);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(975);
				sortDirection();
				}
			}

			setState(979);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(978);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 132, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(981);
			match(NULLS);
			setState(982);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SortExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortExpressionContext sortExpression() throws RecognitionException {
		SortExpressionContext _localctx = new SortExpressionContext(_ctx, getState());
		enterRule(_localctx, 134, RULE_sortExpression);
		try {
			setState(987);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,96,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(984);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(985);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(986);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortDirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public SortDirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortDirection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortDirectionContext sortDirection() throws RecognitionException {
		SortDirectionContext _localctx = new SortDirectionContext(_ctx, getState());
		enterRule(_localctx, 136, RULE_sortDirection);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(989);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollateFunctionContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CollationContext collation() {
			return getRuleContext(CollationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollateFunctionContext collateFunction() throws RecognitionException {
		CollateFunctionContext _localctx = new CollateFunctionContext(_ctx, getState());
		enterRule(_localctx, 138, RULE_collateFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(991);
			match(COLLATE);
			setState(992);
			match(LEFT_PAREN);
			setState(993);
			expression(0);
			setState(994);
			match(AS);
			setState(995);
			collation();
			setState(996);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollationContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public CollationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationContext collation() throws RecognitionException {
		CollationContext _localctx = new CollationContext(_ctx, getState());
		enterRule(_localctx, 140, RULE_collation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(998);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LimitClauseContext extends ParserRuleContext {
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public LimitClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_limitClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLimitClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLimitClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLimitClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LimitClauseContext limitClause() throws RecognitionException {
		LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
		enterRule(_localctx, 142, RULE_limitClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1000);
			match(LIMIT);
			setState(1001);
			parameterOrIntegerLiteral();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetClauseContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetClauseContext offsetClause() throws RecognitionException {
		OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
		enterRule(_localctx, 144, RULE_offsetClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1003);
			match(OFFSET);
			setState(1004);
			parameterOrIntegerLiteral();
			setState(1006);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ROW || _la==ROWS) {
				{
				setState(1005);
				_la = _input.LA(1);
				if ( !(_la==ROW || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FetchClauseContext extends ParserRuleContext {
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public FetchCountOrPercentContext fetchCountOrPercent() {
			return getRuleContext(FetchCountOrPercentContext.class,0);
		}
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public FetchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchClauseContext fetchClause() throws RecognitionException {
		FetchClauseContext _localctx = new FetchClauseContext(_ctx, getState());
		enterRule(_localctx, 146, RULE_fetchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1008);
			match(FETCH);
			setState(1009);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==NEXT) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1010);
			fetchCountOrPercent();
			setState(1011);
			_la = _input.LA(1);
			if ( !(_la==ROW || _la==ROWS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1015);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ONLY:
				{
				setState(1012);
				match(ONLY);
				}
				break;
			case WITH:
				{
				setState(1013);
				match(WITH);
				setState(1014);
				match(TIES);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FetchCountOrPercentContext extends ParserRuleContext {
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public ParameterOrNumberLiteralContext parameterOrNumberLiteral() {
			return getRuleContext(ParameterOrNumberLiteralContext.class,0);
		}
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public FetchCountOrPercentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchCountOrPercent; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchCountOrPercent(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchCountOrPercent(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchCountOrPercent(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchCountOrPercentContext fetchCountOrPercent() throws RecognitionException {
		FetchCountOrPercentContext _localctx = new FetchCountOrPercentContext(_ctx, getState());
		enterRule(_localctx, 148, RULE_fetchCountOrPercent);
		try {
			setState(1021);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,99,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1017);
				parameterOrIntegerLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1018);
				parameterOrNumberLiteral();
				setState(1019);
				match(PERCENT);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterOrIntegerLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ParameterOrIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrIntegerLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrIntegerLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrIntegerLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrIntegerLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() throws RecognitionException {
		ParameterOrIntegerLiteralContext _localctx = new ParameterOrIntegerLiteralContext(_ctx, getState());
		enterRule(_localctx, 150, RULE_parameterOrIntegerLiteral);
		try {
			setState(1025);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(1023);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1024);
				match(INTEGER_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterOrNumberLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public ParameterOrNumberLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrNumberLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrNumberLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrNumberLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrNumberLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrNumberLiteralContext parameterOrNumberLiteral() throws RecognitionException {
		ParameterOrNumberLiteralContext _localctx = new ParameterOrNumberLiteralContext(_ctx, getState());
		enterRule(_localctx, 152, RULE_parameterOrNumberLiteral);
		try {
			setState(1032);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(1027);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1028);
				match(INTEGER_LITERAL);
				}
				break;
			case LONG_LITERAL:
				enterOuterAlt(_localctx, 3);
				{
				setState(1029);
				match(LONG_LITERAL);
				}
				break;
			case FLOAT_LITERAL:
				enterOuterAlt(_localctx, 4);
				{
				setState(1030);
				match(FLOAT_LITERAL);
				}
				break;
			case DOUBLE_LITERAL:
				enterOuterAlt(_localctx, 5);
				{
				setState(1031);
				match(DOUBLE_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WhereClauseContext extends ParserRuleContext {
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public WhereClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_whereClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWhereClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWhereClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWhereClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WhereClauseContext whereClause() throws RecognitionException {
		WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
		enterRule(_localctx, 154, RULE_whereClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1034);
			match(WHERE);
			setState(1035);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PredicateContext extends ParserRuleContext {
		public PredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_predicate; }
	 
		public PredicateContext() { }
		public void copyFrom(PredicateContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsDistinctFromPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsDistinctFromPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsDistinctFromPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsDistinctFromPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsDistinctFromPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ContainsPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode CONTAINS() { return getToken(HqlParser.CONTAINS, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public ContainsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterContainsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitContainsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitContainsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BetweenPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public BetweenPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBetweenPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBetweenPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBetweenPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExistsPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ExistsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class AndPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public AndPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAndPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAndPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAndPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsFalsePredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsFalsePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsFalsePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsFalsePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsFalsePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GroupedPredicateContext extends PredicateContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class LikePredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public LikeEscapeContext likeEscape() {
			return getRuleContext(LikeEscapeContext.class,0);
		}
		public LikePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class InPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public InListContext inList() {
			return getRuleContext(InListContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public InPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IncludesPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode INCLUDES() { return getToken(HqlParser.INCLUDES, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IncludesPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIncludesPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIncludesPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIncludesPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ComparisonPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public ComparisonOperatorContext comparisonOperator() {
			return getRuleContext(ComparisonOperatorContext.class,0);
		}
		public ComparisonPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExistsCollectionPartPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ExistsCollectionPartPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsCollectionPartPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsCollectionPartPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsCollectionPartPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NegatedPredicateContext extends PredicateContext {
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public NegatedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNegatedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNegatedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNegatedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BooleanExpressionPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public BooleanExpressionPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanExpressionPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanExpressionPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanExpressionPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class OrPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public OrPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class MemberOfPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public MemberOfPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMemberOfPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMemberOfPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMemberOfPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsEmptyPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsEmptyPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsEmptyPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsEmptyPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsEmptyPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsNullPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsNullPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsNullPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsNullPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsNullPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsTruePredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsTruePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsTruePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsTruePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsTruePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IntersectsPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode INTERSECTS() { return getToken(HqlParser.INTERSECTS, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IntersectsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIntersectsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIntersectsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIntersectsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PredicateContext predicate() throws RecognitionException {
		return predicate(0);
	}

	private PredicateContext predicate(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		PredicateContext _localctx = new PredicateContext(_ctx, _parentState);
		PredicateContext _prevctx = _localctx;
		int _startState = 156;
		enterRecursionRule(_localctx, 156, RULE_predicate, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1150);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,116,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(1038);
				match(LEFT_PAREN);
				setState(1039);
				predicate(0);
				setState(1040);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new IsNullPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1042);
				expression(0);
				setState(1043);
				match(IS);
				setState(1045);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1044);
					match(NOT);
					}
				}

				setState(1047);
				match(NULL);
				}
				break;
			case 3:
				{
				_localctx = new IsEmptyPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1049);
				expression(0);
				setState(1050);
				match(IS);
				setState(1052);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1051);
					match(NOT);
					}
				}

				setState(1054);
				match(EMPTY);
				}
				break;
			case 4:
				{
				_localctx = new IsTruePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1056);
				expression(0);
				setState(1057);
				match(IS);
				setState(1059);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1058);
					match(NOT);
					}
				}

				setState(1061);
				match(TRUE);
				}
				break;
			case 5:
				{
				_localctx = new IsFalsePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1063);
				expression(0);
				setState(1064);
				match(IS);
				setState(1066);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1065);
					match(NOT);
					}
				}

				setState(1068);
				match(FALSE);
				}
				break;
			case 6:
				{
				_localctx = new IsDistinctFromPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1070);
				expression(0);
				setState(1071);
				match(IS);
				setState(1073);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1072);
					match(NOT);
					}
				}

				setState(1075);
				match(DISTINCT);
				setState(1076);
				match(FROM);
				setState(1077);
				expression(0);
				}
				break;
			case 7:
				{
				_localctx = new MemberOfPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1079);
				expression(0);
				setState(1081);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1080);
					match(NOT);
					}
				}

				setState(1083);
				match(MEMBER);
				setState(1085);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,108,_ctx) ) {
				case 1:
					{
					setState(1084);
					match(OF);
					}
					break;
				}
				setState(1087);
				path();
				}
				break;
			case 8:
				{
				_localctx = new InPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1089);
				expression(0);
				setState(1091);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1090);
					match(NOT);
					}
				}

				setState(1093);
				match(IN);
				setState(1094);
				inList();
				}
				break;
			case 9:
				{
				_localctx = new BetweenPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1096);
				expression(0);
				setState(1098);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1097);
					match(NOT);
					}
				}

				setState(1100);
				match(BETWEEN);
				setState(1101);
				expression(0);
				setState(1102);
				match(AND);
				setState(1103);
				expression(0);
				}
				break;
			case 10:
				{
				_localctx = new LikePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1105);
				expression(0);
				setState(1107);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1106);
					match(NOT);
					}
				}

				setState(1109);
				_la = _input.LA(1);
				if ( !(_la==ILIKE || _la==LIKE) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1110);
				expression(0);
				setState(1112);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,112,_ctx) ) {
				case 1:
					{
					setState(1111);
					likeEscape();
					}
					break;
				}
				}
				break;
			case 11:
				{
				_localctx = new ContainsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1114);
				expression(0);
				setState(1116);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1115);
					match(NOT);
					}
				}

				setState(1118);
				match(CONTAINS);
				setState(1119);
				expression(0);
				}
				break;
			case 12:
				{
				_localctx = new IncludesPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1121);
				expression(0);
				setState(1123);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1122);
					match(NOT);
					}
				}

				setState(1125);
				match(INCLUDES);
				setState(1126);
				expression(0);
				}
				break;
			case 13:
				{
				_localctx = new IntersectsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1128);
				expression(0);
				setState(1130);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1129);
					match(NOT);
					}
				}

				setState(1132);
				match(INTERSECTS);
				setState(1133);
				expression(0);
				}
				break;
			case 14:
				{
				_localctx = new ComparisonPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1135);
				expression(0);
				setState(1136);
				comparisonOperator();
				setState(1137);
				expression(0);
				}
				break;
			case 15:
				{
				_localctx = new ExistsCollectionPartPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1139);
				match(EXISTS);
				setState(1140);
				collectionQuantifier();
				setState(1141);
				match(LEFT_PAREN);
				setState(1142);
				simplePath();
				setState(1143);
				match(RIGHT_PAREN);
				}
				break;
			case 16:
				{
				_localctx = new ExistsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1145);
				match(EXISTS);
				setState(1146);
				expression(0);
				}
				break;
			case 17:
				{
				_localctx = new NegatedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1147);
				match(NOT);
				setState(1148);
				predicate(4);
				}
				break;
			case 18:
				{
				_localctx = new BooleanExpressionPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1149);
				expression(0);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1160);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,118,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1158);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,117,_ctx) ) {
					case 1:
						{
						_localctx = new AndPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1152);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1153);
						match(AND);
						setState(1154);
						predicate(4);
						}
						break;
					case 2:
						{
						_localctx = new OrPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1155);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1156);
						match(OR);
						setState(1157);
						predicate(3);
						}
						break;
					}
					} 
				}
				setState(1162);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,118,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ComparisonOperatorContext extends ParserRuleContext {
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public TerminalNode NOT_EQUAL() { return getToken(HqlParser.NOT_EQUAL, 0); }
		public TerminalNode GREATER() { return getToken(HqlParser.GREATER, 0); }
		public TerminalNode GREATER_EQUAL() { return getToken(HqlParser.GREATER_EQUAL, 0); }
		public TerminalNode LESS() { return getToken(HqlParser.LESS, 0); }
		public TerminalNode LESS_EQUAL() { return getToken(HqlParser.LESS_EQUAL, 0); }
		public ComparisonOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_comparisonOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ComparisonOperatorContext comparisonOperator() throws RecognitionException {
		ComparisonOperatorContext _localctx = new ComparisonOperatorContext(_ctx, getState());
		enterRule(_localctx, 158, RULE_comparisonOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1163);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 4128768L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InListContext extends ParserRuleContext {
		public InListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_inList; }
	 
		public InListContext() { }
		public void copyFrom(InListContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class PersistentCollectionReferenceInListContext extends InListContext {
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PersistentCollectionReferenceInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPersistentCollectionReferenceInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPersistentCollectionReferenceInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPersistentCollectionReferenceInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ParamInListContext extends InListContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParamInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParamInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParamInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParamInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExplicitTupleInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ExplicitTupleInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExplicitTupleInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExplicitTupleInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExplicitTupleInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ArrayInListContext extends InListContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ArrayInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterArrayInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitArrayInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitArrayInList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InListContext inList() throws RecognitionException {
		InListContext _localctx = new InListContext(_ctx, getState());
		enterRule(_localctx, 160, RULE_inList);
		int _la;
		try {
			setState(1188);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,121,_ctx) ) {
			case 1:
				_localctx = new PersistentCollectionReferenceInListContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1165);
				collectionQuantifier();
				setState(1166);
				match(LEFT_PAREN);
				setState(1167);
				simplePath();
				setState(1168);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new ExplicitTupleInListContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1170);
				match(LEFT_PAREN);
				setState(1179);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -3157522317320L) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -1L) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -1L) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & 2147483647L) != 0)) {
					{
					setState(1171);
					expressionOrPredicate();
					setState(1176);
					_errHandler.sync(this);
					_la = _input.LA(1);
					while (_la==COMMA) {
						{
						{
						setState(1172);
						match(COMMA);
						setState(1173);
						expressionOrPredicate();
						}
						}
						setState(1178);
						_errHandler.sync(this);
						_la = _input.LA(1);
					}
					}
				}

				setState(1181);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new SubqueryInListContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1182);
				match(LEFT_PAREN);
				setState(1183);
				subquery();
				setState(1184);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new ParamInListContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1186);
				parameter();
				}
				break;
			case 5:
				_localctx = new ArrayInListContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1187);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LikeEscapeContext extends ParserRuleContext {
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public LikeEscapeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_likeEscape; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikeEscape(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikeEscape(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikeEscape(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LikeEscapeContext likeEscape() throws RecognitionException {
		LikeEscapeContext _localctx = new LikeEscapeContext(_ctx, getState());
		enterRule(_localctx, 162, RULE_likeEscape);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1190);
			match(ESCAPE);
			setState(1194);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				{
				setState(1191);
				match(STRING_LITERAL);
				}
				break;
			case JAVA_STRING_LITERAL:
				{
				setState(1192);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1193);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class AdditionExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public AdditiveOperatorContext additiveOperator() {
			return getRuleContext(AdditiveOperatorContext.class,0);
		}
		public AdditionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class FromDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public FromDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BarePrimaryExpressionContext extends ExpressionContext {
		public PrimaryExpressionContext primaryExpression() {
			return getRuleContext(PrimaryExpressionContext.class,0);
		}
		public BarePrimaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBarePrimaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBarePrimaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBarePrimaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class TupleExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TupleExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTupleExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTupleExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTupleExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class UnaryExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public UnaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GroupedExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ConcatenationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode DOUBLE_PIPE() { return getToken(HqlParser.DOUBLE_PIPE, 0); }
		public ConcatenationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConcatenationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConcatenationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConcatenationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class MultiplicationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public MultiplicativeOperatorContext multiplicativeOperator() {
			return getRuleContext(MultiplicativeOperatorContext.class,0);
		}
		public MultiplicationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ToDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ToDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class UnaryNumericLiteralExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public UnaryNumericLiteralExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryNumericLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryNumericLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryNumericLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		return expression(0);
	}

	private ExpressionContext expression(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		ExpressionContext _localctx = new ExpressionContext(_ctx, _parentState);
		ExpressionContext _prevctx = _localctx;
		int _startState = 164;
		enterRecursionRule(_localctx, 164, RULE_expression, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1222);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,124,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(1197);
				match(LEFT_PAREN);
				setState(1198);
				expression(0);
				setState(1199);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new TupleExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1201);
				match(LEFT_PAREN);
				setState(1202);
				expressionOrPredicate();
				setState(1205); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(1203);
					match(COMMA);
					setState(1204);
					expressionOrPredicate();
					}
					}
					setState(1207); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==COMMA );
				setState(1209);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				{
				_localctx = new SubqueryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1211);
				match(LEFT_PAREN);
				setState(1212);
				subquery();
				setState(1213);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				{
				_localctx = new BarePrimaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1215);
				primaryExpression();
				}
				break;
			case 5:
				{
				_localctx = new UnaryNumericLiteralExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1216);
				signOperator();
				setState(1217);
				numericLiteral();
				}
				break;
			case 6:
				{
				_localctx = new UnaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1219);
				signOperator();
				setState(1220);
				expression(6);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1242);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,126,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1240);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,125,_ctx) ) {
					case 1:
						{
						_localctx = new MultiplicationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1224);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1225);
						multiplicativeOperator();
						setState(1226);
						expression(4);
						}
						break;
					case 2:
						{
						_localctx = new AdditionExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1228);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1229);
						additiveOperator();
						setState(1230);
						expression(3);
						}
						break;
					case 3:
						{
						_localctx = new ConcatenationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1232);
						if (!(precpred(_ctx, 1))) throw new FailedPredicateException(this, "precpred(_ctx, 1)");
						setState(1233);
						match(DOUBLE_PIPE);
						setState(1234);
						expression(2);
						}
						break;
					case 4:
						{
						_localctx = new ToDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1235);
						if (!(precpred(_ctx, 5))) throw new FailedPredicateException(this, "precpred(_ctx, 5)");
						setState(1236);
						datetimeField();
						}
						break;
					case 5:
						{
						_localctx = new FromDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1237);
						if (!(precpred(_ctx, 4))) throw new FailedPredicateException(this, "precpred(_ctx, 4)");
						setState(1238);
						match(BY);
						setState(1239);
						datetimeField();
						}
						break;
					}
					} 
				}
				setState(1244);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,126,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PrimaryExpressionContext extends ParserRuleContext {
		public PrimaryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_primaryExpression; }
	 
		public PrimaryExpressionContext() { }
		public void copyFrom(PrimaryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class FunctionExpressionContext extends PrimaryExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class LiteralExpressionContext extends PrimaryExpressionContext {
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public LiteralExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ParameterExpressionContext extends PrimaryExpressionContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParameterExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityTypeExpressionContext extends PrimaryExpressionContext {
		public EntityTypeReferenceContext entityTypeReference() {
			return getRuleContext(EntityTypeReferenceContext.class,0);
		}
		public EntityTypeExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityIdExpressionContext extends PrimaryExpressionContext {
		public EntityIdReferenceContext entityIdReference() {
			return getRuleContext(EntityIdReferenceContext.class,0);
		}
		public EntityIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityVersionExpressionContext extends PrimaryExpressionContext {
		public EntityVersionReferenceContext entityVersionReference() {
			return getRuleContext(EntityVersionReferenceContext.class,0);
		}
		public EntityVersionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GeneralPathExpressionContext extends PrimaryExpressionContext {
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public GeneralPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityNaturalIdExpressionContext extends PrimaryExpressionContext {
		public EntityNaturalIdReferenceContext entityNaturalIdReference() {
			return getRuleContext(EntityNaturalIdReferenceContext.class,0);
		}
		public EntityNaturalIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class CaseExpressionContext extends PrimaryExpressionContext {
		public CaseListContext caseList() {
			return getRuleContext(CaseListContext.class,0);
		}
		public CaseExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SyntacticPathExpressionContext extends PrimaryExpressionContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PrimaryExpressionContext primaryExpression() throws RecognitionException {
		PrimaryExpressionContext _localctx = new PrimaryExpressionContext(_ctx, getState());
		enterRule(_localctx, 166, RULE_primaryExpression);
		try {
			setState(1258);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,128,_ctx) ) {
			case 1:
				_localctx = new CaseExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1245);
				caseList();
				}
				break;
			case 2:
				_localctx = new LiteralExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1246);
				literal();
				}
				break;
			case 3:
				_localctx = new ParameterExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1247);
				parameter();
				}
				break;
			case 4:
				_localctx = new EntityTypeExpressionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1248);
				entityTypeReference();
				}
				break;
			case 5:
				_localctx = new EntityIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1249);
				entityIdReference();
				}
				break;
			case 6:
				_localctx = new EntityVersionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 6);
				{
				setState(1250);
				entityVersionReference();
				}
				break;
			case 7:
				_localctx = new EntityNaturalIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 7);
				{
				setState(1251);
				entityNaturalIdReference();
				}
				break;
			case 8:
				_localctx = new SyntacticPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 8);
				{
				setState(1252);
				syntacticDomainPath();
				setState(1254);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,127,_ctx) ) {
				case 1:
					{
					setState(1253);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 9:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 9);
				{
				setState(1256);
				function();
				}
				break;
			case 10:
				_localctx = new GeneralPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 10);
				{
				setState(1257);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExpressionOrPredicateContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public ExpressionOrPredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expressionOrPredicate; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExpressionOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExpressionOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExpressionOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionOrPredicateContext expressionOrPredicate() throws RecognitionException {
		ExpressionOrPredicateContext _localctx = new ExpressionOrPredicateContext(_ctx, getState());
		enterRule(_localctx, 168, RULE_expressionOrPredicate);
		try {
			setState(1262);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,129,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1260);
				expression(0);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1261);
				predicate(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionQuantifierContext extends ParserRuleContext {
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public CollectionQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionQuantifierContext collectionQuantifier() throws RecognitionException {
		CollectionQuantifierContext _localctx = new CollectionQuantifierContext(_ctx, getState());
		enterRule(_localctx, 170, RULE_collectionQuantifier);
		try {
			setState(1266);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
			case VALUES:
				enterOuterAlt(_localctx, 1);
				{
				setState(1264);
				elementsValuesQuantifier();
				}
				break;
			case INDICES:
			case KEYS:
				enterOuterAlt(_localctx, 2);
				{
				setState(1265);
				indicesKeysQuantifier();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ElementValueQuantifierContext extends ParserRuleContext {
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public ElementValueQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementValueQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementValueQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementValueQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementValueQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementValueQuantifierContext elementValueQuantifier() throws RecognitionException {
		ElementValueQuantifierContext _localctx = new ElementValueQuantifierContext(_ctx, getState());
		enterRule(_localctx, 172, RULE_elementValueQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1268);
			_la = _input.LA(1);
			if ( !(_la==ELEMENT || _la==VALUE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndexKeyQuantifierContext extends ParserRuleContext {
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public IndexKeyQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexKeyQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexKeyQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexKeyQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexKeyQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexKeyQuantifierContext indexKeyQuantifier() throws RecognitionException {
		IndexKeyQuantifierContext _localctx = new IndexKeyQuantifierContext(_ctx, getState());
		enterRule(_localctx, 174, RULE_indexKeyQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1270);
			_la = _input.LA(1);
			if ( !(_la==INDEX || _la==KEY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ElementsValuesQuantifierContext extends ParserRuleContext {
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public ElementsValuesQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementsValuesQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementsValuesQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementsValuesQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementsValuesQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementsValuesQuantifierContext elementsValuesQuantifier() throws RecognitionException {
		ElementsValuesQuantifierContext _localctx = new ElementsValuesQuantifierContext(_ctx, getState());
		enterRule(_localctx, 176, RULE_elementsValuesQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1272);
			_la = _input.LA(1);
			if ( !(_la==ELEMENTS || _la==VALUES) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndicesKeysQuantifierContext extends ParserRuleContext {
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode KEYS() { return getToken(HqlParser.KEYS, 0); }
		public IndicesKeysQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indicesKeysQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndicesKeysQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndicesKeysQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndicesKeysQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndicesKeysQuantifierContext indicesKeysQuantifier() throws RecognitionException {
		IndicesKeysQuantifierContext _localctx = new IndicesKeysQuantifierContext(_ctx, getState());
		enterRule(_localctx, 178, RULE_indicesKeysQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1274);
			_la = _input.LA(1);
			if ( !(_la==INDICES || _la==KEYS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MultiplicativeOperatorContext extends ParserRuleContext {
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode PERCENT_OP() { return getToken(HqlParser.PERCENT_OP, 0); }
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public MultiplicativeOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_multiplicativeOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicativeOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicativeOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicativeOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MultiplicativeOperatorContext multiplicativeOperator() throws RecognitionException {
		MultiplicativeOperatorContext _localctx = new MultiplicativeOperatorContext(_ctx, getState());
		enterRule(_localctx, 180, RULE_multiplicativeOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1276);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 30064771072L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AdditiveOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public AdditiveOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_additiveOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditiveOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditiveOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditiveOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AdditiveOperatorContext additiveOperator() throws RecognitionException {
		AdditiveOperatorContext _localctx = new AdditiveOperatorContext(_ctx, getState());
		enterRule(_localctx, 182, RULE_additiveOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1278);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SignOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public SignOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_signOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSignOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSignOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSignOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SignOperatorContext signOperator() throws RecognitionException {
		SignOperatorContext _localctx = new SignOperatorContext(_ctx, getState());
		enterRule(_localctx, 184, RULE_signOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1280);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityTypeReferenceContext extends ParserRuleContext {
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public EntityTypeReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityTypeReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityTypeReferenceContext entityTypeReference() throws RecognitionException {
		EntityTypeReferenceContext _localctx = new EntityTypeReferenceContext(_ctx, getState());
		enterRule(_localctx, 186, RULE_entityTypeReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1282);
			match(TYPE);
			setState(1283);
			match(LEFT_PAREN);
			setState(1286);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1284);
				path();
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1285);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1288);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityIdReferenceContext extends ParserRuleContext {
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityIdReferenceContext entityIdReference() throws RecognitionException {
		EntityIdReferenceContext _localctx = new EntityIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 188, RULE_entityIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1290);
			match(ID);
			setState(1291);
			match(LEFT_PAREN);
			setState(1292);
			path();
			setState(1293);
			match(RIGHT_PAREN);
			setState(1295);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,132,_ctx) ) {
			case 1:
				{
				setState(1294);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityVersionReferenceContext extends ParserRuleContext {
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public EntityVersionReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityVersionReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityVersionReferenceContext entityVersionReference() throws RecognitionException {
		EntityVersionReferenceContext _localctx = new EntityVersionReferenceContext(_ctx, getState());
		enterRule(_localctx, 190, RULE_entityVersionReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1297);
			match(VERSION);
			setState(1298);
			match(LEFT_PAREN);
			setState(1299);
			path();
			setState(1300);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityNaturalIdReferenceContext extends ParserRuleContext {
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityNaturalIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityNaturalIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNaturalIdReferenceContext entityNaturalIdReference() throws RecognitionException {
		EntityNaturalIdReferenceContext _localctx = new EntityNaturalIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 192, RULE_entityNaturalIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1302);
			match(NATURALID);
			setState(1303);
			match(LEFT_PAREN);
			setState(1304);
			path();
			setState(1305);
			match(RIGHT_PAREN);
			setState(1307);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,133,_ctx) ) {
			case 1:
				{
				setState(1306);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ToOneFkReferenceContext extends ParserRuleContext {
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ToOneFkReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_toOneFkReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ToOneFkReferenceContext toOneFkReference() throws RecognitionException {
		ToOneFkReferenceContext _localctx = new ToOneFkReferenceContext(_ctx, getState());
		enterRule(_localctx, 194, RULE_toOneFkReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1309);
			match(FK);
			setState(1310);
			match(LEFT_PAREN);
			setState(1311);
			path();
			setState(1312);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CaseListContext extends ParserRuleContext {
		public SimpleCaseListContext simpleCaseList() {
			return getRuleContext(SimpleCaseListContext.class,0);
		}
		public SearchedCaseListContext searchedCaseList() {
			return getRuleContext(SearchedCaseListContext.class,0);
		}
		public CaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseListContext caseList() throws RecognitionException {
		CaseListContext _localctx = new CaseListContext(_ctx, getState());
		enterRule(_localctx, 196, RULE_caseList);
		try {
			setState(1316);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,134,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1314);
				simpleCaseList();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1315);
				searchedCaseList();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimpleCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SimpleCaseWhenContext> simpleCaseWhen() {
			return getRuleContexts(SimpleCaseWhenContext.class);
		}
		public SimpleCaseWhenContext simpleCaseWhen(int i) {
			return getRuleContext(SimpleCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SimpleCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseListContext simpleCaseList() throws RecognitionException {
		SimpleCaseListContext _localctx = new SimpleCaseListContext(_ctx, getState());
		enterRule(_localctx, 198, RULE_simpleCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1318);
			match(CASE);
			setState(1319);
			expressionOrPredicate();
			setState(1321); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1320);
				simpleCaseWhen();
				}
				}
				setState(1323); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1326);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1325);
				caseOtherwise();
				}
			}

			setState(1328);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimpleCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SimpleCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseWhenContext simpleCaseWhen() throws RecognitionException {
		SimpleCaseWhenContext _localctx = new SimpleCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 200, RULE_simpleCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1330);
			match(WHEN);
			setState(1331);
			expression(0);
			setState(1332);
			match(THEN);
			setState(1333);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CaseOtherwiseContext extends ParserRuleContext {
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public CaseOtherwiseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseOtherwise; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseOtherwise(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseOtherwise(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseOtherwise(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseOtherwiseContext caseOtherwise() throws RecognitionException {
		CaseOtherwiseContext _localctx = new CaseOtherwiseContext(_ctx, getState());
		enterRule(_localctx, 202, RULE_caseOtherwise);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1335);
			match(ELSE);
			setState(1336);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchedCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SearchedCaseWhenContext> searchedCaseWhen() {
			return getRuleContexts(SearchedCaseWhenContext.class);
		}
		public SearchedCaseWhenContext searchedCaseWhen(int i) {
			return getRuleContext(SearchedCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SearchedCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseListContext searchedCaseList() throws RecognitionException {
		SearchedCaseListContext _localctx = new SearchedCaseListContext(_ctx, getState());
		enterRule(_localctx, 204, RULE_searchedCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1338);
			match(CASE);
			setState(1340); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1339);
				searchedCaseWhen();
				}
				}
				setState(1342); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1345);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1344);
				caseOtherwise();
				}
			}

			setState(1347);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchedCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SearchedCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseWhenContext searchedCaseWhen() throws RecognitionException {
		SearchedCaseWhenContext _localctx = new SearchedCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 206, RULE_searchedCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1349);
			match(WHEN);
			setState(1350);
			predicate(0);
			setState(1351);
			match(THEN);
			setState(1352);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public BooleanLiteralContext booleanLiteral() {
			return getRuleContext(BooleanLiteralContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public BinaryLiteralContext binaryLiteral() {
			return getRuleContext(BinaryLiteralContext.class,0);
		}
		public TemporalLiteralContext temporalLiteral() {
			return getRuleContext(TemporalLiteralContext.class,0);
		}
		public ArrayLiteralContext arrayLiteral() {
			return getRuleContext(ArrayLiteralContext.class,0);
		}
		public GeneralizedLiteralContext generalizedLiteral() {
			return getRuleContext(GeneralizedLiteralContext.class,0);
		}
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 208, RULE_literal);
		try {
			setState(1363);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,139,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1354);
				match(STRING_LITERAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1355);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1356);
				match(NULL);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1357);
				booleanLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1358);
				numericLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1359);
				binaryLiteral();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1360);
				temporalLiteral();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1361);
				arrayLiteral();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1362);
				generalizedLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class BooleanLiteralContext extends ParserRuleContext {
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public BooleanLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_booleanLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BooleanLiteralContext booleanLiteral() throws RecognitionException {
		BooleanLiteralContext _localctx = new BooleanLiteralContext(_ctx, getState());
		enterRule(_localctx, 210, RULE_booleanLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1365);
			_la = _input.LA(1);
			if ( !(_la==TRUE || _la==FALSE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NumericLiteralContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(HqlParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(HqlParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(HqlParser.HEX_LITERAL, 0); }
		public NumericLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_numericLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNumericLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNumericLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNumericLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NumericLiteralContext numericLiteral() throws RecognitionException {
		NumericLiteralContext _localctx = new NumericLiteralContext(_ctx, getState());
		enterRule(_localctx, 212, RULE_numericLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1367);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 1016L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class BinaryLiteralContext extends ParserRuleContext {
		public TerminalNode BINARY_LITERAL() { return getToken(HqlParser.BINARY_LITERAL, 0); }
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public List<TerminalNode> HEX_LITERAL() { return getTokens(HqlParser.HEX_LITERAL); }
		public TerminalNode HEX_LITERAL(int i) {
			return getToken(HqlParser.HEX_LITERAL, i);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public BinaryLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_binaryLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBinaryLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBinaryLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBinaryLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BinaryLiteralContext binaryLiteral() throws RecognitionException {
		BinaryLiteralContext _localctx = new BinaryLiteralContext(_ctx, getState());
		enterRule(_localctx, 214, RULE_binaryLiteral);
		int _la;
		try {
			setState(1380);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case BINARY_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1369);
				match(BINARY_LITERAL);
				}
				break;
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1370);
				match(LEFT_BRACE);
				setState(1371);
				match(HEX_LITERAL);
				setState(1376);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1372);
					match(COMMA);
					setState(1373);
					match(HEX_LITERAL);
					}
					}
					setState(1378);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(1379);
				match(RIGHT_BRACE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TemporalLiteralContext extends ParserRuleContext {
		public DateTimeLiteralContext dateTimeLiteral() {
			return getRuleContext(DateTimeLiteralContext.class,0);
		}
		public DateLiteralContext dateLiteral() {
			return getRuleContext(DateLiteralContext.class,0);
		}
		public TimeLiteralContext timeLiteral() {
			return getRuleContext(TimeLiteralContext.class,0);
		}
		public JdbcTimestampLiteralContext jdbcTimestampLiteral() {
			return getRuleContext(JdbcTimestampLiteralContext.class,0);
		}
		public JdbcDateLiteralContext jdbcDateLiteral() {
			return getRuleContext(JdbcDateLiteralContext.class,0);
		}
		public JdbcTimeLiteralContext jdbcTimeLiteral() {
			return getRuleContext(JdbcTimeLiteralContext.class,0);
		}
		public TemporalLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_temporalLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTemporalLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTemporalLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTemporalLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TemporalLiteralContext temporalLiteral() throws RecognitionException {
		TemporalLiteralContext _localctx = new TemporalLiteralContext(_ctx, getState());
		enterRule(_localctx, 216, RULE_temporalLiteral);
		try {
			setState(1388);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,142,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1382);
				dateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1383);
				dateLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1384);
				timeLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1385);
				jdbcTimestampLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1386);
				jdbcDateLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1387);
				jdbcTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateTimeLiteralContext extends ParserRuleContext {
		public LocalDateTimeLiteralContext localDateTimeLiteral() {
			return getRuleContext(LocalDateTimeLiteralContext.class,0);
		}
		public ZonedDateTimeLiteralContext zonedDateTimeLiteral() {
			return getRuleContext(ZonedDateTimeLiteralContext.class,0);
		}
		public OffsetDateTimeLiteralContext offsetDateTimeLiteral() {
			return getRuleContext(OffsetDateTimeLiteralContext.class,0);
		}
		public DateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeLiteralContext dateTimeLiteral() throws RecognitionException {
		DateTimeLiteralContext _localctx = new DateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 218, RULE_dateTimeLiteral);
		try {
			setState(1393);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,143,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1390);
				localDateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1391);
				zonedDateTimeLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1392);
				offsetDateTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public LocalDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeLiteralContext localDateTimeLiteral() throws RecognitionException {
		LocalDateTimeLiteralContext _localctx = new LocalDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 220, RULE_localDateTimeLiteral);
		int _la;
		try {
			setState(1404);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1395);
				match(LEFT_BRACE);
				setState(1396);
				localDateTime();
				setState(1397);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1400);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1399);
					match(LOCAL);
					}
				}

				setState(1402);
				match(DATETIME);
				setState(1403);
				localDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZonedDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode ZONED() { return getToken(HqlParser.ZONED, 0); }
		public ZonedDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeLiteralContext zonedDateTimeLiteral() throws RecognitionException {
		ZonedDateTimeLiteralContext _localctx = new ZonedDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 222, RULE_zonedDateTimeLiteral);
		int _la;
		try {
			setState(1415);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1406);
				match(LEFT_BRACE);
				setState(1407);
				zonedDateTime();
				setState(1408);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case ZONED:
				enterOuterAlt(_localctx, 2);
				{
				setState(1411);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ZONED) {
					{
					setState(1410);
					match(ZONED);
					}
				}

				setState(1413);
				match(DATETIME);
				setState(1414);
				zonedDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() {
			return getRuleContext(OffsetDateTimeWithMinutesContext.class,0);
		}
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public OffsetDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeLiteralContext offsetDateTimeLiteral() throws RecognitionException {
		OffsetDateTimeLiteralContext _localctx = new OffsetDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 224, RULE_offsetDateTimeLiteral);
		int _la;
		try {
			setState(1426);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1417);
				match(LEFT_BRACE);
				setState(1418);
				offsetDateTime();
				setState(1419);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1422);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OFFSET) {
					{
					setState(1421);
					match(OFFSET);
					}
				}

				setState(1424);
				match(DATETIME);
				setState(1425);
				offsetDateTimeWithMinutes();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public DateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateLiteralContext dateLiteral() throws RecognitionException {
		DateLiteralContext _localctx = new DateLiteralContext(_ctx, getState());
		enterRule(_localctx, 226, RULE_dateLiteral);
		int _la;
		try {
			setState(1437);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1428);
				match(LEFT_BRACE);
				setState(1429);
				date();
				setState(1430);
				match(RIGHT_BRACE);
				}
				break;
			case DATE:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1433);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1432);
					match(LOCAL);
					}
				}

				setState(1435);
				match(DATE);
				setState(1436);
				date();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeLiteralContext timeLiteral() throws RecognitionException {
		TimeLiteralContext _localctx = new TimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 228, RULE_timeLiteral);
		int _la;
		try {
			setState(1448);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1439);
				match(LEFT_BRACE);
				setState(1440);
				time();
				setState(1441);
				match(RIGHT_BRACE);
				}
				break;
			case LOCAL:
			case TIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1444);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1443);
					match(LOCAL);
					}
				}

				setState(1446);
				match(TIME);
				setState(1447);
				time();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateTimeContext extends ParserRuleContext {
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public DateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeContext dateTime() throws RecognitionException {
		DateTimeContext _localctx = new DateTimeContext(_ctx, getState());
		enterRule(_localctx, 230, RULE_dateTime);
		try {
			setState(1453);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,154,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1450);
				localDateTime();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1451);
				zonedDateTime();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1452);
				offsetDateTime();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public LocalDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeContext localDateTime() throws RecognitionException {
		LocalDateTimeContext _localctx = new LocalDateTimeContext(_ctx, getState());
		enterRule(_localctx, 232, RULE_localDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1455);
			date();
			setState(1456);
			time();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZonedDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public ZoneIdContext zoneId() {
			return getRuleContext(ZoneIdContext.class,0);
		}
		public ZonedDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeContext zonedDateTime() throws RecognitionException {
		ZonedDateTimeContext _localctx = new ZonedDateTimeContext(_ctx, getState());
		enterRule(_localctx, 234, RULE_zonedDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1458);
			date();
			setState(1459);
			time();
			setState(1460);
			zoneId();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetContext offset() {
			return getRuleContext(OffsetContext.class,0);
		}
		public OffsetDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeContext offsetDateTime() throws RecognitionException {
		OffsetDateTimeContext _localctx = new OffsetDateTimeContext(_ctx, getState());
		enterRule(_localctx, 236, RULE_offsetDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1462);
			date();
			setState(1463);
			time();
			setState(1464);
			offset();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeWithMinutesContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetWithMinutesContext offsetWithMinutes() {
			return getRuleContext(OffsetWithMinutesContext.class,0);
		}
		public OffsetDateTimeWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() throws RecognitionException {
		OffsetDateTimeWithMinutesContext _localctx = new OffsetDateTimeWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 238, RULE_offsetDateTimeWithMinutes);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1466);
			date();
			setState(1467);
			time();
			setState(1468);
			offsetWithMinutes();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateContext extends ParserRuleContext {
		public YearContext year() {
			return getRuleContext(YearContext.class,0);
		}
		public List<TerminalNode> MINUS() { return getTokens(HqlParser.MINUS); }
		public TerminalNode MINUS(int i) {
			return getToken(HqlParser.MINUS, i);
		}
		public MonthContext month() {
			return getRuleContext(MonthContext.class,0);
		}
		public DayContext day() {
			return getRuleContext(DayContext.class,0);
		}
		public DateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_date; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateContext date() throws RecognitionException {
		DateContext _localctx = new DateContext(_ctx, getState());
		enterRule(_localctx, 240, RULE_date);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1470);
			year();
			setState(1471);
			match(MINUS);
			setState(1472);
			month();
			setState(1473);
			match(MINUS);
			setState(1474);
			day();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public List<TerminalNode> COLON() { return getTokens(HqlParser.COLON); }
		public TerminalNode COLON(int i) {
			return getToken(HqlParser.COLON, i);
		}
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public SecondContext second() {
			return getRuleContext(SecondContext.class,0);
		}
		public TimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_time; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeContext time() throws RecognitionException {
		TimeContext _localctx = new TimeContext(_ctx, getState());
		enterRule(_localctx, 242, RULE_time);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1476);
			hour();
			setState(1477);
			match(COLON);
			setState(1478);
			minute();
			setState(1481);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,155,_ctx) ) {
			case 1:
				{
				setState(1479);
				match(COLON);
				setState(1480);
				second();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public OffsetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offset; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffset(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffset(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffset(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetContext offset() throws RecognitionException {
		OffsetContext _localctx = new OffsetContext(_ctx, getState());
		enterRule(_localctx, 244, RULE_offset);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1483);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1484);
			hour();
			setState(1487);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COLON) {
				{
				setState(1485);
				match(COLON);
				setState(1486);
				minute();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetWithMinutesContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public OffsetWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetWithMinutesContext offsetWithMinutes() throws RecognitionException {
		OffsetWithMinutesContext _localctx = new OffsetWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 246, RULE_offsetWithMinutes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1489);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1490);
			hour();
			setState(1491);
			match(COLON);
			setState(1492);
			minute();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class YearContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public YearContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_year; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterYear(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitYear(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitYear(this);
			else return visitor.visitChildren(this);
		}
	}

	public final YearContext year() throws RecognitionException {
		YearContext _localctx = new YearContext(_ctx, getState());
		enterRule(_localctx, 248, RULE_year);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1494);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MonthContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MonthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_month; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMonth(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMonth(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMonth(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MonthContext month() throws RecognitionException {
		MonthContext _localctx = new MonthContext(_ctx, getState());
		enterRule(_localctx, 250, RULE_month);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1496);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DayContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public DayContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_day; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDay(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDay(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDay(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayContext day() throws RecognitionException {
		DayContext _localctx = new DayContext(_ctx, getState());
		enterRule(_localctx, 252, RULE_day);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1498);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class HourContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public HourContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_hour; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHour(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHour(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHour(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HourContext hour() throws RecognitionException {
		HourContext _localctx = new HourContext(_ctx, getState());
		enterRule(_localctx, 254, RULE_hour);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1500);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MinuteContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MinuteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_minute; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMinute(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMinute(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMinute(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MinuteContext minute() throws RecognitionException {
		MinuteContext _localctx = new MinuteContext(_ctx, getState());
		enterRule(_localctx, 256, RULE_minute);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1502);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SecondContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public SecondContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_second; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSecond(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSecond(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSecond(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SecondContext second() throws RecognitionException {
		SecondContext _localctx = new SecondContext(_ctx, getState());
		enterRule(_localctx, 258, RULE_second);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1504);
			_la = _input.LA(1);
			if ( !(_la==INTEGER_LITERAL || _la==DOUBLE_LITERAL) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZoneIdContext extends ParserRuleContext {
		public List<TerminalNode> IDENTIFIER() { return getTokens(HqlParser.IDENTIFIER); }
		public TerminalNode IDENTIFIER(int i) {
			return getToken(HqlParser.IDENTIFIER, i);
		}
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ZoneIdContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zoneId; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZoneId(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZoneId(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZoneId(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZoneIdContext zoneId() throws RecognitionException {
		ZoneIdContext _localctx = new ZoneIdContext(_ctx, getState());
		enterRule(_localctx, 260, RULE_zoneId);
		try {
			setState(1512);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1506);
				match(IDENTIFIER);
				setState(1509);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,157,_ctx) ) {
				case 1:
					{
					setState(1507);
					match(SLASH);
					setState(1508);
					match(IDENTIFIER);
					}
					break;
				}
				}
				break;
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1511);
				match(STRING_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcTimestampLiteralContext extends ParserRuleContext {
		public TerminalNode TIMESTAMP_ESCAPE_START() { return getToken(HqlParser.TIMESTAMP_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimestampLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimestampLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimestampLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimestampLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimestampLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimestampLiteralContext jdbcTimestampLiteral() throws RecognitionException {
		JdbcTimestampLiteralContext _localctx = new JdbcTimestampLiteralContext(_ctx, getState());
		enterRule(_localctx, 262, RULE_jdbcTimestampLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1514);
			match(TIMESTAMP_ESCAPE_START);
			setState(1517);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1515);
				dateTime();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1516);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1519);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcDateLiteralContext extends ParserRuleContext {
		public TerminalNode DATE_ESCAPE_START() { return getToken(HqlParser.DATE_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcDateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcDateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcDateLiteralContext jdbcDateLiteral() throws RecognitionException {
		JdbcDateLiteralContext _localctx = new JdbcDateLiteralContext(_ctx, getState());
		enterRule(_localctx, 264, RULE_jdbcDateLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1521);
			match(DATE_ESCAPE_START);
			setState(1524);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1522);
				date();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1523);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1526);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcTimeLiteralContext extends ParserRuleContext {
		public TerminalNode TIME_ESCAPE_START() { return getToken(HqlParser.TIME_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimeLiteralContext jdbcTimeLiteral() throws RecognitionException {
		JdbcTimeLiteralContext _localctx = new JdbcTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 266, RULE_jdbcTimeLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1528);
			match(TIME_ESCAPE_START);
			setState(1531);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1529);
				time();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1530);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1533);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericTemporalLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GenericTemporalLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericTemporalLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericTemporalLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericTemporalLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericTemporalLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericTemporalLiteralTextContext genericTemporalLiteralText() throws RecognitionException {
		GenericTemporalLiteralTextContext _localctx = new GenericTemporalLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 268, RULE_genericTemporalLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1535);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ArrayLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ArrayLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_arrayLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterArrayLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitArrayLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitArrayLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ArrayLiteralContext arrayLiteral() throws RecognitionException {
		ArrayLiteralContext _localctx = new ArrayLiteralContext(_ctx, getState());
		enterRule(_localctx, 270, RULE_arrayLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1537);
			match(LEFT_BRACKET);
			setState(1546);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -3157522317320L) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -1L) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -1L) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & 2147483647L) != 0)) {
				{
				setState(1538);
				expression(0);
				setState(1543);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1539);
					match(COMMA);
					setState(1540);
					expression(0);
					}
					}
					setState(1545);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				}
			}

			setState(1548);
			match(RIGHT_BRACKET);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public GeneralizedLiteralTypeContext generalizedLiteralType() {
			return getRuleContext(GeneralizedLiteralTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public GeneralizedLiteralTextContext generalizedLiteralText() {
			return getRuleContext(GeneralizedLiteralTextContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public GeneralizedLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralContext generalizedLiteral() throws RecognitionException {
		GeneralizedLiteralContext _localctx = new GeneralizedLiteralContext(_ctx, getState());
		enterRule(_localctx, 272, RULE_generalizedLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1550);
			match(LEFT_BRACE);
			setState(1551);
			generalizedLiteralType();
			setState(1552);
			match(COLON);
			setState(1553);
			generalizedLiteralText();
			setState(1554);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralTypeContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTypeContext generalizedLiteralType() throws RecognitionException {
		GeneralizedLiteralTypeContext _localctx = new GeneralizedLiteralTypeContext(_ctx, getState());
		enterRule(_localctx, 274, RULE_generalizedLiteralType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1556);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTextContext generalizedLiteralText() throws RecognitionException {
		GeneralizedLiteralTextContext _localctx = new GeneralizedLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 276, RULE_generalizedLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1558);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterContext extends ParserRuleContext {
		public ParameterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameter; }
	 
		public ParameterContext() { }
		public void copyFrom(ParameterContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NamedParameterContext extends ParameterContext {
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NamedParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNamedParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNamedParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNamedParameter(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class PositionalParameterContext extends ParameterContext {
		public TerminalNode QUESTION_MARK() { return getToken(HqlParser.QUESTION_MARK, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public PositionalParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionalParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionalParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionalParameter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterContext parameter() throws RecognitionException {
		ParameterContext _localctx = new ParameterContext(_ctx, getState());
		enterRule(_localctx, 278, RULE_parameter);
		try {
			setState(1566);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
				_localctx = new NamedParameterContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1560);
				match(COLON);
				setState(1561);
				identifier();
				}
				break;
			case QUESTION_MARK:
				_localctx = new PositionalParameterContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1562);
				match(QUESTION_MARK);
				setState(1564);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,164,_ctx) ) {
				case 1:
					{
					setState(1563);
					match(INTEGER_LITERAL);
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FunctionContext extends ParserRuleContext {
		public StandardFunctionContext standardFunction() {
			return getRuleContext(StandardFunctionContext.class,0);
		}
		public AggregateFunctionContext aggregateFunction() {
			return getRuleContext(AggregateFunctionContext.class,0);
		}
		public CollectionSizeFunctionContext collectionSizeFunction() {
			return getRuleContext(CollectionSizeFunctionContext.class,0);
		}
		public CollectionAggregateFunctionContext collectionAggregateFunction() {
			return getRuleContext(CollectionAggregateFunctionContext.class,0);
		}
		public CollectionFunctionMisuseContext collectionFunctionMisuse() {
			return getRuleContext(CollectionFunctionMisuseContext.class,0);
		}
		public JpaNonstandardFunctionContext jpaNonstandardFunction() {
			return getRuleContext(JpaNonstandardFunctionContext.class,0);
		}
		public ColumnFunctionContext columnFunction() {
			return getRuleContext(ColumnFunctionContext.class,0);
		}
		public GenericFunctionContext genericFunction() {
			return getRuleContext(GenericFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 280, RULE_function);
		try {
			setState(1576);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,166,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1568);
				standardFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1569);
				aggregateFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1570);
				collectionSizeFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1571);
				collectionAggregateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1572);
				collectionFunctionMisuse();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1573);
				jpaNonstandardFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1574);
				columnFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1575);
				genericFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaNonstandardFunctionContext extends ParserRuleContext {
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public JpaNonstandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionContext jpaNonstandardFunction() throws RecognitionException {
		JpaNonstandardFunctionContext _localctx = new JpaNonstandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 282, RULE_jpaNonstandardFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1578);
			match(FUNCTION);
			setState(1579);
			match(LEFT_PAREN);
			setState(1580);
			jpaNonstandardFunctionName();
			setState(1583);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==AS) {
				{
				setState(1581);
				match(AS);
				setState(1582);
				castTarget();
				}
			}

			setState(1587);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(1585);
				match(COMMA);
				setState(1586);
				genericFunctionArguments();
				}
			}

			setState(1589);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaNonstandardFunctionNameContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public JpaNonstandardFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() throws RecognitionException {
		JpaNonstandardFunctionNameContext _localctx = new JpaNonstandardFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 284, RULE_jpaNonstandardFunctionName);
		try {
			setState(1593);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1591);
				match(STRING_LITERAL);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(1592);
				identifier();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ColumnFunctionContext extends ParserRuleContext {
		public TerminalNode COLUMN() { return getToken(HqlParser.COLUMN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public ColumnFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_columnFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterColumnFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitColumnFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitColumnFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ColumnFunctionContext columnFunction() throws RecognitionException {
		ColumnFunctionContext _localctx = new ColumnFunctionContext(_ctx, getState());
		enterRule(_localctx, 286, RULE_columnFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1595);
			match(COLUMN);
			setState(1596);
			match(LEFT_PAREN);
			setState(1597);
			path();
			setState(1598);
			match(DOT);
			setState(1599);
			jpaNonstandardFunctionName();
			setState(1602);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==AS) {
				{
				setState(1600);
				match(AS);
				setState(1601);
				castTarget();
				}
			}

			setState(1604);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionContext extends ParserRuleContext {
		public GenericFunctionNameContext genericFunctionName() {
			return getRuleContext(GenericFunctionNameContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public NthSideClauseContext nthSideClause() {
			return getRuleContext(NthSideClauseContext.class,0);
		}
		public NullsClauseContext nullsClause() {
			return getRuleContext(NullsClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public GenericFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionContext genericFunction() throws RecognitionException {
		GenericFunctionContext _localctx = new GenericFunctionContext(_ctx, getState());
		enterRule(_localctx, 288, RULE_genericFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1606);
			genericFunctionName();
			setState(1607);
			match(LEFT_PAREN);
			setState(1610);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_INTEGER_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case HEX_LITERAL:
			case STRING_LITERAL:
			case JAVA_STRING_LITERAL:
			case BINARY_LITERAL:
			case TIMESTAMP_ESCAPE_START:
			case DATE_ESCAPE_START:
			case TIME_ESCAPE_START:
			case LEFT_PAREN:
			case LEFT_BRACKET:
			case LEFT_BRACE:
			case PLUS:
			case MINUS:
			case COLON:
			case QUESTION_MARK:
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case TRUE:
			case FALSE:
			case NULL:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1608);
				genericFunctionArguments();
				}
				break;
			case ASTERISK:
				{
				setState(1609);
				match(ASTERISK);
				}
				break;
			case RIGHT_PAREN:
				break;
			default:
				break;
			}
			setState(1612);
			match(RIGHT_PAREN);
			setState(1614);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,172,_ctx) ) {
			case 1:
				{
				setState(1613);
				nthSideClause();
				}
				break;
			}
			setState(1617);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,173,_ctx) ) {
			case 1:
				{
				setState(1616);
				nullsClause();
				}
				break;
			}
			setState(1620);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,174,_ctx) ) {
			case 1:
				{
				setState(1619);
				withinGroupClause();
				}
				break;
			}
			setState(1623);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,175,_ctx) ) {
			case 1:
				{
				setState(1622);
				filterClause();
				}
				break;
			}
			setState(1626);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,176,_ctx) ) {
			case 1:
				{
				setState(1625);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionNameContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public GenericFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionNameContext genericFunctionName() throws RecognitionException {
		GenericFunctionNameContext _localctx = new GenericFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 290, RULE_genericFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1628);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionArgumentsContext extends ParserRuleContext {
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GenericFunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionArgumentsContext genericFunctionArguments() throws RecognitionException {
		GenericFunctionArgumentsContext _localctx = new GenericFunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 292, RULE_genericFunctionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1634);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,177,_ctx) ) {
			case 1:
				{
				setState(1630);
				match(DISTINCT);
				}
				break;
			case 2:
				{
				setState(1631);
				datetimeField();
				setState(1632);
				match(COMMA);
				}
				break;
			}
			setState(1636);
			expressionOrPredicate();
			setState(1641);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1637);
				match(COMMA);
				setState(1638);
				expressionOrPredicate();
				}
				}
				setState(1643);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionSizeFunctionContext extends ParserRuleContext {
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollectionSizeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionSizeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionSizeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionSizeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionSizeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionSizeFunctionContext collectionSizeFunction() throws RecognitionException {
		CollectionSizeFunctionContext _localctx = new CollectionSizeFunctionContext(_ctx, getState());
		enterRule(_localctx, 294, RULE_collectionSizeFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1644);
			match(SIZE);
			setState(1645);
			match(LEFT_PAREN);
			setState(1646);
			path();
			setState(1647);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionAggregateFunctionContext extends ParserRuleContext {
		public CollectionAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionAggregateFunction; }
	 
		public CollectionAggregateFunctionContext() { }
		public void copyFrom(CollectionAggregateFunctionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IndexAggregateFunctionContext extends CollectionAggregateFunctionContext {
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public IndexAggregateFunctionContext(CollectionAggregateFunctionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ElementAggregateFunctionContext extends CollectionAggregateFunctionContext {
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public ElementAggregateFunctionContext(CollectionAggregateFunctionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionAggregateFunctionContext collectionAggregateFunction() throws RecognitionException {
		CollectionAggregateFunctionContext _localctx = new CollectionAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 296, RULE_collectionAggregateFunction);
		int _la;
		try {
			setState(1675);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,179,_ctx) ) {
			case 1:
				_localctx = new ElementAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1649);
				_la = _input.LA(1);
				if ( !(_la==AVG || ((((_la - 139)) & ~0x3f) == 0 && ((1L << (_la - 139)) & 2251799813685313L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1650);
				match(LEFT_PAREN);
				setState(1651);
				elementsValuesQuantifier();
				setState(1652);
				match(LEFT_PAREN);
				setState(1653);
				path();
				setState(1654);
				match(RIGHT_PAREN);
				setState(1655);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new IndexAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1657);
				_la = _input.LA(1);
				if ( !(_la==AVG || ((((_la - 139)) & ~0x3f) == 0 && ((1L << (_la - 139)) & 2251799813685313L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1658);
				match(LEFT_PAREN);
				setState(1659);
				indicesKeysQuantifier();
				setState(1660);
				match(LEFT_PAREN);
				setState(1661);
				path();
				setState(1662);
				match(RIGHT_PAREN);
				setState(1663);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new ElementAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1665);
				_la = _input.LA(1);
				if ( !(_la==MAXELEMENT || _la==MINELEMENT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1666);
				match(LEFT_PAREN);
				setState(1667);
				path();
				setState(1668);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new IndexAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1670);
				_la = _input.LA(1);
				if ( !(_la==MAXINDEX || _la==MININDEX) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1671);
				match(LEFT_PAREN);
				setState(1672);
				path();
				setState(1673);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionFunctionMisuseContext extends ParserRuleContext {
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public CollectionFunctionMisuseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionFunctionMisuse; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionFunctionMisuse(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionFunctionMisuse(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionFunctionMisuse(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionFunctionMisuseContext collectionFunctionMisuse() throws RecognitionException {
		CollectionFunctionMisuseContext _localctx = new CollectionFunctionMisuseContext(_ctx, getState());
		enterRule(_localctx, 298, RULE_collectionFunctionMisuse);
		try {
			setState(1687);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
			case VALUES:
				enterOuterAlt(_localctx, 1);
				{
				setState(1677);
				elementsValuesQuantifier();
				setState(1678);
				match(LEFT_PAREN);
				setState(1679);
				path();
				setState(1680);
				match(RIGHT_PAREN);
				}
				break;
			case INDICES:
			case KEYS:
				enterOuterAlt(_localctx, 2);
				{
				setState(1682);
				indicesKeysQuantifier();
				setState(1683);
				match(LEFT_PAREN);
				setState(1684);
				path();
				setState(1685);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AggregateFunctionContext extends ParserRuleContext {
		public EveryFunctionContext everyFunction() {
			return getRuleContext(EveryFunctionContext.class,0);
		}
		public AnyFunctionContext anyFunction() {
			return getRuleContext(AnyFunctionContext.class,0);
		}
		public ListaggFunctionContext listaggFunction() {
			return getRuleContext(ListaggFunctionContext.class,0);
		}
		public AggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_aggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AggregateFunctionContext aggregateFunction() throws RecognitionException {
		AggregateFunctionContext _localctx = new AggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 300, RULE_aggregateFunction);
		try {
			setState(1692);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ALL:
			case EVERY:
				enterOuterAlt(_localctx, 1);
				{
				setState(1689);
				everyFunction();
				}
				break;
			case ANY:
			case SOME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1690);
				anyFunction();
				}
				break;
			case LISTAGG:
				enterOuterAlt(_localctx, 3);
				{
				setState(1691);
				listaggFunction();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EveryFunctionContext extends ParserRuleContext {
		public EveryAllQuantifierContext everyAllQuantifier() {
			return getRuleContext(EveryAllQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public EveryFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryFunctionContext everyFunction() throws RecognitionException {
		EveryFunctionContext _localctx = new EveryFunctionContext(_ctx, getState());
		enterRule(_localctx, 302, RULE_everyFunction);
		try {
			setState(1715);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,184,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1694);
				everyAllQuantifier();
				setState(1695);
				match(LEFT_PAREN);
				setState(1696);
				predicate(0);
				setState(1697);
				match(RIGHT_PAREN);
				setState(1699);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,182,_ctx) ) {
				case 1:
					{
					setState(1698);
					filterClause();
					}
					break;
				}
				setState(1702);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,183,_ctx) ) {
				case 1:
					{
					setState(1701);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1704);
				everyAllQuantifier();
				setState(1705);
				match(LEFT_PAREN);
				setState(1706);
				subquery();
				setState(1707);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1709);
				everyAllQuantifier();
				setState(1710);
				collectionQuantifier();
				setState(1711);
				match(LEFT_PAREN);
				setState(1712);
				simplePath();
				setState(1713);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AnyFunctionContext extends ParserRuleContext {
		public AnySomeQuantifierContext anySomeQuantifier() {
			return getRuleContext(AnySomeQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public AnyFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnyFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnyFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnyFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnyFunctionContext anyFunction() throws RecognitionException {
		AnyFunctionContext _localctx = new AnyFunctionContext(_ctx, getState());
		enterRule(_localctx, 304, RULE_anyFunction);
		try {
			setState(1738);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,187,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1717);
				anySomeQuantifier();
				setState(1718);
				match(LEFT_PAREN);
				setState(1719);
				predicate(0);
				setState(1720);
				match(RIGHT_PAREN);
				setState(1722);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,185,_ctx) ) {
				case 1:
					{
					setState(1721);
					filterClause();
					}
					break;
				}
				setState(1725);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,186,_ctx) ) {
				case 1:
					{
					setState(1724);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1727);
				anySomeQuantifier();
				setState(1728);
				match(LEFT_PAREN);
				setState(1729);
				subquery();
				setState(1730);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1732);
				anySomeQuantifier();
				setState(1733);
				collectionQuantifier();
				setState(1734);
				match(LEFT_PAREN);
				setState(1735);
				simplePath();
				setState(1736);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EveryAllQuantifierContext extends ParserRuleContext {
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public EveryAllQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyAllQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryAllQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryAllQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryAllQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryAllQuantifierContext everyAllQuantifier() throws RecognitionException {
		EveryAllQuantifierContext _localctx = new EveryAllQuantifierContext(_ctx, getState());
		enterRule(_localctx, 306, RULE_everyAllQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1740);
			_la = _input.LA(1);
			if ( !(_la==ALL || _la==EVERY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AnySomeQuantifierContext extends ParserRuleContext {
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public AnySomeQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anySomeQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnySomeQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnySomeQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnySomeQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnySomeQuantifierContext anySomeQuantifier() throws RecognitionException {
		AnySomeQuantifierContext _localctx = new AnySomeQuantifierContext(_ctx, getState());
		enterRule(_localctx, 308, RULE_anySomeQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1742);
			_la = _input.LA(1);
			if ( !(_la==ANY || _la==SOME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ListaggFunctionContext extends ParserRuleContext {
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public OnOverflowClauseContext onOverflowClause() {
			return getRuleContext(OnOverflowClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public ListaggFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_listaggFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterListaggFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitListaggFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitListaggFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ListaggFunctionContext listaggFunction() throws RecognitionException {
		ListaggFunctionContext _localctx = new ListaggFunctionContext(_ctx, getState());
		enterRule(_localctx, 310, RULE_listaggFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1744);
			match(LISTAGG);
			setState(1745);
			match(LEFT_PAREN);
			setState(1747);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,188,_ctx) ) {
			case 1:
				{
				setState(1746);
				match(DISTINCT);
				}
				break;
			}
			setState(1749);
			expressionOrPredicate();
			setState(1750);
			match(COMMA);
			setState(1751);
			expressionOrPredicate();
			setState(1753);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(1752);
				onOverflowClause();
				}
			}

			setState(1755);
			match(RIGHT_PAREN);
			setState(1757);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,190,_ctx) ) {
			case 1:
				{
				setState(1756);
				withinGroupClause();
				}
				break;
			}
			setState(1760);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,191,_ctx) ) {
			case 1:
				{
				setState(1759);
				filterClause();
				}
				break;
			}
			setState(1763);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,192,_ctx) ) {
			case 1:
				{
				setState(1762);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OnOverflowClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OnOverflowClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_onOverflowClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOnOverflowClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOnOverflowClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOnOverflowClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OnOverflowClauseContext onOverflowClause() throws RecognitionException {
		OnOverflowClauseContext _localctx = new OnOverflowClauseContext(_ctx, getState());
		enterRule(_localctx, 312, RULE_onOverflowClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1765);
			match(ON);
			setState(1766);
			match(OVERFLOW);
			setState(1774);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ERROR:
				{
				setState(1767);
				match(ERROR);
				}
				break;
			case TRUNCATE:
				{
				setState(1768);
				match(TRUNCATE);
				setState(1770);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,193,_ctx) ) {
				case 1:
					{
					setState(1769);
					expression(0);
					}
					break;
				}
				setState(1772);
				_la = _input.LA(1);
				if ( !(_la==WITH || _la==WITHOUT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1773);
				match(COUNT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WithinGroupClauseContext extends ParserRuleContext {
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public WithinGroupClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withinGroupClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithinGroupClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithinGroupClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithinGroupClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithinGroupClauseContext withinGroupClause() throws RecognitionException {
		WithinGroupClauseContext _localctx = new WithinGroupClauseContext(_ctx, getState());
		enterRule(_localctx, 314, RULE_withinGroupClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1776);
			match(WITHIN);
			setState(1777);
			match(GROUP);
			setState(1778);
			match(LEFT_PAREN);
			setState(1779);
			orderByClause();
			setState(1780);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FilterClauseContext extends ParserRuleContext {
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_filterClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFilterClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFilterClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFilterClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FilterClauseContext filterClause() throws RecognitionException {
		FilterClauseContext _localctx = new FilterClauseContext(_ctx, getState());
		enterRule(_localctx, 316, RULE_filterClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1782);
			match(FILTER);
			setState(1783);
			match(LEFT_PAREN);
			setState(1784);
			whereClause();
			setState(1785);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NullsClauseContext extends ParserRuleContext {
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public NullsClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsClauseContext nullsClause() throws RecognitionException {
		NullsClauseContext _localctx = new NullsClauseContext(_ctx, getState());
		enterRule(_localctx, 318, RULE_nullsClause);
		try {
			setState(1791);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case RESPECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1787);
				match(RESPECT);
				setState(1788);
				match(NULLS);
				}
				break;
			case IGNORE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1789);
				match(IGNORE);
				setState(1790);
				match(NULLS);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NthSideClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NthSideClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nthSideClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNthSideClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNthSideClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNthSideClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NthSideClauseContext nthSideClause() throws RecognitionException {
		NthSideClauseContext _localctx = new NthSideClauseContext(_ctx, getState());
		enterRule(_localctx, 320, RULE_nthSideClause);
		try {
			setState(1797);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,196,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1793);
				match(FROM);
				setState(1794);
				match(FIRST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1795);
				match(FROM);
				setState(1796);
				match(LAST);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverClauseContext extends ParserRuleContext {
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PartitionClauseContext partitionClause() {
			return getRuleContext(PartitionClauseContext.class,0);
		}
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public FrameClauseContext frameClause() {
			return getRuleContext(FrameClauseContext.class,0);
		}
		public OverClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverClauseContext overClause() throws RecognitionException {
		OverClauseContext _localctx = new OverClauseContext(_ctx, getState());
		enterRule(_localctx, 322, RULE_overClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1799);
			match(OVER);
			setState(1800);
			match(LEFT_PAREN);
			setState(1802);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==PARTITION) {
				{
				setState(1801);
				partitionClause();
				}
			}

			setState(1805);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ORDER) {
				{
				setState(1804);
				orderByClause();
				}
			}

			setState(1808);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==GROUPS || _la==RANGE || _la==ROWS) {
				{
				setState(1807);
				frameClause();
				}
			}

			setState(1810);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PartitionClauseContext extends ParserRuleContext {
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public PartitionClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_partitionClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPartitionClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPartitionClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPartitionClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PartitionClauseContext partitionClause() throws RecognitionException {
		PartitionClauseContext _localctx = new PartitionClauseContext(_ctx, getState());
		enterRule(_localctx, 324, RULE_partitionClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1812);
			match(PARTITION);
			setState(1813);
			match(BY);
			setState(1814);
			expression(0);
			setState(1819);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1815);
				match(COMMA);
				setState(1816);
				expression(0);
				}
				}
				setState(1821);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameClauseContext extends ParserRuleContext {
		public FrameStartContext frameStart() {
			return getRuleContext(FrameStartContext.class,0);
		}
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public FrameExclusionContext frameExclusion() {
			return getRuleContext(FrameExclusionContext.class,0);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public FrameEndContext frameEnd() {
			return getRuleContext(FrameEndContext.class,0);
		}
		public FrameClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameClauseContext frameClause() throws RecognitionException {
		FrameClauseContext _localctx = new FrameClauseContext(_ctx, getState());
		enterRule(_localctx, 326, RULE_frameClause);
		int _la;
		try {
			setState(1835);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,203,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1822);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1823);
				frameStart();
				setState(1825);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1824);
					frameExclusion();
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1827);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1828);
				match(BETWEEN);
				setState(1829);
				frameStart();
				setState(1830);
				match(AND);
				setState(1831);
				frameEnd();
				setState(1833);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1832);
					frameExclusion();
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameStartContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public FrameStartContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameStart; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameStart(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameStart(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameStart(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameStartContext frameStart() throws RecognitionException {
		FrameStartContext _localctx = new FrameStartContext(_ctx, getState());
		enterRule(_localctx, 328, RULE_frameStart);
		try {
			setState(1847);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,204,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1837);
				match(CURRENT);
				setState(1838);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1839);
				match(UNBOUNDED);
				setState(1840);
				match(PRECEDING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1841);
				expression(0);
				setState(1842);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1844);
				expression(0);
				setState(1845);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameEndContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public FrameEndContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameEnd; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameEnd(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameEnd(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameEnd(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameEndContext frameEnd() throws RecognitionException {
		FrameEndContext _localctx = new FrameEndContext(_ctx, getState());
		enterRule(_localctx, 330, RULE_frameEnd);
		try {
			setState(1859);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,205,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1849);
				match(CURRENT);
				setState(1850);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1851);
				match(UNBOUNDED);
				setState(1852);
				match(FOLLOWING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1853);
				expression(0);
				setState(1854);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1856);
				expression(0);
				setState(1857);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameExclusionContext extends ParserRuleContext {
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public FrameExclusionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameExclusion; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameExclusion(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameExclusion(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameExclusion(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameExclusionContext frameExclusion() throws RecognitionException {
		FrameExclusionContext _localctx = new FrameExclusionContext(_ctx, getState());
		enterRule(_localctx, 332, RULE_frameExclusion);
		try {
			setState(1871);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,206,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1861);
				match(EXCLUDE);
				setState(1862);
				match(CURRENT);
				setState(1863);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1864);
				match(EXCLUDE);
				setState(1865);
				match(GROUP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1866);
				match(EXCLUDE);
				setState(1867);
				match(TIES);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1868);
				match(EXCLUDE);
				setState(1869);
				match(NO);
				setState(1870);
				match(OTHERS);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class StandardFunctionContext extends ParserRuleContext {
		public CastFunctionContext castFunction() {
			return getRuleContext(CastFunctionContext.class,0);
		}
		public ExtractFunctionContext extractFunction() {
			return getRuleContext(ExtractFunctionContext.class,0);
		}
		public TruncFunctionContext truncFunction() {
			return getRuleContext(TruncFunctionContext.class,0);
		}
		public FormatFunctionContext formatFunction() {
			return getRuleContext(FormatFunctionContext.class,0);
		}
		public CollateFunctionContext collateFunction() {
			return getRuleContext(CollateFunctionContext.class,0);
		}
		public SubstringFunctionContext substringFunction() {
			return getRuleContext(SubstringFunctionContext.class,0);
		}
		public OverlayFunctionContext overlayFunction() {
			return getRuleContext(OverlayFunctionContext.class,0);
		}
		public TrimFunctionContext trimFunction() {
			return getRuleContext(TrimFunctionContext.class,0);
		}
		public PadFunctionContext padFunction() {
			return getRuleContext(PadFunctionContext.class,0);
		}
		public PositionFunctionContext positionFunction() {
			return getRuleContext(PositionFunctionContext.class,0);
		}
		public CurrentDateFunctionContext currentDateFunction() {
			return getRuleContext(CurrentDateFunctionContext.class,0);
		}
		public CurrentTimeFunctionContext currentTimeFunction() {
			return getRuleContext(CurrentTimeFunctionContext.class,0);
		}
		public CurrentTimestampFunctionContext currentTimestampFunction() {
			return getRuleContext(CurrentTimestampFunctionContext.class,0);
		}
		public InstantFunctionContext instantFunction() {
			return getRuleContext(InstantFunctionContext.class,0);
		}
		public LocalDateFunctionContext localDateFunction() {
			return getRuleContext(LocalDateFunctionContext.class,0);
		}
		public LocalTimeFunctionContext localTimeFunction() {
			return getRuleContext(LocalTimeFunctionContext.class,0);
		}
		public LocalDateTimeFunctionContext localDateTimeFunction() {
			return getRuleContext(LocalDateTimeFunctionContext.class,0);
		}
		public OffsetDateTimeFunctionContext offsetDateTimeFunction() {
			return getRuleContext(OffsetDateTimeFunctionContext.class,0);
		}
		public CubeContext cube() {
			return getRuleContext(CubeContext.class,0);
		}
		public RollupContext rollup() {
			return getRuleContext(RollupContext.class,0);
		}
		public StandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_standardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StandardFunctionContext standardFunction() throws RecognitionException {
		StandardFunctionContext _localctx = new StandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 334, RULE_standardFunction);
		try {
			setState(1893);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,207,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1873);
				castFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1874);
				extractFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1875);
				truncFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1876);
				formatFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1877);
				collateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1878);
				substringFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1879);
				overlayFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1880);
				trimFunction();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1881);
				padFunction();
				}
				break;
			case 10:
				enterOuterAlt(_localctx, 10);
				{
				setState(1882);
				positionFunction();
				}
				break;
			case 11:
				enterOuterAlt(_localctx, 11);
				{
				setState(1883);
				currentDateFunction();
				}
				break;
			case 12:
				enterOuterAlt(_localctx, 12);
				{
				setState(1884);
				currentTimeFunction();
				}
				break;
			case 13:
				enterOuterAlt(_localctx, 13);
				{
				setState(1885);
				currentTimestampFunction();
				}
				break;
			case 14:
				enterOuterAlt(_localctx, 14);
				{
				setState(1886);
				instantFunction();
				}
				break;
			case 15:
				enterOuterAlt(_localctx, 15);
				{
				setState(1887);
				localDateFunction();
				}
				break;
			case 16:
				enterOuterAlt(_localctx, 16);
				{
				setState(1888);
				localTimeFunction();
				}
				break;
			case 17:
				enterOuterAlt(_localctx, 17);
				{
				setState(1889);
				localDateTimeFunction();
				}
				break;
			case 18:
				enterOuterAlt(_localctx, 18);
				{
				setState(1890);
				offsetDateTimeFunction();
				}
				break;
			case 19:
				enterOuterAlt(_localctx, 19);
				{
				setState(1891);
				cube();
				}
				break;
			case 20:
				enterOuterAlt(_localctx, 20);
				{
				setState(1892);
				rollup();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastFunctionContext extends ParserRuleContext {
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CastFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastFunctionContext castFunction() throws RecognitionException {
		CastFunctionContext _localctx = new CastFunctionContext(_ctx, getState());
		enterRule(_localctx, 336, RULE_castFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1895);
			match(CAST);
			setState(1896);
			match(LEFT_PAREN);
			setState(1897);
			expression(0);
			setState(1898);
			match(AS);
			setState(1899);
			castTarget();
			setState(1900);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastTargetContext extends ParserRuleContext {
		public CastTargetTypeContext castTargetType() {
			return getRuleContext(CastTargetTypeContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<TerminalNode> INTEGER_LITERAL() { return getTokens(HqlParser.INTEGER_LITERAL); }
		public TerminalNode INTEGER_LITERAL(int i) {
			return getToken(HqlParser.INTEGER_LITERAL, i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public CastTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetContext castTarget() throws RecognitionException {
		CastTargetContext _localctx = new CastTargetContext(_ctx, getState());
		enterRule(_localctx, 338, RULE_castTarget);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1902);
			castTargetType();
			setState(1910);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN) {
				{
				setState(1903);
				match(LEFT_PAREN);
				setState(1904);
				match(INTEGER_LITERAL);
				setState(1907);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1905);
					match(COMMA);
					setState(1906);
					match(INTEGER_LITERAL);
					}
				}

				setState(1909);
				match(RIGHT_PAREN);
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastTargetTypeContext extends ParserRuleContext {
		public String fullTargetName;
		public IdentifierContext i;
		public IdentifierContext c;
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public CastTargetTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTargetType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTargetType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTargetType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTargetType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetTypeContext castTargetType() throws RecognitionException {
		CastTargetTypeContext _localctx = new CastTargetTypeContext(_ctx, getState());
		enterRule(_localctx, 340, RULE_castTargetType);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			{
			setState(1912);
			((CastTargetTypeContext)_localctx).i = identifier();
			 ((CastTargetTypeContext)_localctx).fullTargetName =  _localctx.i.getText(); 
			}
			setState(1921);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(1915);
				match(DOT);
				setState(1916);
				((CastTargetTypeContext)_localctx).c = identifier();
				 _localctx.fullTargetName += ("." + _localctx.c.getText() ); 
				}
				}
				setState(1923);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionContext extends ParserRuleContext {
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SubstringFunctionStartArgumentContext substringFunctionStartArgument() {
			return getRuleContext(SubstringFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() {
			return getRuleContext(SubstringFunctionLengthArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public SubstringFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionContext substringFunction() throws RecognitionException {
		SubstringFunctionContext _localctx = new SubstringFunctionContext(_ctx, getState());
		enterRule(_localctx, 342, RULE_substringFunction);
		int _la;
		try {
			setState(1946);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,213,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1924);
				match(SUBSTRING);
				setState(1925);
				match(LEFT_PAREN);
				setState(1926);
				expression(0);
				setState(1927);
				match(COMMA);
				setState(1928);
				substringFunctionStartArgument();
				setState(1931);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1929);
					match(COMMA);
					setState(1930);
					substringFunctionLengthArgument();
					}
				}

				setState(1933);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1935);
				match(SUBSTRING);
				setState(1936);
				match(LEFT_PAREN);
				setState(1937);
				expression(0);
				setState(1938);
				match(FROM);
				setState(1939);
				substringFunctionStartArgument();
				setState(1942);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FOR) {
					{
					setState(1940);
					match(FOR);
					setState(1941);
					substringFunctionLengthArgument();
					}
				}

				setState(1944);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionStartArgumentContext substringFunctionStartArgument() throws RecognitionException {
		SubstringFunctionStartArgumentContext _localctx = new SubstringFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 344, RULE_substringFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1948);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() throws RecognitionException {
		SubstringFunctionLengthArgumentContext _localctx = new SubstringFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 346, RULE_substringFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1950);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimFunctionContext extends ParserRuleContext {
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TrimSpecificationContext trimSpecification() {
			return getRuleContext(TrimSpecificationContext.class,0);
		}
		public TrimCharacterContext trimCharacter() {
			return getRuleContext(TrimCharacterContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimFunctionContext trimFunction() throws RecognitionException {
		TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
		enterRule(_localctx, 348, RULE_trimFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1952);
			match(TRIM);
			setState(1953);
			match(LEFT_PAREN);
			setState(1955);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,214,_ctx) ) {
			case 1:
				{
				setState(1954);
				trimSpecification();
				}
				break;
			}
			setState(1958);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,215,_ctx) ) {
			case 1:
				{
				setState(1957);
				trimCharacter();
				}
				break;
			}
			setState(1961);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,216,_ctx) ) {
			case 1:
				{
				setState(1960);
				match(FROM);
				}
				break;
			}
			setState(1963);
			expression(0);
			setState(1964);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TrimSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimSpecificationContext trimSpecification() throws RecognitionException {
		TrimSpecificationContext _localctx = new TrimSpecificationContext(_ctx, getState());
		enterRule(_localctx, 350, RULE_trimSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1966);
			_la = _input.LA(1);
			if ( !(_la==BOTH || _la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TrimCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimCharacterContext trimCharacter() throws RecognitionException {
		TrimCharacterContext _localctx = new TrimCharacterContext(_ctx, getState());
		enterRule(_localctx, 352, RULE_trimCharacter);
		try {
			setState(1970);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1968);
				match(STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 2);
				{
				setState(1969);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadFunctionContext extends ParserRuleContext {
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public PadLengthContext padLength() {
			return getRuleContext(PadLengthContext.class,0);
		}
		public PadSpecificationContext padSpecification() {
			return getRuleContext(PadSpecificationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PadCharacterContext padCharacter() {
			return getRuleContext(PadCharacterContext.class,0);
		}
		public PadFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadFunctionContext padFunction() throws RecognitionException {
		PadFunctionContext _localctx = new PadFunctionContext(_ctx, getState());
		enterRule(_localctx, 354, RULE_padFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1972);
			match(PAD);
			setState(1973);
			match(LEFT_PAREN);
			setState(1974);
			expression(0);
			setState(1975);
			match(WITH);
			setState(1976);
			padLength();
			setState(1977);
			padSpecification();
			setState(1979);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==STRING_LITERAL) {
				{
				setState(1978);
				padCharacter();
				}
			}

			setState(1981);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public PadSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadSpecificationContext padSpecification() throws RecognitionException {
		PadSpecificationContext _localctx = new PadSpecificationContext(_ctx, getState());
		enterRule(_localctx, 356, RULE_padSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1983);
			_la = _input.LA(1);
			if ( !(_la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public PadCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadCharacterContext padCharacter() throws RecognitionException {
		PadCharacterContext _localctx = new PadCharacterContext(_ctx, getState());
		enterRule(_localctx, 358, RULE_padCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1985);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadLengthContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PadLengthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padLength; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadLength(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadLength(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadLength(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadLengthContext padLength() throws RecognitionException {
		PadLengthContext _localctx = new PadLengthContext(_ctx, getState());
		enterRule(_localctx, 360, RULE_padLength);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1987);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionContext extends ParserRuleContext {
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OverlayFunctionStringArgumentContext overlayFunctionStringArgument() {
			return getRuleContext(OverlayFunctionStringArgumentContext.class,0);
		}
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() {
			return getRuleContext(OverlayFunctionReplacementArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public OverlayFunctionStartArgumentContext overlayFunctionStartArgument() {
			return getRuleContext(OverlayFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() {
			return getRuleContext(OverlayFunctionLengthArgumentContext.class,0);
		}
		public OverlayFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionContext overlayFunction() throws RecognitionException {
		OverlayFunctionContext _localctx = new OverlayFunctionContext(_ctx, getState());
		enterRule(_localctx, 362, RULE_overlayFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1989);
			match(OVERLAY);
			setState(1990);
			match(LEFT_PAREN);
			setState(1991);
			overlayFunctionStringArgument();
			setState(1992);
			match(PLACING);
			setState(1993);
			overlayFunctionReplacementArgument();
			setState(1994);
			match(FROM);
			setState(1995);
			overlayFunctionStartArgument();
			setState(1998);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FOR) {
				{
				setState(1996);
				match(FOR);
				setState(1997);
				overlayFunctionLengthArgument();
				}
			}

			setState(2000);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStringArgumentContext overlayFunctionStringArgument() throws RecognitionException {
		OverlayFunctionStringArgumentContext _localctx = new OverlayFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 364, RULE_overlayFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2002);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionReplacementArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionReplacementArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionReplacementArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionReplacementArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionReplacementArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionReplacementArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() throws RecognitionException {
		OverlayFunctionReplacementArgumentContext _localctx = new OverlayFunctionReplacementArgumentContext(_ctx, getState());
		enterRule(_localctx, 366, RULE_overlayFunctionReplacementArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2004);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStartArgumentContext overlayFunctionStartArgument() throws RecognitionException {
		OverlayFunctionStartArgumentContext _localctx = new OverlayFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 368, RULE_overlayFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2006);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() throws RecognitionException {
		OverlayFunctionLengthArgumentContext _localctx = new OverlayFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 370, RULE_overlayFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2008);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentDateFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public CurrentDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentDateFunctionContext currentDateFunction() throws RecognitionException {
		CurrentDateFunctionContext _localctx = new CurrentDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 372, RULE_currentDateFunction);
		try {
			setState(2017);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(2010);
				match(CURRENT_DATE);
				setState(2013);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,220,_ctx) ) {
				case 1:
					{
					setState(2011);
					match(LEFT_PAREN);
					setState(2012);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2015);
				match(CURRENT);
				setState(2016);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentTimeFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public CurrentTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimeFunctionContext currentTimeFunction() throws RecognitionException {
		CurrentTimeFunctionContext _localctx = new CurrentTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 374, RULE_currentTimeFunction);
		try {
			setState(2026);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(2019);
				match(CURRENT_TIME);
				setState(2022);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,222,_ctx) ) {
				case 1:
					{
					setState(2020);
					match(LEFT_PAREN);
					setState(2021);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2024);
				match(CURRENT);
				setState(2025);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentTimestampFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public CurrentTimestampFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimestampFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimestampFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimestampFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimestampFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimestampFunctionContext currentTimestampFunction() throws RecognitionException {
		CurrentTimestampFunctionContext _localctx = new CurrentTimestampFunctionContext(_ctx, getState());
		enterRule(_localctx, 376, RULE_currentTimestampFunction);
		try {
			setState(2035);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIMESTAMP:
				enterOuterAlt(_localctx, 1);
				{
				setState(2028);
				match(CURRENT_TIMESTAMP);
				setState(2031);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,224,_ctx) ) {
				case 1:
					{
					setState(2029);
					match(LEFT_PAREN);
					setState(2030);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2033);
				match(CURRENT);
				setState(2034);
				match(TIMESTAMP);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public InstantFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantFunctionContext instantFunction() throws RecognitionException {
		InstantFunctionContext _localctx = new InstantFunctionContext(_ctx, getState());
		enterRule(_localctx, 378, RULE_instantFunction);
		try {
			setState(2043);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_INSTANT:
				enterOuterAlt(_localctx, 1);
				{
				setState(2037);
				match(CURRENT_INSTANT);
				setState(2040);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,226,_ctx) ) {
				case 1:
					{
					setState(2038);
					match(LEFT_PAREN);
					setState(2039);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case INSTANT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2042);
				match(INSTANT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public LocalDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeFunctionContext localDateTimeFunction() throws RecognitionException {
		LocalDateTimeFunctionContext _localctx = new LocalDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 380, RULE_localDateTimeFunction);
		try {
			setState(2052);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(2045);
				match(LOCAL_DATETIME);
				setState(2048);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,228,_ctx) ) {
				case 1:
					{
					setState(2046);
					match(LEFT_PAREN);
					setState(2047);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(2050);
				match(LOCAL);
				setState(2051);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeFunctionContext offsetDateTimeFunction() throws RecognitionException {
		OffsetDateTimeFunctionContext _localctx = new OffsetDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 382, RULE_offsetDateTimeFunction);
		try {
			setState(2061);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(2054);
				match(OFFSET_DATETIME);
				setState(2057);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,230,_ctx) ) {
				case 1:
					{
					setState(2055);
					match(LEFT_PAREN);
					setState(2056);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(2059);
				match(OFFSET);
				setState(2060);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public LocalDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateFunctionContext localDateFunction() throws RecognitionException {
		LocalDateFunctionContext _localctx = new LocalDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 384, RULE_localDateFunction);
		try {
			setState(2070);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(2063);
				match(LOCAL_DATE);
				setState(2066);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,232,_ctx) ) {
				case 1:
					{
					setState(2064);
					match(LEFT_PAREN);
					setState(2065);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(2068);
				match(LOCAL);
				setState(2069);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public LocalTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalTimeFunctionContext localTimeFunction() throws RecognitionException {
		LocalTimeFunctionContext _localctx = new LocalTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 386, RULE_localTimeFunction);
		try {
			setState(2079);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(2072);
				match(LOCAL_TIME);
				setState(2075);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,234,_ctx) ) {
				case 1:
					{
					setState(2073);
					match(LEFT_PAREN);
					setState(2074);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(2077);
				match(LOCAL);
				setState(2078);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FormatFunctionContext extends ParserRuleContext {
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public FormatContext format() {
			return getRuleContext(FormatContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FormatFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_formatFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormatFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormatFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormatFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatFunctionContext formatFunction() throws RecognitionException {
		FormatFunctionContext _localctx = new FormatFunctionContext(_ctx, getState());
		enterRule(_localctx, 388, RULE_formatFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2081);
			match(FORMAT);
			setState(2082);
			match(LEFT_PAREN);
			setState(2083);
			expression(0);
			setState(2084);
			match(AS);
			setState(2085);
			format();
			setState(2086);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FormatContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public FormatContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_format; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormat(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormat(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormat(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatContext format() throws RecognitionException {
		FormatContext _localctx = new FormatContext(_ctx, getState());
		enterRule(_localctx, 390, RULE_format);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2088);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExtractFunctionContext extends ParserRuleContext {
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExtractFieldContext extractField() {
			return getRuleContext(ExtractFieldContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ExtractFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFunctionContext extractFunction() throws RecognitionException {
		ExtractFunctionContext _localctx = new ExtractFunctionContext(_ctx, getState());
		enterRule(_localctx, 392, RULE_extractFunction);
		try {
			setState(2102);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case EXTRACT:
				enterOuterAlt(_localctx, 1);
				{
				setState(2090);
				match(EXTRACT);
				setState(2091);
				match(LEFT_PAREN);
				setState(2092);
				extractField();
				setState(2093);
				match(FROM);
				setState(2094);
				expression(0);
				setState(2095);
				match(RIGHT_PAREN);
				}
				break;
			case DAY:
			case EPOCH:
			case HOUR:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case QUARTER:
			case SECOND:
			case WEEK:
			case YEAR:
				enterOuterAlt(_localctx, 2);
				{
				setState(2097);
				datetimeField();
				setState(2098);
				match(LEFT_PAREN);
				setState(2099);
				expression(0);
				setState(2100);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TruncFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public TruncFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_truncFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTruncFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTruncFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTruncFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TruncFunctionContext truncFunction() throws RecognitionException {
		TruncFunctionContext _localctx = new TruncFunctionContext(_ctx, getState());
		enterRule(_localctx, 394, RULE_truncFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2104);
			_la = _input.LA(1);
			if ( !(_la==TRUNC || _la==TRUNCATE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(2105);
			match(LEFT_PAREN);
			setState(2106);
			expression(0);
			setState(2112);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(2107);
				match(COMMA);
				setState(2110);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,237,_ctx) ) {
				case 1:
					{
					setState(2108);
					datetimeField();
					}
					break;
				case 2:
					{
					setState(2109);
					expression(0);
					}
					break;
				}
				}
			}

			setState(2114);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExtractFieldContext extends ParserRuleContext {
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public DayFieldContext dayField() {
			return getRuleContext(DayFieldContext.class,0);
		}
		public WeekFieldContext weekField() {
			return getRuleContext(WeekFieldContext.class,0);
		}
		public TimeZoneFieldContext timeZoneField() {
			return getRuleContext(TimeZoneFieldContext.class,0);
		}
		public DateOrTimeFieldContext dateOrTimeField() {
			return getRuleContext(DateOrTimeFieldContext.class,0);
		}
		public ExtractFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFieldContext extractField() throws RecognitionException {
		ExtractFieldContext _localctx = new ExtractFieldContext(_ctx, getState());
		enterRule(_localctx, 396, RULE_extractField);
		try {
			setState(2121);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,239,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2116);
				datetimeField();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2117);
				dayField();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2118);
				weekField();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(2119);
				timeZoneField();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(2120);
				dateOrTimeField();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DatetimeFieldContext extends ParserRuleContext {
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public DatetimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_datetimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDatetimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDatetimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDatetimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DatetimeFieldContext datetimeField() throws RecognitionException {
		DatetimeFieldContext _localctx = new DatetimeFieldContext(_ctx, getState());
		enterRule(_localctx, 398, RULE_datetimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2123);
			_la = _input.LA(1);
			if ( !(((((_la - 75)) & ~0x3f) == 0 && ((1L << (_la - 75)) & 8589942785L) != 0) || ((((_la - 148)) & ~0x3f) == 0 && ((1L << (_la - 148)) & 4611686087415300103L) != 0) || _la==YEAR) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DayFieldContext extends ParserRuleContext {
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public DayFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dayField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDayField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDayField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDayField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayFieldContext dayField() throws RecognitionException {
		DayFieldContext _localctx = new DayFieldContext(_ctx, getState());
		enterRule(_localctx, 400, RULE_dayField);
		try {
			setState(2134);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,240,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2125);
				match(DAY);
				setState(2126);
				match(OF);
				setState(2127);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2128);
				match(DAY);
				setState(2129);
				match(OF);
				setState(2130);
				match(WEEK);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2131);
				match(DAY);
				setState(2132);
				match(OF);
				setState(2133);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WeekFieldContext extends ParserRuleContext {
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public WeekFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_weekField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWeekField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWeekField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWeekField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WeekFieldContext weekField() throws RecognitionException {
		WeekFieldContext _localctx = new WeekFieldContext(_ctx, getState());
		enterRule(_localctx, 402, RULE_weekField);
		try {
			setState(2142);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,241,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2136);
				match(WEEK);
				setState(2137);
				match(OF);
				setState(2138);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2139);
				match(WEEK);
				setState(2140);
				match(OF);
				setState(2141);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeZoneFieldContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TimeZoneFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeZoneField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeZoneField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeZoneField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeZoneField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeZoneFieldContext timeZoneField() throws RecognitionException {
		TimeZoneFieldContext _localctx = new TimeZoneFieldContext(_ctx, getState());
		enterRule(_localctx, 404, RULE_timeZoneField);
		int _la;
		try {
			setState(2150);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET:
				enterOuterAlt(_localctx, 1);
				{
				setState(2144);
				match(OFFSET);
				setState(2146);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==HOUR || _la==MINUTE) {
					{
					setState(2145);
					_la = _input.LA(1);
					if ( !(_la==HOUR || _la==MINUTE) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				}
				break;
			case TIMEZONE_HOUR:
				enterOuterAlt(_localctx, 2);
				{
				setState(2148);
				match(TIMEZONE_HOUR);
				}
				break;
			case TIMEZONE_MINUTE:
				enterOuterAlt(_localctx, 3);
				{
				setState(2149);
				match(TIMEZONE_MINUTE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateOrTimeFieldContext extends ParserRuleContext {
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public DateOrTimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateOrTimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateOrTimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateOrTimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateOrTimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateOrTimeFieldContext dateOrTimeField() throws RecognitionException {
		DateOrTimeFieldContext _localctx = new DateOrTimeFieldContext(_ctx, getState());
		enterRule(_localctx, 406, RULE_dateOrTimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2152);
			_la = _input.LA(1);
			if ( !(_la==DATE || _la==TIME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionContext extends ParserRuleContext {
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PositionFunctionPatternArgumentContext positionFunctionPatternArgument() {
			return getRuleContext(PositionFunctionPatternArgumentContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public PositionFunctionStringArgumentContext positionFunctionStringArgument() {
			return getRuleContext(PositionFunctionStringArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PositionFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionContext positionFunction() throws RecognitionException {
		PositionFunctionContext _localctx = new PositionFunctionContext(_ctx, getState());
		enterRule(_localctx, 408, RULE_positionFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2154);
			match(POSITION);
			setState(2155);
			match(LEFT_PAREN);
			setState(2156);
			positionFunctionPatternArgument();
			setState(2157);
			match(IN);
			setState(2158);
			positionFunctionStringArgument();
			setState(2159);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionPatternArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionPatternArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionPatternArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionPatternArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionPatternArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionPatternArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionPatternArgumentContext positionFunctionPatternArgument() throws RecognitionException {
		PositionFunctionPatternArgumentContext _localctx = new PositionFunctionPatternArgumentContext(_ctx, getState());
		enterRule(_localctx, 410, RULE_positionFunctionPatternArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2161);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionStringArgumentContext positionFunctionStringArgument() throws RecognitionException {
		PositionFunctionStringArgumentContext _localctx = new PositionFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 412, RULE_positionFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2163);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CubeContext extends ParserRuleContext {
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CubeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cube; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCube(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCube(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCube(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CubeContext cube() throws RecognitionException {
		CubeContext _localctx = new CubeContext(_ctx, getState());
		enterRule(_localctx, 414, RULE_cube);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2165);
			match(CUBE);
			setState(2166);
			match(LEFT_PAREN);
			setState(2167);
			expressionOrPredicate();
			setState(2172);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2168);
				match(COMMA);
				setState(2169);
				expressionOrPredicate();
				}
				}
				setState(2174);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2175);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class RollupContext extends ParserRuleContext {
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public RollupContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rollup; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRollup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRollup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRollup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RollupContext rollup() throws RecognitionException {
		RollupContext _localctx = new RollupContext(_ctx, getState());
		enterRule(_localctx, 416, RULE_rollup);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2177);
			match(ROLLUP);
			setState(2178);
			match(LEFT_PAREN);
			setState(2179);
			expressionOrPredicate();
			setState(2184);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2180);
				match(COMMA);
				setState(2181);
				expressionOrPredicate();
				}
				}
				setState(2186);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2187);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NakedIdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(HqlParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(HqlParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode COLUMN() { return getToken(HqlParser.COLUMN, 0); }
		public TerminalNode CONFLICT() { return getToken(HqlParser.CONFLICT, 0); }
		public TerminalNode CONSTRAINT() { return getToken(HqlParser.CONSTRAINT, 0); }
		public TerminalNode CONTAINS() { return getToken(HqlParser.CONTAINS, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode DO() { return getToken(HqlParser.DO, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode INCLUDES() { return getToken(HqlParser.INCLUDES, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode INTERSECTS() { return getToken(HqlParser.INTERSECTS, 0); }
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode KEYS() { return getToken(HqlParser.KEYS, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public TerminalNode MICROSECOND() { return getToken(HqlParser.MICROSECOND, 0); }
		public TerminalNode MILLISECOND() { return getToken(HqlParser.MILLISECOND, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode NOTHING() { return getToken(HqlParser.NOTHING, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode ZONED() { return getToken(HqlParser.ZONED, 0); }
		public NakedIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nakedIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNakedIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNakedIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNakedIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NakedIdentifierContext nakedIdentifier() throws RecognitionException {
		NakedIdentifierContext _localctx = new NakedIdentifierContext(_ctx, getState());
		enterRule(_localctx, 418, RULE_nakedIdentifier);
		int _la;
		try {
			setState(2193);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2189);
				match(IDENTIFIER);
				}
				break;
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(2190);
				match(QUOTED_IDENTIFIER);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
				enterOuterAlt(_localctx, 3);
				{
				setState(2191);
				_la = _input.LA(1);
				if ( !(((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -2305843009213693953L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -1152921504611041793L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 281474976710143L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IdentifierContext extends ParserRuleContext {
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 420, RULE_identifier);
		int _la;
		try {
			setState(2198);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case CONTAINS:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INCLUDES:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTERSECTS:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2195);
				nakedIdentifier();
				}
				break;
			case FULL:
			case INNER:
			case LEFT:
			case OUTER:
			case RIGHT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2196);
				_la = _input.LA(1);
				if ( !(((((_la - 103)) & ~0x3f) == 0 && ((1L << (_la - 103)) & -9223372036821217279L) != 0) || _la==RIGHT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public boolean sempred(RuleContext _localctx, int ruleIndex, int predIndex) {
		switch (ruleIndex) {
		case 78:
			return predicate_sempred((PredicateContext)_localctx, predIndex);
		case 82:
			return expression_sempred((ExpressionContext)_localctx, predIndex);
		}
		return true;
	}
	private boolean predicate_sempred(PredicateContext _localctx, int predIndex) {
		switch (predIndex) {
		case 0:
			return precpred(_ctx, 3);
		case 1:
			return precpred(_ctx, 2);
		}
		return true;
	}
	private boolean expression_sempred(ExpressionContext _localctx, int predIndex) {
		switch (predIndex) {
		case 2:
			return precpred(_ctx, 3);
		case 3:
			return precpred(_ctx, 2);
		case 4:
			return precpred(_ctx, 1);
		case 5:
			return precpred(_ctx, 5);
		case 6:
			return precpred(_ctx, 4);
		}
		return true;
	}

	public static final String _serializedATN =
		"\u0004\u0001\u00de\u0899\u0002\u0000\u0007\u0000\u0002\u0001\u0007\u0001"+
		"\u0002\u0002\u0007\u0002\u0002\u0003\u0007\u0003\u0002\u0004\u0007\u0004"+
		"\u0002\u0005\u0007\u0005\u0002\u0006\u0007\u0006\u0002\u0007\u0007\u0007"+
		"\u0002\b\u0007\b\u0002\t\u0007\t\u0002\n\u0007\n\u0002\u000b\u0007\u000b"+
		"\u0002\f\u0007\f\u0002\r\u0007\r\u0002\u000e\u0007\u000e\u0002\u000f\u0007"+
		"\u000f\u0002\u0010\u0007\u0010\u0002\u0011\u0007\u0011\u0002\u0012\u0007"+
		"\u0012\u0002\u0013\u0007\u0013\u0002\u0014\u0007\u0014\u0002\u0015\u0007"+
		"\u0015\u0002\u0016\u0007\u0016\u0002\u0017\u0007\u0017\u0002\u0018\u0007"+
		"\u0018\u0002\u0019\u0007\u0019\u0002\u001a\u0007\u001a\u0002\u001b\u0007"+
		"\u001b\u0002\u001c\u0007\u001c\u0002\u001d\u0007\u001d\u0002\u001e\u0007"+
		"\u001e\u0002\u001f\u0007\u001f\u0002 \u0007 \u0002!\u0007!\u0002\"\u0007"+
		"\"\u0002#\u0007#\u0002$\u0007$\u0002%\u0007%\u0002&\u0007&\u0002\'\u0007"+
		"\'\u0002(\u0007(\u0002)\u0007)\u0002*\u0007*\u0002+\u0007+\u0002,\u0007"+
		",\u0002-\u0007-\u0002.\u0007.\u0002/\u0007/\u00020\u00070\u00021\u0007"+
		"1\u00022\u00072\u00023\u00073\u00024\u00074\u00025\u00075\u00026\u0007"+
		"6\u00027\u00077\u00028\u00078\u00029\u00079\u0002:\u0007:\u0002;\u0007"+
		";\u0002<\u0007<\u0002=\u0007=\u0002>\u0007>\u0002?\u0007?\u0002@\u0007"+
		"@\u0002A\u0007A\u0002B\u0007B\u0002C\u0007C\u0002D\u0007D\u0002E\u0007"+
		"E\u0002F\u0007F\u0002G\u0007G\u0002H\u0007H\u0002I\u0007I\u0002J\u0007"+
		"J\u0002K\u0007K\u0002L\u0007L\u0002M\u0007M\u0002N\u0007N\u0002O\u0007"+
		"O\u0002P\u0007P\u0002Q\u0007Q\u0002R\u0007R\u0002S\u0007S\u0002T\u0007"+
		"T\u0002U\u0007U\u0002V\u0007V\u0002W\u0007W\u0002X\u0007X\u0002Y\u0007"+
		"Y\u0002Z\u0007Z\u0002[\u0007[\u0002\\\u0007\\\u0002]\u0007]\u0002^\u0007"+
		"^\u0002_\u0007_\u0002`\u0007`\u0002a\u0007a\u0002b\u0007b\u0002c\u0007"+
		"c\u0002d\u0007d\u0002e\u0007e\u0002f\u0007f\u0002g\u0007g\u0002h\u0007"+
		"h\u0002i\u0007i\u0002j\u0007j\u0002k\u0007k\u0002l\u0007l\u0002m\u0007"+
		"m\u0002n\u0007n\u0002o\u0007o\u0002p\u0007p\u0002q\u0007q\u0002r\u0007"+
		"r\u0002s\u0007s\u0002t\u0007t\u0002u\u0007u\u0002v\u0007v\u0002w\u0007"+
		"w\u0002x\u0007x\u0002y\u0007y\u0002z\u0007z\u0002{\u0007{\u0002|\u0007"+
		"|\u0002}\u0007}\u0002~\u0007~\u0002\u007f\u0007\u007f\u0002\u0080\u0007"+
		"\u0080\u0002\u0081\u0007\u0081\u0002\u0082\u0007\u0082\u0002\u0083\u0007"+
		"\u0083\u0002\u0084\u0007\u0084\u0002\u0085\u0007\u0085\u0002\u0086\u0007"+
		"\u0086\u0002\u0087\u0007\u0087\u0002\u0088\u0007\u0088\u0002\u0089\u0007"+
		"\u0089\u0002\u008a\u0007\u008a\u0002\u008b\u0007\u008b\u0002\u008c\u0007"+
		"\u008c\u0002\u008d\u0007\u008d\u0002\u008e\u0007\u008e\u0002\u008f\u0007"+
		"\u008f\u0002\u0090\u0007\u0090\u0002\u0091\u0007\u0091\u0002\u0092\u0007"+
		"\u0092\u0002\u0093\u0007\u0093\u0002\u0094\u0007\u0094\u0002\u0095\u0007"+
		"\u0095\u0002\u0096\u0007\u0096\u0002\u0097\u0007\u0097\u0002\u0098\u0007"+
		"\u0098\u0002\u0099\u0007\u0099\u0002\u009a\u0007\u009a\u0002\u009b\u0007"+
		"\u009b\u0002\u009c\u0007\u009c\u0002\u009d\u0007\u009d\u0002\u009e\u0007"+
		"\u009e\u0002\u009f\u0007\u009f\u0002\u00a0\u0007\u00a0\u0002\u00a1\u0007"+
		"\u00a1\u0002\u00a2\u0007\u00a2\u0002\u00a3\u0007\u00a3\u0002\u00a4\u0007"+
		"\u00a4\u0002\u00a5\u0007\u00a5\u0002\u00a6\u0007\u00a6\u0002\u00a7\u0007"+
		"\u00a7\u0002\u00a8\u0007\u00a8\u0002\u00a9\u0007\u00a9\u0002\u00aa\u0007"+
		"\u00aa\u0002\u00ab\u0007\u00ab\u0002\u00ac\u0007\u00ac\u0002\u00ad\u0007"+
		"\u00ad\u0002\u00ae\u0007\u00ae\u0002\u00af\u0007\u00af\u0002\u00b0\u0007"+
		"\u00b0\u0002\u00b1\u0007\u00b1\u0002\u00b2\u0007\u00b2\u0002\u00b3\u0007"+
		"\u00b3\u0002\u00b4\u0007\u00b4\u0002\u00b5\u0007\u00b5\u0002\u00b6\u0007"+
		"\u00b6\u0002\u00b7\u0007\u00b7\u0002\u00b8\u0007\u00b8\u0002\u00b9\u0007"+
		"\u00b9\u0002\u00ba\u0007\u00ba\u0002\u00bb\u0007\u00bb\u0002\u00bc\u0007"+
		"\u00bc\u0002\u00bd\u0007\u00bd\u0002\u00be\u0007\u00be\u0002\u00bf\u0007"+
		"\u00bf\u0002\u00c0\u0007\u00c0\u0002\u00c1\u0007\u00c1\u0002\u00c2\u0007"+
		"\u00c2\u0002\u00c3\u0007\u00c3\u0002\u00c4\u0007\u00c4\u0002\u00c5\u0007"+
		"\u00c5\u0002\u00c6\u0007\u00c6\u0002\u00c7\u0007\u00c7\u0002\u00c8\u0007"+
		"\u00c8\u0002\u00c9\u0007\u00c9\u0002\u00ca\u0007\u00ca\u0002\u00cb\u0007"+
		"\u00cb\u0002\u00cc\u0007\u00cc\u0002\u00cd\u0007\u00cd\u0002\u00ce\u0007"+
		"\u00ce\u0002\u00cf\u0007\u00cf\u0002\u00d0\u0007\u00d0\u0002\u00d1\u0007"+
		"\u00d1\u0002\u00d2\u0007\u00d2\u0001\u0000\u0001\u0000\u0001\u0000\u0001"+
		"\u0000\u0003\u0000\u01ab\b\u0000\u0001\u0000\u0001\u0000\u0001\u0001\u0001"+
		"\u0001\u0001\u0002\u0001\u0002\u0001\u0003\u0001\u0003\u0003\u0003\u01b5"+
		"\b\u0003\u0001\u0004\u0001\u0004\u0003\u0004\u01b9\b\u0004\u0001\u0004"+
		"\u0001\u0004\u0003\u0004\u01bd\b\u0004\u0001\u0005\u0001\u0005\u0003\u0005"+
		"\u01c1\b\u0005\u0001\u0005\u0001\u0005\u0001\u0005\u0003\u0005\u01c6\b"+
		"\u0005\u0001\u0006\u0001\u0006\u0001\u0006\u0001\u0006\u0005\u0006\u01cc"+
		"\b\u0006\n\u0006\f\u0006\u01cf\t\u0006\u0001\u0007\u0001\u0007\u0001\u0007"+
		"\u0001\u0007\u0001\b\u0001\b\u0003\b\u01d7\b\b\u0001\b\u0001\b\u0001\b"+
		"\u0001\b\u0003\b\u01dd\b\b\u0001\b\u0003\b\u01e0\b\b\u0001\t\u0001\t\u0001"+
		"\t\u0001\t\u0005\t\u01e6\b\t\n\t\f\t\u01e9\t\t\u0001\t\u0001\t\u0001\n"+
		"\u0001\n\u0001\n\u0001\n\u0005\n\u01f1\b\n\n\n\f\n\u01f4\t\n\u0001\u000b"+
		"\u0001\u000b\u0001\u000b\u0001\u000b\u0005\u000b\u01fa\b\u000b\n\u000b"+
		"\f\u000b\u01fd\t\u000b\u0001\u000b\u0001\u000b\u0001\f\u0001\f\u0001\f"+
		"\u0003\f\u0204\b\f\u0001\f\u0001\f\u0001\f\u0001\r\u0001\r\u0001\r\u0001"+
		"\r\u0001\r\u0001\r\u0001\r\u0005\r\u0210\b\r\n\r\f\r\u0213\t\r\u0001\r"+
		"\u0001\r\u0003\r\u0217\b\r\u0001\u000e\u0001\u000e\u0001\u000e\u0001\u000e"+
		"\u0003\u000e\u021d\b\u000e\u0003\u000e\u021f\b\u000e\u0001\u000f\u0001"+
		"\u000f\u0001\u000f\u0001\u000f\u0005\u000f\u0225\b\u000f\n\u000f\f\u000f"+
		"\u0228\t\u000f\u0001\u0010\u0001\u0010\u0001\u0010\u0003\u0010\u022d\b"+
		"\u0010\u0001\u0010\u0003\u0010\u0230\b\u0010\u0001\u0010\u0001\u0010\u0001"+
		"\u0010\u0001\u0010\u0003\u0010\u0236\b\u0010\u0001\u0010\u0003\u0010\u0239"+
		"\b\u0010\u0001\u0011\u0001\u0011\u0001\u0011\u0005\u0011\u023e\b\u0011"+
		"\n\u0011\f\u0011\u0241\t\u0011\u0001\u0012\u0001\u0012\u0001\u0012\u0001"+
		"\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0013\u0001"+
		"\u0013\u0001\u0013\u0005\u0013\u024e\b\u0013\n\u0013\f\u0013\u0251\t\u0013"+
		"\u0001\u0014\u0001\u0014\u0003\u0014\u0255\b\u0014\u0001\u0014\u0003\u0014"+
		"\u0258\b\u0014\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015"+
		"\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0003\u0015\u0263\b\u0015"+
		"\u0001\u0015\u0001\u0015\u0003\u0015\u0267\b\u0015\u0001\u0016\u0003\u0016"+
		"\u026a\b\u0016\u0001\u0016\u0001\u0016\u0003\u0016\u026e\b\u0016\u0001"+
		"\u0016\u0001\u0016\u0001\u0016\u0001\u0016\u0004\u0016\u0274\b\u0016\u000b"+
		"\u0016\f\u0016\u0275\u0003\u0016\u0278\b\u0016\u0001\u0017\u0001\u0017"+
		"\u0003\u0017\u027c\b\u0017\u0001\u0017\u0001\u0017\u0001\u0017\u0001\u0017"+
		"\u0003\u0017\u0282\b\u0017\u0001\u0017\u0003\u0017\u0285\b\u0017\u0001"+
		"\u0018\u0001\u0018\u0003\u0018\u0289\b\u0018\u0001\u0018\u0001\u0018\u0003"+
		"\u0018\u028d\b\u0018\u0001\u0018\u0001\u0018\u0003\u0018\u0291\b\u0018"+
		"\u0003\u0018\u0293\b\u0018\u0001\u0019\u0001\u0019\u0003\u0019\u0297\b"+
		"\u0019\u0001\u0019\u0003\u0019\u029a\b\u0019\u0001\u0019\u0003\u0019\u029d"+
		"\b\u0019\u0001\u001a\u0001\u001a\u0003\u001a\u02a1\b\u001a\u0001\u001a"+
		"\u0003\u001a\u02a4\b\u001a\u0001\u001a\u0001\u001a\u0003\u001a\u02a8\b"+
		"\u001a\u0003\u001a\u02aa\b\u001a\u0001\u001a\u0001\u001a\u0003\u001a\u02ae"+
		"\b\u001a\u0001\u001a\u0001\u001a\u0003\u001a\u02b2\b\u001a\u0003\u001a"+
		"\u02b4\b\u001a\u0001\u001a\u0003\u001a\u02b7\b\u001a\u0001\u001a\u0003"+
		"\u001a\u02ba\b\u001a\u0001\u001b\u0001\u001b\u0001\u001b\u0001\u001b\u0005"+
		"\u001b\u02c0\b\u001b\n\u001b\f\u001b\u02c3\t\u001b\u0001\u001c\u0001\u001c"+
		"\u0001\u001c\u0001\u001c\u0005\u001c\u02c9\b\u001c\n\u001c\f\u001c\u02cc"+
		"\t\u001c\u0001\u001d\u0001\u001d\u0003\u001d\u02d0\b\u001d\u0001\u001d"+
		"\u0001\u001d\u0001\u001d\u0001\u001d\u0003\u001d\u02d6\b\u001d\u0003\u001d"+
		"\u02d8\b\u001d\u0001\u001e\u0001\u001e\u0001\u001e\u0005\u001e\u02dd\b"+
		"\u001e\n\u001e\f\u001e\u02e0\t\u001e\u0001\u001f\u0001\u001f\u0001\u001f"+
		"\u0003\u001f\u02e5\b\u001f\u0001 \u0001 \u0001 \u0001 \u0003 \u02eb\b"+
		" \u0001!\u0001!\u0001!\u0001!\u0001!\u0001!\u0003!\u02f3\b!\u0001\"\u0001"+
		"\"\u0001\"\u0003\"\u02f8\b\"\u0001\"\u0001\"\u0003\"\u02fc\b\"\u0001#"+
		"\u0003#\u02ff\b#\u0001#\u0003#\u0302\b#\u0001#\u0003#\u0305\b#\u0003#"+
		"\u0307\b#\u0001$\u0001$\u0003$\u030b\b$\u0001$\u0003$\u030e\b$\u0001$"+
		"\u0001$\u0001$\u0001$\u0003$\u0314\b$\u0003$\u0316\b$\u0001%\u0001%\u0001"+
		"%\u0001&\u0001&\u0003&\u031d\b&\u0001&\u0001&\u0001\'\u0001\'\u0001\'"+
		"\u0005\'\u0324\b\'\n\'\f\'\u0327\t\'\u0001(\u0001(\u0003(\u032b\b(\u0001"+
		")\u0001)\u0001)\u0001)\u0003)\u0331\b)\u0001*\u0001*\u0001*\u0001*\u0001"+
		"*\u0001+\u0001+\u0001+\u0001+\u0001+\u0001+\u0001,\u0001,\u0001,\u0003"+
		",\u0341\b,\u0001-\u0001-\u0001-\u0005-\u0346\b-\n-\f-\u0349\t-\u0001."+
		"\u0001.\u0003.\u034d\b.\u0001/\u0001/\u0003/\u0351\b/\u00010\u00010\u0001"+
		"0\u00010\u00010\u00011\u00011\u00051\u035a\b1\n1\f1\u035d\t1\u00012\u0001"+
		"2\u00012\u00013\u00013\u00033\u0364\b3\u00013\u00033\u0367\b3\u00014\u0001"+
		"4\u00014\u00015\u00015\u00015\u00015\u00015\u00015\u00015\u00015\u0001"+
		"5\u00015\u00015\u00015\u00015\u00015\u00015\u00015\u00035\u037c\b5\u0001"+
		"5\u00015\u00015\u00035\u0381\b5\u00016\u00016\u00036\u0385\b6\u00017\u0001"+
		"7\u00017\u00017\u00017\u00037\u038c\b7\u00018\u00018\u00018\u00018\u0001"+
		"8\u00018\u00019\u00019\u00019\u00019\u00019\u00019\u00019\u00039\u039b"+
		"\b9\u0001:\u0001:\u0001:\u0001:\u0001:\u0003:\u03a2\b:\u0001;\u0001;\u0001"+
		";\u0001;\u0001;\u0003;\u03a9\b;\u0001<\u0001<\u0001<\u0001<\u0001<\u0005"+
		"<\u03b0\b<\n<\f<\u03b3\t<\u0001=\u0001=\u0001=\u0003=\u03b8\b=\u0001>"+
		"\u0001>\u0001>\u0001?\u0001?\u0001?\u0001?\u0001?\u0005?\u03c2\b?\n?\f"+
		"?\u03c5\t?\u0001@\u0001@\u0001@\u0005@\u03ca\b@\n@\f@\u03cd\t@\u0001A"+
		"\u0001A\u0003A\u03d1\bA\u0001A\u0003A\u03d4\bA\u0001B\u0001B\u0001B\u0001"+
		"C\u0001C\u0001C\u0003C\u03dc\bC\u0001D\u0001D\u0001E\u0001E\u0001E\u0001"+
		"E\u0001E\u0001E\u0001E\u0001F\u0001F\u0001G\u0001G\u0001G\u0001H\u0001"+
		"H\u0001H\u0003H\u03ef\bH\u0001I\u0001I\u0001I\u0001I\u0001I\u0001I\u0001"+
		"I\u0003I\u03f8\bI\u0001J\u0001J\u0001J\u0001J\u0003J\u03fe\bJ\u0001K\u0001"+
		"K\u0003K\u0402\bK\u0001L\u0001L\u0001L\u0001L\u0001L\u0003L\u0409\bL\u0001"+
		"M\u0001M\u0001M\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001"+
		"N\u0003N\u0416\bN\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u041d\bN\u0001"+
		"N\u0001N\u0001N\u0001N\u0001N\u0003N\u0424\bN\u0001N\u0001N\u0001N\u0001"+
		"N\u0001N\u0003N\u042b\bN\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u0432"+
		"\bN\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u043a\bN\u0001N\u0001"+
		"N\u0003N\u043e\bN\u0001N\u0001N\u0001N\u0001N\u0003N\u0444\bN\u0001N\u0001"+
		"N\u0001N\u0001N\u0001N\u0003N\u044b\bN\u0001N\u0001N\u0001N\u0001N\u0001"+
		"N\u0001N\u0001N\u0003N\u0454\bN\u0001N\u0001N\u0001N\u0003N\u0459\bN\u0001"+
		"N\u0001N\u0003N\u045d\bN\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u0464"+
		"\bN\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u046b\bN\u0001N\u0001N\u0001"+
		"N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001"+
		"N\u0001N\u0001N\u0001N\u0001N\u0001N\u0003N\u047f\bN\u0001N\u0001N\u0001"+
		"N\u0001N\u0001N\u0001N\u0005N\u0487\bN\nN\fN\u048a\tN\u0001O\u0001O\u0001"+
		"P\u0001P\u0001P\u0001P\u0001P\u0001P\u0001P\u0001P\u0001P\u0005P\u0497"+
		"\bP\nP\fP\u049a\tP\u0003P\u049c\bP\u0001P\u0001P\u0001P\u0001P\u0001P"+
		"\u0001P\u0001P\u0003P\u04a5\bP\u0001Q\u0001Q\u0001Q\u0001Q\u0003Q\u04ab"+
		"\bQ\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0004"+
		"R\u04b6\bR\u000bR\fR\u04b7\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001"+
		"R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0003R\u04c7\bR\u0001R\u0001"+
		"R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001"+
		"R\u0001R\u0001R\u0001R\u0001R\u0005R\u04d9\bR\nR\fR\u04dc\tR\u0001S\u0001"+
		"S\u0001S\u0001S\u0001S\u0001S\u0001S\u0001S\u0001S\u0003S\u04e7\bS\u0001"+
		"S\u0001S\u0003S\u04eb\bS\u0001T\u0001T\u0003T\u04ef\bT\u0001U\u0001U\u0003"+
		"U\u04f3\bU\u0001V\u0001V\u0001W\u0001W\u0001X\u0001X\u0001Y\u0001Y\u0001"+
		"Z\u0001Z\u0001[\u0001[\u0001\\\u0001\\\u0001]\u0001]\u0001]\u0001]\u0003"+
		"]\u0507\b]\u0001]\u0001]\u0001^\u0001^\u0001^\u0001^\u0001^\u0003^\u0510"+
		"\b^\u0001_\u0001_\u0001_\u0001_\u0001_\u0001`\u0001`\u0001`\u0001`\u0001"+
		"`\u0003`\u051c\b`\u0001a\u0001a\u0001a\u0001a\u0001a\u0001b\u0001b\u0003"+
		"b\u0525\bb\u0001c\u0001c\u0001c\u0004c\u052a\bc\u000bc\fc\u052b\u0001"+
		"c\u0003c\u052f\bc\u0001c\u0001c\u0001d\u0001d\u0001d\u0001d\u0001d\u0001"+
		"e\u0001e\u0001e\u0001f\u0001f\u0004f\u053d\bf\u000bf\ff\u053e\u0001f\u0003"+
		"f\u0542\bf\u0001f\u0001f\u0001g\u0001g\u0001g\u0001g\u0001g\u0001h\u0001"+
		"h\u0001h\u0001h\u0001h\u0001h\u0001h\u0001h\u0001h\u0003h\u0554\bh\u0001"+
		"i\u0001i\u0001j\u0001j\u0001k\u0001k\u0001k\u0001k\u0001k\u0005k\u055f"+
		"\bk\nk\fk\u0562\tk\u0001k\u0003k\u0565\bk\u0001l\u0001l\u0001l\u0001l"+
		"\u0001l\u0001l\u0003l\u056d\bl\u0001m\u0001m\u0001m\u0003m\u0572\bm\u0001"+
		"n\u0001n\u0001n\u0001n\u0001n\u0003n\u0579\bn\u0001n\u0001n\u0003n\u057d"+
		"\bn\u0001o\u0001o\u0001o\u0001o\u0001o\u0003o\u0584\bo\u0001o\u0001o\u0003"+
		"o\u0588\bo\u0001p\u0001p\u0001p\u0001p\u0001p\u0003p\u058f\bp\u0001p\u0001"+
		"p\u0003p\u0593\bp\u0001q\u0001q\u0001q\u0001q\u0001q\u0003q\u059a\bq\u0001"+
		"q\u0001q\u0003q\u059e\bq\u0001r\u0001r\u0001r\u0001r\u0001r\u0003r\u05a5"+
		"\br\u0001r\u0001r\u0003r\u05a9\br\u0001s\u0001s\u0001s\u0003s\u05ae\b"+
		"s\u0001t\u0001t\u0001t\u0001u\u0001u\u0001u\u0001u\u0001v\u0001v\u0001"+
		"v\u0001v\u0001w\u0001w\u0001w\u0001w\u0001x\u0001x\u0001x\u0001x\u0001"+
		"x\u0001x\u0001y\u0001y\u0001y\u0001y\u0001y\u0003y\u05ca\by\u0001z\u0001"+
		"z\u0001z\u0001z\u0003z\u05d0\bz\u0001{\u0001{\u0001{\u0001{\u0001{\u0001"+
		"|\u0001|\u0001}\u0001}\u0001~\u0001~\u0001\u007f\u0001\u007f\u0001\u0080"+
		"\u0001\u0080\u0001\u0081\u0001\u0081\u0001\u0082\u0001\u0082\u0001\u0082"+
		"\u0003\u0082\u05e6\b\u0082\u0001\u0082\u0003\u0082\u05e9\b\u0082\u0001"+
		"\u0083\u0001\u0083\u0001\u0083\u0003\u0083\u05ee\b\u0083\u0001\u0083\u0001"+
		"\u0083\u0001\u0084\u0001\u0084\u0001\u0084\u0003\u0084\u05f5\b\u0084\u0001"+
		"\u0084\u0001\u0084\u0001\u0085\u0001\u0085\u0001\u0085\u0003\u0085\u05fc"+
		"\b\u0085\u0001\u0085\u0001\u0085\u0001\u0086\u0001\u0086\u0001\u0087\u0001"+
		"\u0087\u0001\u0087\u0001\u0087\u0005\u0087\u0606\b\u0087\n\u0087\f\u0087"+
		"\u0609\t\u0087\u0003\u0087\u060b\b\u0087\u0001\u0087\u0001\u0087\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0089\u0001\u0089\u0001\u008a\u0001\u008a\u0001\u008b\u0001\u008b\u0001"+
		"\u008b\u0001\u008b\u0003\u008b\u061d\b\u008b\u0003\u008b\u061f\b\u008b"+
		"\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c"+
		"\u0001\u008c\u0001\u008c\u0003\u008c\u0629\b\u008c\u0001\u008d\u0001\u008d"+
		"\u0001\u008d\u0001\u008d\u0001\u008d\u0003\u008d\u0630\b\u008d\u0001\u008d"+
		"\u0001\u008d\u0003\u008d\u0634\b\u008d\u0001\u008d\u0001\u008d\u0001\u008e"+
		"\u0001\u008e\u0003\u008e\u063a\b\u008e\u0001\u008f\u0001\u008f\u0001\u008f"+
		"\u0001\u008f\u0001\u008f\u0001\u008f\u0001\u008f\u0003\u008f\u0643\b\u008f"+
		"\u0001\u008f\u0001\u008f\u0001\u0090\u0001\u0090\u0001\u0090\u0001\u0090"+
		"\u0003\u0090\u064b\b\u0090\u0001\u0090\u0001\u0090\u0003\u0090\u064f\b"+
		"\u0090\u0001\u0090\u0003\u0090\u0652\b\u0090\u0001\u0090\u0003\u0090\u0655"+
		"\b\u0090\u0001\u0090\u0003\u0090\u0658\b\u0090\u0001\u0090\u0003\u0090"+
		"\u065b\b\u0090\u0001\u0091\u0001\u0091\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0001\u0092\u0003\u0092\u0663\b\u0092\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0005\u0092\u0668\b\u0092\n\u0092\f\u0092\u066b\t\u0092\u0001\u0093\u0001"+
		"\u0093\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0094\u0001\u0094\u0001"+
		"\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001"+
		"\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001"+
		"\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001"+
		"\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0001\u0094\u0003"+
		"\u0094\u068c\b\u0094\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0001"+
		"\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0003"+
		"\u0095\u0698\b\u0095\u0001\u0096\u0001\u0096\u0001\u0096\u0003\u0096\u069d"+
		"\b\u0096\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0003"+
		"\u0097\u06a4\b\u0097\u0001\u0097\u0003\u0097\u06a7\b\u0097\u0001\u0097"+
		"\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097"+
		"\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0003\u0097\u06b4\b\u0097"+
		"\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0003\u0098"+
		"\u06bb\b\u0098\u0001\u0098\u0003\u0098\u06be\b\u0098\u0001\u0098\u0001"+
		"\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001"+
		"\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0003\u0098\u06cb\b\u0098\u0001"+
		"\u0099\u0001\u0099\u0001\u009a\u0001\u009a\u0001\u009b\u0001\u009b\u0001"+
		"\u009b\u0003\u009b\u06d4\b\u009b\u0001\u009b\u0001\u009b\u0001\u009b\u0001"+
		"\u009b\u0003\u009b\u06da\b\u009b\u0001\u009b\u0001\u009b\u0003\u009b\u06de"+
		"\b\u009b\u0001\u009b\u0003\u009b\u06e1\b\u009b\u0001\u009b\u0003\u009b"+
		"\u06e4\b\u009b\u0001\u009c\u0001\u009c\u0001\u009c\u0001\u009c\u0001\u009c"+
		"\u0003\u009c\u06eb\b\u009c\u0001\u009c\u0001\u009c\u0003\u009c\u06ef\b"+
		"\u009c\u0001\u009d\u0001\u009d\u0001\u009d\u0001\u009d\u0001\u009d\u0001"+
		"\u009d\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001"+
		"\u009f\u0001\u009f\u0001\u009f\u0001\u009f\u0003\u009f\u0700\b\u009f\u0001"+
		"\u00a0\u0001\u00a0\u0001\u00a0\u0001\u00a0\u0003\u00a0\u0706\b\u00a0\u0001"+
		"\u00a1\u0001\u00a1\u0001\u00a1\u0003\u00a1\u070b\b\u00a1\u0001\u00a1\u0003"+
		"\u00a1\u070e\b\u00a1\u0001\u00a1\u0003\u00a1\u0711\b\u00a1\u0001\u00a1"+
		"\u0001\u00a1\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2"+
		"\u0005\u00a2\u071a\b\u00a2\n\u00a2\f\u00a2\u071d\t\u00a2\u0001\u00a3\u0001"+
		"\u00a3\u0001\u00a3\u0003\u00a3\u0722\b\u00a3\u0001\u00a3\u0001\u00a3\u0001"+
		"\u00a3\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0003\u00a3\u072a\b\u00a3\u0003"+
		"\u00a3\u072c\b\u00a3\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001"+
		"\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0003"+
		"\u00a4\u0738\b\u00a4\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001"+
		"\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0003"+
		"\u00a5\u0744\b\u00a5\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001"+
		"\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0003"+
		"\u00a6\u0750\b\u00a6\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001"+
		"\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001"+
		"\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0001"+
		"\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0003\u00a7\u0766\b\u00a7\u0001"+
		"\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001"+
		"\u00a8\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0003"+
		"\u00a9\u0774\b\u00a9\u0001\u00a9\u0003\u00a9\u0777\b\u00a9\u0001\u00aa"+
		"\u0001\u00aa\u0001\u00aa\u0001\u00aa\u0001\u00aa\u0001\u00aa\u0001\u00aa"+
		"\u0005\u00aa\u0780\b\u00aa\n\u00aa\f\u00aa\u0783\t\u00aa\u0001\u00ab\u0001"+
		"\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0003"+
		"\u00ab\u078c\b\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001"+
		"\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0001\u00ab\u0003\u00ab\u0797"+
		"\b\u00ab\u0001\u00ab\u0001\u00ab\u0003\u00ab\u079b\b\u00ab\u0001\u00ac"+
		"\u0001\u00ac\u0001\u00ad\u0001\u00ad\u0001\u00ae\u0001\u00ae\u0001\u00ae"+
		"\u0003\u00ae\u07a4\b\u00ae\u0001\u00ae\u0003\u00ae\u07a7\b\u00ae\u0001"+
		"\u00ae\u0003\u00ae\u07aa\b\u00ae\u0001\u00ae\u0001\u00ae\u0001\u00ae\u0001"+
		"\u00af\u0001\u00af\u0001\u00b0\u0001\u00b0\u0003\u00b0\u07b3\b\u00b0\u0001"+
		"\u00b1\u0001\u00b1\u0001\u00b1\u0001\u00b1\u0001\u00b1\u0001\u00b1\u0001"+
		"\u00b1\u0003\u00b1\u07bc\b\u00b1\u0001\u00b1\u0001\u00b1\u0001\u00b2\u0001"+
		"\u00b2\u0001\u00b3\u0001\u00b3\u0001\u00b4\u0001\u00b4\u0001\u00b5\u0001"+
		"\u00b5\u0001\u00b5\u0001\u00b5\u0001\u00b5\u0001\u00b5\u0001\u00b5\u0001"+
		"\u00b5\u0001\u00b5\u0003\u00b5\u07cf\b\u00b5\u0001\u00b5\u0001\u00b5\u0001"+
		"\u00b6\u0001\u00b6\u0001\u00b7\u0001\u00b7\u0001\u00b8\u0001\u00b8\u0001"+
		"\u00b9\u0001\u00b9\u0001\u00ba\u0001\u00ba\u0001\u00ba\u0003\u00ba\u07de"+
		"\b\u00ba\u0001\u00ba\u0001\u00ba\u0003\u00ba\u07e2\b\u00ba\u0001\u00bb"+
		"\u0001\u00bb\u0001\u00bb\u0003\u00bb\u07e7\b\u00bb\u0001\u00bb\u0001\u00bb"+
		"\u0003\u00bb\u07eb\b\u00bb\u0001\u00bc\u0001\u00bc\u0001\u00bc\u0003\u00bc"+
		"\u07f0\b\u00bc\u0001\u00bc\u0001\u00bc\u0003\u00bc\u07f4\b\u00bc\u0001"+
		"\u00bd\u0001\u00bd\u0001\u00bd\u0003\u00bd\u07f9\b\u00bd\u0001\u00bd\u0003"+
		"\u00bd\u07fc\b\u00bd\u0001\u00be\u0001\u00be\u0001\u00be\u0003\u00be\u0801"+
		"\b\u00be\u0001\u00be\u0001\u00be\u0003\u00be\u0805\b\u00be\u0001\u00bf"+
		"\u0001\u00bf\u0001\u00bf\u0003\u00bf\u080a\b\u00bf\u0001\u00bf\u0001\u00bf"+
		"\u0003\u00bf\u080e\b\u00bf\u0001\u00c0\u0001\u00c0\u0001\u00c0\u0003\u00c0"+
		"\u0813\b\u00c0\u0001\u00c0\u0001\u00c0\u0003\u00c0\u0817\b\u00c0\u0001"+
		"\u00c1\u0001\u00c1\u0001\u00c1\u0003\u00c1\u081c\b\u00c1\u0001\u00c1\u0001"+
		"\u00c1\u0003\u00c1\u0820\b\u00c1\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001"+
		"\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c3\u0001\u00c3\u0001"+
		"\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001"+
		"\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0003"+
		"\u00c4\u0837\b\u00c4\u0001\u00c5\u0001\u00c5\u0001\u00c5\u0001\u00c5\u0001"+
		"\u00c5\u0001\u00c5\u0003\u00c5\u083f\b\u00c5\u0003\u00c5\u0841\b\u00c5"+
		"\u0001\u00c5\u0001\u00c5\u0001\u00c6\u0001\u00c6\u0001\u00c6\u0001\u00c6"+
		"\u0001\u00c6\u0003\u00c6\u084a\b\u00c6\u0001\u00c7\u0001\u00c7\u0001\u00c8"+
		"\u0001\u00c8\u0001\u00c8\u0001\u00c8\u0001\u00c8\u0001\u00c8\u0001\u00c8"+
		"\u0001\u00c8\u0001\u00c8\u0003\u00c8\u0857\b\u00c8\u0001\u00c9\u0001\u00c9"+
		"\u0001\u00c9\u0001\u00c9\u0001\u00c9\u0001\u00c9\u0003\u00c9\u085f\b\u00c9"+
		"\u0001\u00ca\u0001\u00ca\u0003\u00ca\u0863\b\u00ca\u0001\u00ca\u0001\u00ca"+
		"\u0003\u00ca\u0867\b\u00ca\u0001\u00cb\u0001\u00cb\u0001\u00cc\u0001\u00cc"+
		"\u0001\u00cc\u0001\u00cc\u0001\u00cc\u0001\u00cc\u0001\u00cc\u0001\u00cd"+
		"\u0001\u00cd\u0001\u00ce\u0001\u00ce\u0001\u00cf\u0001\u00cf\u0001\u00cf"+
		"\u0001\u00cf\u0001\u00cf\u0005\u00cf\u087b\b\u00cf\n\u00cf\f\u00cf\u087e"+
		"\t\u00cf\u0001\u00cf\u0001\u00cf\u0001\u00d0\u0001\u00d0\u0001\u00d0\u0001"+
		"\u00d0\u0001\u00d0\u0005\u00d0\u0887\b\u00d0\n\u00d0\f\u00d0\u088a\t\u00d0"+
		"\u0001\u00d0\u0001\u00d0\u0001\u00d1\u0001\u00d1\u0001\u00d1\u0001\u00d1"+
		"\u0003\u00d1\u0892\b\u00d1\u0001\u00d2\u0001\u00d2\u0001\u00d2\u0003\u00d2"+
		"\u0897\b\u00d2\u0001\u00d2\u0000\u0002\u009c\u00a4\u00d3\u0000\u0002\u0004"+
		"\u0006\b\n\f\u000e\u0010\u0012\u0014\u0016\u0018\u001a\u001c\u001e \""+
		"$&(*,.02468:<>@BDFHJLNPRTVXZ\\^`bdfhjlnprtvxz|~\u0080\u0082\u0084\u0086"+
		"\u0088\u008a\u008c\u008e\u0090\u0092\u0094\u0096\u0098\u009a\u009c\u009e"+
		"\u00a0\u00a2\u00a4\u00a6\u00a8\u00aa\u00ac\u00ae\u00b0\u00b2\u00b4\u00b6"+
		"\u00b8\u00ba\u00bc\u00be\u00c0\u00c2\u00c4\u00c6\u00c8\u00ca\u00cc\u00ce"+
		"\u00d0\u00d2\u00d4\u00d6\u00d8\u00da\u00dc\u00de\u00e0\u00e2\u00e4\u00e6"+
		"\u00e8\u00ea\u00ec\u00ee\u00f0\u00f2\u00f4\u00f6\u00f8\u00fa\u00fc\u00fe"+
		"\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116"+
		"\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e"+
		"\u0130\u0132\u0134\u0136\u0138\u013a\u013c\u013e\u0140\u0142\u0144\u0146"+
		"\u0148\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e"+
		"\u0160\u0162\u0164\u0166\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176"+
		"\u0178\u017a\u017c\u017e\u0180\u0182\u0184\u0186\u0188\u018a\u018c\u018e"+
		"\u0190\u0192\u0194\u0196\u0198\u019a\u019c\u019e\u01a0\u01a2\u01a4\u0000"+
		"!\u0002\u000077NN\u0003\u0000gg\u0080\u0080\u00b3\u00b3\u0002\u0000\u00a1"+
		"\u00a1\u00d5\u00d5\u0002\u0000bb}}\u0002\u000033OO\u0001\u0000\u00b5\u00b6"+
		"\u0002\u0000bb\u0098\u0098\u0002\u0000nn\u0081\u0081\u0001\u0000\u0010"+
		"\u0015\u0002\u0000RR\u00d0\u00d0\u0002\u0000qq{{\u0002\u0000SS\u00d1\u00d1"+
		"\u0002\u0000rr||\u0001\u0000 \"\u0001\u0000\u001e\u001f\u0001\u0000\u00da"+
		"\u00db\u0001\u0000\u0003\t\u0002\u0000\u0003\u0003\u0006\u0006\u0004\u0000"+
		"44\u008b\u008b\u0091\u0091\u00be\u00be\u0002\u0000\u008c\u008c\u0092\u0092"+
		"\u0002\u0000\u008d\u008d\u0093\u0093\u0002\u0000//[[\u0002\u000011\u00bc"+
		"\u00bc\u0002\u0000\u00d5\u00d5\u00d7\u00d7\u0003\u0000jj\u00b1\u00b1\u00b6"+
		"\u00b6\u0003\u000066\u007f\u007f\u00c6\u00c6\u0002\u0000\u007f\u007f\u00c6"+
		"\u00c6\u0001\u0000\u00c9\u00ca\b\u0000KKXXll\u0094\u0096\u00b0\u00b0\u00b8"+
		"\u00b8\u00d2\u00d2\u00d8\u00d8\u0002\u0000ll\u0094\u0094\u0002\u0000I"+
		"I\u00c1\u00c1\u0006\u0000*fhrt\u007f\u0081\u00a5\u00a7\u00b2\u00b4\u00d9"+
		"\u0005\u0000ggss\u0080\u0080\u00a6\u00a6\u00b3\u00b3\u092d\u0000\u01aa"+
		"\u0001\u0000\u0000\u0000\u0002\u01ae\u0001\u0000\u0000\u0000\u0004\u01b0"+
		"\u0001\u0000\u0000\u0000\u0006\u01b2\u0001\u0000\u0000\u0000\b\u01b6\u0001"+
		"\u0000\u0000\u0000\n\u01be\u0001\u0000\u0000\u0000\f\u01c7\u0001\u0000"+
		"\u0000\u0000\u000e\u01d0\u0001\u0000\u0000\u0000\u0010\u01d4\u0001\u0000"+
		"\u0000\u0000\u0012\u01e1\u0001\u0000\u0000\u0000\u0014\u01ec\u0001\u0000"+
		"\u0000\u0000\u0016\u01f5\u0001\u0000\u0000\u0000\u0018\u0200\u0001\u0000"+
		"\u0000\u0000\u001a\u0216\u0001\u0000\u0000\u0000\u001c\u021e\u0001\u0000"+
		"\u0000\u0000\u001e\u0220\u0001\u0000\u0000\u0000 \u0229\u0001\u0000\u0000"+
		"\u0000\"\u023a\u0001\u0000\u0000\u0000$\u0242\u0001\u0000\u0000\u0000"+
		"&\u024a\u0001\u0000\u0000\u0000(\u0252\u0001\u0000\u0000\u0000*\u0259"+
		"\u0001\u0000\u0000\u0000,\u0277\u0001\u0000\u0000\u0000.\u0284\u0001\u0000"+
		"\u0000\u00000\u0292\u0001\u0000\u0000\u00002\u0294\u0001\u0000\u0000\u0000"+
		"4\u02b9\u0001\u0000\u0000\u00006\u02bb\u0001\u0000\u0000\u00008\u02c4"+
		"\u0001\u0000\u0000\u0000:\u02d7\u0001\u0000\u0000\u0000<\u02d9\u0001\u0000"+
		"\u0000\u0000>\u02e4\u0001\u0000\u0000\u0000@\u02e6\u0001\u0000\u0000\u0000"+
		"B\u02ec\u0001\u0000\u0000\u0000D\u02f4\u0001\u0000\u0000\u0000F\u0306"+
		"\u0001\u0000\u0000\u0000H\u0315\u0001\u0000\u0000\u0000J\u0317\u0001\u0000"+
		"\u0000\u0000L\u031a\u0001\u0000\u0000\u0000N\u0320\u0001\u0000\u0000\u0000"+
		"P\u0328\u0001\u0000\u0000\u0000R\u0330\u0001\u0000\u0000\u0000T\u0332"+
		"\u0001\u0000\u0000\u0000V\u0337\u0001\u0000\u0000\u0000X\u0340\u0001\u0000"+
		"\u0000\u0000Z\u0342\u0001\u0000\u0000\u0000\\\u034a\u0001\u0000\u0000"+
		"\u0000^\u0350\u0001\u0000\u0000\u0000`\u0352\u0001\u0000\u0000\u0000b"+
		"\u0357\u0001\u0000\u0000\u0000d\u035e\u0001\u0000\u0000\u0000f\u0366\u0001"+
		"\u0000\u0000\u0000h\u0368\u0001\u0000\u0000\u0000j\u0380\u0001\u0000\u0000"+
		"\u0000l\u0382\u0001\u0000\u0000\u0000n\u0386\u0001\u0000\u0000\u0000p"+
		"\u038d\u0001\u0000\u0000\u0000r\u0393\u0001\u0000\u0000\u0000t\u039c\u0001"+
		"\u0000\u0000\u0000v\u03a3\u0001\u0000\u0000\u0000x\u03aa\u0001\u0000\u0000"+
		"\u0000z\u03b7\u0001\u0000\u0000\u0000|\u03b9\u0001\u0000\u0000\u0000~"+
		"\u03bc\u0001\u0000\u0000\u0000\u0080\u03c6\u0001\u0000\u0000\u0000\u0082"+
		"\u03ce\u0001\u0000\u0000\u0000\u0084\u03d5\u0001\u0000\u0000\u0000\u0086"+
		"\u03db\u0001\u0000\u0000\u0000\u0088\u03dd\u0001\u0000\u0000\u0000\u008a"+
		"\u03df\u0001\u0000\u0000\u0000\u008c\u03e6\u0001\u0000\u0000\u0000\u008e"+
		"\u03e8\u0001\u0000\u0000\u0000\u0090\u03eb\u0001\u0000\u0000\u0000\u0092"+
		"\u03f0\u0001\u0000\u0000\u0000\u0094\u03fd\u0001\u0000\u0000\u0000\u0096"+
		"\u0401\u0001\u0000\u0000\u0000\u0098\u0408\u0001\u0000\u0000\u0000\u009a"+
		"\u040a\u0001\u0000\u0000\u0000\u009c\u047e\u0001\u0000\u0000\u0000\u009e"+
		"\u048b\u0001\u0000\u0000\u0000\u00a0\u04a4\u0001\u0000\u0000\u0000\u00a2"+
		"\u04a6\u0001\u0000\u0000\u0000\u00a4\u04c6\u0001\u0000\u0000\u0000\u00a6"+
		"\u04ea\u0001\u0000\u0000\u0000\u00a8\u04ee\u0001\u0000\u0000\u0000\u00aa"+
		"\u04f2\u0001\u0000\u0000\u0000\u00ac\u04f4\u0001\u0000\u0000\u0000\u00ae"+
		"\u04f6\u0001\u0000\u0000\u0000\u00b0\u04f8\u0001\u0000\u0000\u0000\u00b2"+
		"\u04fa\u0001\u0000\u0000\u0000\u00b4\u04fc\u0001\u0000\u0000\u0000\u00b6"+
		"\u04fe\u0001\u0000\u0000\u0000\u00b8\u0500\u0001\u0000\u0000\u0000\u00ba"+
		"\u0502\u0001\u0000\u0000\u0000\u00bc\u050a\u0001\u0000\u0000\u0000\u00be"+
		"\u0511\u0001\u0000\u0000\u0000\u00c0\u0516\u0001\u0000\u0000\u0000\u00c2"+
		"\u051d\u0001\u0000\u0000\u0000\u00c4\u0524\u0001\u0000\u0000\u0000\u00c6"+
		"\u0526\u0001\u0000\u0000\u0000\u00c8\u0532\u0001\u0000\u0000\u0000\u00ca"+
		"\u0537\u0001\u0000\u0000\u0000\u00cc\u053a\u0001\u0000\u0000\u0000\u00ce"+
		"\u0545\u0001\u0000\u0000\u0000\u00d0\u0553\u0001\u0000\u0000\u0000\u00d2"+
		"\u0555\u0001\u0000\u0000\u0000\u00d4\u0557\u0001\u0000\u0000\u0000\u00d6"+
		"\u0564\u0001\u0000\u0000\u0000\u00d8\u056c\u0001\u0000\u0000\u0000\u00da"+
		"\u0571\u0001\u0000\u0000\u0000\u00dc\u057c\u0001\u0000\u0000\u0000\u00de"+
		"\u0587\u0001\u0000\u0000\u0000\u00e0\u0592\u0001\u0000\u0000\u0000\u00e2"+
		"\u059d\u0001\u0000\u0000\u0000\u00e4\u05a8\u0001\u0000\u0000\u0000\u00e6"+
		"\u05ad\u0001\u0000\u0000\u0000\u00e8\u05af\u0001\u0000\u0000\u0000\u00ea"+
		"\u05b2\u0001\u0000\u0000\u0000\u00ec\u05b6\u0001\u0000\u0000\u0000\u00ee"+
		"\u05ba\u0001\u0000\u0000\u0000\u00f0\u05be\u0001\u0000\u0000\u0000\u00f2"+
		"\u05c4\u0001\u0000\u0000\u0000\u00f4\u05cb\u0001\u0000\u0000\u0000\u00f6"+
		"\u05d1\u0001\u0000\u0000\u0000\u00f8\u05d6\u0001\u0000\u0000\u0000\u00fa"+
		"\u05d8\u0001\u0000\u0000\u0000\u00fc\u05da\u0001\u0000\u0000\u0000\u00fe"+
		"\u05dc\u0001\u0000\u0000\u0000\u0100\u05de\u0001\u0000\u0000\u0000\u0102"+
		"\u05e0\u0001\u0000\u0000\u0000\u0104\u05e8\u0001\u0000\u0000\u0000\u0106"+
		"\u05ea\u0001\u0000\u0000\u0000\u0108\u05f1\u0001\u0000\u0000\u0000\u010a"+
		"\u05f8\u0001\u0000\u0000\u0000\u010c\u05ff\u0001\u0000\u0000\u0000\u010e"+
		"\u0601\u0001\u0000\u0000\u0000\u0110\u060e\u0001\u0000\u0000\u0000\u0112"+
		"\u0614\u0001\u0000\u0000\u0000\u0114\u0616\u0001\u0000\u0000\u0000\u0116"+
		"\u061e\u0001\u0000\u0000\u0000\u0118\u0628\u0001\u0000\u0000\u0000\u011a"+
		"\u062a\u0001\u0000\u0000\u0000\u011c\u0639\u0001\u0000\u0000\u0000\u011e"+
		"\u063b\u0001\u0000\u0000\u0000\u0120\u0646\u0001\u0000\u0000\u0000\u0122"+
		"\u065c\u0001\u0000\u0000\u0000\u0124\u0662\u0001\u0000\u0000\u0000\u0126"+
		"\u066c\u0001\u0000\u0000\u0000\u0128\u068b\u0001\u0000\u0000\u0000\u012a"+
		"\u0697\u0001\u0000\u0000\u0000\u012c\u069c\u0001\u0000\u0000\u0000\u012e"+
		"\u06b3\u0001\u0000\u0000\u0000\u0130\u06ca\u0001\u0000\u0000\u0000\u0132"+
		"\u06cc\u0001\u0000\u0000\u0000\u0134\u06ce\u0001\u0000\u0000\u0000\u0136"+
		"\u06d0\u0001\u0000\u0000\u0000\u0138\u06e5\u0001\u0000\u0000\u0000\u013a"+
		"\u06f0\u0001\u0000\u0000\u0000\u013c\u06f6\u0001\u0000\u0000\u0000\u013e"+
		"\u06ff\u0001\u0000\u0000\u0000\u0140\u0705\u0001\u0000\u0000\u0000\u0142"+
		"\u0707\u0001\u0000\u0000\u0000\u0144\u0714\u0001\u0000\u0000\u0000\u0146"+
		"\u072b\u0001\u0000\u0000\u0000\u0148\u0737\u0001\u0000\u0000\u0000\u014a"+
		"\u0743\u0001\u0000\u0000\u0000\u014c\u074f\u0001\u0000\u0000\u0000\u014e"+
		"\u0765\u0001\u0000\u0000\u0000\u0150\u0767\u0001\u0000\u0000\u0000\u0152"+
		"\u076e\u0001\u0000\u0000\u0000\u0154\u0778\u0001\u0000\u0000\u0000\u0156"+
		"\u079a\u0001\u0000\u0000\u0000\u0158\u079c\u0001\u0000\u0000\u0000\u015a"+
		"\u079e\u0001\u0000\u0000\u0000\u015c\u07a0\u0001\u0000\u0000\u0000\u015e"+
		"\u07ae\u0001\u0000\u0000\u0000\u0160\u07b2\u0001\u0000\u0000\u0000\u0162"+
		"\u07b4\u0001\u0000\u0000\u0000\u0164\u07bf\u0001\u0000\u0000\u0000\u0166"+
		"\u07c1\u0001\u0000\u0000\u0000\u0168\u07c3\u0001\u0000\u0000\u0000\u016a"+
		"\u07c5\u0001\u0000\u0000\u0000\u016c\u07d2\u0001\u0000\u0000\u0000\u016e"+
		"\u07d4\u0001\u0000\u0000\u0000\u0170\u07d6\u0001\u0000\u0000\u0000\u0172"+
		"\u07d8\u0001\u0000\u0000\u0000\u0174\u07e1\u0001\u0000\u0000\u0000\u0176"+
		"\u07ea\u0001\u0000\u0000\u0000\u0178\u07f3\u0001\u0000\u0000\u0000\u017a"+
		"\u07fb\u0001\u0000\u0000\u0000\u017c\u0804\u0001\u0000\u0000\u0000\u017e"+
		"\u080d\u0001\u0000\u0000\u0000\u0180\u0816\u0001\u0000\u0000\u0000\u0182"+
		"\u081f\u0001\u0000\u0000\u0000\u0184\u0821\u0001\u0000\u0000\u0000\u0186"+
		"\u0828\u0001\u0000\u0000\u0000\u0188\u0836\u0001\u0000\u0000\u0000\u018a"+
		"\u0838\u0001\u0000\u0000\u0000\u018c\u0849\u0001\u0000\u0000\u0000\u018e"+
		"\u084b\u0001\u0000\u0000\u0000\u0190\u0856\u0001\u0000\u0000\u0000\u0192"+
		"\u085e\u0001\u0000\u0000\u0000\u0194\u0866\u0001\u0000\u0000\u0000\u0196"+
		"\u0868\u0001\u0000\u0000\u0000\u0198\u086a\u0001\u0000\u0000\u0000\u019a"+
		"\u0871\u0001\u0000\u0000\u0000\u019c\u0873\u0001\u0000\u0000\u0000\u019e"+
		"\u0875\u0001\u0000\u0000\u0000\u01a0\u0881\u0001\u0000\u0000\u0000\u01a2"+
		"\u0891\u0001\u0000\u0000\u0000\u01a4\u0896\u0001\u0000\u0000\u0000\u01a6"+
		"\u01ab\u0003\u0002\u0001\u0000\u01a7\u01ab\u0003\n\u0005\u0000\u01a8\u01ab"+
		"\u0003\b\u0004\u0000\u01a9\u01ab\u0003\u0010\b\u0000\u01aa\u01a6\u0001"+
		"\u0000\u0000\u0000\u01aa\u01a7\u0001\u0000\u0000\u0000\u01aa\u01a8\u0001"+
		"\u0000\u0000\u0000\u01aa\u01a9\u0001\u0000\u0000\u0000\u01ab\u01ac\u0001"+
		"\u0000\u0000\u0000\u01ac\u01ad\u0005\u0000\u0000\u0001\u01ad\u0001\u0001"+
		"\u0000\u0000\u0000\u01ae\u01af\u0003,\u0016\u0000\u01af\u0003\u0001\u0000"+
		"\u0000\u0000\u01b0\u01b1\u0003,\u0016\u0000\u01b1\u0005\u0001\u0000\u0000"+
		"\u0000\u01b2\u01b4\u0003<\u001e\u0000\u01b3\u01b5\u0003>\u001f\u0000\u01b4"+
		"\u01b3\u0001\u0000\u0000\u0000\u01b4\u01b5\u0001\u0000\u0000\u0000\u01b5"+
		"\u0007\u0001\u0000\u0000\u0000\u01b6\u01b8\u0005M\u0000\u0000\u01b7\u01b9"+
		"\u0005f\u0000\u0000\u01b8\u01b7\u0001\u0000\u0000\u0000\u01b8\u01b9\u0001"+
		"\u0000\u0000\u0000\u01b9\u01ba\u0001\u0000\u0000\u0000\u01ba\u01bc\u0003"+
		"8\u001c\u0000\u01bb\u01bd\u0003\u009aM\u0000\u01bc\u01bb\u0001\u0000\u0000"+
		"\u0000\u01bc\u01bd\u0001\u0000\u0000\u0000\u01bd\t\u0001\u0000\u0000\u0000"+
		"\u01be\u01c0\u0005\u00ce\u0000\u0000\u01bf\u01c1\u0005,\u0000\u0000\u01c0"+
		"\u01bf\u0001\u0000\u0000\u0000\u01c0\u01c1\u0001\u0000\u0000\u0000\u01c1"+
		"\u01c2\u0001\u0000\u0000\u0000\u01c2\u01c3\u00038\u001c\u0000\u01c3\u01c5"+
		"\u0003\f\u0006\u0000\u01c4\u01c6\u0003\u009aM\u0000\u01c5\u01c4\u0001"+
		"\u0000\u0000\u0000\u01c5\u01c6\u0001\u0000\u0000\u0000\u01c6\u000b\u0001"+
		"\u0000\u0000\u0000\u01c7\u01c8\u0005\u00ba\u0000\u0000\u01c8\u01cd\u0003"+
		"\u000e\u0007\u0000\u01c9\u01ca\u0005\u0016\u0000\u0000\u01ca\u01cc\u0003"+
		"\u000e\u0007\u0000\u01cb\u01c9\u0001\u0000\u0000\u0000\u01cc\u01cf\u0001"+
		"\u0000\u0000\u0000\u01cd\u01cb\u0001\u0000\u0000\u0000\u01cd\u01ce\u0001"+
		"\u0000\u0000\u0000\u01ce\r\u0001\u0000\u0000\u0000\u01cf\u01cd\u0001\u0000"+
		"\u0000\u0000\u01d0\u01d1\u0003b1\u0000\u01d1\u01d2\u0005\u0010\u0000\u0000"+
		"\u01d2\u01d3\u0003\u00a8T\u0000\u01d3\u000f\u0001\u0000\u0000\u0000\u01d4"+
		"\u01d6\u0005t\u0000\u0000\u01d5\u01d7\u0005x\u0000\u0000\u01d6\u01d5\u0001"+
		"\u0000\u0000\u0000\u01d6\u01d7\u0001\u0000\u0000\u0000\u01d7\u01d8\u0001"+
		"\u0000\u0000\u0000\u01d8\u01d9\u0003\u0006\u0003\u0000\u01d9\u01dc\u0003"+
		"\u0012\t\u0000\u01da\u01dd\u0003,\u0016\u0000\u01db\u01dd\u0003\u0014"+
		"\n\u0000\u01dc\u01da\u0001\u0000\u0000\u0000\u01dc\u01db\u0001\u0000\u0000"+
		"\u0000\u01dd\u01df\u0001\u0000\u0000\u0000\u01de\u01e0\u0003\u0018\f\u0000"+
		"\u01df\u01de\u0001\u0000\u0000\u0000\u01df\u01e0\u0001\u0000\u0000\u0000"+
		"\u01e0\u0011\u0001\u0000\u0000\u0000\u01e1\u01e2\u0005\u0018\u0000\u0000"+
		"\u01e2\u01e7\u0003b1\u0000\u01e3\u01e4\u0005\u0016\u0000\u0000\u01e4\u01e6"+
		"\u0003b1\u0000\u01e5\u01e3\u0001\u0000\u0000\u0000\u01e6\u01e9\u0001\u0000"+
		"\u0000\u0000\u01e7\u01e5\u0001\u0000\u0000\u0000\u01e7\u01e8\u0001\u0000"+
		"\u0000\u0000\u01e8\u01ea\u0001\u0000\u0000\u0000\u01e9\u01e7\u0001\u0000"+
		"\u0000\u0000\u01ea\u01eb\u0005\u0019\u0000\u0000\u01eb\u0013\u0001\u0000"+
		"\u0000\u0000\u01ec\u01ed\u0005\u00d1\u0000\u0000\u01ed\u01f2\u0003\u0016"+
		"\u000b\u0000\u01ee\u01ef\u0005\u0016\u0000\u0000\u01ef\u01f1\u0003\u0016"+
		"\u000b\u0000\u01f0\u01ee\u0001\u0000\u0000\u0000\u01f1\u01f4\u0001\u0000"+
		"\u0000\u0000\u01f2\u01f0\u0001\u0000\u0000\u0000\u01f2\u01f3\u0001\u0000"+
		"\u0000\u0000\u01f3\u0015\u0001\u0000\u0000\u0000\u01f4\u01f2\u0001\u0000"+
		"\u0000\u0000\u01f5\u01f6\u0005\u0018\u0000\u0000\u01f6\u01fb\u0003\u00a8"+
		"T\u0000\u01f7\u01f8\u0005\u0016\u0000\u0000\u01f8\u01fa\u0003\u00a8T\u0000"+
		"\u01f9\u01f7\u0001\u0000\u0000\u0000\u01fa\u01fd\u0001\u0000\u0000\u0000"+
		"\u01fb\u01f9\u0001\u0000\u0000\u0000\u01fb\u01fc\u0001\u0000\u0000\u0000"+
		"\u01fc\u01fe\u0001\u0000\u0000\u0000\u01fd\u01fb\u0001\u0000\u0000\u0000"+
		"\u01fe\u01ff\u0005\u0019\u0000\u0000\u01ff\u0017\u0001\u0000\u0000\u0000"+
		"\u0200\u0201\u0005\u00a1\u0000\u0000\u0201\u0203\u0005=\u0000\u0000\u0202"+
		"\u0204\u0003\u001a\r\u0000\u0203\u0202\u0001\u0000\u0000\u0000\u0203\u0204"+
		"\u0001\u0000\u0000\u0000\u0204\u0205\u0001\u0000\u0000\u0000\u0205\u0206"+
		"\u0005Q\u0000\u0000\u0206\u0207\u0003\u001c\u000e\u0000\u0207\u0019\u0001"+
		"\u0000\u0000\u0000\u0208\u0209\u0005\u00a1\u0000\u0000\u0209\u020a\u0005"+
		">\u0000\u0000\u020a\u0217\u0003\u01a4\u00d2\u0000\u020b\u020c\u0005\u0018"+
		"\u0000\u0000\u020c\u0211\u0003b1\u0000\u020d\u020e\u0005\u0016\u0000\u0000"+
		"\u020e\u0210\u0003b1\u0000\u020f\u020d\u0001\u0000\u0000\u0000\u0210\u0213"+
		"\u0001\u0000\u0000\u0000\u0211\u020f\u0001\u0000\u0000\u0000\u0211\u0212"+
		"\u0001\u0000\u0000\u0000\u0212\u0214\u0001\u0000\u0000\u0000\u0213\u0211"+
		"\u0001\u0000\u0000\u0000\u0214\u0215\u0005\u0019\u0000\u0000\u0215\u0217"+
		"\u0001\u0000\u0000\u0000\u0216\u0208\u0001\u0000\u0000\u0000\u0216\u020b"+
		"\u0001\u0000\u0000\u0000\u0217\u001b\u0001\u0000\u0000\u0000\u0218\u021f"+
		"\u0005\u009b\u0000\u0000\u0219\u021a\u0005\u00ce\u0000\u0000\u021a\u021c"+
		"\u0003\f\u0006\u0000\u021b\u021d\u0003\u009aM\u0000\u021c\u021b\u0001"+
		"\u0000\u0000\u0000\u021c\u021d\u0001\u0000\u0000\u0000\u021d\u021f\u0001"+
		"\u0000\u0000\u0000\u021e\u0218\u0001\u0000\u0000\u0000\u021e\u0219\u0001"+
		"\u0000\u0000\u0000\u021f\u001d\u0001\u0000\u0000\u0000\u0220\u0221\u0005"+
		"\u00d5\u0000\u0000\u0221\u0226\u0003 \u0010\u0000\u0222\u0223\u0005\u0016"+
		"\u0000\u0000\u0223\u0225\u0003 \u0010\u0000\u0224\u0222\u0001\u0000\u0000"+
		"\u0000\u0225\u0228\u0001\u0000\u0000\u0000\u0226\u0224\u0001\u0000\u0000"+
		"\u0000\u0226\u0227\u0001\u0000\u0000\u0000\u0227\u001f\u0001\u0000\u0000"+
		"\u0000\u0228\u0226\u0001\u0000\u0000\u0000\u0229\u022a\u0003\u01a4\u00d2"+
		"\u0000\u022a\u022f\u00052\u0000\u0000\u022b\u022d\u0005\u009a\u0000\u0000"+
		"\u022c\u022b\u0001\u0000\u0000\u0000\u022c\u022d\u0001\u0000\u0000\u0000"+
		"\u022d\u022e\u0001\u0000\u0000\u0000\u022e\u0230\u0005\u008a\u0000\u0000"+
		"\u022f\u022c\u0001\u0000\u0000\u0000\u022f\u0230\u0001\u0000\u0000\u0000"+
		"\u0230\u0231\u0001\u0000\u0000\u0000\u0231\u0232\u0005\u0018\u0000\u0000"+
		"\u0232\u0233\u0003,\u0016\u0000\u0233\u0235\u0005\u0019\u0000\u0000\u0234"+
		"\u0236\u0003$\u0012\u0000\u0235\u0234\u0001\u0000\u0000\u0000\u0235\u0236"+
		"\u0001\u0000\u0000\u0000\u0236\u0238\u0001\u0000\u0000\u0000\u0237\u0239"+
		"\u0003*\u0015\u0000\u0238\u0237\u0001\u0000\u0000\u0000\u0238\u0239\u0001"+
		"\u0000\u0000\u0000\u0239!\u0001\u0000\u0000\u0000\u023a\u023f\u0003\u01a4"+
		"\u00d2\u0000\u023b\u023c\u0005\u0016\u0000\u0000\u023c\u023e\u0003\u01a4"+
		"\u00d2\u0000\u023d\u023b\u0001\u0000\u0000\u0000\u023e\u0241\u0001\u0000"+
		"\u0000\u0000\u023f\u023d\u0001\u0000\u0000\u0000\u023f\u0240\u0001\u0000"+
		"\u0000\u0000\u0240#\u0001\u0000\u0000\u0000\u0241\u023f\u0001\u0000\u0000"+
		"\u0000\u0242\u0243\u0005\u00b7\u0000\u0000\u0243\u0244\u0007\u0000\u0000"+
		"\u0000\u0244\u0245\u0005b\u0000\u0000\u0245\u0246\u00058\u0000\u0000\u0246"+
		"\u0247\u0003&\u0013\u0000\u0247\u0248\u0005\u00ba\u0000\u0000\u0248\u0249"+
		"\u0003\u01a4\u00d2\u0000\u0249%\u0001\u0000\u0000\u0000\u024a\u024f\u0003"+
		"(\u0014\u0000\u024b\u024c\u0005\u0016\u0000\u0000\u024c\u024e\u0003(\u0014"+
		"\u0000\u024d\u024b\u0001\u0000\u0000\u0000\u024e\u0251\u0001\u0000\u0000"+
		"\u0000\u024f\u024d\u0001\u0000\u0000\u0000\u024f\u0250\u0001\u0000\u0000"+
		"\u0000\u0250\'\u0001\u0000\u0000\u0000\u0251\u024f\u0001\u0000\u0000\u0000"+
		"\u0252\u0254\u0003\u01a4\u00d2\u0000\u0253\u0255\u0003\u0088D\u0000\u0254"+
		"\u0253\u0001\u0000\u0000\u0000\u0254\u0255\u0001\u0000\u0000\u0000\u0255"+
		"\u0257\u0001\u0000\u0000\u0000\u0256\u0258\u0003\u0084B\u0000\u0257\u0256"+
		"\u0001\u0000\u0000\u0000\u0257\u0258\u0001\u0000\u0000\u0000\u0258)\u0001"+
		"\u0000\u0000\u0000\u0259\u025a\u0005H\u0000\u0000\u025a\u025b\u0003\""+
		"\u0011\u0000\u025b\u025c\u0005\u00ba\u0000\u0000\u025c\u0262\u0003\u01a4"+
		"\u00d2\u0000\u025d\u025e\u0005\u00c5\u0000\u0000\u025e\u025f\u0003\u00d0"+
		"h\u0000\u025f\u0260\u0005L\u0000\u0000\u0260\u0261\u0003\u00d0h\u0000"+
		"\u0261\u0263\u0001\u0000\u0000\u0000\u0262\u025d\u0001\u0000\u0000\u0000"+
		"\u0262\u0263\u0001\u0000\u0000\u0000\u0263\u0266\u0001\u0000\u0000\u0000"+
		"\u0264\u0265\u0005\u00cf\u0000\u0000\u0265\u0267\u0003\u01a4\u00d2\u0000"+
		"\u0266\u0264\u0001\u0000\u0000\u0000\u0266\u0267\u0001\u0000\u0000\u0000"+
		"\u0267+\u0001\u0000\u0000\u0000\u0268\u026a\u0003\u001e\u000f\u0000\u0269"+
		"\u0268\u0001\u0000\u0000\u0000\u0269\u026a\u0001\u0000\u0000\u0000\u026a"+
		"\u026b\u0001\u0000\u0000\u0000\u026b\u0278\u0003.\u0017\u0000\u026c\u026e"+
		"\u0003\u001e\u000f\u0000\u026d\u026c\u0001\u0000\u0000\u0000\u026d\u026e"+
		"\u0001\u0000\u0000\u0000\u026e\u026f\u0001\u0000\u0000\u0000\u026f\u0273"+
		"\u0003.\u0017\u0000\u0270\u0271\u00030\u0018\u0000\u0271\u0272\u0003."+
		"\u0017\u0000\u0272\u0274\u0001\u0000\u0000\u0000\u0273\u0270\u0001\u0000"+
		"\u0000\u0000\u0274\u0275\u0001\u0000\u0000\u0000\u0275\u0273\u0001\u0000"+
		"\u0000\u0000\u0275\u0276\u0001\u0000\u0000\u0000\u0276\u0278\u0001\u0000"+
		"\u0000\u0000\u0277\u0269\u0001\u0000\u0000\u0000\u0277\u026d\u0001\u0000"+
		"\u0000\u0000\u0278-\u0001\u0000\u0000\u0000\u0279\u027b\u00034\u001a\u0000"+
		"\u027a\u027c\u00032\u0019\u0000\u027b\u027a\u0001\u0000\u0000\u0000\u027b"+
		"\u027c\u0001\u0000\u0000\u0000\u027c\u0285\u0001\u0000\u0000\u0000\u027d"+
		"\u027e\u0005\u0018\u0000\u0000\u027e\u027f\u0003,\u0016\u0000\u027f\u0281"+
		"\u0005\u0019\u0000\u0000\u0280\u0282\u00032\u0019\u0000\u0281\u0280\u0001"+
		"\u0000\u0000\u0000\u0281\u0282\u0001\u0000\u0000\u0000\u0282\u0285\u0001"+
		"\u0000\u0000\u0000\u0283\u0285\u00032\u0019\u0000\u0284\u0279\u0001\u0000"+
		"\u0000\u0000\u0284\u027d\u0001\u0000\u0000\u0000\u0284\u0283\u0001\u0000"+
		"\u0000\u0000\u0285/\u0001\u0000\u0000\u0000\u0286\u0288\u0005\u00cd\u0000"+
		"\u0000\u0287\u0289\u0005/\u0000\u0000\u0288\u0287\u0001\u0000\u0000\u0000"+
		"\u0288\u0289\u0001\u0000\u0000\u0000\u0289\u0293\u0001\u0000\u0000\u0000"+
		"\u028a\u028c\u0005v\u0000\u0000\u028b\u028d\u0005/\u0000\u0000\u028c\u028b"+
		"\u0001\u0000\u0000\u0000\u028c\u028d\u0001\u0000\u0000\u0000\u028d\u0293"+
		"\u0001\u0000\u0000\u0000\u028e\u0290\u0005\\\u0000\u0000\u028f\u0291\u0005"+
		"/\u0000\u0000\u0290\u028f\u0001\u0000\u0000\u0000\u0290\u0291\u0001\u0000"+
		"\u0000\u0000\u0291\u0293\u0001\u0000\u0000\u0000\u0292\u0286\u0001\u0000"+
		"\u0000\u0000\u0292\u028a\u0001\u0000\u0000\u0000\u0292\u028e\u0001\u0000"+
		"\u0000\u0000\u02931\u0001\u0000\u0000\u0000\u0294\u0296\u0003~?\u0000"+
		"\u0295\u0297\u0003\u008eG\u0000\u0296\u0295\u0001\u0000\u0000\u0000\u0296"+
		"\u0297\u0001\u0000\u0000\u0000\u0297\u0299\u0001\u0000\u0000\u0000\u0298"+
		"\u029a\u0003\u0090H\u0000\u0299\u0298\u0001\u0000\u0000\u0000\u0299\u029a"+
		"\u0001\u0000\u0000\u0000\u029a\u029c\u0001\u0000\u0000\u0000\u029b\u029d"+
		"\u0003\u0092I\u0000\u029c\u029b\u0001\u0000\u0000\u0000\u029c\u029d\u0001"+
		"\u0000\u0000\u0000\u029d3\u0001\u0000\u0000\u0000\u029e\u02a0\u0003L&"+
		"\u0000\u029f\u02a1\u00036\u001b\u0000\u02a0\u029f\u0001\u0000\u0000\u0000"+
		"\u02a0\u02a1\u0001\u0000\u0000\u0000\u02a1\u02a3\u0001\u0000\u0000\u0000"+
		"\u02a2\u02a4\u0003\u009aM\u0000\u02a3\u02a2\u0001\u0000\u0000\u0000\u02a3"+
		"\u02a4\u0001\u0000\u0000\u0000\u02a4\u02a9\u0001\u0000\u0000\u0000\u02a5"+
		"\u02a7\u0003x<\u0000\u02a6\u02a8\u0003|>\u0000\u02a7\u02a6\u0001\u0000"+
		"\u0000\u0000\u02a7\u02a8\u0001\u0000\u0000\u0000\u02a8\u02aa\u0001\u0000"+
		"\u0000\u0000\u02a9\u02a5\u0001\u0000\u0000\u0000\u02a9\u02aa\u0001\u0000"+
		"\u0000\u0000\u02aa\u02ba\u0001\u0000\u0000\u0000\u02ab\u02ad\u00036\u001b"+
		"\u0000\u02ac\u02ae\u0003\u009aM\u0000\u02ad\u02ac\u0001\u0000\u0000\u0000"+
		"\u02ad\u02ae\u0001\u0000\u0000\u0000\u02ae\u02b3\u0001\u0000\u0000\u0000"+
		"\u02af\u02b1\u0003x<\u0000\u02b0\u02b2\u0003|>\u0000\u02b1\u02b0\u0001"+
		"\u0000\u0000\u0000\u02b1\u02b2\u0001\u0000\u0000\u0000\u02b2\u02b4\u0001"+
		"\u0000\u0000\u0000\u02b3\u02af\u0001\u0000\u0000\u0000\u02b3\u02b4\u0001"+
		"\u0000\u0000\u0000\u02b4\u02b6\u0001\u0000\u0000\u0000\u02b5\u02b7\u0003"+
		"L&\u0000\u02b6\u02b5\u0001\u0000\u0000\u0000\u02b6\u02b7\u0001\u0000\u0000"+
		"\u0000\u02b7\u02ba\u0001\u0000\u0000\u0000\u02b8\u02ba\u0003\u009aM\u0000"+
		"\u02b9\u029e\u0001\u0000\u0000\u0000\u02b9\u02ab\u0001\u0000\u0000\u0000"+
		"\u02b9\u02b8\u0001\u0000\u0000\u0000\u02ba5\u0001\u0000\u0000\u0000\u02bb"+
		"\u02bc\u0005f\u0000\u0000\u02bc\u02c1\u00038\u001c\u0000\u02bd\u02be\u0005"+
		"\u0016\u0000\u0000\u02be\u02c0\u00038\u001c\u0000\u02bf\u02bd\u0001\u0000"+
		"\u0000\u0000\u02c0\u02c3\u0001\u0000\u0000\u0000\u02c1\u02bf\u0001\u0000"+
		"\u0000\u0000\u02c1\u02c2\u0001\u0000\u0000\u0000\u02c27\u0001\u0000\u0000"+
		"\u0000\u02c3\u02c1\u0001\u0000\u0000\u0000\u02c4\u02ca\u0003:\u001d\u0000"+
		"\u02c5\u02c9\u0003D\"\u0000\u02c6\u02c9\u0003@ \u0000\u02c7\u02c9\u0003"+
		"B!\u0000\u02c8\u02c5\u0001\u0000\u0000\u0000\u02c8\u02c6\u0001\u0000\u0000"+
		"\u0000\u02c8\u02c7\u0001\u0000\u0000\u0000\u02c9\u02cc\u0001\u0000\u0000"+
		"\u0000\u02ca\u02c8\u0001\u0000\u0000\u0000\u02ca\u02cb\u0001\u0000\u0000"+
		"\u0000\u02cb9\u0001\u0000\u0000\u0000\u02cc\u02ca\u0001\u0000\u0000\u0000"+
		"\u02cd\u02cf\u0003<\u001e\u0000\u02ce\u02d0\u0003>\u001f\u0000\u02cf\u02ce"+
		"\u0001\u0000\u0000\u0000\u02cf\u02d0\u0001\u0000\u0000\u0000\u02d0\u02d8"+
		"\u0001\u0000\u0000\u0000\u02d1\u02d2\u0005\u0018\u0000\u0000\u02d2\u02d3"+
		"\u0003\u0004\u0002\u0000\u02d3\u02d5\u0005\u0019\u0000\u0000\u02d4\u02d6"+
		"\u0003>\u001f\u0000\u02d5\u02d4\u0001\u0000\u0000\u0000\u02d5\u02d6\u0001"+
		"\u0000\u0000\u0000\u02d6\u02d8\u0001\u0000\u0000\u0000\u02d7\u02cd\u0001"+
		"\u0000\u0000\u0000\u02d7\u02d1\u0001\u0000\u0000\u0000\u02d8;\u0001\u0000"+
		"\u0000\u0000\u02d9\u02de\u0003\u01a4\u00d2\u0000\u02da\u02db\u0005\u0017"+
		"\u0000\u0000\u02db\u02dd\u0003\u01a4\u00d2\u0000\u02dc\u02da\u0001\u0000"+
		"\u0000\u0000\u02dd\u02e0\u0001\u0000\u0000\u0000\u02de\u02dc\u0001\u0000"+
		"\u0000\u0000\u02de\u02df\u0001\u0000\u0000\u0000\u02df=\u0001\u0000\u0000"+
		"\u0000\u02e0\u02de\u0001\u0000\u0000\u0000\u02e1\u02e2\u00052\u0000\u0000"+
		"\u02e2\u02e5\u0003\u01a4\u00d2\u0000\u02e3\u02e5\u0003\u01a2\u00d1\u0000"+
		"\u02e4\u02e1\u0001\u0000\u0000\u0000\u02e4\u02e3\u0001\u0000\u0000\u0000"+
		"\u02e5?\u0001\u0000\u0000\u0000\u02e6\u02e7\u0005A\u0000\u0000\u02e7\u02e8"+
		"\u0005z\u0000\u0000\u02e8\u02ea\u0003<\u001e\u0000\u02e9\u02eb\u0003>"+
		"\u001f\u0000\u02ea\u02e9\u0001\u0000\u0000\u0000\u02ea\u02eb\u0001\u0000"+
		"\u0000\u0000\u02ebA\u0001\u0000\u0000\u0000\u02ec\u02ed\u0005\u0016\u0000"+
		"\u0000\u02ed\u02ee\u0005o\u0000\u0000\u02ee\u02ef\u0005\u0018\u0000\u0000"+
		"\u02ef\u02f0\u0003f3\u0000\u02f0\u02f2\u0005\u0019\u0000\u0000\u02f1\u02f3"+
		"\u0003>\u001f\u0000\u02f2\u02f1\u0001\u0000\u0000\u0000\u02f2\u02f3\u0001"+
		"\u0000\u0000\u0000\u02f3C\u0001\u0000\u0000\u0000\u02f4\u02f5\u0003F#"+
		"\u0000\u02f5\u02f7\u0005z\u0000\u0000\u02f6\u02f8\u0005`\u0000\u0000\u02f7"+
		"\u02f6\u0001\u0000\u0000\u0000\u02f7\u02f8\u0001\u0000\u0000\u0000\u02f8"+
		"\u02f9\u0001\u0000\u0000\u0000\u02f9\u02fb\u0003H$\u0000\u02fa\u02fc\u0003"+
		"J%\u0000\u02fb\u02fa\u0001\u0000\u0000\u0000\u02fb\u02fc\u0001\u0000\u0000"+
		"\u0000\u02fcE\u0001\u0000\u0000\u0000\u02fd\u02ff\u0005s\u0000\u0000\u02fe"+
		"\u02fd\u0001\u0000\u0000\u0000\u02fe\u02ff\u0001\u0000\u0000\u0000\u02ff"+
		"\u0307\u0001\u0000\u0000\u0000\u0300\u0302\u0007\u0001\u0000\u0000\u0301"+
		"\u0300\u0001\u0000\u0000\u0000\u0301\u0302\u0001\u0000\u0000\u0000\u0302"+
		"\u0304\u0001\u0000\u0000\u0000\u0303\u0305\u0005\u00a6\u0000\u0000\u0304"+
		"\u0303\u0001\u0000\u0000\u0000\u0304\u0305\u0001\u0000\u0000\u0000\u0305"+
		"\u0307\u0001\u0000\u0000\u0000\u0306\u02fe\u0001\u0000\u0000\u0000\u0306"+
		"\u0301\u0001\u0000\u0000\u0000\u0307G\u0001\u0000\u0000\u0000\u0308\u030a"+
		"\u0003f3\u0000\u0309\u030b\u0003>\u001f\u0000\u030a\u0309\u0001\u0000"+
		"\u0000\u0000\u030a\u030b\u0001\u0000\u0000\u0000\u030b\u0316\u0001\u0000"+
		"\u0000\u0000\u030c\u030e\u0005~\u0000\u0000\u030d\u030c\u0001\u0000\u0000"+
		"\u0000\u030d\u030e\u0001\u0000\u0000\u0000\u030e\u030f\u0001\u0000\u0000"+
		"\u0000\u030f\u0310\u0005\u0018\u0000\u0000\u0310\u0311\u0003\u0004\u0002"+
		"\u0000\u0311\u0313\u0005\u0019\u0000\u0000\u0312\u0314\u0003>\u001f\u0000"+
		"\u0313\u0312\u0001\u0000\u0000\u0000\u0313\u0314\u0001\u0000\u0000\u0000"+
		"\u0314\u0316\u0001\u0000\u0000\u0000\u0315\u0308\u0001\u0000\u0000\u0000"+
		"\u0315\u030d\u0001\u0000\u0000\u0000\u0316I\u0001\u0000\u0000\u0000\u0317"+
		"\u0318\u0007\u0002\u0000\u0000\u0318\u0319\u0003\u009cN\u0000\u0319K\u0001"+
		"\u0000\u0000\u0000\u031a\u031c\u0005\u00b9\u0000\u0000\u031b\u031d\u0005"+
		"P\u0000\u0000\u031c\u031b\u0001\u0000\u0000\u0000\u031c\u031d\u0001\u0000"+
		"\u0000\u0000\u031d\u031e\u0001\u0000\u0000\u0000\u031e\u031f\u0003N\'"+
		"\u0000\u031fM\u0001\u0000\u0000\u0000\u0320\u0325\u0003P(\u0000\u0321"+
		"\u0322\u0005\u0016\u0000\u0000\u0322\u0324\u0003P(\u0000\u0323\u0321\u0001"+
		"\u0000\u0000\u0000\u0324\u0327\u0001\u0000\u0000\u0000\u0325\u0323\u0001"+
		"\u0000\u0000\u0000\u0325\u0326\u0001\u0000\u0000\u0000\u0326O\u0001\u0000"+
		"\u0000\u0000\u0327\u0325\u0001\u0000\u0000\u0000\u0328\u032a\u0003R)\u0000"+
		"\u0329\u032b\u0003>\u001f\u0000\u032a\u0329\u0001\u0000\u0000\u0000\u032a"+
		"\u032b\u0001\u0000\u0000\u0000\u032bQ\u0001\u0000\u0000\u0000\u032c\u0331"+
		"\u0003V+\u0000\u032d\u0331\u0003T*\u0000\u032e\u0331\u0003`0\u0000\u032f"+
		"\u0331\u0003\u00a8T\u0000\u0330\u032c\u0001\u0000\u0000\u0000\u0330\u032d"+
		"\u0001\u0000\u0000\u0000\u0330\u032e\u0001\u0000\u0000\u0000\u0330\u032f"+
		"\u0001\u0000\u0000\u0000\u0331S\u0001\u0000\u0000\u0000\u0332\u0333\u0005"+
		"W\u0000\u0000\u0333\u0334\u0005\u0018\u0000\u0000\u0334\u0335\u0003f3"+
		"\u0000\u0335\u0336\u0005\u0019\u0000\u0000\u0336U\u0001\u0000\u0000\u0000"+
		"\u0337\u0338\u0005\u0097\u0000\u0000\u0338\u0339\u0003X,\u0000\u0339\u033a"+
		"\u0005\u0018\u0000\u0000\u033a\u033b\u0003Z-\u0000\u033b\u033c\u0005\u0019"+
		"\u0000\u0000\u033cW\u0001\u0000\u0000\u0000\u033d\u0341\u0005\u0083\u0000"+
		"\u0000\u033e\u0341\u0005\u0089\u0000\u0000\u033f\u0341\u0003b1\u0000\u0340"+
		"\u033d\u0001\u0000\u0000\u0000\u0340\u033e\u0001\u0000\u0000\u0000\u0340"+
		"\u033f\u0001\u0000\u0000\u0000\u0341Y\u0001\u0000\u0000\u0000\u0342\u0347"+
		"\u0003\\.\u0000\u0343\u0344\u0005\u0016\u0000\u0000\u0344\u0346\u0003"+
		"\\.\u0000\u0345\u0343\u0001\u0000\u0000\u0000\u0346\u0349\u0001\u0000"+
		"\u0000\u0000\u0347\u0345\u0001\u0000\u0000\u0000\u0347\u0348\u0001\u0000"+
		"\u0000\u0000\u0348[\u0001\u0000\u0000\u0000\u0349\u0347\u0001\u0000\u0000"+
		"\u0000\u034a\u034c\u0003^/\u0000\u034b\u034d\u0003>\u001f\u0000\u034c"+
		"\u034b\u0001\u0000\u0000\u0000\u034c\u034d\u0001\u0000\u0000\u0000\u034d"+
		"]\u0001\u0000\u0000\u0000\u034e\u0351\u0003\u00a8T\u0000\u034f\u0351\u0003"+
		"V+\u0000\u0350\u034e\u0001\u0000\u0000\u0000\u0350\u034f\u0001\u0000\u0000"+
		"\u0000\u0351_\u0001\u0000\u0000\u0000\u0352\u0353\u0005\u009d\u0000\u0000"+
		"\u0353\u0354\u0005\u0018\u0000\u0000\u0354\u0355\u0003\u01a4\u00d2\u0000"+
		"\u0355\u0356\u0005\u0019\u0000\u0000\u0356a\u0001\u0000\u0000\u0000\u0357"+
		"\u035b\u0003\u01a4\u00d2\u0000\u0358\u035a\u0003d2\u0000\u0359\u0358\u0001"+
		"\u0000\u0000\u0000\u035a\u035d\u0001\u0000\u0000\u0000\u035b\u0359\u0001"+
		"\u0000\u0000\u0000\u035b\u035c\u0001\u0000\u0000\u0000\u035cc\u0001\u0000"+
		"\u0000\u0000\u035d\u035b\u0001\u0000\u0000\u0000\u035e\u035f\u0005\u0017"+
		"\u0000\u0000\u035f\u0360\u0003\u01a4\u00d2\u0000\u0360e\u0001\u0000\u0000"+
		"\u0000\u0361\u0363\u0003j5\u0000\u0362\u0364\u0003h4\u0000\u0363\u0362"+
		"\u0001\u0000\u0000\u0000\u0363\u0364\u0001\u0000\u0000\u0000\u0364\u0367"+
		"\u0001\u0000\u0000\u0000\u0365\u0367\u0003l6\u0000\u0366\u0361\u0001\u0000"+
		"\u0000\u0000\u0366\u0365\u0001\u0000\u0000\u0000\u0367g\u0001\u0000\u0000"+
		"\u0000\u0368\u0369\u0005\u0017\u0000\u0000\u0369\u036a\u0003b1\u0000\u036a"+
		"i\u0001\u0000\u0000\u0000\u036b\u0381\u0003r9\u0000\u036c\u0381\u0003"+
		"t:\u0000\u036d\u0381\u0003v;\u0000\u036e\u036f\u0003b1\u0000\u036f\u0370"+
		"\u0003n7\u0000\u0370\u0381\u0001\u0000\u0000\u0000\u0371\u0372\u0003b"+
		"1\u0000\u0372\u0373\u0003p8\u0000\u0373\u0381\u0001\u0000\u0000\u0000"+
		"\u0374\u0381\u0003\u00c2a\u0000\u0375\u0376\u0003\u0118\u008c\u0000\u0376"+
		"\u0377\u0003h4\u0000\u0377\u0381\u0001\u0000\u0000\u0000\u0378\u0379\u0003"+
		"\u0118\u008c\u0000\u0379\u037b\u0003n7\u0000\u037a\u037c\u0003h4\u0000"+
		"\u037b\u037a\u0001\u0000\u0000\u0000\u037b\u037c\u0001\u0000\u0000\u0000"+
		"\u037c\u0381\u0001\u0000\u0000\u0000\u037d\u037e\u0003\u0118\u008c\u0000"+
		"\u037e\u037f\u0003p8\u0000\u037f\u0381\u0001\u0000\u0000\u0000\u0380\u036b"+
		"\u0001\u0000\u0000\u0000\u0380\u036c\u0001\u0000\u0000\u0000\u0380\u036d"+
		"\u0001\u0000\u0000\u0000\u0380\u036e\u0001\u0000\u0000\u0000\u0380\u0371"+
		"\u0001\u0000\u0000\u0000\u0380\u0374\u0001\u0000\u0000\u0000\u0380\u0375"+
		"\u0001\u0000\u0000\u0000\u0380\u0378\u0001\u0000\u0000\u0000\u0380\u037d"+
		"\u0001\u0000\u0000\u0000\u0381k\u0001\u0000\u0000\u0000\u0382\u0384\u0003"+
		"b1\u0000\u0383\u0385\u0003n7\u0000\u0384\u0383\u0001\u0000\u0000\u0000"+
		"\u0384\u0385\u0001\u0000\u0000\u0000\u0385m\u0001\u0000\u0000\u0000\u0386"+
		"\u0387\u0005\u001a\u0000\u0000\u0387\u0388\u0003\u00a4R\u0000\u0388\u038b"+
		"\u0005\u001b\u0000\u0000\u0389\u038a\u0005\u0017\u0000\u0000\u038a\u038c"+
		"\u0003l6\u0000\u038b\u0389\u0001\u0000\u0000\u0000\u038b\u038c\u0001\u0000"+
		"\u0000\u0000\u038co\u0001\u0000\u0000\u0000\u038d\u038e\u0005\u001a\u0000"+
		"\u0000\u038e\u038f\u0003\u00a4R\u0000\u038f\u0390\u0005%\u0000\u0000\u0390"+
		"\u0391\u0003\u00a4R\u0000\u0391\u0392\u0005\u001b\u0000\u0000\u0392q\u0001"+
		"\u0000\u0000\u0000\u0393\u0394\u0005\u00c7\u0000\u0000\u0394\u0395\u0005"+
		"\u0018\u0000\u0000\u0395\u0396\u0003f3\u0000\u0396\u0397\u00052\u0000"+
		"\u0000\u0397\u0398\u0003b1\u0000\u0398\u039a\u0005\u0019\u0000\u0000\u0399"+
		"\u039b\u0003h4\u0000\u039a\u0399\u0001\u0000\u0000\u0000\u039a\u039b\u0001"+
		"\u0000\u0000\u0000\u039bs\u0001\u0000\u0000\u0000\u039c\u039d\u0003\u00ac"+
		"V\u0000\u039d\u039e\u0005\u0018\u0000\u0000\u039e\u039f\u0003f3\u0000"+
		"\u039f\u03a1\u0005\u0019\u0000\u0000\u03a0\u03a2\u0003h4\u0000\u03a1\u03a0"+
		"\u0001\u0000\u0000\u0000\u03a1\u03a2\u0001\u0000\u0000\u0000\u03a2u\u0001"+
		"\u0000\u0000\u0000\u03a3\u03a4\u0003\u00aeW\u0000\u03a4\u03a5\u0005\u0018"+
		"\u0000\u0000\u03a5\u03a6\u0003f3\u0000\u03a6\u03a8\u0005\u0019\u0000\u0000"+
		"\u03a7\u03a9\u0003h4\u0000\u03a8\u03a7\u0001\u0000\u0000\u0000\u03a8\u03a9"+
		"\u0001\u0000\u0000\u0000\u03a9w\u0001\u0000\u0000\u0000\u03aa\u03ab\u0005"+
		"i\u0000\u0000\u03ab\u03ac\u00058\u0000\u0000\u03ac\u03b1\u0003z=\u0000"+
		"\u03ad\u03ae\u0005\u0016\u0000\u0000\u03ae\u03b0\u0003z=\u0000\u03af\u03ad"+
		"\u0001\u0000\u0000\u0000\u03b0\u03b3\u0001\u0000\u0000\u0000\u03b1\u03af"+
		"\u0001\u0000\u0000\u0000\u03b1\u03b2\u0001\u0000\u0000\u0000\u03b2y\u0001"+
		"\u0000\u0000\u0000\u03b3\u03b1\u0001\u0000\u0000\u0000\u03b4\u03b8\u0003"+
		"\u01a4\u00d2\u0000\u03b5\u03b8\u0005\u0003\u0000\u0000\u03b6\u03b8\u0003"+
		"\u00a4R\u0000\u03b7\u03b4\u0001\u0000\u0000\u0000\u03b7\u03b5\u0001\u0000"+
		"\u0000\u0000\u03b7\u03b6\u0001\u0000\u0000\u0000\u03b8{\u0001\u0000\u0000"+
		"\u0000\u03b9\u03ba\u0005k\u0000\u0000\u03ba\u03bb\u0003\u009cN\u0000\u03bb"+
		"}\u0001\u0000\u0000\u0000\u03bc\u03bd\u0005\u00a4\u0000\u0000\u03bd\u03be"+
		"\u00058\u0000\u0000\u03be\u03c3\u0003\u0082A\u0000\u03bf\u03c0\u0005\u0016"+
		"\u0000\u0000\u03c0\u03c2\u0003\u0082A\u0000\u03c1\u03bf\u0001\u0000\u0000"+
		"\u0000\u03c2\u03c5\u0001\u0000\u0000\u0000\u03c3\u03c1\u0001\u0000\u0000"+
		"\u0000\u03c3\u03c4\u0001\u0000\u0000\u0000\u03c4\u007f\u0001\u0000\u0000"+
		"\u0000\u03c5\u03c3\u0001\u0000\u0000\u0000\u03c6\u03cb\u0003\u0082A\u0000"+
		"\u03c7\u03c8\u0005\u0016\u0000\u0000\u03c8\u03ca\u0003\u0082A\u0000\u03c9"+
		"\u03c7\u0001\u0000\u0000\u0000\u03ca\u03cd\u0001\u0000\u0000\u0000\u03cb"+
		"\u03c9\u0001\u0000\u0000\u0000\u03cb\u03cc\u0001\u0000\u0000\u0000\u03cc"+
		"\u0081\u0001\u0000\u0000\u0000\u03cd\u03cb\u0001\u0000\u0000\u0000\u03ce"+
		"\u03d0\u0003\u0086C\u0000\u03cf\u03d1\u0003\u0088D\u0000\u03d0\u03cf\u0001"+
		"\u0000\u0000\u0000\u03d0\u03d1\u0001\u0000\u0000\u0000\u03d1\u03d3\u0001"+
		"\u0000\u0000\u0000\u03d2\u03d4\u0003\u0084B\u0000\u03d3\u03d2\u0001\u0000"+
		"\u0000\u0000\u03d3\u03d4\u0001\u0000\u0000\u0000\u03d4\u0083\u0001\u0000"+
		"\u0000\u0000\u03d5\u03d6\u0005\u009c\u0000\u0000\u03d6\u03d7\u0007\u0003"+
		"\u0000\u0000\u03d7\u0085\u0001\u0000\u0000\u0000\u03d8\u03dc\u0003\u01a4"+
		"\u00d2\u0000\u03d9\u03dc\u0005\u0003\u0000\u0000\u03da\u03dc\u0003\u00a4"+
		"R\u0000\u03db\u03d8\u0001\u0000\u0000\u0000\u03db\u03d9\u0001\u0000\u0000"+
		"\u0000\u03db\u03da\u0001\u0000\u0000\u0000\u03dc\u0087\u0001\u0000\u0000"+
		"\u0000\u03dd\u03de\u0007\u0004\u0000\u0000\u03de\u0089\u0001\u0000\u0000"+
		"\u0000\u03df\u03e0\u0005;\u0000\u0000\u03e0\u03e1\u0005\u0018\u0000\u0000"+
		"\u03e1\u03e2\u0003\u00a4R\u0000\u03e2\u03e3\u00052\u0000\u0000\u03e3\u03e4"+
		"\u0003\u008cF\u0000\u03e4\u03e5\u0005\u0019\u0000\u0000\u03e5\u008b\u0001"+
		"\u0000\u0000\u0000\u03e6\u03e7\u0003b1\u0000\u03e7\u008d\u0001\u0000\u0000"+
		"\u0000\u03e8\u03e9\u0005\u0082\u0000\u0000\u03e9\u03ea\u0003\u0096K\u0000"+
		"\u03ea\u008f\u0001\u0000\u0000\u0000\u03eb\u03ec\u0005\u009f\u0000\u0000"+
		"\u03ec\u03ee\u0003\u0096K\u0000\u03ed\u03ef\u0007\u0005\u0000\u0000\u03ee"+
		"\u03ed\u0001\u0000\u0000\u0000\u03ee\u03ef\u0001\u0000\u0000\u0000\u03ef"+
		"\u0091\u0001\u0000\u0000\u0000\u03f0\u03f1\u0005`\u0000\u0000\u03f1\u03f2"+
		"\u0007\u0006\u0000\u0000\u03f2\u03f3\u0003\u0094J\u0000\u03f3\u03f7\u0007"+
		"\u0005\u0000\u0000\u03f4\u03f8\u0005\u00a2\u0000\u0000\u03f5\u03f6\u0005"+
		"\u00d5\u0000\u0000\u03f6\u03f8\u0005\u00c0\u0000\u0000\u03f7\u03f4\u0001"+
		"\u0000\u0000\u0000\u03f7\u03f5\u0001\u0000\u0000\u0000\u03f8\u0093\u0001"+
		"\u0000\u0000\u0000\u03f9\u03fe\u0003\u0096K\u0000\u03fa\u03fb\u0003\u0098"+
		"L\u0000\u03fb\u03fc\u0005\u00ac\u0000\u0000\u03fc\u03fe\u0001\u0000\u0000"+
		"\u0000\u03fd\u03f9\u0001\u0000\u0000\u0000\u03fd\u03fa\u0001\u0000\u0000"+
		"\u0000\u03fe\u0095\u0001\u0000\u0000\u0000\u03ff\u0402\u0003\u0116\u008b"+
		"\u0000\u0400\u0402\u0005\u0003\u0000\u0000\u0401\u03ff\u0001\u0000\u0000"+
		"\u0000\u0401\u0400\u0001\u0000\u0000\u0000\u0402\u0097\u0001\u0000\u0000"+
		"\u0000\u0403\u0409\u0003\u0116\u008b\u0000\u0404\u0409\u0005\u0003\u0000"+
		"\u0000\u0405\u0409\u0005\u0004\u0000\u0000\u0406\u0409\u0005\u0005\u0000"+
		"\u0000\u0407\u0409\u0005\u0006\u0000\u0000\u0408\u0403\u0001\u0000\u0000"+
		"\u0000\u0408\u0404\u0001\u0000\u0000\u0000\u0408\u0405\u0001\u0000\u0000"+
		"\u0000\u0408\u0406\u0001\u0000\u0000\u0000\u0408\u0407\u0001\u0000\u0000"+
		"\u0000\u0409\u0099\u0001\u0000\u0000\u0000\u040a\u040b\u0005\u00d4\u0000"+
		"\u0000\u040b\u040c\u0003\u009cN\u0000\u040c\u009b\u0001\u0000\u0000\u0000"+
		"\u040d\u040e\u0006N\uffff\uffff\u0000\u040e\u040f\u0005\u0018\u0000\u0000"+
		"\u040f\u0410\u0003\u009cN\u0000\u0410\u0411\u0005\u0019\u0000\u0000\u0411"+
		"\u047f\u0001\u0000\u0000\u0000\u0412\u0413\u0003\u00a4R\u0000\u0413\u0415"+
		"\u0005y\u0000\u0000\u0414\u0416\u0005\u009a\u0000\u0000\u0415\u0414\u0001"+
		"\u0000\u0000\u0000\u0415\u0416\u0001\u0000\u0000\u0000\u0416\u0417\u0001"+
		"\u0000\u0000\u0000\u0417\u0418\u0005\u00dc\u0000\u0000\u0418\u047f\u0001"+
		"\u0000\u0000\u0000\u0419\u041a\u0003\u00a4R\u0000\u041a\u041c\u0005y\u0000"+
		"\u0000\u041b\u041d\u0005\u009a\u0000\u0000\u041c\u041b\u0001\u0000\u0000"+
		"\u0000\u041c\u041d\u0001\u0000\u0000\u0000\u041d\u041e\u0001\u0000\u0000"+
		"\u0000\u041e\u041f\u0005U\u0000\u0000\u041f\u047f\u0001\u0000\u0000\u0000"+
		"\u0420\u0421\u0003\u00a4R\u0000\u0421\u0423\u0005y\u0000\u0000\u0422\u0424"+
		"\u0005\u009a\u0000\u0000\u0423\u0422\u0001\u0000\u0000\u0000\u0423\u0424"+
		"\u0001\u0000\u0000\u0000\u0424\u0425\u0001\u0000\u0000\u0000\u0425\u0426"+
		"\u0005\u00da\u0000\u0000\u0426\u047f\u0001\u0000\u0000\u0000\u0427\u0428"+
		"\u0003\u00a4R\u0000\u0428\u042a\u0005y\u0000\u0000\u0429\u042b\u0005\u009a"+
		"\u0000\u0000\u042a\u0429\u0001\u0000\u0000\u0000\u042a\u042b\u0001\u0000"+
		"\u0000\u0000\u042b\u042c\u0001\u0000\u0000\u0000\u042c\u042d\u0005\u00db"+
		"\u0000\u0000\u042d\u047f\u0001\u0000\u0000\u0000\u042e\u042f\u0003\u00a4"+
		"R\u0000\u042f\u0431\u0005y\u0000\u0000\u0430\u0432\u0005\u009a\u0000\u0000"+
		"\u0431\u0430\u0001\u0000\u0000\u0000\u0431\u0432\u0001\u0000\u0000\u0000"+
		"\u0432\u0433\u0001\u0000\u0000\u0000\u0433\u0434\u0005P\u0000\u0000\u0434"+
		"\u0435\u0005f\u0000\u0000\u0435\u0436\u0003\u00a4R\u0000\u0436\u047f\u0001"+
		"\u0000\u0000\u0000\u0437\u0439\u0003\u00a4R\u0000\u0438\u043a\u0005\u009a"+
		"\u0000\u0000\u0439\u0438\u0001\u0000\u0000\u0000\u0439\u043a\u0001\u0000"+
		"\u0000\u0000\u043a\u043b\u0001\u0000\u0000\u0000\u043b\u043d\u0005\u008e"+
		"\u0000\u0000\u043c\u043e\u0005\u009e\u0000\u0000\u043d\u043c\u0001\u0000"+
		"\u0000\u0000\u043d\u043e\u0001\u0000\u0000\u0000\u043e\u043f\u0001\u0000"+
		"\u0000\u0000\u043f\u0440\u0003f3\u0000\u0440\u047f\u0001\u0000\u0000\u0000"+
		"\u0441\u0443\u0003\u00a4R\u0000\u0442\u0444\u0005\u009a\u0000\u0000\u0443"+
		"\u0442\u0001\u0000\u0000\u0000\u0443\u0444\u0001\u0000\u0000\u0000\u0444"+
		"\u0445\u0001\u0000\u0000\u0000\u0445\u0446\u0005o\u0000\u0000\u0446\u0447"+
		"\u0003\u00a0P\u0000\u0447\u047f\u0001\u0000\u0000\u0000\u0448\u044a\u0003"+
		"\u00a4R\u0000\u0449\u044b\u0005\u009a\u0000\u0000\u044a\u0449\u0001\u0000"+
		"\u0000\u0000\u044a\u044b\u0001\u0000\u0000\u0000\u044b\u044c\u0001\u0000"+
		"\u0000\u0000\u044c\u044d\u00055\u0000\u0000\u044d\u044e\u0003\u00a4R\u0000"+
		"\u044e\u044f\u00050\u0000\u0000\u044f\u0450\u0003\u00a4R\u0000\u0450\u047f"+
		"\u0001\u0000\u0000\u0000\u0451\u0453\u0003\u00a4R\u0000\u0452\u0454\u0005"+
		"\u009a\u0000\u0000\u0453\u0452\u0001\u0000\u0000\u0000\u0453\u0454\u0001"+
		"\u0000\u0000\u0000\u0454\u0455\u0001\u0000\u0000\u0000\u0455\u0456\u0007"+
		"\u0007\u0000\u0000\u0456\u0458\u0003\u00a4R\u0000\u0457\u0459\u0003\u00a2"+
		"Q\u0000\u0458\u0457\u0001\u0000\u0000\u0000\u0458\u0459\u0001\u0000\u0000"+
		"\u0000\u0459\u047f\u0001\u0000\u0000\u0000\u045a\u045c\u0003\u00a4R\u0000"+
		"\u045b\u045d\u0005\u009a\u0000\u0000\u045c\u045b\u0001\u0000\u0000\u0000"+
		"\u045c\u045d\u0001\u0000\u0000\u0000\u045d\u045e\u0001\u0000\u0000\u0000"+
		"\u045e\u045f\u0005?\u0000\u0000\u045f\u0460\u0003\u00a4R\u0000\u0460\u047f"+
		"\u0001\u0000\u0000\u0000\u0461\u0463\u0003\u00a4R\u0000\u0462\u0464\u0005"+
		"\u009a\u0000\u0000\u0463\u0462\u0001\u0000\u0000\u0000\u0463\u0464\u0001"+
		"\u0000\u0000\u0000\u0464\u0465\u0001\u0000\u0000\u0000\u0465\u0466\u0005"+
		"p\u0000\u0000\u0466\u0467\u0003\u00a4R\u0000\u0467\u047f\u0001\u0000\u0000"+
		"\u0000\u0468\u046a\u0003\u00a4R\u0000\u0469\u046b\u0005\u009a\u0000\u0000"+
		"\u046a\u0469\u0001\u0000\u0000\u0000\u046a\u046b\u0001\u0000\u0000\u0000"+
		"\u046b\u046c\u0001\u0000\u0000\u0000\u046c\u046d\u0005w\u0000\u0000\u046d"+
		"\u046e\u0003\u00a4R\u0000\u046e\u047f\u0001\u0000\u0000\u0000\u046f\u0470"+
		"\u0003\u00a4R\u0000\u0470\u0471\u0003\u009eO\u0000\u0471\u0472\u0003\u00a4"+
		"R\u0000\u0472\u047f\u0001\u0000\u0000\u0000\u0473\u0474\u0005^\u0000\u0000"+
		"\u0474\u0475\u0003\u00aaU\u0000\u0475\u0476\u0005\u0018\u0000\u0000\u0476"+
		"\u0477\u0003b1\u0000\u0477\u0478\u0005\u0019\u0000\u0000\u0478\u047f\u0001"+
		"\u0000\u0000\u0000\u0479\u047a\u0005^\u0000\u0000\u047a\u047f\u0003\u00a4"+
		"R\u0000\u047b\u047c\u0005\u009a\u0000\u0000\u047c\u047f\u0003\u009cN\u0004"+
		"\u047d\u047f\u0003\u00a4R\u0000\u047e\u040d\u0001\u0000\u0000\u0000\u047e"+
		"\u0412\u0001\u0000\u0000\u0000\u047e\u0419\u0001\u0000\u0000\u0000\u047e"+
		"\u0420\u0001\u0000\u0000\u0000\u047e\u0427\u0001\u0000\u0000\u0000\u047e"+
		"\u042e\u0001\u0000\u0000\u0000\u047e\u0437\u0001\u0000\u0000\u0000\u047e"+
		"\u0441\u0001\u0000\u0000\u0000\u047e\u0448\u0001\u0000\u0000\u0000\u047e"+
		"\u0451\u0001\u0000\u0000\u0000\u047e\u045a\u0001\u0000\u0000\u0000\u047e"+
		"\u0461\u0001\u0000\u0000\u0000\u047e\u0468\u0001\u0000\u0000\u0000\u047e"+
		"\u046f\u0001\u0000\u0000\u0000\u047e\u0473\u0001\u0000\u0000\u0000\u047e"+
		"\u0479\u0001\u0000\u0000\u0000\u047e\u047b\u0001\u0000\u0000\u0000\u047e"+
		"\u047d\u0001\u0000\u0000\u0000\u047f\u0488\u0001\u0000\u0000\u0000\u0480"+
		"\u0481\n\u0003\u0000\u0000\u0481\u0482\u00050\u0000\u0000\u0482\u0487"+
		"\u0003\u009cN\u0004\u0483\u0484\n\u0002\u0000\u0000\u0484\u0485\u0005"+
		"\u00a3\u0000\u0000\u0485\u0487\u0003\u009cN\u0003\u0486\u0480\u0001\u0000"+
		"\u0000\u0000\u0486\u0483\u0001\u0000\u0000\u0000\u0487\u048a\u0001\u0000"+
		"\u0000\u0000\u0488\u0486\u0001\u0000\u0000\u0000\u0488\u0489\u0001\u0000"+
		"\u0000\u0000\u0489\u009d\u0001\u0000\u0000\u0000\u048a\u0488\u0001\u0000"+
		"\u0000\u0000\u048b\u048c\u0007\b\u0000\u0000\u048c\u009f\u0001\u0000\u0000"+
		"\u0000\u048d\u048e\u0003\u00aaU\u0000\u048e\u048f\u0005\u0018\u0000\u0000"+
		"\u048f\u0490\u0003b1\u0000\u0490\u0491\u0005\u0019\u0000\u0000\u0491\u04a5"+
		"\u0001\u0000\u0000\u0000\u0492\u049b\u0005\u0018\u0000\u0000\u0493\u0498"+
		"\u0003\u00a8T\u0000\u0494\u0495\u0005\u0016\u0000\u0000\u0495\u0497\u0003"+
		"\u00a8T\u0000\u0496\u0494\u0001\u0000\u0000\u0000\u0497\u049a\u0001\u0000"+
		"\u0000\u0000\u0498\u0496\u0001\u0000\u0000\u0000\u0498\u0499\u0001\u0000"+
		"\u0000\u0000\u0499\u049c\u0001\u0000\u0000\u0000\u049a\u0498\u0001\u0000"+
		"\u0000\u0000\u049b\u0493\u0001\u0000\u0000\u0000\u049b\u049c\u0001\u0000"+
		"\u0000\u0000\u049c\u049d\u0001\u0000\u0000\u0000\u049d\u04a5\u0005\u0019"+
		"\u0000\u0000\u049e\u049f\u0005\u0018\u0000\u0000\u049f\u04a0\u0003\u0004"+
		"\u0002\u0000\u04a0\u04a1\u0005\u0019\u0000\u0000\u04a1\u04a5\u0001\u0000"+
		"\u0000\u0000\u04a2\u04a5\u0003\u0116\u008b\u0000\u04a3\u04a5\u0003\u00a4"+
		"R\u0000\u04a4\u048d\u0001\u0000\u0000\u0000\u04a4\u0492\u0001\u0000\u0000"+
		"\u0000\u04a4\u049e\u0001\u0000\u0000\u0000\u04a4\u04a2\u0001\u0000\u0000"+
		"\u0000\u04a4\u04a3\u0001\u0000\u0000\u0000\u04a5\u00a1\u0001\u0000\u0000"+
		"\u0000\u04a6\u04aa\u0005Z\u0000\u0000\u04a7\u04ab\u0005\n\u0000\u0000"+
		"\u04a8\u04ab\u0005\u000b\u0000\u0000\u04a9\u04ab\u0003\u0116\u008b\u0000"+
		"\u04aa\u04a7\u0001\u0000\u0000\u0000\u04aa\u04a8\u0001\u0000\u0000\u0000"+
		"\u04aa\u04a9\u0001\u0000\u0000\u0000\u04ab\u00a3\u0001\u0000\u0000\u0000"+
		"\u04ac\u04ad\u0006R\uffff\uffff\u0000\u04ad\u04ae\u0005\u0018\u0000\u0000"+
		"\u04ae\u04af\u0003\u00a4R\u0000\u04af\u04b0\u0005\u0019\u0000\u0000\u04b0"+
		"\u04c7\u0001\u0000\u0000\u0000\u04b1\u04b2\u0005\u0018\u0000\u0000\u04b2"+
		"\u04b5\u0003\u00a8T\u0000\u04b3\u04b4\u0005\u0016\u0000\u0000\u04b4\u04b6"+
		"\u0003\u00a8T\u0000\u04b5\u04b3\u0001\u0000\u0000\u0000\u04b6\u04b7\u0001"+
		"\u0000\u0000\u0000\u04b7\u04b5\u0001\u0000\u0000\u0000\u04b7\u04b8\u0001"+
		"\u0000\u0000\u0000\u04b8\u04b9\u0001\u0000\u0000\u0000\u04b9\u04ba\u0005"+
		"\u0019\u0000\u0000\u04ba\u04c7\u0001\u0000\u0000\u0000\u04bb\u04bc\u0005"+
		"\u0018\u0000\u0000\u04bc\u04bd\u0003\u0004\u0002\u0000\u04bd\u04be\u0005"+
		"\u0019\u0000\u0000\u04be\u04c7\u0001\u0000\u0000\u0000\u04bf\u04c7\u0003"+
		"\u00a6S\u0000\u04c0\u04c1\u0003\u00b8\\\u0000\u04c1\u04c2\u0003\u00d4"+
		"j\u0000\u04c2\u04c7\u0001\u0000\u0000\u0000\u04c3\u04c4\u0003\u00b8\\"+
		"\u0000\u04c4\u04c5\u0003\u00a4R\u0006\u04c5\u04c7\u0001\u0000\u0000\u0000"+
		"\u04c6\u04ac\u0001\u0000\u0000\u0000\u04c6\u04b1\u0001\u0000\u0000\u0000"+
		"\u04c6\u04bb\u0001\u0000\u0000\u0000\u04c6\u04bf\u0001\u0000\u0000\u0000"+
		"\u04c6\u04c0\u0001\u0000\u0000\u0000\u04c6\u04c3\u0001\u0000\u0000\u0000"+
		"\u04c7\u04da\u0001\u0000\u0000\u0000\u04c8\u04c9\n\u0003\u0000\u0000\u04c9"+
		"\u04ca\u0003\u00b4Z\u0000\u04ca\u04cb\u0003\u00a4R\u0004\u04cb\u04d9\u0001"+
		"\u0000\u0000\u0000\u04cc\u04cd\n\u0002\u0000\u0000\u04cd\u04ce\u0003\u00b6"+
		"[\u0000\u04ce\u04cf\u0003\u00a4R\u0003\u04cf\u04d9\u0001\u0000\u0000\u0000"+
		"\u04d0\u04d1\n\u0001\u0000\u0000\u04d1\u04d2\u0005\'\u0000\u0000\u04d2"+
		"\u04d9\u0003\u00a4R\u0002\u04d3\u04d4\n\u0005\u0000\u0000\u04d4\u04d9"+
		"\u0003\u018e\u00c7\u0000\u04d5\u04d6\n\u0004\u0000\u0000\u04d6\u04d7\u0005"+
		"8\u0000\u0000\u04d7\u04d9\u0003\u018e\u00c7\u0000\u04d8\u04c8\u0001\u0000"+
		"\u0000\u0000\u04d8\u04cc\u0001\u0000\u0000\u0000\u04d8\u04d0\u0001\u0000"+
		"\u0000\u0000\u04d8\u04d3\u0001\u0000\u0000\u0000\u04d8\u04d5\u0001\u0000"+
		"\u0000\u0000\u04d9\u04dc\u0001\u0000\u0000\u0000\u04da\u04d8\u0001\u0000"+
		"\u0000\u0000\u04da\u04db\u0001\u0000\u0000\u0000\u04db\u00a5\u0001\u0000"+
		"\u0000\u0000\u04dc\u04da\u0001\u0000\u0000\u0000\u04dd\u04eb\u0003\u00c4"+
		"b\u0000\u04de\u04eb\u0003\u00d0h\u0000\u04df\u04eb\u0003\u0116\u008b\u0000"+
		"\u04e0\u04eb\u0003\u00ba]\u0000\u04e1\u04eb\u0003\u00bc^\u0000\u04e2\u04eb"+
		"\u0003\u00be_\u0000\u04e3\u04eb\u0003\u00c0`\u0000\u04e4\u04e6\u0003j"+
		"5\u0000\u04e5\u04e7\u0003h4\u0000\u04e6\u04e5\u0001\u0000\u0000\u0000"+
		"\u04e6\u04e7\u0001\u0000\u0000\u0000\u04e7\u04eb\u0001\u0000\u0000\u0000"+
		"\u04e8\u04eb\u0003\u0118\u008c\u0000\u04e9\u04eb\u0003l6\u0000\u04ea\u04dd"+
		"\u0001\u0000\u0000\u0000\u04ea\u04de\u0001\u0000\u0000\u0000\u04ea\u04df"+
		"\u0001\u0000\u0000\u0000\u04ea\u04e0\u0001\u0000\u0000\u0000\u04ea\u04e1"+
		"\u0001\u0000\u0000\u0000\u04ea\u04e2\u0001\u0000\u0000\u0000\u04ea\u04e3"+
		"\u0001\u0000\u0000\u0000\u04ea\u04e4\u0001\u0000\u0000\u0000\u04ea\u04e8"+
		"\u0001\u0000\u0000\u0000\u04ea\u04e9\u0001\u0000\u0000\u0000\u04eb\u00a7"+
		"\u0001\u0000\u0000\u0000\u04ec\u04ef\u0003\u00a4R\u0000\u04ed\u04ef\u0003"+
		"\u009cN\u0000\u04ee\u04ec\u0001\u0000\u0000\u0000\u04ee\u04ed\u0001\u0000"+
		"\u0000\u0000\u04ef\u00a9\u0001\u0000\u0000\u0000\u04f0\u04f3\u0003\u00b0"+
		"X\u0000\u04f1\u04f3\u0003\u00b2Y\u0000\u04f2\u04f0\u0001\u0000\u0000\u0000"+
		"\u04f2\u04f1\u0001\u0000\u0000\u0000\u04f3\u00ab\u0001\u0000\u0000\u0000"+
		"\u04f4\u04f5\u0007\t\u0000\u0000\u04f5\u00ad\u0001\u0000\u0000\u0000\u04f6"+
		"\u04f7\u0007\n\u0000\u0000\u04f7\u00af\u0001\u0000\u0000\u0000\u04f8\u04f9"+
		"\u0007\u000b\u0000\u0000\u04f9\u00b1\u0001\u0000\u0000\u0000\u04fa\u04fb"+
		"\u0007\f\u0000\u0000\u04fb\u00b3\u0001\u0000\u0000\u0000\u04fc\u04fd\u0007"+
		"\r\u0000\u0000\u04fd\u00b5\u0001\u0000\u0000\u0000\u04fe\u04ff\u0007\u000e"+
		"\u0000\u0000\u04ff\u00b7\u0001\u0000\u0000\u0000\u0500\u0501\u0007\u000e"+
		"\u0000\u0000\u0501\u00b9\u0001\u0000\u0000\u0000\u0502\u0503\u0005\u00cb"+
		"\u0000\u0000\u0503\u0506\u0005\u0018\u0000\u0000\u0504\u0507\u0003f3\u0000"+
		"\u0505\u0507\u0003\u0116\u008b\u0000\u0506\u0504\u0001\u0000\u0000\u0000"+
		"\u0506\u0505\u0001\u0000\u0000\u0000\u0507\u0508\u0001\u0000\u0000\u0000"+
		"\u0508\u0509\u0005\u0019\u0000\u0000\u0509\u00bb\u0001\u0000\u0000\u0000"+
		"\u050a\u050b\u0005*\u0000\u0000\u050b\u050c\u0005\u0018\u0000\u0000\u050c"+
		"\u050d\u0003f3\u0000\u050d\u050f\u0005\u0019\u0000\u0000\u050e\u0510\u0003"+
		"h4\u0000\u050f\u050e\u0001\u0000\u0000\u0000\u050f\u0510\u0001\u0000\u0000"+
		"\u0000\u0510\u00bd\u0001\u0000\u0000\u0000\u0511\u0512\u0005+\u0000\u0000"+
		"\u0512\u0513\u0005\u0018\u0000\u0000\u0513\u0514\u0003f3\u0000\u0514\u0515"+
		"\u0005\u0019\u0000\u0000\u0515\u00bf\u0001\u0000\u0000\u0000\u0516\u0517"+
		"\u0005-\u0000\u0000\u0517\u0518\u0005\u0018\u0000\u0000\u0518\u0519\u0003"+
		"f3\u0000\u0519\u051b\u0005\u0019\u0000\u0000\u051a\u051c\u0003h4\u0000"+
		"\u051b\u051a\u0001\u0000\u0000\u0000\u051b\u051c\u0001\u0000\u0000\u0000"+
		"\u051c\u00c1\u0001\u0000\u0000\u0000\u051d\u051e\u0005.\u0000\u0000\u051e"+
		"\u051f\u0005\u0018\u0000\u0000\u051f\u0520\u0003f3\u0000\u0520\u0521\u0005"+
		"\u0019\u0000\u0000\u0521\u00c3\u0001\u0000\u0000\u0000\u0522\u0525\u0003"+
		"\u00c6c\u0000\u0523\u0525\u0003\u00ccf\u0000\u0524\u0522\u0001\u0000\u0000"+
		"\u0000\u0524\u0523\u0001\u0000\u0000\u0000\u0525\u00c5\u0001\u0000\u0000"+
		"\u0000\u0526\u0527\u00059\u0000\u0000\u0527\u0529\u0003\u00a8T\u0000\u0528"+
		"\u052a\u0003\u00c8d\u0000\u0529\u0528\u0001\u0000\u0000\u0000\u052a\u052b"+
		"\u0001\u0000\u0000\u0000\u052b\u0529\u0001\u0000\u0000\u0000\u052b\u052c"+
		"\u0001\u0000\u0000\u0000\u052c\u052e\u0001\u0000\u0000\u0000\u052d\u052f"+
		"\u0003\u00cae\u0000\u052e\u052d\u0001\u0000\u0000\u0000\u052e\u052f\u0001"+
		"\u0000\u0000\u0000\u052f\u0530\u0001\u0000\u0000\u0000\u0530\u0531\u0005"+
		"V\u0000\u0000\u0531\u00c7\u0001\u0000\u0000\u0000\u0532\u0533\u0005\u00d3"+
		"\u0000\u0000\u0533\u0534\u0003\u00a4R\u0000\u0534\u0535\u0005\u00bf\u0000"+
		"\u0000\u0535\u0536\u0003\u00a8T\u0000\u0536\u00c9\u0001\u0000\u0000\u0000"+
		"\u0537\u0538\u0005T\u0000\u0000\u0538\u0539\u0003\u00a8T\u0000\u0539\u00cb"+
		"\u0001\u0000\u0000\u0000\u053a\u053c\u00059\u0000\u0000\u053b\u053d\u0003"+
		"\u00ceg\u0000\u053c\u053b\u0001\u0000\u0000\u0000\u053d\u053e\u0001\u0000"+
		"\u0000\u0000\u053e\u053c\u0001\u0000\u0000\u0000\u053e\u053f\u0001\u0000"+
		"\u0000\u0000\u053f\u0541\u0001\u0000\u0000\u0000\u0540\u0542\u0003\u00ca"+
		"e\u0000\u0541\u0540\u0001\u0000\u0000\u0000\u0541\u0542\u0001\u0000\u0000"+
		"\u0000\u0542\u0543\u0001\u0000\u0000\u0000\u0543\u0544\u0005V\u0000\u0000"+
		"\u0544\u00cd\u0001\u0000\u0000\u0000\u0545\u0546\u0005\u00d3\u0000\u0000"+
		"\u0546\u0547\u0003\u009cN\u0000\u0547\u0548\u0005\u00bf\u0000\u0000\u0548"+
		"\u0549\u0003\u00a8T\u0000\u0549\u00cf\u0001\u0000\u0000\u0000\u054a\u0554"+
		"\u0005\n\u0000\u0000\u054b\u0554\u0005\u000b\u0000\u0000\u054c\u0554\u0005"+
		"\u00dc\u0000\u0000\u054d\u0554\u0003\u00d2i\u0000\u054e\u0554\u0003\u00d4"+
		"j\u0000\u054f\u0554\u0003\u00d6k\u0000\u0550\u0554\u0003\u00d8l\u0000"+
		"\u0551\u0554\u0003\u010e\u0087\u0000\u0552\u0554\u0003\u0110\u0088\u0000"+
		"\u0553\u054a\u0001\u0000\u0000\u0000\u0553\u054b\u0001\u0000\u0000\u0000"+
		"\u0553\u054c\u0001\u0000\u0000\u0000\u0553\u054d\u0001\u0000\u0000\u0000"+
		"\u0553\u054e\u0001\u0000\u0000\u0000\u0553\u054f\u0001\u0000\u0000\u0000"+
		"\u0553\u0550\u0001\u0000\u0000\u0000\u0553\u0551\u0001\u0000\u0000\u0000"+
		"\u0553\u0552\u0001\u0000\u0000\u0000\u0554\u00d1\u0001\u0000\u0000\u0000"+
		"\u0555\u0556\u0007\u000f\u0000\u0000\u0556\u00d3\u0001\u0000\u0000\u0000"+
		"\u0557\u0558\u0007\u0010\u0000\u0000\u0558\u00d5\u0001\u0000\u0000\u0000"+
		"\u0559\u0565\u0005\f\u0000\u0000\u055a\u055b\u0005\u001c\u0000\u0000\u055b"+
		"\u0560\u0005\t\u0000\u0000\u055c\u055d\u0005\u0016\u0000\u0000\u055d\u055f"+
		"\u0005\t\u0000\u0000\u055e\u055c\u0001\u0000\u0000\u0000\u055f\u0562\u0001"+
		"\u0000\u0000\u0000\u0560\u055e\u0001\u0000\u0000\u0000\u0560\u0561\u0001"+
		"\u0000\u0000\u0000\u0561\u0563\u0001\u0000\u0000\u0000\u0562\u0560\u0001"+
		"\u0000\u0000\u0000\u0563\u0565\u0005\u001d\u0000\u0000\u0564\u0559\u0001"+
		"\u0000\u0000\u0000\u0564\u055a\u0001\u0000\u0000\u0000\u0565\u00d7\u0001"+
		"\u0000\u0000\u0000\u0566\u056d\u0003\u00dam\u0000\u0567\u056d\u0003\u00e2"+
		"q\u0000\u0568\u056d\u0003\u00e4r\u0000\u0569\u056d\u0003\u0106\u0083\u0000"+
		"\u056a\u056d\u0003\u0108\u0084\u0000\u056b\u056d\u0003\u010a\u0085\u0000"+
		"\u056c\u0566\u0001\u0000\u0000\u0000\u056c\u0567\u0001\u0000\u0000\u0000"+
		"\u056c\u0568\u0001\u0000\u0000\u0000\u056c\u0569\u0001\u0000\u0000\u0000"+
		"\u056c\u056a\u0001\u0000\u0000\u0000\u056c\u056b\u0001\u0000\u0000\u0000"+
		"\u056d\u00d9\u0001\u0000\u0000\u0000\u056e\u0572\u0003\u00dcn\u0000\u056f"+
		"\u0572\u0003\u00deo\u0000\u0570\u0572\u0003\u00e0p\u0000\u0571\u056e\u0001"+
		"\u0000\u0000\u0000\u0571\u056f\u0001\u0000\u0000\u0000\u0571\u0570\u0001"+
		"\u0000\u0000\u0000\u0572\u00db\u0001\u0000\u0000\u0000\u0573\u0574\u0005"+
		"\u001c\u0000\u0000\u0574\u0575\u0003\u00e8t\u0000\u0575\u0576\u0005\u001d"+
		"\u0000\u0000\u0576\u057d\u0001\u0000\u0000\u0000\u0577\u0579\u0005\u0085"+
		"\u0000\u0000\u0578\u0577\u0001\u0000\u0000\u0000\u0578\u0579\u0001\u0000"+
		"\u0000\u0000\u0579\u057a\u0001\u0000\u0000\u0000\u057a\u057b\u0005J\u0000"+
		"\u0000\u057b\u057d\u0003\u00e8t\u0000\u057c\u0573\u0001\u0000\u0000\u0000"+
		"\u057c\u0578\u0001\u0000\u0000\u0000\u057d\u00dd\u0001\u0000\u0000\u0000"+
		"\u057e\u057f\u0005\u001c\u0000\u0000\u057f\u0580\u0003\u00eau\u0000\u0580"+
		"\u0581\u0005\u001d\u0000\u0000\u0581\u0588\u0001\u0000\u0000\u0000\u0582"+
		"\u0584\u0005\u00d9\u0000\u0000\u0583\u0582\u0001\u0000\u0000\u0000\u0583"+
		"\u0584\u0001\u0000\u0000\u0000\u0584\u0585\u0001\u0000\u0000\u0000\u0585"+
		"\u0586\u0005J\u0000\u0000\u0586\u0588\u0003\u00eau\u0000\u0587\u057e\u0001"+
		"\u0000\u0000\u0000\u0587\u0583\u0001\u0000\u0000\u0000\u0588\u00df\u0001"+
		"\u0000\u0000\u0000\u0589\u058a\u0005\u001c\u0000\u0000\u058a\u058b\u0003"+
		"\u00ecv\u0000\u058b\u058c\u0005\u001d\u0000\u0000\u058c\u0593\u0001\u0000"+
		"\u0000\u0000\u058d\u058f\u0005\u009f\u0000\u0000\u058e\u058d\u0001\u0000"+
		"\u0000\u0000\u058e\u058f\u0001\u0000\u0000\u0000\u058f\u0590\u0001\u0000"+
		"\u0000\u0000\u0590\u0591\u0005J\u0000\u0000\u0591\u0593\u0003\u00eew\u0000"+
		"\u0592\u0589\u0001\u0000\u0000\u0000\u0592\u058e\u0001\u0000\u0000\u0000"+
		"\u0593\u00e1\u0001\u0000\u0000\u0000\u0594\u0595\u0005\u001c\u0000\u0000"+
		"\u0595\u0596\u0003\u00f0x\u0000\u0596\u0597\u0005\u001d\u0000\u0000\u0597"+
		"\u059e\u0001\u0000\u0000\u0000\u0598\u059a\u0005\u0085\u0000\u0000\u0599"+
		"\u0598\u0001\u0000\u0000\u0000\u0599\u059a\u0001\u0000\u0000\u0000\u059a"+
		"\u059b\u0001\u0000\u0000\u0000\u059b\u059c\u0005I\u0000\u0000\u059c\u059e"+
		"\u0003\u00f0x\u0000\u059d\u0594\u0001\u0000\u0000\u0000\u059d\u0599\u0001"+
		"\u0000\u0000\u0000\u059e\u00e3\u0001\u0000\u0000\u0000\u059f\u05a0\u0005"+
		"\u001c\u0000\u0000\u05a0\u05a1\u0003\u00f2y\u0000\u05a1\u05a2\u0005\u001d"+
		"\u0000\u0000\u05a2\u05a9\u0001\u0000\u0000\u0000\u05a3\u05a5\u0005\u0085"+
		"\u0000\u0000\u05a4\u05a3\u0001\u0000\u0000\u0000\u05a4\u05a5\u0001\u0000"+
		"\u0000\u0000\u05a5\u05a6\u0001\u0000\u0000\u0000\u05a6\u05a7\u0005\u00c1"+
		"\u0000\u0000\u05a7\u05a9\u0003\u00f2y\u0000\u05a8\u059f\u0001\u0000\u0000"+
		"\u0000\u05a8\u05a4\u0001\u0000\u0000\u0000\u05a9\u00e5\u0001\u0000\u0000"+
		"\u0000\u05aa\u05ae\u0003\u00e8t\u0000\u05ab\u05ae\u0003\u00eau\u0000\u05ac"+
		"\u05ae\u0003\u00ecv\u0000\u05ad\u05aa\u0001\u0000\u0000\u0000\u05ad\u05ab"+
		"\u0001\u0000\u0000\u0000\u05ad\u05ac\u0001\u0000\u0000\u0000\u05ae\u00e7"+
		"\u0001\u0000\u0000\u0000\u05af\u05b0\u0003\u00f0x\u0000\u05b0\u05b1\u0003"+
		"\u00f2y\u0000\u05b1\u00e9\u0001\u0000\u0000\u0000\u05b2\u05b3\u0003\u00f0"+
		"x\u0000\u05b3\u05b4\u0003\u00f2y\u0000\u05b4\u05b5\u0003\u0104\u0082\u0000"+
		"\u05b5\u00eb\u0001\u0000\u0000\u0000\u05b6\u05b7\u0003\u00f0x\u0000\u05b7"+
		"\u05b8\u0003\u00f2y\u0000\u05b8\u05b9\u0003\u00f4z\u0000\u05b9\u00ed\u0001"+
		"\u0000\u0000\u0000\u05ba\u05bb\u0003\u00f0x\u0000\u05bb\u05bc\u0003\u00f2"+
		"y\u0000\u05bc\u05bd\u0003\u00f6{\u0000\u05bd\u00ef\u0001\u0000\u0000\u0000"+
		"\u05be\u05bf\u0003\u00f8|\u0000\u05bf\u05c0\u0005\u001f\u0000\u0000\u05c0"+
		"\u05c1\u0003\u00fa}\u0000\u05c1\u05c2\u0005\u001f\u0000\u0000\u05c2\u05c3"+
		"\u0003\u00fc~\u0000\u05c3\u00f1\u0001\u0000\u0000\u0000\u05c4\u05c5\u0003"+
		"\u00fe\u007f\u0000\u05c5\u05c6\u0005%\u0000\u0000\u05c6\u05c9\u0003\u0100"+
		"\u0080\u0000\u05c7\u05c8\u0005%\u0000\u0000\u05c8\u05ca\u0003\u0102\u0081"+
		"\u0000\u05c9\u05c7\u0001\u0000\u0000\u0000\u05c9\u05ca\u0001\u0000\u0000"+
		"\u0000\u05ca\u00f3\u0001\u0000\u0000\u0000\u05cb\u05cc\u0007\u000e\u0000"+
		"\u0000\u05cc\u05cf\u0003\u00fe\u007f\u0000\u05cd\u05ce\u0005%\u0000\u0000"+
		"\u05ce\u05d0\u0003\u0100\u0080\u0000\u05cf\u05cd\u0001\u0000\u0000\u0000"+
		"\u05cf\u05d0\u0001\u0000\u0000\u0000\u05d0\u00f5\u0001\u0000\u0000\u0000"+
		"\u05d1\u05d2\u0007\u000e\u0000\u0000\u05d2\u05d3\u0003\u00fe\u007f\u0000"+
		"\u05d3\u05d4\u0005%\u0000\u0000\u05d4\u05d5\u0003\u0100\u0080\u0000\u05d5"+
		"\u00f7\u0001\u0000\u0000\u0000\u05d6\u05d7\u0005\u0003\u0000\u0000\u05d7"+
		"\u00f9\u0001\u0000\u0000\u0000\u05d8\u05d9\u0005\u0003\u0000\u0000\u05d9"+
		"\u00fb\u0001\u0000\u0000\u0000\u05da\u05db\u0005\u0003\u0000\u0000\u05db"+
		"\u00fd\u0001\u0000\u0000\u0000\u05dc\u05dd\u0005\u0003\u0000\u0000\u05dd"+
		"\u00ff\u0001\u0000\u0000\u0000\u05de\u05df\u0005\u0003\u0000\u0000\u05df"+
		"\u0101\u0001\u0000\u0000\u0000\u05e0\u05e1\u0007\u0011\u0000\u0000\u05e1"+
		"\u0103\u0001\u0000\u0000\u0000\u05e2\u05e5\u0005\u00dd\u0000\u0000\u05e3"+
		"\u05e4\u0005!\u0000\u0000\u05e4\u05e6\u0005\u00dd\u0000\u0000\u05e5\u05e3"+
		"\u0001\u0000\u0000\u0000\u05e5\u05e6\u0001\u0000\u0000\u0000\u05e6\u05e9"+
		"\u0001\u0000\u0000\u0000\u05e7\u05e9\u0005\n\u0000\u0000\u05e8\u05e2\u0001"+
		"\u0000\u0000\u0000\u05e8\u05e7\u0001\u0000\u0000\u0000\u05e9\u0105\u0001"+
		"\u0000\u0000\u0000\u05ea\u05ed\u0005\r\u0000\u0000\u05eb\u05ee\u0003\u00e6"+
		"s\u0000\u05ec\u05ee\u0003\u010c\u0086\u0000\u05ed\u05eb\u0001\u0000\u0000"+
		"\u0000\u05ed\u05ec\u0001\u0000\u0000\u0000\u05ee\u05ef\u0001\u0000\u0000"+
		"\u0000\u05ef\u05f0\u0005\u001d\u0000\u0000\u05f0\u0107\u0001\u0000\u0000"+
		"\u0000\u05f1\u05f4\u0005\u000e\u0000\u0000\u05f2\u05f5\u0003\u00f0x\u0000"+
		"\u05f3\u05f5\u0003\u010c\u0086\u0000\u05f4\u05f2\u0001\u0000\u0000\u0000"+
		"\u05f4\u05f3\u0001\u0000\u0000\u0000\u05f5\u05f6\u0001\u0000\u0000\u0000"+
		"\u05f6\u05f7\u0005\u001d\u0000\u0000\u05f7\u0109\u0001\u0000\u0000\u0000"+
		"\u05f8\u05fb\u0005\u000f\u0000\u0000\u05f9\u05fc\u0003\u00f2y\u0000\u05fa"+
		"\u05fc\u0003\u010c\u0086\u0000\u05fb\u05f9\u0001\u0000\u0000\u0000\u05fb"+
		"\u05fa\u0001\u0000\u0000\u0000\u05fc\u05fd\u0001\u0000\u0000\u0000\u05fd"+
		"\u05fe\u0005\u001d\u0000\u0000\u05fe\u010b\u0001\u0000\u0000\u0000\u05ff"+
		"\u0600\u0005\n\u0000\u0000\u0600\u010d\u0001\u0000\u0000\u0000\u0601\u060a"+
		"\u0005\u001a\u0000\u0000\u0602\u0607\u0003\u00a4R\u0000\u0603\u0604\u0005"+
		"\u0016\u0000\u0000\u0604\u0606\u0003\u00a4R\u0000\u0605\u0603\u0001\u0000"+
		"\u0000\u0000\u0606\u0609\u0001\u0000\u0000\u0000\u0607\u0605\u0001\u0000"+
		"\u0000\u0000\u0607\u0608\u0001\u0000\u0000\u0000\u0608\u060b\u0001\u0000"+
		"\u0000\u0000\u0609\u0607\u0001\u0000\u0000\u0000\u060a\u0602\u0001\u0000"+
		"\u0000\u0000\u060a\u060b\u0001\u0000\u0000\u0000\u060b\u060c\u0001\u0000"+
		"\u0000\u0000\u060c\u060d\u0005\u001b\u0000\u0000\u060d\u010f\u0001\u0000"+
		"\u0000\u0000\u060e\u060f\u0005\u001c\u0000\u0000\u060f\u0610\u0003\u0112"+
		"\u0089\u0000\u0610\u0611\u0005%\u0000\u0000\u0611\u0612\u0003\u0114\u008a"+
		"\u0000\u0612\u0613\u0005\u001d\u0000\u0000\u0613\u0111\u0001\u0000\u0000"+
		"\u0000\u0614\u0615\u0005\n\u0000\u0000\u0615\u0113\u0001\u0000\u0000\u0000"+
		"\u0616\u0617\u0005\n\u0000\u0000\u0617\u0115\u0001\u0000\u0000\u0000\u0618"+
		"\u0619\u0005%\u0000\u0000\u0619\u061f\u0003\u01a4\u00d2\u0000\u061a\u061c"+
		"\u0005(\u0000\u0000\u061b\u061d\u0005\u0003\u0000\u0000\u061c\u061b\u0001"+
		"\u0000\u0000\u0000\u061c\u061d\u0001\u0000\u0000\u0000\u061d\u061f\u0001"+
		"\u0000\u0000\u0000\u061e\u0618\u0001\u0000\u0000\u0000\u061e\u061a\u0001"+
		"\u0000\u0000\u0000\u061f\u0117\u0001\u0000\u0000\u0000\u0620\u0629\u0003"+
		"\u014e\u00a7\u0000\u0621\u0629\u0003\u012c\u0096\u0000\u0622\u0629\u0003"+
		"\u0126\u0093\u0000\u0623\u0629\u0003\u0128\u0094\u0000\u0624\u0629\u0003"+
		"\u012a\u0095\u0000\u0625\u0629\u0003\u011a\u008d\u0000\u0626\u0629\u0003"+
		"\u011e\u008f\u0000\u0627\u0629\u0003\u0120\u0090\u0000\u0628\u0620\u0001"+
		"\u0000\u0000\u0000\u0628\u0621\u0001\u0000\u0000\u0000\u0628\u0622\u0001"+
		"\u0000\u0000\u0000\u0628\u0623\u0001\u0000\u0000\u0000\u0628\u0624\u0001"+
		"\u0000\u0000\u0000\u0628\u0625\u0001\u0000\u0000\u0000\u0628\u0626\u0001"+
		"\u0000\u0000\u0000\u0628\u0627\u0001\u0000\u0000\u0000\u0629\u0119\u0001"+
		"\u0000\u0000\u0000\u062a\u062b\u0005h\u0000\u0000\u062b\u062c\u0005\u0018"+
		"\u0000\u0000\u062c\u062f\u0003\u011c\u008e\u0000\u062d\u062e\u00052\u0000"+
		"\u0000\u062e\u0630\u0003\u0152\u00a9\u0000\u062f\u062d\u0001\u0000\u0000"+
		"\u0000\u062f\u0630\u0001\u0000\u0000\u0000\u0630\u0633\u0001\u0000\u0000"+
		"\u0000\u0631\u0632\u0005\u0016\u0000\u0000\u0632\u0634\u0003\u0124\u0092"+
		"\u0000\u0633\u0631\u0001\u0000\u0000\u0000\u0633\u0634\u0001\u0000\u0000"+
		"\u0000\u0634\u0635\u0001\u0000\u0000\u0000\u0635\u0636\u0005\u0019\u0000"+
		"\u0000\u0636\u011b\u0001\u0000\u0000\u0000\u0637\u063a\u0005\n\u0000\u0000"+
		"\u0638\u063a\u0003\u01a4\u00d2\u0000\u0639\u0637\u0001\u0000\u0000\u0000"+
		"\u0639\u0638\u0001\u0000\u0000\u0000\u063a\u011d\u0001\u0000\u0000\u0000"+
		"\u063b\u063c\u0005<\u0000\u0000\u063c\u063d\u0005\u0018\u0000\u0000\u063d"+
		"\u063e\u0003f3\u0000\u063e\u063f\u0005\u0017\u0000\u0000\u063f\u0642\u0003"+
		"\u011c\u008e\u0000\u0640\u0641\u00052\u0000\u0000\u0641\u0643\u0003\u0152"+
		"\u00a9\u0000\u0642\u0640\u0001\u0000\u0000\u0000\u0642\u0643\u0001\u0000"+
		"\u0000\u0000\u0643\u0644\u0001\u0000\u0000\u0000\u0644\u0645\u0005\u0019"+
		"\u0000\u0000\u0645\u011f\u0001\u0000\u0000\u0000\u0646\u0647\u0003\u0122"+
		"\u0091\u0000\u0647\u064a\u0005\u0018\u0000\u0000\u0648\u064b\u0003\u0124"+
		"\u0092\u0000\u0649\u064b\u0005 \u0000\u0000\u064a\u0648\u0001\u0000\u0000"+
		"\u0000\u064a\u0649\u0001\u0000\u0000\u0000\u064a\u064b\u0001\u0000\u0000"+
		"\u0000\u064b\u064c\u0001\u0000\u0000\u0000\u064c\u064e\u0005\u0019\u0000"+
		"\u0000\u064d\u064f\u0003\u0140\u00a0\u0000\u064e\u064d\u0001\u0000\u0000"+
		"\u0000\u064e\u064f\u0001\u0000\u0000\u0000\u064f\u0651\u0001\u0000\u0000"+
		"\u0000\u0650\u0652\u0003\u013e\u009f\u0000\u0651\u0650\u0001\u0000\u0000"+
		"\u0000\u0651\u0652\u0001\u0000\u0000\u0000\u0652\u0654\u0001\u0000\u0000"+
		"\u0000\u0653\u0655\u0003\u013a\u009d\u0000\u0654\u0653\u0001\u0000\u0000"+
		"\u0000\u0654\u0655\u0001\u0000\u0000\u0000\u0655\u0657\u0001\u0000\u0000"+
		"\u0000\u0656\u0658\u0003\u013c\u009e\u0000\u0657\u0656\u0001\u0000\u0000"+
		"\u0000\u0657\u0658\u0001\u0000\u0000\u0000\u0658\u065a\u0001\u0000\u0000"+
		"\u0000\u0659\u065b\u0003\u0142\u00a1\u0000\u065a\u0659\u0001\u0000\u0000"+
		"\u0000\u065a\u065b\u0001\u0000\u0000\u0000\u065b\u0121\u0001\u0000\u0000"+
		"\u0000\u065c\u065d\u0003b1\u0000\u065d\u0123\u0001\u0000\u0000\u0000\u065e"+
		"\u0663\u0005P\u0000\u0000\u065f\u0660\u0003\u018e\u00c7\u0000\u0660\u0661"+
		"\u0005\u0016\u0000\u0000\u0661\u0663\u0001\u0000\u0000\u0000\u0662\u065e"+
		"\u0001\u0000\u0000\u0000\u0662\u065f\u0001\u0000\u0000\u0000\u0662\u0663"+
		"\u0001\u0000\u0000\u0000\u0663\u0664\u0001\u0000\u0000\u0000\u0664\u0669"+
		"\u0003\u00a8T\u0000\u0665\u0666\u0005\u0016\u0000\u0000\u0666\u0668\u0003"+
		"\u00a8T\u0000\u0667\u0665\u0001\u0000\u0000\u0000\u0668\u066b\u0001\u0000"+
		"\u0000\u0000\u0669\u0667\u0001\u0000\u0000\u0000\u0669\u066a\u0001\u0000"+
		"\u0000\u0000\u066a\u0125\u0001\u0000\u0000\u0000\u066b\u0669\u0001\u0000"+
		"\u0000\u0000\u066c\u066d\u0005\u00bb\u0000\u0000\u066d\u066e\u0005\u0018"+
		"\u0000\u0000\u066e\u066f\u0003f3\u0000\u066f\u0670\u0005\u0019\u0000\u0000"+
		"\u0670\u0127\u0001\u0000\u0000\u0000\u0671\u0672\u0007\u0012\u0000\u0000"+
		"\u0672\u0673\u0005\u0018\u0000\u0000\u0673\u0674\u0003\u00b0X\u0000\u0674"+
		"\u0675\u0005\u0018\u0000\u0000\u0675\u0676\u0003f3\u0000\u0676\u0677\u0005"+
		"\u0019\u0000\u0000\u0677\u0678\u0005\u0019\u0000\u0000\u0678\u068c\u0001"+
		"\u0000\u0000\u0000\u0679\u067a\u0007\u0012\u0000\u0000\u067a\u067b\u0005"+
		"\u0018\u0000\u0000\u067b\u067c\u0003\u00b2Y\u0000\u067c\u067d\u0005\u0018"+
		"\u0000\u0000\u067d\u067e\u0003f3\u0000\u067e\u067f\u0005\u0019\u0000\u0000"+
		"\u067f\u0680\u0005\u0019\u0000\u0000\u0680\u068c\u0001\u0000\u0000\u0000"+
		"\u0681\u0682\u0007\u0013\u0000\u0000\u0682\u0683\u0005\u0018\u0000\u0000"+
		"\u0683\u0684\u0003f3\u0000\u0684\u0685\u0005\u0019\u0000\u0000\u0685\u068c"+
		"\u0001\u0000\u0000\u0000\u0686\u0687\u0007\u0014\u0000\u0000\u0687\u0688"+
		"\u0005\u0018\u0000\u0000\u0688\u0689\u0003f3\u0000\u0689\u068a\u0005\u0019"+
		"\u0000\u0000\u068a\u068c\u0001\u0000\u0000\u0000\u068b\u0671\u0001\u0000"+
		"\u0000\u0000\u068b\u0679\u0001\u0000\u0000\u0000\u068b\u0681\u0001\u0000"+
		"\u0000\u0000\u068b\u0686\u0001\u0000\u0000\u0000\u068c\u0129\u0001\u0000"+
		"\u0000\u0000\u068d\u068e\u0003\u00b0X\u0000\u068e\u068f\u0005\u0018\u0000"+
		"\u0000\u068f\u0690\u0003f3\u0000\u0690\u0691\u0005\u0019\u0000\u0000\u0691"+
		"\u0698\u0001\u0000\u0000\u0000\u0692\u0693\u0003\u00b2Y\u0000\u0693\u0694"+
		"\u0005\u0018\u0000\u0000\u0694\u0695\u0003f3\u0000\u0695\u0696\u0005\u0019"+
		"\u0000\u0000\u0696\u0698\u0001\u0000\u0000\u0000\u0697\u068d\u0001\u0000"+
		"\u0000\u0000\u0697\u0692\u0001\u0000\u0000\u0000\u0698\u012b\u0001\u0000"+
		"\u0000\u0000\u0699\u069d\u0003\u012e\u0097\u0000\u069a\u069d\u0003\u0130"+
		"\u0098\u0000\u069b\u069d\u0003\u0136\u009b\u0000\u069c\u0699\u0001\u0000"+
		"\u0000\u0000\u069c\u069a\u0001\u0000\u0000\u0000\u069c\u069b\u0001\u0000"+
		"\u0000\u0000\u069d\u012d\u0001\u0000\u0000\u0000\u069e\u069f\u0003\u0132"+
		"\u0099\u0000\u069f\u06a0\u0005\u0018\u0000\u0000\u06a0\u06a1\u0003\u009c"+
		"N\u0000\u06a1\u06a3\u0005\u0019\u0000\u0000\u06a2\u06a4\u0003\u013c\u009e"+
		"\u0000\u06a3\u06a2\u0001\u0000\u0000\u0000\u06a3\u06a4\u0001\u0000\u0000"+
		"\u0000\u06a4\u06a6\u0001\u0000\u0000\u0000\u06a5\u06a7\u0003\u0142\u00a1"+
		"\u0000\u06a6\u06a5\u0001\u0000\u0000\u0000\u06a6\u06a7\u0001\u0000\u0000"+
		"\u0000\u06a7\u06b4\u0001\u0000\u0000\u0000\u06a8\u06a9\u0003\u0132\u0099"+
		"\u0000\u06a9\u06aa\u0005\u0018\u0000\u0000\u06aa\u06ab\u0003\u0004\u0002"+
		"\u0000\u06ab\u06ac\u0005\u0019\u0000\u0000\u06ac\u06b4\u0001\u0000\u0000"+
		"\u0000\u06ad\u06ae\u0003\u0132\u0099\u0000\u06ae\u06af\u0003\u00aaU\u0000"+
		"\u06af\u06b0\u0005\u0018\u0000\u0000\u06b0\u06b1\u0003b1\u0000\u06b1\u06b2"+
		"\u0005\u0019\u0000\u0000\u06b2\u06b4\u0001\u0000\u0000\u0000\u06b3\u069e"+
		"\u0001\u0000\u0000\u0000\u06b3\u06a8\u0001\u0000\u0000\u0000\u06b3\u06ad"+
		"\u0001\u0000\u0000\u0000\u06b4\u012f\u0001\u0000\u0000\u0000\u06b5\u06b6"+
		"\u0003\u0134\u009a\u0000\u06b6\u06b7\u0005\u0018\u0000\u0000\u06b7\u06b8"+
		"\u0003\u009cN\u0000\u06b8\u06ba\u0005\u0019\u0000\u0000\u06b9\u06bb\u0003"+
		"\u013c\u009e\u0000\u06ba\u06b9\u0001\u0000\u0000\u0000\u06ba\u06bb\u0001"+
		"\u0000\u0000\u0000\u06bb\u06bd\u0001\u0000\u0000\u0000\u06bc\u06be\u0003"+
		"\u0142\u00a1\u0000\u06bd\u06bc\u0001\u0000\u0000\u0000\u06bd\u06be\u0001"+
		"\u0000\u0000\u0000\u06be\u06cb\u0001\u0000\u0000\u0000\u06bf\u06c0\u0003"+
		"\u0134\u009a\u0000\u06c0\u06c1\u0005\u0018\u0000\u0000\u06c1\u06c2\u0003"+
		"\u0004\u0002\u0000\u06c2\u06c3\u0005\u0019\u0000\u0000\u06c3\u06cb\u0001"+
		"\u0000\u0000\u0000\u06c4\u06c5\u0003\u0134\u009a\u0000\u06c5\u06c6\u0003"+
		"\u00aaU\u0000\u06c6\u06c7\u0005\u0018\u0000\u0000\u06c7\u06c8\u0003b1"+
		"\u0000\u06c8\u06c9\u0005\u0019\u0000\u0000\u06c9\u06cb\u0001\u0000\u0000"+
		"\u0000\u06ca\u06b5\u0001\u0000\u0000\u0000\u06ca\u06bf\u0001\u0000\u0000"+
		"\u0000\u06ca\u06c4\u0001\u0000\u0000\u0000\u06cb\u0131\u0001\u0000\u0000"+
		"\u0000\u06cc\u06cd\u0007\u0015\u0000\u0000\u06cd\u0133\u0001\u0000\u0000"+
		"\u0000\u06ce\u06cf\u0007\u0016\u0000\u0000\u06cf\u0135\u0001\u0000\u0000"+
		"\u0000\u06d0\u06d1\u0005\u0084\u0000\u0000\u06d1\u06d3\u0005\u0018\u0000"+
		"\u0000\u06d2\u06d4\u0005P\u0000\u0000\u06d3\u06d2\u0001\u0000\u0000\u0000"+
		"\u06d3\u06d4\u0001\u0000\u0000\u0000\u06d4\u06d5\u0001\u0000\u0000\u0000"+
		"\u06d5\u06d6\u0003\u00a8T\u0000\u06d6\u06d7\u0005\u0016\u0000\u0000\u06d7"+
		"\u06d9\u0003\u00a8T\u0000\u06d8\u06da\u0003\u0138\u009c\u0000\u06d9\u06d8"+
		"\u0001\u0000\u0000\u0000\u06d9\u06da\u0001\u0000\u0000\u0000\u06da\u06db"+
		"\u0001\u0000\u0000\u0000\u06db\u06dd\u0005\u0019\u0000\u0000\u06dc\u06de"+
		"\u0003\u013a\u009d\u0000\u06dd\u06dc\u0001\u0000\u0000\u0000\u06dd\u06de"+
		"\u0001\u0000\u0000\u0000\u06de\u06e0\u0001\u0000\u0000\u0000\u06df\u06e1"+
		"\u0003\u013c\u009e\u0000\u06e0\u06df\u0001\u0000\u0000\u0000\u06e0\u06e1"+
		"\u0001\u0000\u0000\u0000\u06e1\u06e3\u0001\u0000\u0000\u0000\u06e2\u06e4"+
		"\u0003\u0142\u00a1\u0000\u06e3\u06e2\u0001\u0000\u0000\u0000\u06e3\u06e4"+
		"\u0001\u0000\u0000\u0000\u06e4\u0137\u0001\u0000\u0000\u0000\u06e5\u06e6"+
		"\u0005\u00a1\u0000\u0000\u06e6\u06ee\u0005\u00a8\u0000\u0000\u06e7\u06ef"+
		"\u0005Y\u0000\u0000\u06e8\u06ea\u0005\u00ca\u0000\u0000\u06e9\u06eb\u0003"+
		"\u00a4R\u0000\u06ea\u06e9\u0001\u0000\u0000\u0000\u06ea\u06eb\u0001\u0000"+
		"\u0000\u0000\u06eb\u06ec\u0001\u0000\u0000\u0000\u06ec\u06ed\u0007\u0017"+
		"\u0000\u0000\u06ed\u06ef\u0005@\u0000\u0000\u06ee\u06e7\u0001\u0000\u0000"+
		"\u0000\u06ee\u06e8\u0001\u0000\u0000\u0000\u06ef\u0139\u0001\u0000\u0000"+
		"\u0000\u06f0\u06f1\u0005\u00d6\u0000\u0000\u06f1\u06f2\u0005i\u0000\u0000"+
		"\u06f2\u06f3\u0005\u0018\u0000\u0000\u06f3\u06f4\u0003~?\u0000\u06f4\u06f5"+
		"\u0005\u0019\u0000\u0000\u06f5\u013b\u0001\u0000\u0000\u0000\u06f6\u06f7"+
		"\u0005a\u0000\u0000\u06f7\u06f8\u0005\u0018\u0000\u0000\u06f8\u06f9\u0003"+
		"\u009aM\u0000\u06f9\u06fa\u0005\u0019\u0000\u0000\u06fa\u013d\u0001\u0000"+
		"\u0000\u0000\u06fb\u06fc\u0005\u00b2\u0000\u0000\u06fc\u0700\u0005\u009c"+
		"\u0000\u0000\u06fd\u06fe\u0005m\u0000\u0000\u06fe\u0700\u0005\u009c\u0000"+
		"\u0000\u06ff\u06fb\u0001\u0000\u0000\u0000\u06ff\u06fd\u0001\u0000\u0000"+
		"\u0000\u0700\u013f\u0001\u0000\u0000\u0000\u0701\u0702\u0005f\u0000\u0000"+
		"\u0702\u0706\u0005b\u0000\u0000\u0703\u0704\u0005f\u0000\u0000\u0704\u0706"+
		"\u0005}\u0000\u0000\u0705\u0701\u0001\u0000\u0000\u0000\u0705\u0703\u0001"+
		"\u0000\u0000\u0000\u0706\u0141\u0001\u0000\u0000\u0000\u0707\u0708\u0005"+
		"\u00a7\u0000\u0000\u0708\u070a\u0005\u0018\u0000\u0000\u0709\u070b\u0003"+
		"\u0144\u00a2\u0000\u070a\u0709\u0001\u0000\u0000\u0000\u070a\u070b\u0001"+
		"\u0000\u0000\u0000\u070b\u070d\u0001\u0000\u0000\u0000\u070c\u070e\u0003"+
		"~?\u0000\u070d\u070c\u0001\u0000\u0000\u0000\u070d\u070e\u0001\u0000\u0000"+
		"\u0000\u070e\u0710\u0001\u0000\u0000\u0000\u070f\u0711\u0003\u0146\u00a3"+
		"\u0000\u0710\u070f\u0001\u0000\u0000\u0000\u0710\u0711\u0001\u0000\u0000"+
		"\u0000\u0711\u0712\u0001\u0000\u0000\u0000\u0712\u0713\u0005\u0019\u0000"+
		"\u0000\u0713\u0143\u0001\u0000\u0000\u0000\u0714\u0715\u0005\u00ab\u0000"+
		"\u0000\u0715\u0716\u00058\u0000\u0000\u0716\u071b\u0003\u00a4R\u0000\u0717"+
		"\u0718\u0005\u0016\u0000\u0000\u0718\u071a\u0003\u00a4R\u0000\u0719\u0717"+
		"\u0001\u0000\u0000\u0000\u071a\u071d\u0001\u0000\u0000\u0000\u071b\u0719"+
		"\u0001\u0000\u0000\u0000\u071b\u071c\u0001\u0000\u0000\u0000\u071c\u0145"+
		"\u0001\u0000\u0000\u0000\u071d\u071b\u0001\u0000\u0000\u0000\u071e\u071f"+
		"\u0007\u0018\u0000\u0000\u071f\u0721\u0003\u0148\u00a4\u0000\u0720\u0722"+
		"\u0003\u014c\u00a6\u0000\u0721\u0720\u0001\u0000\u0000\u0000\u0721\u0722"+
		"\u0001\u0000\u0000\u0000\u0722\u072c\u0001\u0000\u0000\u0000\u0723\u0724"+
		"\u0007\u0018\u0000\u0000\u0724\u0725\u00055\u0000\u0000\u0725\u0726\u0003"+
		"\u0148\u00a4\u0000\u0726\u0727\u00050\u0000\u0000\u0727\u0729\u0003\u014a"+
		"\u00a5\u0000\u0728\u072a\u0003\u014c\u00a6\u0000\u0729\u0728\u0001\u0000"+
		"\u0000\u0000\u0729\u072a\u0001\u0000\u0000\u0000\u072a\u072c\u0001\u0000"+
		"\u0000\u0000\u072b\u071e\u0001\u0000\u0000\u0000\u072b\u0723\u0001\u0000"+
		"\u0000\u0000\u072c\u0147\u0001\u0000\u0000\u0000\u072d\u072e\u0005C\u0000"+
		"\u0000\u072e\u0738\u0005\u00b5\u0000\u0000\u072f\u0730\u0005\u00cc\u0000"+
		"\u0000\u0730\u0738\u0005\u00af\u0000\u0000\u0731\u0732\u0003\u00a4R\u0000"+
		"\u0732\u0733\u0005\u00af\u0000\u0000\u0733\u0738\u0001\u0000\u0000\u0000"+
		"\u0734\u0735\u0003\u00a4R\u0000\u0735\u0736\u0005c\u0000\u0000\u0736\u0738"+
		"\u0001\u0000\u0000\u0000\u0737\u072d\u0001\u0000\u0000\u0000\u0737\u072f"+
		"\u0001\u0000\u0000\u0000\u0737\u0731\u0001\u0000\u0000\u0000\u0737\u0734"+
		"\u0001\u0000\u0000\u0000\u0738\u0149\u0001\u0000\u0000\u0000\u0739\u073a"+
		"\u0005C\u0000\u0000\u073a\u0744\u0005\u00b5\u0000\u0000\u073b\u073c\u0005"+
		"\u00cc\u0000\u0000\u073c\u0744\u0005c\u0000\u0000\u073d\u073e\u0003\u00a4"+
		"R\u0000\u073e\u073f\u0005\u00af\u0000\u0000\u073f\u0744\u0001\u0000\u0000"+
		"\u0000\u0740\u0741\u0003\u00a4R\u0000\u0741\u0742\u0005c\u0000\u0000\u0742"+
		"\u0744\u0001\u0000\u0000\u0000\u0743\u0739\u0001\u0000\u0000\u0000\u0743"+
		"\u073b\u0001\u0000\u0000\u0000\u0743\u073d\u0001\u0000\u0000\u0000\u0743"+
		"\u0740\u0001\u0000\u0000\u0000\u0744\u014b\u0001\u0000\u0000\u0000\u0745"+
		"\u0746\u0005]\u0000\u0000\u0746\u0747\u0005C\u0000\u0000\u0747\u0750\u0005"+
		"\u00b5\u0000\u0000\u0748\u0749\u0005]\u0000\u0000\u0749\u0750\u0005i\u0000"+
		"\u0000\u074a\u074b\u0005]\u0000\u0000\u074b\u0750\u0005\u00c0\u0000\u0000"+
		"\u074c\u074d\u0005]\u0000\u0000\u074d\u074e\u0005\u0099\u0000\u0000\u074e"+
		"\u0750\u0005\u00a5\u0000\u0000\u074f\u0745\u0001\u0000\u0000\u0000\u074f"+
		"\u0748\u0001\u0000\u0000\u0000\u074f\u074a\u0001\u0000\u0000\u0000\u074f"+
		"\u074c\u0001\u0000\u0000\u0000\u0750\u014d\u0001\u0000\u0000\u0000\u0751"+
		"\u0766\u0003\u0150\u00a8\u0000\u0752\u0766\u0003\u0188\u00c4\u0000\u0753"+
		"\u0766\u0003\u018a\u00c5\u0000\u0754\u0766\u0003\u0184\u00c2\u0000\u0755"+
		"\u0766\u0003\u008aE\u0000\u0756\u0766\u0003\u0156\u00ab\u0000\u0757\u0766"+
		"\u0003\u016a\u00b5\u0000\u0758\u0766\u0003\u015c\u00ae\u0000\u0759\u0766"+
		"\u0003\u0162\u00b1\u0000\u075a\u0766\u0003\u0198\u00cc\u0000\u075b\u0766"+
		"\u0003\u0174\u00ba\u0000\u075c\u0766\u0003\u0176\u00bb\u0000\u075d\u0766"+
		"\u0003\u0178\u00bc\u0000\u075e\u0766\u0003\u017a\u00bd\u0000\u075f\u0766"+
		"\u0003\u0180\u00c0\u0000\u0760\u0766\u0003\u0182\u00c1\u0000\u0761\u0766"+
		"\u0003\u017c\u00be\u0000\u0762\u0766\u0003\u017e\u00bf\u0000\u0763\u0766"+
		"\u0003\u019e\u00cf\u0000\u0764\u0766\u0003\u01a0\u00d0\u0000\u0765\u0751"+
		"\u0001\u0000\u0000\u0000\u0765\u0752\u0001\u0000\u0000\u0000\u0765\u0753"+
		"\u0001\u0000\u0000\u0000\u0765\u0754\u0001\u0000\u0000\u0000\u0765\u0755"+
		"\u0001\u0000\u0000\u0000\u0765\u0756\u0001\u0000\u0000\u0000\u0765\u0757"+
		"\u0001\u0000\u0000\u0000\u0765\u0758\u0001\u0000\u0000\u0000\u0765\u0759"+
		"\u0001\u0000\u0000\u0000\u0765\u075a\u0001\u0000\u0000\u0000\u0765\u075b"+
		"\u0001\u0000\u0000\u0000\u0765\u075c\u0001\u0000\u0000\u0000\u0765\u075d"+
		"\u0001\u0000\u0000\u0000\u0765\u075e\u0001\u0000\u0000\u0000\u0765\u075f"+
		"\u0001\u0000\u0000\u0000\u0765\u0760\u0001\u0000\u0000\u0000\u0765\u0761"+
		"\u0001\u0000\u0000\u0000\u0765\u0762\u0001\u0000\u0000\u0000\u0765\u0763"+
		"\u0001\u0000\u0000\u0000\u0765\u0764\u0001\u0000\u0000\u0000\u0766\u014f"+
		"\u0001\u0000\u0000\u0000\u0767\u0768\u0005:\u0000\u0000\u0768\u0769\u0005"+
		"\u0018\u0000\u0000\u0769\u076a\u0003\u00a4R\u0000\u076a\u076b\u00052\u0000"+
		"\u0000\u076b\u076c\u0003\u0152\u00a9\u0000\u076c\u076d\u0005\u0019\u0000"+
		"\u0000\u076d\u0151\u0001\u0000\u0000\u0000\u076e\u0776\u0003\u0154\u00aa"+
		"\u0000\u076f\u0770\u0005\u0018\u0000\u0000\u0770\u0773\u0005\u0003\u0000"+
		"\u0000\u0771\u0772\u0005\u0016\u0000\u0000\u0772\u0774\u0005\u0003\u0000"+
		"\u0000\u0773\u0771\u0001\u0000\u0000\u0000\u0773\u0774\u0001\u0000\u0000"+
		"\u0000\u0774\u0775\u0001\u0000\u0000\u0000\u0775\u0777\u0005\u0019\u0000"+
		"\u0000\u0776\u076f\u0001\u0000\u0000\u0000\u0776\u0777\u0001\u0000\u0000"+
		"\u0000\u0777\u0153\u0001\u0000\u0000\u0000\u0778\u0779\u0003\u01a4\u00d2"+
		"\u0000\u0779\u077a\u0006\u00aa\uffff\uffff\u0000\u077a\u0781\u0001\u0000"+
		"\u0000\u0000\u077b\u077c\u0005\u0017\u0000\u0000\u077c\u077d\u0003\u01a4"+
		"\u00d2\u0000\u077d\u077e\u0006\u00aa\uffff\uffff\u0000\u077e\u0780\u0001"+
		"\u0000\u0000\u0000\u077f\u077b\u0001\u0000\u0000\u0000\u0780\u0783\u0001"+
		"\u0000\u0000\u0000\u0781\u077f\u0001\u0000\u0000\u0000\u0781\u0782\u0001"+
		"\u0000\u0000\u0000\u0782\u0155\u0001\u0000\u0000\u0000\u0783\u0781\u0001"+
		"\u0000\u0000\u0000\u0784\u0785\u0005\u00bd\u0000\u0000\u0785\u0786\u0005"+
		"\u0018\u0000\u0000\u0786\u0787\u0003\u00a4R\u0000\u0787\u0788\u0005\u0016"+
		"\u0000\u0000\u0788\u078b\u0003\u0158\u00ac\u0000\u0789\u078a\u0005\u0016"+
		"\u0000\u0000\u078a\u078c\u0003\u015a\u00ad\u0000\u078b\u0789\u0001\u0000"+
		"\u0000\u0000\u078b\u078c\u0001\u0000\u0000\u0000\u078c\u078d\u0001\u0000"+
		"\u0000\u0000\u078d\u078e\u0005\u0019\u0000\u0000\u078e\u079b\u0001\u0000"+
		"\u0000\u0000\u078f\u0790\u0005\u00bd\u0000\u0000\u0790\u0791\u0005\u0018"+
		"\u0000\u0000\u0791\u0792\u0003\u00a4R\u0000\u0792\u0793\u0005f\u0000\u0000"+
		"\u0793\u0796\u0003\u0158\u00ac\u0000\u0794\u0795\u0005d\u0000\u0000\u0795"+
		"\u0797\u0003\u015a\u00ad\u0000\u0796\u0794\u0001\u0000\u0000\u0000\u0796"+
		"\u0797\u0001\u0000\u0000\u0000\u0797\u0798\u0001\u0000\u0000\u0000\u0798"+
		"\u0799\u0005\u0019\u0000\u0000\u0799\u079b\u0001\u0000\u0000\u0000\u079a"+
		"\u0784\u0001\u0000\u0000\u0000\u079a\u078f\u0001\u0000\u0000\u0000\u079b"+
		"\u0157\u0001\u0000\u0000\u0000\u079c\u079d\u0003\u00a4R\u0000\u079d\u0159"+
		"\u0001\u0000\u0000\u0000\u079e\u079f\u0003\u00a4R\u0000\u079f\u015b\u0001"+
		"\u0000\u0000\u0000\u07a0\u07a1\u0005\u00c8\u0000\u0000\u07a1\u07a3\u0005"+
		"\u0018\u0000\u0000\u07a2\u07a4\u0003\u015e\u00af\u0000\u07a3\u07a2\u0001"+
		"\u0000\u0000\u0000\u07a3\u07a4\u0001\u0000\u0000\u0000\u07a4\u07a6\u0001"+
		"\u0000\u0000\u0000\u07a5\u07a7\u0003\u0160\u00b0\u0000\u07a6\u07a5\u0001"+
		"\u0000\u0000\u0000\u07a6\u07a7\u0001\u0000\u0000\u0000\u07a7\u07a9\u0001"+
		"\u0000\u0000\u0000\u07a8\u07aa\u0005f\u0000\u0000\u07a9\u07a8\u0001\u0000"+
		"\u0000\u0000\u07a9\u07aa\u0001\u0000\u0000\u0000\u07aa\u07ab\u0001\u0000"+
		"\u0000\u0000\u07ab\u07ac\u0003\u00a4R\u0000\u07ac\u07ad\u0005\u0019\u0000"+
		"\u0000\u07ad\u015d\u0001\u0000\u0000\u0000\u07ae\u07af\u0007\u0019\u0000"+
		"\u0000\u07af\u015f\u0001\u0000\u0000\u0000\u07b0\u07b3\u0005\n\u0000\u0000"+
		"\u07b1\u07b3\u0003\u0116\u008b\u0000\u07b2\u07b0\u0001\u0000\u0000\u0000"+
		"\u07b2\u07b1\u0001\u0000\u0000\u0000\u07b3\u0161\u0001\u0000\u0000\u0000"+
		"\u07b4\u07b5\u0005\u00aa\u0000\u0000\u07b5\u07b6\u0005\u0018\u0000\u0000"+
		"\u07b6\u07b7\u0003\u00a4R\u0000\u07b7\u07b8\u0005\u00d5\u0000\u0000\u07b8"+
		"\u07b9\u0003\u0168\u00b4\u0000\u07b9\u07bb\u0003\u0164\u00b2\u0000\u07ba"+
		"\u07bc\u0003\u0166\u00b3\u0000\u07bb\u07ba\u0001\u0000\u0000\u0000\u07bb"+
		"\u07bc\u0001\u0000\u0000\u0000\u07bc\u07bd\u0001\u0000\u0000\u0000\u07bd"+
		"\u07be\u0005\u0019\u0000\u0000\u07be\u0163\u0001\u0000\u0000\u0000\u07bf"+
		"\u07c0\u0007\u001a\u0000\u0000\u07c0\u0165\u0001\u0000\u0000\u0000\u07c1"+
		"\u07c2\u0005\n\u0000\u0000\u07c2\u0167\u0001\u0000\u0000\u0000\u07c3\u07c4"+
		"\u0003\u00a4R\u0000\u07c4\u0169\u0001\u0000\u0000\u0000\u07c5\u07c6\u0005"+
		"\u00a9\u0000\u0000\u07c6\u07c7\u0005\u0018\u0000\u0000\u07c7\u07c8\u0003"+
		"\u016c\u00b6\u0000\u07c8\u07c9\u0005\u00ad\u0000\u0000\u07c9\u07ca\u0003"+
		"\u016e\u00b7\u0000\u07ca\u07cb\u0005f\u0000\u0000\u07cb\u07ce\u0003\u0170"+
		"\u00b8\u0000\u07cc\u07cd\u0005d\u0000\u0000\u07cd\u07cf\u0003\u0172\u00b9"+
		"\u0000\u07ce\u07cc\u0001\u0000\u0000\u0000\u07ce\u07cf\u0001\u0000\u0000"+
		"\u0000\u07cf\u07d0\u0001\u0000\u0000\u0000\u07d0\u07d1\u0005\u0019\u0000"+
		"\u0000\u07d1\u016b\u0001\u0000\u0000\u0000\u07d2\u07d3\u0003\u00a4R\u0000"+
		"\u07d3\u016d\u0001\u0000\u0000\u0000\u07d4\u07d5\u0003\u00a4R\u0000\u07d5"+
		"\u016f\u0001\u0000\u0000\u0000\u07d6\u07d7\u0003\u00a4R\u0000\u07d7\u0171"+
		"\u0001\u0000\u0000\u0000\u07d8\u07d9\u0003\u00a4R\u0000\u07d9\u0173\u0001"+
		"\u0000\u0000\u0000\u07da\u07dd\u0005D\u0000\u0000\u07db\u07dc\u0005\u0018"+
		"\u0000\u0000\u07dc\u07de\u0005\u0019\u0000\u0000\u07dd\u07db\u0001\u0000"+
		"\u0000\u0000\u07dd\u07de\u0001\u0000\u0000\u0000\u07de\u07e2\u0001\u0000"+
		"\u0000\u0000\u07df\u07e0\u0005C\u0000\u0000\u07e0\u07e2\u0005I\u0000\u0000"+
		"\u07e1\u07da\u0001\u0000\u0000\u0000\u07e1\u07df\u0001\u0000\u0000\u0000"+
		"\u07e2\u0175\u0001\u0000\u0000\u0000\u07e3\u07e6\u0005F\u0000\u0000\u07e4"+
		"\u07e5\u0005\u0018\u0000\u0000\u07e5\u07e7\u0005\u0019\u0000\u0000\u07e6"+
		"\u07e4\u0001\u0000\u0000\u0000\u07e6\u07e7\u0001\u0000\u0000\u0000\u07e7"+
		"\u07eb\u0001\u0000\u0000\u0000\u07e8\u07e9\u0005C\u0000\u0000\u07e9\u07eb"+
		"\u0005\u00c1\u0000\u0000\u07ea\u07e3\u0001\u0000\u0000\u0000\u07ea\u07e8"+
		"\u0001\u0000\u0000\u0000\u07eb\u0177\u0001\u0000\u0000\u0000\u07ec\u07ef"+
		"\u0005G\u0000\u0000\u07ed\u07ee\u0005\u0018\u0000\u0000\u07ee\u07f0\u0005"+
		"\u0019\u0000\u0000\u07ef\u07ed\u0001\u0000\u0000\u0000\u07ef\u07f0\u0001"+
		"\u0000\u0000\u0000\u07f0\u07f4\u0001\u0000\u0000\u0000\u07f1\u07f2\u0005"+
		"C\u0000\u0000\u07f2\u07f4\u0005\u00c2\u0000\u0000\u07f3\u07ec\u0001\u0000"+
		"\u0000\u0000\u07f3\u07f1\u0001\u0000\u0000\u0000\u07f4\u0179\u0001\u0000"+
		"\u0000\u0000\u07f5\u07f8\u0005E\u0000\u0000\u07f6\u07f7\u0005\u0018\u0000"+
		"\u0000\u07f7\u07f9\u0005\u0019\u0000\u0000\u07f8\u07f6\u0001\u0000\u0000"+
		"\u0000\u07f8\u07f9\u0001\u0000\u0000\u0000\u07f9\u07fc\u0001\u0000\u0000"+
		"\u0000\u07fa\u07fc\u0005u\u0000\u0000\u07fb\u07f5\u0001\u0000\u0000\u0000"+
		"\u07fb\u07fa\u0001\u0000\u0000\u0000\u07fc\u017b\u0001\u0000\u0000\u0000"+
		"\u07fd\u0800\u0005\u0087\u0000\u0000\u07fe\u07ff\u0005\u0018\u0000\u0000"+
		"\u07ff\u0801\u0005\u0019\u0000\u0000\u0800\u07fe\u0001\u0000\u0000\u0000"+
		"\u0800\u0801\u0001\u0000\u0000\u0000\u0801\u0805\u0001\u0000\u0000\u0000"+
		"\u0802\u0803\u0005\u0085\u0000\u0000\u0803\u0805\u0005J\u0000\u0000\u0804"+
		"\u07fd\u0001\u0000\u0000\u0000\u0804\u0802\u0001\u0000\u0000\u0000\u0805"+
		"\u017d\u0001\u0000\u0000\u0000\u0806\u0809\u0005\u00a0\u0000\u0000\u0807"+
		"\u0808\u0005\u0018\u0000\u0000\u0808\u080a\u0005\u0019\u0000\u0000\u0809"+
		"\u0807\u0001\u0000\u0000\u0000\u0809\u080a\u0001\u0000\u0000\u0000\u080a"+
		"\u080e\u0001\u0000\u0000\u0000\u080b\u080c\u0005\u009f\u0000\u0000\u080c"+
		"\u080e\u0005J\u0000\u0000\u080d\u0806\u0001\u0000\u0000\u0000\u080d\u080b"+
		"\u0001\u0000\u0000\u0000\u080e\u017f\u0001\u0000\u0000\u0000\u080f\u0812"+
		"\u0005\u0086\u0000\u0000\u0810\u0811\u0005\u0018\u0000\u0000\u0811\u0813"+
		"\u0005\u0019\u0000\u0000\u0812\u0810\u0001\u0000\u0000\u0000\u0812\u0813"+
		"\u0001\u0000\u0000\u0000\u0813\u0817\u0001\u0000\u0000\u0000\u0814\u0815"+
		"\u0005\u0085\u0000\u0000\u0815\u0817\u0005I\u0000\u0000\u0816\u080f\u0001"+
		"\u0000\u0000\u0000\u0816\u0814\u0001\u0000\u0000\u0000\u0817\u0181\u0001"+
		"\u0000\u0000\u0000\u0818\u081b\u0005\u0088\u0000\u0000\u0819\u081a\u0005"+
		"\u0018\u0000\u0000\u081a\u081c\u0005\u0019\u0000\u0000\u081b\u0819\u0001"+
		"\u0000\u0000\u0000\u081b\u081c\u0001\u0000\u0000\u0000\u081c\u0820\u0001"+
		"\u0000\u0000\u0000\u081d\u081e\u0005\u0085\u0000\u0000\u081e\u0820\u0005"+
		"\u00c1\u0000\u0000\u081f\u0818\u0001\u0000\u0000\u0000\u081f\u081d\u0001"+
		"\u0000\u0000\u0000\u0820\u0183\u0001\u0000\u0000\u0000\u0821\u0822\u0005"+
		"e\u0000\u0000\u0822\u0823\u0005\u0018\u0000\u0000\u0823\u0824\u0003\u00a4"+
		"R\u0000\u0824\u0825\u00052\u0000\u0000\u0825\u0826\u0003\u0186\u00c3\u0000"+
		"\u0826\u0827\u0005\u0019\u0000\u0000\u0827\u0185\u0001\u0000\u0000\u0000"+
		"\u0828\u0829\u0005\n\u0000\u0000\u0829\u0187\u0001\u0000\u0000\u0000\u082a"+
		"\u082b\u0005_\u0000\u0000\u082b\u082c\u0005\u0018\u0000\u0000\u082c\u082d"+
		"\u0003\u018c\u00c6\u0000\u082d\u082e\u0005f\u0000\u0000\u082e\u082f\u0003"+
		"\u00a4R\u0000\u082f\u0830\u0005\u0019\u0000\u0000\u0830\u0837\u0001\u0000"+
		"\u0000\u0000\u0831\u0832\u0003\u018e\u00c7\u0000\u0832\u0833\u0005\u0018"+
		"\u0000\u0000\u0833\u0834\u0003\u00a4R\u0000\u0834\u0835\u0005\u0019\u0000"+
		"\u0000\u0835\u0837\u0001\u0000\u0000\u0000\u0836\u082a\u0001\u0000\u0000"+
		"\u0000\u0836\u0831\u0001\u0000\u0000\u0000\u0837\u0189\u0001\u0000\u0000"+
		"\u0000\u0838\u0839\u0007\u001b\u0000\u0000\u0839\u083a\u0005\u0018\u0000"+
		"\u0000\u083a\u0840\u0003\u00a4R\u0000\u083b\u083e\u0005\u0016\u0000\u0000"+
		"\u083c\u083f\u0003\u018e\u00c7\u0000\u083d\u083f\u0003\u00a4R\u0000\u083e"+
		"\u083c\u0001\u0000\u0000\u0000\u083e\u083d\u0001\u0000\u0000\u0000\u083f"+
		"\u0841\u0001\u0000\u0000\u0000\u0840\u083b\u0001\u0000\u0000\u0000\u0840"+
		"\u0841\u0001\u0000\u0000\u0000\u0841\u0842\u0001\u0000\u0000\u0000\u0842"+
		"\u0843\u0005\u0019\u0000\u0000\u0843\u018b\u0001\u0000\u0000\u0000\u0844"+
		"\u084a\u0003\u018e\u00c7\u0000\u0845\u084a\u0003\u0190\u00c8\u0000\u0846"+
		"\u084a\u0003\u0192\u00c9\u0000\u0847\u084a\u0003\u0194\u00ca\u0000\u0848"+
		"\u084a\u0003\u0196\u00cb\u0000\u0849\u0844\u0001\u0000\u0000\u0000\u0849"+
		"\u0845\u0001\u0000\u0000\u0000\u0849\u0846\u0001\u0000\u0000\u0000\u0849"+
		"\u0847\u0001\u0000\u0000\u0000\u0849\u0848\u0001\u0000\u0000\u0000\u084a"+
		"\u018d\u0001\u0000\u0000\u0000\u084b\u084c\u0007\u001c\u0000\u0000\u084c"+
		"\u018f\u0001\u0000\u0000\u0000\u084d\u084e\u0005K\u0000\u0000\u084e\u084f"+
		"\u0005\u009e\u0000\u0000\u084f\u0857\u0005\u0095\u0000\u0000\u0850\u0851"+
		"\u0005K\u0000\u0000\u0851\u0852\u0005\u009e\u0000\u0000\u0852\u0857\u0005"+
		"\u00d2\u0000\u0000\u0853\u0854\u0005K\u0000\u0000\u0854\u0855\u0005\u009e"+
		"\u0000\u0000\u0855\u0857\u0005\u00d8\u0000\u0000\u0856\u084d\u0001\u0000"+
		"\u0000\u0000\u0856\u0850\u0001\u0000\u0000\u0000\u0856\u0853\u0001\u0000"+
		"\u0000\u0000\u0857\u0191\u0001\u0000\u0000\u0000\u0858\u0859\u0005\u00d2"+
		"\u0000\u0000\u0859\u085a\u0005\u009e\u0000\u0000\u085a\u085f\u0005\u0095"+
		"\u0000\u0000\u085b\u085c\u0005\u00d2\u0000\u0000\u085c\u085d\u0005\u009e"+
		"\u0000\u0000\u085d\u085f\u0005\u00d8\u0000\u0000\u085e\u0858\u0001\u0000"+
		"\u0000\u0000\u085e\u085b\u0001\u0000\u0000\u0000\u085f\u0193\u0001\u0000"+
		"\u0000\u0000\u0860\u0862\u0005\u009f\u0000\u0000\u0861\u0863\u0007\u001d"+
		"\u0000\u0000\u0862\u0861\u0001\u0000\u0000\u0000\u0862\u0863\u0001\u0000"+
		"\u0000\u0000\u0863\u0867\u0001\u0000\u0000\u0000\u0864\u0867\u0005\u00c3"+
		"\u0000\u0000\u0865\u0867\u0005\u00c4\u0000\u0000\u0866\u0860\u0001\u0000"+
		"\u0000\u0000\u0866\u0864\u0001\u0000\u0000\u0000\u0866\u0865\u0001\u0000"+
		"\u0000\u0000\u0867\u0195\u0001\u0000\u0000\u0000\u0868\u0869\u0007\u001e"+
		"\u0000\u0000\u0869\u0197\u0001\u0000\u0000\u0000\u086a\u086b\u0005\u00ae"+
		"\u0000\u0000\u086b\u086c\u0005\u0018\u0000\u0000\u086c\u086d\u0003\u019a"+
		"\u00cd\u0000\u086d\u086e\u0005o\u0000\u0000\u086e\u086f\u0003\u019c\u00ce"+
		"\u0000\u086f\u0870\u0005\u0019\u0000\u0000\u0870\u0199\u0001\u0000\u0000"+
		"\u0000\u0871\u0872\u0003\u00a4R\u0000\u0872\u019b\u0001\u0000\u0000\u0000"+
		"\u0873\u0874\u0003\u00a4R\u0000\u0874\u019d\u0001\u0000\u0000\u0000\u0875"+
		"\u0876\u0005B\u0000\u0000\u0876\u0877\u0005\u0018\u0000\u0000\u0877\u087c"+
		"\u0003\u00a8T\u0000\u0878\u0879\u0005\u0016\u0000\u0000\u0879\u087b\u0003"+
		"\u00a8T\u0000\u087a\u0878\u0001\u0000\u0000\u0000\u087b\u087e\u0001\u0000"+
		"\u0000\u0000\u087c\u087a\u0001\u0000\u0000\u0000\u087c\u087d\u0001\u0000"+
		"\u0000\u0000\u087d\u087f\u0001\u0000\u0000\u0000\u087e\u087c\u0001\u0000"+
		"\u0000\u0000\u087f\u0880\u0005\u0019\u0000\u0000\u0880\u019f\u0001\u0000"+
		"\u0000\u0000\u0881\u0882\u0005\u00b4\u0000\u0000\u0882\u0883\u0005\u0018"+
		"\u0000\u0000\u0883\u0888\u0003\u00a8T\u0000\u0884\u0885\u0005\u0016\u0000"+
		"\u0000\u0885\u0887\u0003\u00a8T\u0000\u0886\u0884\u0001\u0000\u0000\u0000"+
		"\u0887\u088a\u0001\u0000\u0000\u0000\u0888\u0886\u0001\u0000\u0000\u0000"+
		"\u0888\u0889\u0001\u0000\u0000\u0000\u0889\u088b\u0001\u0000\u0000\u0000"+
		"\u088a\u0888\u0001\u0000\u0000\u0000\u088b\u088c\u0005\u0019\u0000\u0000"+
		"\u088c\u01a1\u0001\u0000\u0000\u0000\u088d\u0892\u0005\u00dd\u0000\u0000"+
		"\u088e\u0892\u0005\u00de\u0000\u0000\u088f\u0890\u0007\u001f\u0000\u0000"+
		"\u0890\u0892\u0006\u00d1\uffff\uffff\u0000\u0891\u088d\u0001\u0000\u0000"+
		"\u0000\u0891\u088e\u0001\u0000\u0000\u0000\u0891\u088f\u0001\u0000\u0000"+
		"\u0000\u0892\u01a3\u0001\u0000\u0000\u0000\u0893\u0897\u0003\u01a2\u00d1"+
		"\u0000\u0894\u0895\u0007 \u0000\u0000\u0895\u0897\u0006\u00d2\uffff\uffff"+
		"\u0000\u0896\u0893\u0001\u0000\u0000\u0000\u0896\u0894\u0001\u0000\u0000"+
		"\u0000\u0897\u01a5\u0001\u0000\u0000\u0000\u00f8\u01aa\u01b4\u01b8\u01bc"+
		"\u01c0\u01c5\u01cd\u01d6\u01dc\u01df\u01e7\u01f2\u01fb\u0203\u0211\u0216"+
		"\u021c\u021e\u0226\u022c\u022f\u0235\u0238\u023f\u024f\u0254\u0257\u0262"+
		"\u0266\u0269\u026d\u0275\u0277\u027b\u0281\u0284\u0288\u028c\u0290\u0292"+
		"\u0296\u0299\u029c\u02a0\u02a3\u02a7\u02a9\u02ad\u02b1\u02b3\u02b6\u02b9"+
		"\u02c1\u02c8\u02ca\u02cf\u02d5\u02d7\u02de\u02e4\u02ea\u02f2\u02f7\u02fb"+
		"\u02fe\u0301\u0304\u0306\u030a\u030d\u0313\u0315\u031c\u0325\u032a\u0330"+
		"\u0340\u0347\u034c\u0350\u035b\u0363\u0366\u037b\u0380\u0384\u038b\u039a"+
		"\u03a1\u03a8\u03b1\u03b7\u03c3\u03cb\u03d0\u03d3\u03db\u03ee\u03f7\u03fd"+
		"\u0401\u0408\u0415\u041c\u0423\u042a\u0431\u0439\u043d\u0443\u044a\u0453"+
		"\u0458\u045c\u0463\u046a\u047e\u0486\u0488\u0498\u049b\u04a4\u04aa\u04b7"+
		"\u04c6\u04d8\u04da\u04e6\u04ea\u04ee\u04f2\u0506\u050f\u051b\u0524\u052b"+
		"\u052e\u053e\u0541\u0553\u0560\u0564\u056c\u0571\u0578\u057c\u0583\u0587"+
		"\u058e\u0592\u0599\u059d\u05a4\u05a8\u05ad\u05c9\u05cf\u05e5\u05e8\u05ed"+
		"\u05f4\u05fb\u0607\u060a\u061c\u061e\u0628\u062f\u0633\u0639\u0642\u064a"+
		"\u064e\u0651\u0654\u0657\u065a\u0662\u0669\u068b\u0697\u069c\u06a3\u06a6"+
		"\u06b3\u06ba\u06bd\u06ca\u06d3\u06d9\u06dd\u06e0\u06e3\u06ea\u06ee\u06ff"+
		"\u0705\u070a\u070d\u0710\u071b\u0721\u0729\u072b\u0737\u0743\u074f\u0765"+
		"\u0773\u0776\u0781\u078b\u0796\u079a\u07a3\u07a6\u07a9\u07b2\u07bb\u07ce"+
		"\u07dd\u07e1\u07e6\u07ea\u07ef\u07f3\u07f8\u07fb\u0800\u0804\u0809\u080d"+
		"\u0812\u0816\u081b\u081f\u0836\u083e\u0840\u0849\u0856\u085e\u0862\u0866"+
		"\u087c\u0888\u0891\u0896";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
