
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 See `@org.hibernate.annotations.TenantId`
 *             
 * 
 * <p>Java class for tenant-id complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="tenant-id">
 *   <complexContent>
 *     <extension base="{http://www.hibernate.org/xsd/orm/mapping}basic">
 *       <attribute name="bind-as-param" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "tenant-id", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbTenantId
    extends JaxbBasic
    implements Serializable
{

    @XmlAttribute(name = "bind-as-param")
    protected Boolean bindAsParam;

    /**
     * Gets the value of the bindAsParam property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBindAsParam() {
        if (bindAsParam == null) {
            return true;
        } else {
            return bindAsParam;
        }
    }

    /**
     * Sets the value of the bindAsParam property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setBindAsParam(Boolean value) {
        this.bindAsParam = value;
    }

}
