/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayRemoveIndexUnnestFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class H2ArrayRemoveIndexFunction
extends ArrayRemoveIndexUnnestFunction {
    private final int maximumArraySize;

    public H2ArrayRemoveIndexFunction(int maximumArraySize) {
        super(false);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then coalesce((select array_agg(array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx)) from system_range(1,");
        sqlAppender.append(Integer.toString(this.maximumArraySize));
        sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append("),0) and i.idx is distinct from ");
        indexExpression.accept(walker);
        sqlAppender.append("),array[]) end");
    }
}

