/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html.
 */
package org.hibernate.boot.spi;

import java.io.InputStream;

import org.hibernate.Incubating;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.mapping.Table;

/**
 * Collector for contributions from {@linkplain AdditionalMappingContributor contributors}
 *
 * @author Steve Ebersole
 *
 * @since 6.2
 */
@Incubating
public interface AdditionalMappingContributions {
	/**
	 * Contribute a presumably annotated entity class.
	 */
	void contributeEntity(Class<?> entityType);

	/**
	 * Contribute mappings from the InputStream containing an XML mapping document.
	 */
	void contributeBinding(InputStream xmlStream);

	/**
	 * Contribute mappings in the form of {@code hbm.xml} JAXB bindings.
	 *
	 * @deprecated {@code hbm.xml} mapping file support is deprecated.  Use
	 * {@linkplain #contributeBinding(JaxbEntityMappings) extended orm.xml}
	 * bindings instead.
	 */
	@Deprecated
	void contributeBinding(JaxbHbmHibernateMapping hbmJaxbBinding);

	/**
	 * Contribute mappings in the form of (extended) {@code orm.xml} JAXB bindings
	 */
	void contributeBinding(JaxbEntityMappings mappingJaxbBinding);

	/**
	 * Contribute a materialized Table
	 */
	void contributeTable(Table table);

	/**
	 * Contribute a materialized Sequence
	 */
	void contributeSequence(Sequence sequence);

	/**
	 * Contribute a materialized AuxiliaryDatabaseObject
	 */
	void contributeAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject);
}
