/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.QueryHintDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.procedure.internal.NamedCallableQueryMementoImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.query.results.ResultSetMapping;

public class NamedProcedureCallDefinitionImpl
implements NamedProcedureCallDefinition {
    private final String registeredName;
    private final String procedureName;
    private final Class<?>[] resultClasses;
    private final String[] resultSetMappings;
    private final ParameterDefinitions parameterDefinitions;
    private final Map<String, Object> hints;

    public NamedProcedureCallDefinitionImpl(AnnotationUsage<NamedStoredProcedureQuery> annotation) {
        boolean specifiesResultSetMappings;
        this.registeredName = annotation.getString("name");
        this.procedureName = annotation.getString("procedureName");
        this.hints = new QueryHintDefinition(this.registeredName, annotation.getList("hints")).getHintsMap();
        this.resultClasses = this.interpretResultClasses(annotation);
        this.resultSetMappings = this.interpretResultMappings(annotation);
        this.parameterDefinitions = new ParameterDefinitions(annotation.getList("parameters"));
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean bl = specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        if (specifiesResultClasses && specifiesResultSetMappings) {
            throw new MappingException(String.format("NamedStoredProcedureQuery [%s] specified both resultClasses and resultSetMappings", this.registeredName));
        }
    }

    private Class<?>[] interpretResultClasses(AnnotationUsage<NamedStoredProcedureQuery> annotation) {
        List resultClassDetails = annotation.getList("resultClasses");
        if (resultClassDetails == null) {
            return null;
        }
        Class[] resultClasses = new Class[resultClassDetails.size()];
        for (int i = 0; i < resultClassDetails.size(); ++i) {
            resultClasses[i] = ((ClassDetails)resultClassDetails.get(i)).toJavaClass();
        }
        return resultClasses;
    }

    private String[] interpretResultMappings(AnnotationUsage<NamedStoredProcedureQuery> annotation) {
        List list = annotation.getList("resultSetMappings");
        if (list == null) {
            return null;
        }
        String[] strings = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            strings[i] = (String)list.get(i);
        }
        return strings;
    }

    @Override
    public String getRegistrationName() {
        return this.registeredName;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public NamedCallableQueryMemento resolve(SessionFactoryImplementor sessionFactory) {
        HashSet<String> collectedQuerySpaces = new HashSet<String>();
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        ResultSetMapping resultSetMapping = this.buildResultSetMapping(this.registeredName, sessionFactory);
        if (specifiesResultClasses) {
            Util.resolveResultSetMappingClasses(this.resultClasses, resultSetMapping, collectedQuerySpaces::add, () -> sessionFactory);
        } else if (specifiesResultSetMappings) {
            Util.resolveResultSetMappingNames(this.resultSetMappings, resultSetMapping, collectedQuerySpaces::add, () -> sessionFactory);
        }
        return new NamedCallableQueryMementoImpl(this.getRegistrationName(), this.procedureName, this.parameterDefinitions.getParameterStrategy(), this.parameterDefinitions.toMementos(sessionFactory), this.resultSetMappings, this.resultClasses, collectedQuerySpaces, false, null, CacheMode.IGNORE, FlushMode.AUTO, false, null, null, null, this.hints);
    }

    private ResultSetMapping buildResultSetMapping(String registeredName, SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getFastSessionServices().getJdbcValuesMappingProducerProvider().buildResultSetMapping(registeredName, false, sessionFactory);
    }

    private static String normalize(String name) {
        return StringHelper.isNotEmpty(name) ? name : null;
    }

    static class ParameterDefinitions {
        private final ParameterStrategy parameterStrategy;
        private final ParameterDefinition<?>[] parameterDefinitions;

        ParameterDefinitions(List<AnnotationUsage<StoredProcedureParameter>> parameters) {
            if (CollectionHelper.isEmpty(parameters)) {
                this.parameterStrategy = ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[0];
            } else {
                AnnotationUsage<StoredProcedureParameter> parameterAnn = parameters.get(0);
                boolean firstParameterHasName = StringHelper.isNotEmpty((String)parameterAnn.findAttributeValue("name"));
                this.parameterStrategy = firstParameterHasName ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    this.parameterDefinitions[i] = new ParameterDefinition(i + 1, parameters.get(i));
                }
            }
        }

        public ParameterStrategy getParameterStrategy() {
            return this.parameterStrategy;
        }

        public List<NamedCallableQueryMemento.ParameterMemento> toMementos(SessionFactoryImplementor sessionFactory) {
            ArrayList<NamedCallableQueryMemento.ParameterMemento> mementos = new ArrayList<NamedCallableQueryMemento.ParameterMemento>();
            for (ParameterDefinition<?> definition : this.parameterDefinitions) {
                mementos.add(definition.toMemento(sessionFactory));
            }
            return mementos;
        }
    }

    static class ParameterDefinition<T> {
        private final Integer position;
        private final String name;
        private final ParameterMode parameterMode;
        private final Class<T> type;

        ParameterDefinition(int position, AnnotationUsage<StoredProcedureParameter> annotation) {
            this.position = position;
            this.name = NamedProcedureCallDefinitionImpl.normalize(annotation.getString("name"));
            this.parameterMode = (ParameterMode)annotation.getEnum("mode");
            this.type = annotation.getClassDetails("type").toJavaClass();
        }

        public NamedCallableQueryMemento.ParameterMemento toMemento(SessionFactoryImplementor sessionFactory) {
            return new NamedCallableQueryMementoImpl.ParameterMementoImpl<T>(this.position, this.name, this.parameterMode, this.type, sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(this.type));
        }
    }
}

