/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Struct;
import org.hibernate.boot.model.internal.AggregateComponentSecondPass;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public final class AggregateComponentBinder {
    private AggregateComponentBinder() {
    }

    public static void processAggregate(Component component, PropertyHolder propertyHolder, PropertyData inferredData, ClassDetails returnedClassOrElement, AnnotatedColumns columns, MetadataBuildingContext context) {
        if (AggregateComponentBinder.isAggregate(inferredData.getAttributeMember(), inferredData.getClassOrElementType(), context)) {
            AggregateComponentBinder.validateComponent(component, BinderHelper.getPath(propertyHolder, inferredData));
            InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
            TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
            String structName = AggregateComponentBinder.determineStructName(columns, inferredData, returnedClassOrElement);
            typeConfiguration.getJavaTypeRegistry().resolveDescriptor(component.getComponentClass(), () -> new EmbeddableAggregateJavaType(component.getComponentClass(), structName));
            component.setStructName(structName);
            component.setStructColumnNames(AggregateComponentBinder.determineStructAttributeNames(inferredData, returnedClassOrElement));
            BasicValueBinder basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, component, context);
            basicValueBinder.setPropertyName(inferredData.getPropertyName());
            basicValueBinder.setReturnedClassName(inferredData.getClassOrElementName());
            basicValueBinder.setColumns(columns);
            basicValueBinder.setPersistentClassName(propertyHolder.getClassName());
            basicValueBinder.setType(inferredData.getAttributeMember(), inferredData.getPropertyType(), inferredData.getDeclaringClass().getName(), null);
            BasicValue propertyValue = basicValueBinder.make();
            AggregateColumn aggregateColumn = (AggregateColumn)propertyValue.getColumn();
            aggregateColumn.setSqlType(structName);
            if (structName != null) {
                aggregateColumn.setSqlTypeCode(2002);
            }
            component.setAggregateColumn(aggregateColumn);
            context.getMetadataCollector().addSecondPass(new AggregateComponentSecondPass(propertyHolder, component, returnedClassOrElement, context));
        }
    }

    private static void validateComponent(Component component, String basePath) {
        for (Property property : component.getProperties()) {
            Component c;
            Value value = property.getValue();
            if (!(value instanceof BasicValue) && !(value instanceof Component)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' uses not yet supported mapping type '" + value.getClass().getName() + "' in component class '" + component.getComponentClassName() + "'. Aggregate components currently may only contain basic values and components of basic values.");
            }
            if (!(value instanceof Component) || (c = (Component)value).getAggregateColumn() != null) continue;
            AggregateComponentBinder.validateComponent(c, StringHelper.qualify(basePath, property.getName()));
        }
    }

    private static String determineStructName(AnnotatedColumns columns, PropertyData inferredData, ClassDetails returnedClassOrElement) {
        AnnotationUsage struct;
        MemberDetails property = inferredData.getAttributeMember();
        if (property != null) {
            List<AnnotatedColumn> columnList;
            Integer jdbcTypeCode;
            struct = property.getAnnotationUsage(Struct.class);
            if (struct != null) {
                return struct.getString("name");
            }
            AnnotationUsage jdbcTypeCodeAnn = property.getAnnotationUsage(JdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && columns != null && (jdbcTypeCode = jdbcTypeCodeAnn.getInteger("value")) == 2002 && (columnList = columns.getColumns()).size() == 1 && columnList.get(0).getSqlType() != null) {
                return columnList.get(0).getSqlType();
            }
        }
        if ((struct = returnedClassOrElement.getAnnotationUsage(Struct.class)) != null) {
            return struct.getString("name");
        }
        return null;
    }

    private static String[] determineStructAttributeNames(PropertyData inferredData, ClassDetails returnedClassOrElement) {
        AnnotationUsage struct;
        MemberDetails property = inferredData.getAttributeMember();
        if (property != null && (struct = property.getAnnotationUsage(Struct.class)) != null) {
            List attributes = struct.getList("attributes");
            return attributes.toArray(new String[0]);
        }
        struct = returnedClassOrElement.getAnnotationUsage(Struct.class);
        if (struct != null) {
            List attributes = struct.getList("attributes");
            return attributes.toArray(new String[0]);
        }
        return null;
    }

    private static boolean isAggregate(MemberDetails property, TypeDetails returnedClass, MetadataBuildingContext context) {
        if (property != null) {
            if (property.hasAnnotationUsage(Struct.class)) {
                return true;
            }
            AnnotationUsage jdbcTypeCode = property.getAnnotationUsage(JdbcTypeCode.class);
            if (jdbcTypeCode != null) {
                switch (jdbcTypeCode.getInteger("value")) {
                    case 2002: 
                    case 2009: 
                    case 3001: {
                        return true;
                    }
                }
            }
        }
        if (returnedClass != null) {
            return returnedClass.determineRawClass().hasAnnotationUsage(Struct.class);
        }
        return false;
    }
}

