/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.FractionalSeconds;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

class ColumnsBuilder {
    private final PropertyHolder propertyHolder;
    private final Nullability nullability;
    private final MemberDetails property;
    private final PropertyData inferredData;
    private final EntityBinder entityBinder;
    private final MetadataBuildingContext buildingContext;
    private AnnotatedColumns columns;
    private AnnotatedJoinColumns joinColumns;

    public ColumnsBuilder(PropertyHolder propertyHolder, Nullability nullability, MemberDetails property, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext buildingContext) {
        this.propertyHolder = propertyHolder;
        this.nullability = nullability;
        this.property = property;
        this.inferredData = inferredData;
        this.entityBinder = entityBinder;
        this.buildingContext = buildingContext;
    }

    public AnnotatedColumns getColumns() {
        return this.columns;
    }

    public AnnotatedJoinColumns getJoinColumns() {
        return this.joinColumns;
    }

    public ColumnsBuilder extractMetadata() {
        this.columns = null;
        this.joinColumns = this.buildExplicitJoinColumns(this.property, this.inferredData);
        AnnotationUsage columnAnn = this.property.getAnnotationUsage(Column.class);
        AnnotationUsage formulaAnn = this.property.getAnnotationUsage(Formula.class);
        AnnotationUsage columnsAnn = this.property.getAnnotationUsage(Columns.class);
        if (columnAnn != null) {
            this.columns = AnnotatedColumn.buildColumnFromAnnotation((AnnotationUsage<Column>)this.property.getAnnotationUsage(Column.class), (AnnotationUsage<FractionalSeconds>)this.property.getAnnotationUsage(FractionalSeconds.class), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (formulaAnn != null) {
            this.columns = AnnotatedColumn.buildFormulaFromAnnotation(BinderHelper.getOverridableAnnotation((AnnotationTarget)this.property, Formula.class, this.buildingContext), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (columnsAnn != null) {
            this.columns = AnnotatedColumn.buildColumnsFromAnnotations((List<AnnotationUsage<Column>>)columnsAnn.getList("columns"), null, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.joinColumns == null && (this.property.hasAnnotationUsage(ManyToOne.class) || this.property.hasAnnotationUsage(OneToOne.class))) {
            this.joinColumns = this.buildDefaultJoinColumnsForToOne(this.property, this.inferredData);
        } else if (this.joinColumns == null && (this.property.hasAnnotationUsage(OneToMany.class) || this.property.hasAnnotationUsage(ElementCollection.class))) {
            AnnotationUsage oneToMany = this.property.getAnnotationUsage(OneToMany.class);
            this.joinColumns = AnnotatedJoinColumns.buildJoinColumns(null, oneToMany == null ? null : StringHelper.nullIfEmpty(oneToMany.getString("mappedBy")), this.entityBinder.getSecondaryTables(), this.propertyHolder, this.inferredData, this.buildingContext);
        } else if (this.joinColumns == null && this.property.hasAnnotationUsage(Any.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is annotated '@Any' and must declare at least one '@JoinColumn'");
        }
        if (this.columns == null && !this.property.hasAnnotationUsage(ManyToMany.class)) {
            this.columns = AnnotatedColumn.buildColumnFromNoAnnotation((AnnotationUsage<FractionalSeconds>)this.property.getAnnotationUsage(FractionalSeconds.class), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.nullability == Nullability.FORCED_NOT_NULL) {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.forceNotNull();
            }
        }
        return this;
    }

    private AnnotatedJoinColumns buildDefaultJoinColumnsForToOne(MemberDetails property, PropertyData inferredData) {
        AnnotationUsage<JoinTable> joinTableAnn = this.propertyHolder.getJoinTable(property);
        if (joinTableAnn != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinTableAnn.getList("inverseJoinColumns"), null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        AnnotationUsage oneToOneAnn = property.getAnnotationUsage(OneToOne.class);
        return AnnotatedJoinColumns.buildJoinColumns(null, oneToOneAnn == null ? null : StringHelper.nullIfEmpty(oneToOneAnn.getString("mappedBy")), this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
    }

    private AnnotatedJoinColumns buildExplicitJoinColumns(MemberDetails property, PropertyData inferredData) {
        List<AnnotationUsage<JoinColumn>> joinColumnAnnotations = this.getJoinColumnAnnotations(property, inferredData);
        if (joinColumnAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinColumnAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        List<AnnotationUsage<JoinColumnOrFormula>> joinColumnOrFormulaAnnotations = this.joinColumnOrFormulaAnnotations(property, inferredData);
        if (joinColumnOrFormulaAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumnsOrFormulas(joinColumnOrFormulaAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        if (property.hasAnnotationUsage(JoinFormula.class)) {
            AnnotationUsage<JoinFormula> joinFormula = BinderHelper.getOverridableAnnotation((AnnotationTarget)property, JoinFormula.class, this.buildingContext);
            return AnnotatedJoinColumns.buildJoinColumnsWithFormula(joinFormula, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        return null;
    }

    private List<AnnotationUsage<JoinColumnOrFormula>> joinColumnOrFormulaAnnotations(MemberDetails property, PropertyData inferredData) {
        if (property.hasAnnotationUsage(JoinColumnOrFormula.class)) {
            return List.of(property.getAnnotationUsage(JoinColumnOrFormula.class));
        }
        if (property.hasAnnotationUsage(JoinColumnsOrFormulas.class)) {
            AnnotationUsage joinColumnsOrFormulas = property.getAnnotationUsage(JoinColumnsOrFormulas.class);
            List joinColumnOrFormulaList = joinColumnsOrFormulas.getList("value");
            if (joinColumnOrFormulaList.isEmpty()) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, inferredData) + "' has an empty '@JoinColumnsOrFormulas' annotation");
            }
            return joinColumnOrFormulaList;
        }
        return null;
    }

    private List<AnnotationUsage<JoinColumn>> getJoinColumnAnnotations(MemberDetails property, PropertyData inferredData) {
        if (property.hasAnnotationUsage(JoinColumn.class)) {
            return List.of(property.getAnnotationUsage(JoinColumn.class));
        }
        if (property.hasAnnotationUsage(JoinColumns.class)) {
            AnnotationUsage joinColumns = property.getAnnotationUsage(JoinColumns.class);
            List joinColumnsList = joinColumns.getList("value");
            if (joinColumnsList.isEmpty()) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, inferredData) + "' has an empty '@JoinColumns' annotation");
            }
            return joinColumnsList;
        }
        if (property.hasAnnotationUsage(MapsId.class)) {
            if (property.hasAnnotationUsage(PrimaryKeyJoinColumns.class)) {
                ArrayList<AnnotationUsage<JoinColumn>> adapters = new ArrayList<AnnotationUsage<JoinColumn>>();
                property.forEachAnnotationUsage(PrimaryKeyJoinColumn.class, usage -> adapters.add(this.makePrimaryKeyJoinColumnAdapter((AnnotationUsage<PrimaryKeyJoinColumn>)usage, property)));
                return adapters;
            }
            AnnotationUsage pkJoinColumnAnn = property.getAnnotationUsage(PrimaryKeyJoinColumn.class);
            if (pkJoinColumnAnn != null) {
                return List.of(this.makePrimaryKeyJoinColumnAdapter((AnnotationUsage<PrimaryKeyJoinColumn>)pkJoinColumnAnn, property));
            }
            return null;
        }
        return null;
    }

    private AnnotationUsage<JoinColumn> makePrimaryKeyJoinColumnAdapter(AnnotationUsage<PrimaryKeyJoinColumn> pkJoinColumnAnn, MemberDetails property) {
        SourceModelBuildingContext hibernateModelsContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        AnnotationDescriptorRegistry descriptorRegistry = hibernateModelsContext.getAnnotationDescriptorRegistry();
        AnnotationDescriptor joinColumnDescriptor = descriptorRegistry.getDescriptor(JoinColumn.class);
        return joinColumnDescriptor.createUsage((AnnotationTarget)property, usage -> {
            AnnotationUsageHelper.applyAttributeIfSpecified("name", pkJoinColumnAnn.getAttributeValue("name"), usage);
            AnnotationUsageHelper.applyAttributeIfSpecified("referencedColumnName", pkJoinColumnAnn.getAttributeValue("referencedColumnName"), usage);
            AnnotationUsageHelper.applyAttributeIfSpecified("columnDefinition", pkJoinColumnAnn.getAttributeValue("columnDefinition"), usage);
            AnnotationUsageHelper.applyAttributeIfSpecified("options", pkJoinColumnAnn.getAttributeValue("options"), usage);
            AnnotationUsageHelper.applyAttributeIfSpecified("foreignKey", pkJoinColumnAnn.getAttributeValue("foreignKey"), usage);
        }, hibernateModelsContext);
    }

    AnnotatedColumns overrideColumnFromMapperOrMapsIdProperty(boolean isId) {
        PropertyData override = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, this.propertyHolder, this.property.resolveAttributeName(), this.buildingContext);
        if (override != null) {
            AnnotatedJoinColumns joinColumns = this.buildExplicitJoinColumns(override.getAttributeMember(), override);
            return joinColumns == null ? this.buildDefaultJoinColumnsForToOne(override.getAttributeMember(), override) : joinColumns;
        }
        return this.columns;
    }

    private static final class JoinColumnAdapter
    implements JoinColumn {
        private final PrimaryKeyJoinColumn column;

        public JoinColumnAdapter(PrimaryKeyJoinColumn column) {
            this.column = column;
        }

        public String name() {
            return this.column.name();
        }

        public String referencedColumnName() {
            return this.column.referencedColumnName();
        }

        public boolean unique() {
            return false;
        }

        public boolean nullable() {
            return false;
        }

        public boolean insertable() {
            return false;
        }

        public boolean updatable() {
            return false;
        }

        public String columnDefinition() {
            return this.column.columnDefinition();
        }

        public String options() {
            return null;
        }

        public String table() {
            return "";
        }

        public ForeignKey foreignKey() {
            return this.column.foreignKey();
        }

        public CheckConstraint[] check() {
            return new CheckConstraint[0];
        }

        public String comment() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return JoinColumn.class;
        }
    }
}

