/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.Instantiator;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AggregateComponentBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CopyIdentifierComponentSecondPass;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EmbeddableBinder.class);

    static PropertyBinder createCompositeBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, AnnotatedColumns columns, ClassDetails returnedClass, PropertyBinder propertyBinder, boolean isOverridden, Class<? extends CompositeUserType<?>> compositeUserType) {
        AnnotatedJoinColumns actualColumns;
        String propertyName;
        String referencedEntityName;
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.resolveAttributeName(), context);
            referencedEntityName = mapsIdProperty.getClassOrElementName();
            propertyName = mapsIdProperty.getPropertyName();
            AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
            parent.setBuildingContext(context);
            parent.setPropertyHolder(propertyHolder);
            parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            for (AnnotatedColumn column : columns.getColumns()) {
                column.setParent(parent);
            }
            actualColumns = parent;
        } else {
            referencedEntityName = null;
            propertyName = null;
            actualColumns = null;
        }
        return EmbeddableBinder.createEmbeddedProperty(inferredData, propertyHolder, entityBinder, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, EmbeddableBinder.bindEmbeddable(inferredData, propertyHolder, entityBinder.getPropertyAccessor((AnnotationTarget)property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, referencedEntityName, propertyName, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, actualColumns, columns));
    }

    static boolean isEmbedded(MemberDetails property, ClassDetails returnedClass) {
        return property.hasAnnotationUsage(Embedded.class) || property.hasAnnotationUsage(EmbeddedId.class) || returnedClass.hasAnnotationUsage(Embeddable.class) && !property.hasAnnotationUsage(Convert.class);
    }

    static boolean isEmbedded(MemberDetails property, TypeDetails returnedClass) {
        if (property.hasAnnotationUsage(Embedded.class) || property.hasAnnotationUsage(EmbeddedId.class)) {
            return true;
        }
        ClassDetails returnClassDetails = returnedClass.determineRawClass();
        return returnClassDetails.hasAnnotationUsage(Embeddable.class) && !property.hasAnnotationUsage(Convert.class);
    }

    private static Component bindEmbeddable(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedJoinColumns columns, AnnotatedColumns annotatedColumns) {
        Component component;
        if (referencedEntityName != null) {
            component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
            context.getMetadataCollector().addSecondPass(new CopyIdentifierComponentSecondPass(component, referencedEntityName, propertyName, columns, context));
        } else {
            component = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, context.getMetadataCollector().isInSecondPass(), customInstantiatorImpl, compositeUserTypeClass, annotatedColumns, context, inheritanceStatePerClass);
        }
        if (isId) {
            component.setKey(true);
            EmbeddableBinder.checkEmbeddedId(inferredData, propertyHolder, referencedEntityName, component);
        }
        EmbeddableBinder.callTypeBinders(component, context, inferredData.getPropertyType());
        return component;
    }

    private static void callTypeBinders(Component component, MetadataBuildingContext context, TypeDetails annotatedClass) {
        List metaAnnotatedAnnotations = annotatedClass.determineRawClass().getMetaAnnotated(TypeBinderType.class);
        for (AnnotationUsage metaAnnotated : metaAnnotatedAnnotations) {
            AnnotationUsage binderType = metaAnnotated.getAnnotationDescriptor().getAnnotationUsage(TypeBinderType.class);
            try {
                ClassDetails binderImpl = binderType.getClassDetails("binder");
                Class binderJavaType = binderImpl.toJavaClass();
                TypeBinder binder = (TypeBinder)binderJavaType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                binder.bind(metaAnnotated.toAnnotation(), context, component);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @TypeBinderType annotation '" + metaAnnotated + "'", e);
            }
        }
    }

    private static PropertyBinder createEmbeddedProperty(PropertyData inferredData, PropertyHolder propertyHolder, EntityBinder entityBinder, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, Component component) {
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(component);
        binder.setMemberDetails(inferredData.getAttributeMember());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(context);
        binder.makePropertyAndBind();
        return binder;
    }

    private static void checkEmbeddedId(PropertyData inferredData, PropertyHolder propertyHolder, String referencedEntityName, Component component) {
        if (propertyHolder.getPersistentClass().getIdentifier() != null) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
        }
        if (referencedEntityName == null && component.getPropertySpan() == 0) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
        }
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        return EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, null, propertyAccessor, null, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, columns, context, inheritanceStatePerClass, false);
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, ClassDetails entityAtStake, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, boolean isIdClass) {
        ClassDetails returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", subpath);
        PropertyHolder subholder = PropertyHolderBuilder.buildPropertyHolder(component, subpath, inferredData, propertyHolder, context);
        propertyHolder.startingProperty(inferredData.getAttributeMember());
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrElementType().determineRawClass();
        } else {
            compositeUserType = EmbeddableBinder.compositeUserType(compositeUserTypeClass, context);
            component.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = context.getMetadataCollector().getSourceModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(compositeUserType.embeddable().getName());
        }
        TypeDetails annotatedType = inferredData.getPropertyType();
        List<PropertyData> classElements = EmbeddableBinder.collectClassElements(propertyAccessor, context, returnedClassOrElement, annotatedType, isIdClass);
        List<PropertyData> baseClassElements = EmbeddableBinder.collectBaseClassElements(baseInferredData, propertyAccessor, context, entityAtStake);
        if (baseClassElements != null && !EmbeddableBinder.hasAnnotationsOnIdClass(annotatedType)) {
            EmbeddableBinder.processIdClassElements(propertyHolder, baseInferredData, classElements, baseClassElements);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            PropertyBinder.processElementAnnotations(subholder, entityBinder.getPersistentClass() instanceof SingleTableSubclass ? Nullability.FORCED_NULL : (isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL), propertyAnnotatedElement, new HashMap<String, IdentifierGeneratorDefinition>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            MemberDetails property = propertyAnnotatedElement.getAttributeMember();
            if (!property.hasAnnotationUsage(GeneratedValue.class)) continue;
            if (isIdClass || subholder.isOrWithinEmbeddedId()) {
                EmbeddableBinder.processGeneratedId(context, component, property);
                continue;
            }
            throw new AnnotationException("Property '" + property.getName() + "' of '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '@GeneratedValue' but is not part of an identifier");
        }
        if (compositeUserType != null) {
            EmbeddableBinder.processCompositeUserType(component, compositeUserType);
        }
        AggregateComponentBinder.processAggregate(component, propertyHolder, inferredData, returnedClassOrElement, columns, context);
        return component;
    }

    private static CompositeUserType<?> compositeUserType(Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext context) {
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(compositeUserTypeClass);
        }
        return context.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(compositeUserTypeClass).getBeanInstance();
    }

    private static List<PropertyData> collectClassElements(AccessType propertyAccessor, MetadataBuildingContext context, ClassDetails returnedClassOrElement, TypeDetails annotatedClass, boolean isIdClass) {
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        PropertyContainer container = new PropertyContainer(returnedClassOrElement, (TypeVariableScope)annotatedClass, propertyAccessor);
        PropertyBinder.addElementsOfClass(classElements, container, context);
        ClassDetails superClass = annotatedClass.determineRawClass().getSuperClass();
        while (EmbeddableBinder.isValidSuperclass(superClass, isIdClass)) {
            PropertyContainer superContainer = new PropertyContainer(superClass, (TypeVariableScope)annotatedClass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context);
            superClass = superClass.getSuperClass();
        }
        return classElements;
    }

    private static boolean isValidSuperclass(ClassDetails superClass, boolean isIdClass) {
        if (superClass == null) {
            return false;
        }
        return superClass.hasAnnotationUsage(MappedSuperclass.class) || isIdClass && !superClass.getName().equals(Object.class.getName()) && !superClass.getName().equals("java.lang.Record");
    }

    private static List<PropertyData> collectBaseClassElements(PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context, ClassDetails entityAtStake) {
        if (baseInferredData != null) {
            ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
            TypeDetails baseReturnedClassOrElement = baseInferredData.getClassOrElementType();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                PropertyContainer container = new PropertyContainer(baseReturnedClassOrElement.determineRawClass(), (TypeVariableScope)entityAtStake, propertyAccessor);
                PropertyBinder.addElementsOfClass(baseClassElements, container, context);
                baseReturnedClassOrElement = baseReturnedClassOrElement.determineRawClass().getGenericSuperType();
            }
            return baseClassElements;
        }
        return null;
    }

    private static void processCompositeUserType(Component component, CompositeUserType<?> compositeUserType) {
        component.sortProperties();
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(component.getPropertySpan());
        ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(component.getPropertySpan());
        PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
        for (Property property : component.getProperties()) {
            sortedPropertyNames.add(property.getName());
            sortedPropertyTypes.add(PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
            property.setPropertyAccessStrategy(strategy);
        }
    }

    private static boolean hasAnnotationsOnIdClass(TypeDetails idClassType) {
        return EmbeddableBinder.hasAnnotationsOnIdClass(idClassType.determineRawClass());
    }

    private static boolean hasAnnotationsOnIdClass(ClassDetails idClass) {
        for (FieldDetails field : idClass.getFields()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation((MemberDetails)field)) continue;
            return true;
        }
        for (MethodDetails method : idClass.getMethods()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation((MemberDetails)method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(MemberDetails property) {
        return property.hasAnnotationUsage(Column.class) || property.hasAnnotationUsage(OneToMany.class) || property.hasAnnotationUsage(ManyToOne.class) || property.hasAnnotationUsage(Id.class) || property.hasAnnotationUsage(GeneratedValue.class) || property.hasAnnotationUsage(OneToOne.class) || property.hasAnnotationUsage(ManyToMany.class);
    }

    private static void processGeneratedId(MetadataBuildingContext context, Component component, MemberDetails property) {
        String generator;
        AnnotationUsage generatedValue = property.getAnnotationUsage(GeneratedValue.class);
        String generatorType = generatedValue != null ? GeneratorBinder.generatorType((AnnotationUsage<GeneratedValue>)generatedValue, property.getType().determineRawClass(), context) : "assigned";
        String string = generator = generatedValue != null ? generatedValue.getString("generator") : "";
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            GeneratorBinder.buildGenerators((AnnotationTarget)property, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context));
        } else {
            GeneratorBinder.makeIdGenerator((SimpleValue)component.getProperty(property.getName()).getValue(), property, generatorType, generator, context, new HashMap<String, IdentifierGeneratorDefinition>(GeneratorBinder.buildGenerators((AnnotationTarget)property, context)));
        }
    }

    private static void processIdClassElements(PropertyHolder propertyHolder, PropertyData baseInferredData, List<PropertyData> classElements, List<PropertyData> baseClassElements) {
        HashMap<String, PropertyData> baseClassElementsByName = new HashMap<String, PropertyData>();
        for (PropertyData element : baseClassElements) {
            baseClassElementsByName.put(element.getPropertyName(), element);
        }
        for (int i = 0; i < classElements.size(); ++i) {
            PropertyData idClassPropertyData = classElements.get(i);
            PropertyData entityPropertyData = (PropertyData)baseClassElementsByName.get(idClassPropertyData.getPropertyName());
            if (propertyHolder.isInIdClass()) {
                if (entityPropertyData == null) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyType().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                }
                if (BinderHelper.hasToOneAnnotation((AnnotationTarget)entityPropertyData.getAttributeMember()) && !entityPropertyData.getClassOrElementType().equals(idClassPropertyData.getClassOrElementType())) continue;
            }
            classElements.set(i, entityPropertyData);
        }
    }

    static Component createEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        Component component = new Component(context, propertyHolder.getPersistentClass());
        component.setEmbedded(isComponentEmbedded);
        component.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
        } else {
            component.setComponentClassName(inferredData.getClassOrElementName());
        }
        component.setCustomInstantiator(customInstantiatorImpl);
        Constructor<?> constructor = EmbeddableBinder.resolveInstantiator(inferredData.getClassOrElementType(), context);
        if (constructor != null) {
            component.setInstantiator(constructor, constructor.getAnnotation(Instantiator.class).value());
        }
        return component;
    }

    private static Constructor<?> resolveInstantiator(TypeDetails embeddableClass, MetadataBuildingContext buildingContext) {
        return embeddableClass == null ? null : EmbeddableBinder.resolveInstantiator(embeddableClass.determineRawClass(), buildingContext);
    }

    private static Constructor<?> resolveInstantiator(ClassDetails embeddableClass, MetadataBuildingContext buildingContext) {
        if (embeddableClass != null) {
            Constructor<?>[] declaredConstructors = embeddableClass.toJavaClass().getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredConstructor : declaredConstructors) {
                if (!declaredConstructor.isAnnotationPresent(Instantiator.class)) continue;
                if (constructor != null) {
                    throw new AnnotationException("Multiple constructors of '" + embeddableClass.getName() + "' are annotated '@Instantiator' but only one constructor can be the canonical constructor");
                }
                constructor = declaredConstructor;
            }
            return constructor;
        }
        return null;
    }

    private static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(MemberDetails property, ClassDetails returnedClass, MetadataBuildingContext context) {
        if (property.hasAnnotationUsage(EmbeddedId.class)) {
            return null;
        }
        AnnotationUsage propertyAnnotation = property.getAnnotationUsage(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.getClassDetails("value").toJavaClass();
        }
        AnnotationUsage classAnnotation = returnedClass.getAnnotationUsage(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.getClassDetails("value").toJavaClass();
        }
        if (returnedClass.getClassName() != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(returnedClass.toJavaClass());
        }
        return null;
    }
}

