/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Cacheable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.QueryCacheLayout;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.annotations.SecondaryRows;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.View;
import org.hibernate.annotations.Where;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CreateKeySecondPass;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.IndexBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.JoinedSubclassFkSecondPass;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.NullableDiscriminatorColumnSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.boot.model.internal.SecondaryTableSecondPass;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jpa.event.internal.CallbackDefinitionResolver;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.jboss.logging.Logger;

public class EntityBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityBinder.class.getName());
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private MetadataBuildingContext context;
    private String name;
    private ClassDetails annotatedClass;
    private PersistentClass persistentClass;
    private PolymorphismType polymorphismType;
    private boolean lazy;
    private ClassDetails proxyClass;
    private String where;
    private final Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private final Map<String, Join> secondaryTablesFromAnnotation = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableFromAnnotationJoins = new HashMap<String, Object>();
    private final List<AnnotationUsage<Filter>> filters = new ArrayList<AnnotationUsage<Filter>>();
    private boolean ignoreIdAnnotations;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;
    private CacheLayout queryCacheLayout;

    public static void bindEntityClass(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, MetadataBuildingContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStates.get(clazzToProcess);
        PersistentClass superEntity = EntityBinder.getSuperEntity(clazzToProcess, inheritanceStates, context, inheritanceState);
        PersistentClass persistentClass = EntityBinder.makePersistentClass(inheritanceState, superEntity, context);
        EntityBinder.checkOverrides(clazzToProcess, superEntity);
        EntityBinder entityBinder = new EntityBinder(clazzToProcess, persistentClass, context);
        entityBinder.bindEntity();
        entityBinder.bindSubselect();
        entityBinder.bindTables(inheritanceState, superEntity);
        entityBinder.bindCustomSql();
        entityBinder.bindSynchronize();
        entityBinder.bindFilters();
        entityBinder.handleCheckConstraints();
        PropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, context, inheritanceStates);
        entityBinder.handleInheritance(inheritanceState, superEntity, holder);
        entityBinder.handleIdentifier(holder, inheritanceStates, generators, inheritanceState);
        InFlightMetadataCollector collector = context.getMetadataCollector();
        if (persistentClass instanceof RootClass) {
            collector.addSecondPass(new CreateKeySecondPass((RootClass)persistentClass));
            EntityBinder.bindSoftDelete(clazzToProcess, (RootClass)persistentClass, inheritanceState, context);
        }
        if (persistentClass instanceof Subclass) {
            assert (superEntity != null);
            superEntity.addSubclass((Subclass)persistentClass);
        }
        collector.addEntityBinding(persistentClass);
        collector.addSecondPass(new SecondaryTableFromAnnotationSecondPass(entityBinder, holder));
        collector.addSecondPass(new SecondaryTableSecondPass(entityBinder, holder));
        entityBinder.processComplementaryTableDefinitions();
        EntityBinder.bindCallbacks(clazzToProcess, persistentClass, context);
        entityBinder.callTypeBinders(persistentClass);
    }

    private void bindTables(InheritanceState inheritanceState, PersistentClass superEntity) {
        this.handleClassTable(inheritanceState, superEntity);
        this.handleSecondaryTables();
    }

    private static void checkOverrides(ClassDetails clazzToProcess, PersistentClass superEntity) {
        if (superEntity != null) {
            clazzToProcess.forEachAnnotationUsage(AttributeOverride.class, usage -> EntityBinder.checkOverride(superEntity, usage.getString("name"), clazzToProcess, AttributeOverride.class));
            clazzToProcess.forEachAnnotationUsage(AssociationOverride.class, usage -> EntityBinder.checkOverride(superEntity, usage.getString("name"), clazzToProcess, AttributeOverride.class));
        }
    }

    private static void checkOverride(PersistentClass superEntity, String name, ClassDetails clazzToProcess, Class<?> overrideClass) {
        if (superEntity.hasProperty(StringHelper.root(name))) {
            throw new AnnotationException("Property '" + name + "' is inherited from entity '" + superEntity.getEntityName() + "' and may not be overridden using '@" + overrideClass.getSimpleName() + "' in entity subclass '" + clazzToProcess.getName() + "'");
        }
    }

    private static void bindSoftDelete(ClassDetails classDetails, RootClass rootClass, InheritanceState inheritanceState, MetadataBuildingContext context) {
        AnnotationUsage<SoftDelete> softDelete = EntityBinder.extractSoftDelete(classDetails, inheritanceState, context);
        if (softDelete != null) {
            SoftDeleteHelper.bindSoftDeleteIndicator(softDelete, rootClass, rootClass.getRootTable(), context);
        }
    }

    private static AnnotationUsage<SoftDelete> extractSoftDelete(ClassDetails classDetails, InheritanceState inheritanceState, MetadataBuildingContext context) {
        AnnotationUsage fromClass = classDetails.getAnnotationUsage(SoftDelete.class);
        if (fromClass != null) {
            return fromClass;
        }
        for (ClassDetails classToCheck = classDetails.getSuperClass(); classToCheck != null; classToCheck = classToCheck.getSuperClass()) {
            AnnotationUsage fromSuper = classToCheck.getAnnotationUsage(SoftDelete.class);
            if (fromSuper == null || !classToCheck.hasAnnotationUsage(jakarta.persistence.MappedSuperclass.class)) continue;
            return fromSuper;
        }
        return BinderHelper.extractFromPackage(SoftDelete.class, classDetails, context);
    }

    private void handleCheckConstraints() {
        if (this.annotatedClass.hasAnnotationUsage(Checks.class)) {
            AnnotationUsage explicitUsage = this.annotatedClass.getAnnotationUsage(Checks.class);
            for (AnnotationUsage check : explicitUsage.getList("value")) {
                this.addCheckToEntity((AnnotationUsage<Check>)check);
            }
        } else {
            AnnotationUsage<Check> check = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, Check.class, this.context);
            if (check != null) {
                this.addCheckToEntity(check);
            }
        }
    }

    private void addCheckToEntity(AnnotationUsage<Check> check) {
        String name = check.getString("name");
        String constraint = check.getString("constraints");
        this.persistentClass.addCheckConstraint(name.isEmpty() ? new CheckConstraint(constraint) : new CheckConstraint(name, constraint));
    }

    private void callTypeBinders(PersistentClass persistentClass) {
        List metaAnnotatedList = this.annotatedClass.getMetaAnnotated(TypeBinderType.class);
        for (AnnotationUsage metaAnnotated : metaAnnotatedList) {
            this.applyTypeBinder(metaAnnotated, persistentClass);
        }
    }

    private void applyTypeBinder(AnnotationUsage<?> metaAnnotated, PersistentClass persistentClass) {
        Class<TypeBinder<?>> binderClass = metaAnnotated.getAnnotationType().getAnnotation(TypeBinderType.class).binder();
        Annotation containingAnnotation = metaAnnotated.toAnnotation();
        try {
            TypeBinder<?> binder = binderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            binder.bind(containingAnnotation, this.context, persistentClass);
        }
        catch (Exception e) {
            throw new AnnotationException("error processing @TypeBinderType annotation '" + containingAnnotation + "'", e);
        }
    }

    private void handleIdentifier(PropertyHolder propertyHolder, Map<ClassDetails, InheritanceState> inheritanceStates, Map<String, IdentifierGeneratorDefinition> generators, InheritanceState inheritanceState) {
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.postProcess(this.persistentClass, this);
        Set<String> idPropertiesIfIdClass = this.handleIdClass(this.persistentClass, inheritanceState, this.context, propertyHolder, elementsToProcess, inheritanceStates);
        this.processIdPropertiesIfNotAlready(this.persistentClass, inheritanceState, this.context, propertyHolder, generators, idPropertiesIfIdClass, elementsToProcess, inheritanceStates);
    }

    private void processComplementaryTableDefinitions() {
        this.annotatedClass.forEachAnnotationUsage(org.hibernate.annotations.Table.class, usage -> {
            String checkConstraint;
            org.hibernate.mapping.Table appliedTable = this.findTable(usage.getString("appliesTo"));
            String comment = usage.getString("comment");
            if (!comment.isEmpty()) {
                appliedTable.setComment(comment);
            }
            if (!(checkConstraint = usage.getString("checkConstraint")).isEmpty()) {
                appliedTable.addCheckConstraint(checkConstraint);
            }
            TableBinder.addIndexes(appliedTable, usage.getList("indexes"), this.context);
        });
        AnnotationUsage jpaTableUsage = this.annotatedClass.getAnnotationUsage(Table.class);
        if (jpaTableUsage != null) {
            TableBinder.addJpaIndexes(this.persistentClass.getTable(), jpaTableUsage.getList("indexes"), this.context);
        }
        InFlightMetadataCollector.EntityTableXref entityTableXref = this.context.getMetadataCollector().getEntityTableXref(this.persistentClass.getEntityName());
        this.annotatedClass.forEachAnnotationUsage(SecondaryTable.class, usage -> {
            Identifier secondaryTableLogicalName = Identifier.toIdentifier(usage.getString("name"));
            org.hibernate.mapping.Table table = entityTableXref.resolveTable(secondaryTableLogicalName);
            assert (table != null);
            TableBinder.addJpaIndexes(table, usage.getList("indexes"), this.context);
        });
    }

    private Set<String> handleIdClass(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = this.mapAsIdClass(inheritanceStates, inheritanceState, persistentClass, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context);
        if (!isIdClass) {
            this.setWrapIdsInEmbeddedComponents(elementsToProcess.getIdPropertyCount() > 1);
        }
        return idPropertiesIfIdClass;
    }

    private boolean mapAsIdClass(Map<ClassDetails, InheritanceState> inheritanceStates, InheritanceState inheritanceState, PersistentClass persistentClass, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context) {
        ClassDetails classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            AccessType propertyAccessor;
            PropertyPreloadedData baseInferredData;
            Class idClassValue = classWithIdClass.getAnnotationUsage(IdClass.class).getClassDetails("value").toJavaClass();
            ClassDetails compositeClass = context.getMetadataCollector().getSourceModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(idClassValue.getName());
            ClassTypeDetailsImpl compositeType = new ClassTypeDetailsImpl(compositeClass, TypeDetails.Kind.CLASS);
            ClassTypeDetailsImpl classWithIdType = new ClassTypeDetailsImpl(classWithIdClass, TypeDetails.Kind.CLASS);
            AccessType accessType = this.getPropertyAccessType();
            PropertyPreloadedData inferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)compositeType);
            boolean isFakeIdClass = EntityBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, compositeClass, inferredData, baseInferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)classWithIdType), propertyAccessor = this.getPropertyAccessor((AnnotationTarget)compositeClass), inheritanceStates, context);
            if (isFakeIdClass) {
                return false;
            }
            boolean ignoreIdAnnotations = this.isIgnoreIdAnnotations();
            this.setIgnoreIdAnnotations(true);
            this.bindIdClass(inferredData, baseInferredData, propertyHolder, propertyAccessor, context, inheritanceStates);
            Component mapper = this.createMapperProperty(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, (TypeDetails)compositeType, baseInferredData, propertyAccessor, true);
            this.setIgnoreIdAnnotations(ignoreIdAnnotations);
            for (Property property : mapper.getProperties()) {
                idPropertiesIfIdClass.add(property.getName());
            }
            return true;
        }
        return false;
    }

    private Component createMapperProperty(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = this.createMapper(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, compositeClass, baseInferredData, propertyAccessor, isIdClass);
        Property mapperProperty = new Property();
        mapperProperty.setName("_identifierMapper");
        mapperProperty.setUpdateable(false);
        mapperProperty.setInsertable(false);
        mapperProperty.setPropertyAccessorName("embedded");
        mapperProperty.setValue(mapper);
        persistentClass.addProperty(mapperProperty);
        return mapper;
    }

    private Component createMapper(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = EmbeddableBinder.fillEmbeddable(propertyHolder, new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass), baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, true, false, null, null, null, context, inheritanceStates, isIdClass);
        persistentClass.setIdentifierMapper(mapper);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(classWithIdClass, inheritanceStates, context);
        if (superclass != null) {
            superclass.setDeclaredIdentifierMapper(mapper);
        } else {
            persistentClass.setDeclaredIdentifierMapper(mapper);
        }
        return mapper;
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElementType().determineRawClass(), (TypeVariableScope)inferredData.getPropertyType(), propertyAccessor);
        PropertyBinder.addElementsOfClass(baseClassElements, propContainer, context);
        return (PropertyData)baseClassElements.get(0);
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, ClassDetails compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = EntityBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, context);
            InheritanceState state = inheritanceStates.get(idPropertyOnBaseClass.getClassOrElementType().determineRawClass());
            if (state == null) {
                return false;
            }
            ClassDetails associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                return BinderHelper.hasToOneAnnotation((AnnotationTarget)idPropertyOnBaseClass.getAttributeMember());
            }
            AnnotationUsage idClass = associatedClassWithIdClass.getAnnotationUsage(IdClass.class);
            return compositeClass.equals(idClass.getClassDetails("value"));
        }
        return false;
    }

    private void bindIdClass(PropertyData inferredData, PropertyData baseInferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, MetadataBuildingContext buildingContext, Map<ClassDetails, InheritanceState> inheritanceStates) {
        propertyHolder.setInIdClass(true);
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' is a subclass in an entity inheritance hierarchy and may not redefine the identifier of the root entity");
        }
        RootClass rootClass = (RootClass)persistentClass;
        Component id = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, false, false, null, null, null, buildingContext, inheritanceStates, true);
        id.setKey(true);
        if (rootClass.getIdentifier() != null) {
            throw new AssertionFailure("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' and may not have an identifier property");
        }
        if (id.getPropertySpan() == 0) {
            throw new AnnotationException("Class '" + id.getComponentClassName() + " is the '@IdClass' for the entity '" + persistentClass.getEntityName() + "' but has no persistent properties");
        }
        rootClass.setIdentifier(id);
        EntityBinder.handleIdGenerator(inferredData, buildingContext, id);
        rootClass.setEmbeddedIdentifier(inferredData.getPropertyType() == null);
        propertyHolder.setInIdClass(null);
    }

    private static void handleIdGenerator(PropertyData inferredData, MetadataBuildingContext buildingContext, Component id) {
        if (buildingContext.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            buildingContext.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass(id, inferredData.getAttributeMember(), "assigned", "", buildingContext));
        } else {
            GeneratorBinder.makeIdGenerator((SimpleValue)id, inferredData.getAttributeMember(), "assigned", "", buildingContext, Collections.emptyMap());
        }
    }

    private void handleSecondaryTables() {
        this.annotatedClass.forEachAnnotationUsage(SecondaryTable.class, usage -> this.addSecondaryTable((AnnotationUsage<SecondaryTable>)usage, null, false));
    }

    private void handleClassTable(InheritanceState inheritanceState, PersistentClass superEntity) {
        List uniqueConstraints;
        String catalog;
        String schema;
        String table;
        boolean hasTableAnnotation = this.annotatedClass.hasAnnotationUsage(Table.class);
        if (hasTableAnnotation) {
            AnnotationUsage tableAnnotation = this.annotatedClass.getAnnotationUsage(Table.class);
            table = tableAnnotation.getString("name");
            schema = tableAnnotation.getString("schema");
            catalog = tableAnnotation.getString("catalog");
            uniqueConstraints = tableAnnotation.getList("uniqueConstraints");
        } else {
            schema = "";
            table = "";
            catalog = "";
            uniqueConstraints = Collections.emptyList();
        }
        if (inheritanceState.hasTable()) {
            this.createTable(inheritanceState, superEntity, schema, table, catalog, uniqueConstraints);
        } else {
            if (hasTableAnnotation) {
                org.hibernate.mapping.Table superTable = this.persistentClass.getRootClass().getTable();
                if (!this.logicalTableName(table, schema, catalog).equals(superTable.getQualifiedTableName())) {
                    throw new AnnotationException("Entity '" + this.annotatedClass.getName() + "' is a subclass in a 'SINGLE_TABLE' hierarchy and may not be annotated '@Table' (the root class declares the table mapping for the hierarchy)");
                }
            }
            this.bindTableForDiscriminatedSubclass(superEntity.getEntityName());
        }
    }

    private void createTable(InheritanceState inheritanceState, PersistentClass superEntity, String schema, String table, String catalog, List<AnnotationUsage<UniqueConstraint>> uniqueConstraints) {
        AnnotationUsage rowId = this.annotatedClass.getAnnotationUsage(RowId.class);
        AnnotationUsage view = this.annotatedClass.getAnnotationUsage(View.class);
        this.bindTable(schema, catalog, table, uniqueConstraints, rowId == null ? null : rowId.getString("value"), view == null ? null : view.getString("query"), inheritanceState.hasDenormalizedTable() ? this.context.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()) : null);
    }

    private void handleInheritance(InheritanceState inheritanceState, PersistentClass superEntity, PropertyHolder propertyHolder) {
        boolean isJoinedSubclass = switch (inheritanceState.getType()) {
            case InheritanceType.JOINED -> {
                this.joinedInheritance(inheritanceState, superEntity, propertyHolder);
                yield inheritanceState.hasParents();
            }
            case InheritanceType.SINGLE_TABLE -> {
                this.singleTableInheritance(inheritanceState, propertyHolder);
                yield false;
            }
            case InheritanceType.TABLE_PER_CLASS -> false;
            default -> throw new AssertionFailure("Unrecognized InheritanceType");
        };
        this.bindDiscriminatorValue();
        if (!isJoinedSubclass) {
            this.checkNoJoinColumns(this.annotatedClass);
            EntityBinder.checkNoOnDelete(this.annotatedClass);
        }
    }

    private void singleTableInheritance(InheritanceState inheritanceState, PropertyHolder holder) {
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processSingleTableDiscriminatorProperties(inheritanceState);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (inheritanceState.hasSiblings() || discriminatorColumn != null && !discriminatorColumn.isImplicit()) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void joinedInheritance(InheritanceState state, PersistentClass superEntity, PropertyHolder holder) {
        if (state.hasParents()) {
            AnnotatedJoinColumns joinColumns = EntityBinder.subclassJoinColumns(this.annotatedClass, superEntity, this.context);
            JoinedSubclass jsc = (JoinedSubclass)this.persistentClass;
            DependantValue key = new DependantValue(this.context, jsc.getTable(), jsc.getIdentifier());
            jsc.setKey(key);
            EntityBinder.handleForeignKeys(this.annotatedClass, this.context, key);
            AnnotationUsage onDelete = this.annotatedClass.getAnnotationUsage(OnDelete.class);
            key.setOnDeleteAction(onDelete == null ? null : (OnDeleteAction)onDelete.getEnum("action"));
            this.context.getMetadataCollector().addSecondPass(new JoinedSubclassFkSecondPass(jsc, joinColumns, key, this.context));
            this.context.getMetadataCollector().addSecondPass(new CreateKeySecondPass(jsc));
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processJoinedDiscriminatorProperties(state);
        if (!state.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (discriminatorColumn != null && (state.hasSiblings() || !discriminatorColumn.isImplicit())) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void checkNoJoinColumns(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class)) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not specify a '@PrimaryKeyJoinColumn'");
        }
    }

    private static void checkNoOnDelete(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class)) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not be annotated '@OnDelete'");
        }
    }

    private static void handleForeignKeys(ClassDetails clazzToProcess, MetadataBuildingContext context, DependantValue key) {
        AnnotationUsage pkJoinColumn = clazzToProcess.getSingleAnnotationUsage(PrimaryKeyJoinColumn.class);
        AnnotationUsage pkJoinColumns = clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumns.class);
        boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
        if (pkJoinColumn != null && BinderHelper.noConstraint((AnnotationUsage<jakarta.persistence.ForeignKey>)pkJoinColumn.getNestedUsage("foreignKey"), noConstraintByDefault) || pkJoinColumns != null && BinderHelper.noConstraint((AnnotationUsage<jakarta.persistence.ForeignKey>)pkJoinColumns.getNestedUsage("foreignKey"), noConstraintByDefault)) {
            key.disableForeignKey();
        } else {
            AnnotationUsage fk = clazzToProcess.getAnnotationUsage(ForeignKey.class);
            if (fk != null && StringHelper.isNotEmpty(fk.getString("name"))) {
                key.setForeignKeyName(fk.getString("name"));
            } else {
                AnnotationUsage foreignKey = clazzToProcess.getAnnotationUsage(jakarta.persistence.ForeignKey.class);
                if (BinderHelper.noConstraint((AnnotationUsage<jakarta.persistence.ForeignKey>)foreignKey, noConstraintByDefault)) {
                    key.disableForeignKey();
                } else if (foreignKey != null) {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.getString("name")));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.getString("foreignKeyDefinition")));
                } else if (noConstraintByDefault) {
                    key.disableForeignKey();
                } else if (pkJoinColumns != null) {
                    AnnotationUsage nestedFk = pkJoinColumns.getNestedUsage("foreignKey");
                    key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.getString("name")));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.getString("foreignKeyDefinition")));
                } else if (pkJoinColumn != null) {
                    AnnotationUsage nestedFk = pkJoinColumn.getNestedUsage("foreignKey");
                    key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.getString("name")));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.getString("foreignKeyDefinition")));
                }
            }
        }
    }

    private void bindDiscriminatorColumnToRootPersistentClass(RootClass rootClass, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            AnnotatedColumns columns = new AnnotatedColumns();
            columns.setPropertyHolder(holder);
            columns.setBuildingContext(this.context);
            columns.setJoins(this.secondaryTables);
            discriminatorColumn.setParent(columns);
            BasicValue discriminatorColumnBinding = new BasicValue(this.context, rootClass.getTable());
            rootClass.setDiscriminator(discriminatorColumnBinding);
            discriminatorColumn.linkWithValue(discriminatorColumnBinding);
            discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            String rootEntityName = rootClass.getEntityName();
            LOG.tracev("Setting discriminator for entity {0}", rootEntityName);
            this.context.getMetadataCollector().addSecondPass(new NullableDiscriminatorColumnSecondPass(rootEntityName));
        }
    }

    private AnnotatedDiscriminatorColumn processSingleTableDiscriminatorProperties(InheritanceState inheritanceState) {
        AnnotationUsage discriminatorColumn = this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class);
        AnnotationUsage<DiscriminatorFormula> discriminatorFormula = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, DiscriminatorFormula.class, this.context);
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class)) {
            return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn((AnnotationUsage<DiscriminatorColumn>)discriminatorColumn, discriminatorFormula, this.context);
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        if (discriminatorFormula != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorFormula' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private AnnotatedDiscriminatorColumn processJoinedDiscriminatorProperties(InheritanceState inheritanceState) {
        if (this.annotatedClass.hasAnnotationUsage(DiscriminatorFormula.class)) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' has 'JOINED' inheritance and is annotated '@DiscriminatorFormula'");
        }
        AnnotationUsage discriminatorColumn = this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class);
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class)) {
            return this.useDiscriminatorColumnForJoined((AnnotationUsage<DiscriminatorColumn>)discriminatorColumn) ? AnnotatedDiscriminatorColumn.buildDiscriminatorColumn((AnnotationUsage<DiscriminatorColumn>)discriminatorColumn, null, this.context) : null;
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private boolean useDiscriminatorColumnForJoined(AnnotationUsage<DiscriminatorColumn> discriminatorColumn) {
        if (discriminatorColumn != null) {
            boolean ignore = this.context.getBuildingOptions().ignoreExplicitDiscriminatorsForJoinedInheritance();
            if (ignore) {
                LOG.debugf("Ignoring explicit @DiscriminatorColumn annotation on: %s", this.annotatedClass.getName());
            }
            return !ignore;
        }
        boolean createImplicit = this.context.getBuildingOptions().createImplicitDiscriminatorsForJoinedInheritance();
        if (createImplicit) {
            LOG.debugf("Inferring implicit @DiscriminatorColumn using defaults for: %s", this.annotatedClass.getName());
        }
        return createImplicit;
    }

    private void processIdPropertiesIfNotAlready(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> generators, Set<String> idPropertiesIfIdClass, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        HashSet<String> missingEntityProperties = new HashSet<String>();
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                boolean subclassAndSingleTableStrategy;
                MemberDetails property = propertyAnnotatedElement.getAttributeMember();
                boolean hasIdAnnotation = PropertyBinder.hasIdAnnotation(property);
                if (!idPropertiesIfIdClass.isEmpty() && !this.isIgnoreIdAnnotations() && hasIdAnnotation) {
                    missingEntityProperties.add(propertyName);
                    continue;
                }
                boolean bl = subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
                if (!hasIdAnnotation && property.hasAnnotationUsage(GeneratedValue.class)) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, propertyAnnotatedElement) + "' is annotated @GeneratedValue but is not part of an identifier");
                }
                PropertyBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, generators, this, false, false, false, context, inheritanceStates);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (!missingIdProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' with properties " + EntityBinder.getMissingPropertiesString(missingIdProperties) + " which do not match properties of the entity class");
        }
        if (!missingEntityProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has '@Id' annotated properties " + EntityBinder.getMissingPropertiesString(missingEntityProperties) + " which do not match properties of the specified '@IdClass'");
        }
    }

    private static String getMissingPropertiesString(Set<String> propertyNames) {
        StringBuilder sb = new StringBuilder();
        for (String property : propertyNames) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'").append(property).append("'");
        }
        return sb.toString();
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass(metadataBuildingContext);
        }
        switch (inheritanceState.getType()) {
            case SINGLE_TABLE: {
                return new SingleTableSubclass(superEntity, metadataBuildingContext);
            }
            case JOINED: {
                return new JoinedSubclass(superEntity, metadataBuildingContext);
            }
            case TABLE_PER_CLASS: {
                return new UnionSubclass(superEntity, metadataBuildingContext);
            }
        }
        throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
    }

    private static AnnotatedJoinColumns subclassJoinColumns(ClassDetails clazzToProcess, PersistentClass superEntity, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        AnnotationUsage primaryKeyJoinColumns = clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumns.class);
        if (primaryKeyJoinColumns != null) {
            List columns = primaryKeyJoinColumns.getList("value");
            if (!columns.isEmpty()) {
                for (AnnotationUsage column : columns) {
                    AnnotatedJoinColumn.buildInheritanceJoinColumn((AnnotationUsage<PrimaryKeyJoinColumn>)column, null, superEntity.getIdentifier(), joinColumns, context);
                }
            } else {
                AnnotationUsage columnAnnotation = clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class);
                AnnotatedJoinColumn.buildInheritanceJoinColumn((AnnotationUsage<PrimaryKeyJoinColumn>)columnAnnotation, null, superEntity.getIdentifier(), joinColumns, context);
            }
        } else {
            AnnotatedJoinColumn.buildInheritanceJoinColumn((AnnotationUsage<PrimaryKeyJoinColumn>)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class), null, superEntity.getIdentifier(), joinColumns, context);
        }
        LOG.trace("Subclass joined column(s) created");
        return joinColumns;
    }

    private static PersistentClass getSuperEntity(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context, InheritanceState inheritanceState) {
        InheritanceState superState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStates);
        if (superState == null) {
            return null;
        }
        PersistentClass superEntity = context.getMetadataCollector().getEntityBinding(superState.getClassDetails().getName());
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be bound after its parent class: " + superState.getClassDetails().getName());
        }
        return superEntity;
    }

    private static void bindCallbacks(ClassDetails entityClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        for (CallbackType callbackType : CallbackType.values()) {
            persistentClass.addCallbackDefinitions(CallbackDefinitionResolver.resolveEntityCallbacks(context, entityClass, callbackType));
        }
        context.getMetadataCollector().addSecondPass(persistentClasses -> {
            for (Property property : persistentClass.getDeclaredProperties()) {
                if (!property.isComposite()) continue;
                try {
                    Class<?> mappedClass = persistentClass.getMappedClass();
                    for (CallbackType type : CallbackType.values()) {
                        property.addCallbackDefinitions(CallbackDefinitionResolver.resolveEmbeddableCallbacks(context, mappedClass, property, type));
                    }
                }
                catch (ClassLoadingException classLoadingException) {
                }
            }
        });
    }

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder() {
    }

    public EntityBinder(ClassDetails annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.persistentClass != null && this.persistentClass.isPropertyDefinedInSuperHierarchy(name);
    }

    private void bindRowManagement() {
        AnnotationUsage dynamicInsertAnn = this.annotatedClass.getAnnotationUsage(DynamicInsert.class);
        this.persistentClass.setDynamicInsert(dynamicInsertAnn != null && dynamicInsertAnn.getBoolean("value") != false);
        AnnotationUsage dynamicUpdateAnn = this.annotatedClass.getAnnotationUsage(DynamicUpdate.class);
        this.persistentClass.setDynamicUpdate(dynamicUpdateAnn != null && dynamicUpdateAnn.getBoolean("value") != false);
        if (this.persistentClass.useDynamicInsert() && this.annotatedClass.hasAnnotationUsage(SQLInsert.class)) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicInsert' and '@SQLInsert'");
        }
        if (this.persistentClass.useDynamicUpdate() && this.annotatedClass.hasAnnotationUsage(SQLUpdate.class)) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicUpdate' and '@SQLUpdate'");
        }
        AnnotationUsage selectBeforeUpdateAnn = this.annotatedClass.getAnnotationUsage(SelectBeforeUpdate.class);
        this.persistentClass.setSelectBeforeUpdate(selectBeforeUpdateAnn != null && selectBeforeUpdateAnn.getBoolean("value") != false);
    }

    private void bindOptimisticLocking() {
        AnnotationUsage optimisticLockingAnn = this.annotatedClass.getAnnotationUsage(OptimisticLocking.class);
        this.persistentClass.setOptimisticLockStyle(OptimisticLockStyle.fromLockType(optimisticLockingAnn == null ? OptimisticLockType.VERSION : (OptimisticLockType)optimisticLockingAnn.getEnum("type")));
    }

    private void bindPolymorphism() {
        AnnotationUsage polymorphismAnn = this.annotatedClass.getAnnotationUsage(Polymorphism.class);
        this.polymorphismType = polymorphismAnn == null ? PolymorphismType.IMPLICIT : (PolymorphismType)polymorphismAnn.getEnum("type");
    }

    private void bindEntityAnnotation() {
        AnnotationUsage entity = this.annotatedClass.getAnnotationUsage(Entity.class);
        if (entity == null) {
            throw new AssertionFailure("@Entity should never be missing");
        }
        String entityName = entity.getString("name");
        this.name = entityName.isEmpty() ? StringHelper.unqualify(this.annotatedClass.getName()) : entityName;
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void bindEntity() {
        this.bindEntityAnnotation();
        this.bindRowManagement();
        this.bindOptimisticLocking();
        this.bindPolymorphism();
        this.bindProxy();
        this.bindWhere();
        this.bindCache();
        this.bindNaturalIdCache();
        this.bindFiltersInHierarchy();
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getClassName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.persistentClass.setCached(this.isCached);
        this.persistentClass.setLazy(this.lazy);
        this.persistentClass.setQueryCacheLayout(this.queryCacheLayout);
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        if (this.persistentClass instanceof RootClass) {
            this.bindRootEntity();
        } else if (!this.isMutable()) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@Immutable' but it is a subclass in an entity inheritance hierarchy (only root classes may declare mutability)");
        }
        this.ensureNoMutabilityPlan();
        this.bindCustomLoader();
        this.registerImportName();
        this.processNamedEntityGraphs();
    }

    private void ensureNoMutabilityPlan() {
        if (this.annotatedClass.hasAnnotationUsage(Mutability.class)) {
            throw new MappingException("@Mutability is not allowed on entity");
        }
    }

    private boolean isMutable() {
        return !this.annotatedClass.hasAnnotationUsage(Immutable.class);
    }

    private void registerImportName() {
        LOG.debugf("Import with entity name %s", this.name);
        try {
            this.context.getMetadataCollector().addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.context.getMetadataCollector().addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
    }

    private void bindRootEntity() {
        RootClass rootClass = (RootClass)this.persistentClass;
        rootClass.setMutable(this.isMutable());
        rootClass.setExplicitPolymorphism(this.polymorphismType == PolymorphismType.EXPLICIT);
        if (StringHelper.isNotEmpty(this.where)) {
            rootClass.setWhere(this.where);
        }
        if (this.cacheConcurrentStrategy != null) {
            rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
            rootClass.setCacheRegionName(this.cacheRegion);
            rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
        }
        rootClass.setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
    }

    private void bindCustomSql() {
        AnnotationUsage hqlSelect;
        AnnotationUsage<SQLDeleteAll> sqlDeleteAll;
        AnnotationUsage<SQLDelete> sqlDelete;
        AnnotationUsage<SQLUpdate> sqlUpdate;
        String primaryTableName = this.persistentClass.getTable().getName();
        AnnotationUsage<SQLInsert> sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, primaryTableName);
        if (sqlInsert == null) {
            sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, "");
        }
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.getString("sql").trim(), sqlInsert.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlInsert.getEnum("check")));
            Class expectationClass = sqlInsert.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setInsertExpectation(expectationClass);
            }
        }
        if ((sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, primaryTableName)) == null) {
            sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, "");
        }
        if (sqlUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.getString("sql").trim(), sqlUpdate.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlUpdate.getEnum("check")));
            Class expectationClass = sqlUpdate.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setUpdateExpectation(expectationClass);
            }
        }
        if ((sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, primaryTableName)) == null) {
            sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, "");
        }
        if (sqlDelete != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.getString("sql").trim(), sqlDelete.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlDelete.getEnum("check")));
            Class expectationClass = sqlDelete.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setDeleteExpectation(expectationClass);
            }
        }
        if ((sqlDeleteAll = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDeleteAll.class, "")) != null) {
            throw new AnnotationException("@SQLDeleteAll does not apply to entities: " + this.persistentClass.getEntityName());
        }
        AnnotationUsage<SQLSelect> sqlSelect = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, SQLSelect.class, this.context);
        if (sqlSelect != null) {
            String loaderName = this.persistentClass.getEntityName() + "$SQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindNativeQuery(loaderName, sqlSelect, this.annotatedClass, this.context);
        }
        if ((hqlSelect = this.annotatedClass.getAnnotationUsage(HQLSelect.class)) != null) {
            String loaderName = this.persistentClass.getEntityName() + "$HQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindQuery(loaderName, (AnnotationUsage<HQLSelect>)hqlSelect, this.context);
        }
    }

    private void bindCustomLoader() {
        AnnotationUsage loader = this.annotatedClass.getAnnotationUsage(Loader.class);
        if (loader != null) {
            this.persistentClass.setLoaderName(loader.getString("namedQuery"));
        }
    }

    private void bindSubselect() {
        AnnotationUsage subselect = this.annotatedClass.getAnnotationUsage(Subselect.class);
        if (subselect != null) {
            this.subselect = subselect.getString("value");
        }
    }

    private <A extends Annotation> AnnotationUsage<A> resolveCustomSqlAnnotation(ClassDetails annotatedClass, Class<A> annotationType, String tableName) {
        Class overrideAnnotation = BinderHelper.getOverrideAnnotation(annotationType);
        List dialectOverrides = annotatedClass.getRepeatedAnnotationUsages(overrideAnnotation);
        if (CollectionHelper.isNotEmpty(dialectOverrides)) {
            for (AnnotationUsage dialectOverride : dialectOverrides) {
                if (!BinderHelper.overrideMatchesDialect((AnnotationUsage<? extends Annotation>)dialectOverride, this.context.getMetadataCollector().getDatabase().getDialect())) continue;
                AnnotationUsage override = dialectOverride.getNestedUsage("override");
                if (StringHelper.isEmpty(tableName) && StringHelper.isEmpty(override.getString("table"))) {
                    return override;
                }
                if (!StringHelper.isNotEmpty(tableName) || !tableName.equals(override.getString("table"))) continue;
                return override;
            }
        }
        return annotatedClass.getNamedAnnotationUsage(annotationType, tableName, "table");
    }

    private void bindFilters() {
        for (AnnotationUsage<Filter> filter : this.filters) {
            String filterName = filter.getString("name");
            String condition = filter.getString("condition");
            if (condition.isEmpty()) {
                condition = this.getDefaultFilterCondition(filterName);
            }
            this.persistentClass.addFilter(filterName, condition, filter.getBoolean("deduceAliasInjectionPoints"), BinderHelper.toAliasTableMap(filter.getList("aliases")), BinderHelper.toAliasEntityMap(filter.getList("aliases")));
        }
    }

    private String getDefaultFilterCondition(String filterName) {
        FilterDefinition definition = this.context.getMetadataCollector().getFilterDefinition(filterName);
        if (definition == null) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' for an undefined filter named '" + filterName + "'");
        }
        String condition = definition.getDefaultFilterCondition();
        if (StringHelper.isEmpty(condition)) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' with no 'condition' and no default condition was given by the '@FilterDef' named '" + filterName + "'");
        }
        return condition;
    }

    private void bindSynchronize() {
        if (this.annotatedClass.hasAnnotationUsage(Synchronize.class)) {
            JdbcEnvironment jdbcEnvironment = this.context.getMetadataCollector().getDatabase().getJdbcEnvironment();
            AnnotationUsage synchronize = this.annotatedClass.getAnnotationUsage(Synchronize.class);
            boolean logical = synchronize.getBoolean("logical");
            List tableNames = synchronize.getList("value");
            for (String tableName : tableNames) {
                String physicalName = logical ? this.toPhysicalName(jdbcEnvironment, tableName) : tableName;
                this.persistentClass.addSynchronizedTable(physicalName);
            }
        }
    }

    private String toPhysicalName(JdbcEnvironment jdbcEnvironment, String logicalName) {
        Identifier identifier = jdbcEnvironment.getIdentifierHelper().toIdentifier(logicalName);
        return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(identifier, jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    private void processNamedEntityGraphs() {
        this.annotatedClass.forEachAnnotationUsage(NamedEntityGraph.class, this::processNamedEntityGraph);
    }

    private void processNamedEntityGraph(AnnotationUsage<NamedEntityGraph> annotation) {
        if (annotation == null) {
            return;
        }
        this.context.getMetadataCollector().addNamedEntityGraph(new NamedEntityGraphDefinition((NamedEntityGraph)annotation.toAnnotation(), this.name, this.persistentClass.getEntityName()));
    }

    public void bindDiscriminatorValue() {
        String discriminatorValue;
        String string = discriminatorValue = this.annotatedClass.hasAnnotationUsage(DiscriminatorValue.class) ? this.annotatedClass.getAnnotationUsage(DiscriminatorValue.class).getString("value") : null;
        if (StringHelper.isEmpty(discriminatorValue)) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(discriminator.getType().getName())) {
                    throw new AnnotationException("Entity '" + this.name + "' has a discriminator of character type and must specify its '@DiscriminatorValue'");
                }
                if ("integer".equals(discriminator.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(discriminatorValue);
        }
    }

    public void bindProxy() {
        AnnotationUsage proxy = this.annotatedClass.getAnnotationUsage(Proxy.class);
        if (proxy != null) {
            this.lazy = proxy.getBoolean("lazy");
            this.proxyClass = this.lazy ? EntityBinder.resolveProxyClass((AnnotationUsage<Proxy>)proxy, this.annotatedClass) : null;
        } else {
            this.lazy = true;
            this.proxyClass = this.annotatedClass;
        }
    }

    private static ClassDetails resolveProxyClass(AnnotationUsage<Proxy> proxy, ClassDetails annotatedClass) {
        ClassDetails proxyClass = proxy.getClassDetails("proxyClass");
        if (proxyClass == ClassDetails.VOID_CLASS_DETAILS) {
            return annotatedClass;
        }
        return proxyClass;
    }

    public void bindWhere() {
        AnnotationUsage<SQLRestriction> restriction;
        AnnotationUsage<Where> where = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, Where.class, this.context);
        if (where != null) {
            this.where = where.getString("clause");
        }
        if ((restriction = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, SQLRestriction.class, this.context)) != null) {
            this.where = restriction.getString("value");
        }
    }

    public void setWrapIdsInEmbeddedComponents(boolean wrapIdsInEmbeddedComponents) {
        this.wrapIdsInEmbeddedComponents = wrapIdsInEmbeddedComponents;
    }

    private void bindNaturalIdCache() {
        AnnotationUsage explicitCacheAnn;
        this.naturalIdCacheRegion = null;
        AnnotationUsage naturalIdCacheAnn = this.annotatedClass.getAnnotationUsage(NaturalIdCache.class);
        if (naturalIdCacheAnn == null) {
            return;
        }
        String region = naturalIdCacheAnn.getString("region");
        this.naturalIdCacheRegion = region.isEmpty() ? ((explicitCacheAnn = this.annotatedClass.getAnnotationUsage(Cache.class)) != null && StringHelper.isNotEmpty(explicitCacheAnn.getString("region")) ? explicitCacheAnn.getString("region") + NATURAL_ID_CACHE_SUFFIX : this.annotatedClass.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCacheAnn.getString("region");
    }

    private void bindCache() {
        this.isCached = false;
        this.cacheConcurrentStrategy = null;
        this.cacheRegion = null;
        this.cacheLazyProperty = true;
        this.queryCacheLayout = null;
        SharedCacheMode sharedCacheMode = this.context.getBuildingOptions().getSharedCacheMode();
        if (this.persistentClass instanceof RootClass) {
            this.bindRootClassCache(sharedCacheMode, this.context);
        } else {
            this.bindSubclassCache(sharedCacheMode);
        }
    }

    private void bindSubclassCache(SharedCacheMode sharedCacheMode) {
        if (this.annotatedClass.hasAnnotationUsage(Cache.class)) {
            String className = this.persistentClass.getClassName() == null ? this.annotatedClass.getName() : this.persistentClass.getClassName();
            throw new AnnotationException("Entity class '" + className + "' is annotated '@Cache' but it is a subclass in an entity inheritance hierarchy (only root classes may define second-level caching semantics)");
        }
        AnnotationUsage cacheable = this.annotatedClass.getAnnotationUsage(Cacheable.class);
        this.isCached = cacheable == null && this.persistentClass.getSuperclass() != null ? this.persistentClass.getSuperclass().isCached() : EntityBinder.isCacheable(sharedCacheMode, (AnnotationUsage<Cacheable>)cacheable);
    }

    private void bindRootClassCache(SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        AnnotationUsage<Cache> effectiveCache;
        AnnotationUsage<Cache> cache = this.annotatedClass.getAnnotationUsage(Cache.class);
        AnnotationUsage cacheable = this.annotatedClass.getAnnotationUsage(Cacheable.class);
        if (cache != null) {
            this.isCached = true;
            effectiveCache = cache;
        } else {
            effectiveCache = EntityBinder.buildCacheMock(this.annotatedClass, context);
            this.isCached = EntityBinder.isCacheable(sharedCacheMode, (AnnotationUsage<Cacheable>)cacheable);
        }
        this.cacheConcurrentStrategy = EntityBinder.resolveCacheConcurrencyStrategy((CacheConcurrencyStrategy)effectiveCache.getEnum("usage"));
        this.cacheRegion = effectiveCache.getString("region");
        this.cacheLazyProperty = EntityBinder.isCacheLazy(effectiveCache, this.annotatedClass);
        AnnotationUsage queryCache = this.annotatedClass.getAnnotationUsage(QueryCacheLayout.class);
        this.queryCacheLayout = queryCache == null ? null : (CacheLayout)queryCache.getEnum("layout");
    }

    private static boolean isCacheLazy(AnnotationUsage<Cache> effectiveCache, ClassDetails annotatedClass) {
        if (!effectiveCache.getBoolean("includeLazy").booleanValue()) {
            return false;
        }
        return switch (effectiveCache.getString("include").toLowerCase(Locale.ROOT)) {
            case "all" -> true;
            case "non-lazy" -> false;
            default -> throw new AnnotationException("Class '" + annotatedClass.getName() + "' has a '@Cache' with undefined option 'include=\"" + effectiveCache.getString("include") + "\"'");
        };
    }

    private static boolean isCacheable(SharedCacheMode sharedCacheMode, AnnotationUsage<Cacheable> explicitCacheableAnn) {
        return switch (sharedCacheMode) {
            case SharedCacheMode.ALL -> true;
            case SharedCacheMode.ENABLE_SELECTIVE, SharedCacheMode.UNSPECIFIED -> {
                if (explicitCacheableAnn != null && explicitCacheableAnn.getBoolean("value").booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case SharedCacheMode.DISABLE_SELECTIVE -> {
                if (explicitCacheableAnn == null || explicitCacheableAnn.getBoolean("value").booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static String resolveCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    private static AnnotationUsage<Cache> buildCacheMock(ClassDetails classDetails, MetadataBuildingContext context) {
        MutableAnnotationUsage cacheUsage = HibernateAnnotations.CACHE.createUsage((AnnotationTarget)classDetails, context.getMetadataCollector().getSourceModelBuildingContext());
        AnnotationUsageHelper.applyAttributeIfSpecified("region", classDetails.getName(), cacheUsage);
        AnnotationUsageHelper.applyAttributeIfSpecified("usage", (Object)EntityBinder.determineCacheConcurrencyStrategy(context), cacheUsage);
        return cacheUsage;
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(MetadataBuildingContext context) {
        return CacheConcurrencyStrategy.fromAccessType(context.getBuildingOptions().getImplicitCacheAccessType());
    }

    public void bindTableForDiscriminatedSubclass(String entityName) {
        if (!(this.persistentClass instanceof SingleTableSubclass)) {
            throw new AssertionFailure("Was expecting a discriminated subclass [" + SingleTableSubclass.class.getName() + "] but found [" + this.persistentClass.getClass().getName() + "] for entity [" + this.persistentClass.getEntityName() + "]");
        }
        InFlightMetadataCollector collector = this.context.getMetadataCollector();
        InFlightMetadataCollector.EntityTableXref superTableXref = collector.getEntityTableXref(entityName);
        org.hibernate.mapping.Table primaryTable = superTableXref.getPrimaryTable();
        collector.addEntityTableXref(this.persistentClass.getEntityName(), collector.getDatabase().toIdentifier(collector.getLogicalTableName(primaryTable)), primaryTable, superTableXref);
    }

    public void bindTable(String schema, String catalog, String tableName, List<AnnotationUsage<UniqueConstraint>> uniqueConstraints, String rowId, String viewQuery, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        String entityName = this.persistentClass.getEntityName();
        EntityTableNamingStrategyHelper namingStrategyHelper = new EntityTableNamingStrategyHelper(this.persistentClass.getClassName(), entityName, this.name);
        Identifier logicalName = StringHelper.isNotEmpty(tableName) ? namingStrategyHelper.handleExplicitName(tableName, this.context) : namingStrategyHelper.determineImplicitName(this.context);
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName, this.persistentClass.isAbstract(), uniqueConstraints, this.context, this.subselect, denormalizedSuperTableXref);
        table.setRowId(rowId);
        table.setViewQuery(viewQuery);
        this.context.getMetadataCollector().addEntityTableXref(entityName, logicalName, table, denormalizedSuperTableXref);
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        LOG.debugf("Bind entity %s on table %s", entityName, table.getName());
        ((TableOwner)((Object)this.persistentClass)).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    public void finalSecondaryTableFromAnnotationBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableFromAnnotationJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (!this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    private void createPrimaryColumnsToSecondaryTable(Object column, PropertyHolder propertyHolder, Join join) {
        AnnotatedJoinColumns annotatedJoinColumns;
        List joinColumnSource = (List)column;
        if (CollectionHelper.isEmpty(joinColumnSource)) {
            annotatedJoinColumns = this.createDefaultJoinColumn(propertyHolder);
        } else {
            List joinColumns;
            List pkJoinColumns;
            AnnotationUsage first = (AnnotationUsage)joinColumnSource.get(0);
            if (first.getAnnotationDescriptor().getAnnotationType().equals(PrimaryKeyJoinColumn.class)) {
                pkJoinColumns = joinColumnSource;
                joinColumns = null;
            } else if (first.getAnnotationDescriptor().getAnnotationType().equals(JoinColumn.class)) {
                pkJoinColumns = null;
                joinColumns = joinColumnSource;
            } else {
                throw new IllegalArgumentException("Expecting list of AnnotationUsages for either @JoinColumn or @PrimaryKeyJoinColumn, but got as list of AnnotationUsages for @" + first.getAnnotationDescriptor().getAnnotationType().getName());
            }
            annotatedJoinColumns = this.createJoinColumns(propertyHolder, pkJoinColumns, joinColumns);
        }
        for (AnnotatedJoinColumn joinColumn : annotatedJoinColumns.getJoinColumns()) {
            joinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, annotatedJoinColumns, this.context);
    }

    private AnnotatedJoinColumns createDefaultJoinColumn(PropertyHolder propertyHolder) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(this.context);
        joinColumns.setJoins(this.secondaryTables);
        joinColumns.setPropertyHolder(propertyHolder);
        AnnotatedJoinColumn.buildInheritanceJoinColumn(null, null, this.persistentClass.getIdentifier(), joinColumns, this.context);
        return joinColumns;
    }

    private AnnotatedJoinColumns createJoinColumns(PropertyHolder propertyHolder, List<AnnotationUsage<PrimaryKeyJoinColumn>> primaryKeyJoinColumns, List<AnnotationUsage<JoinColumn>> joinColumns) {
        int joinColumnCount;
        int n = joinColumnCount = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.size() : joinColumns.size();
        if (joinColumnCount == 0) {
            return this.createDefaultJoinColumn(propertyHolder);
        }
        AnnotatedJoinColumns columns = new AnnotatedJoinColumns();
        columns.setBuildingContext(this.context);
        columns.setJoins(this.secondaryTables);
        columns.setPropertyHolder(propertyHolder);
        for (int colIndex = 0; colIndex < joinColumnCount; ++colIndex) {
            AnnotationUsage<PrimaryKeyJoinColumn> primaryKeyJoinColumn = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.get(colIndex) : null;
            AnnotationUsage<JoinColumn> joinColumn = joinColumns != null ? joinColumns.get(colIndex) : null;
            AnnotatedJoinColumn.buildInheritanceJoinColumn(primaryKeyJoinColumn, joinColumn, this.persistentClass.getIdentifier(), columns, this.context);
        }
        return columns;
    }

    private void bindJoinToPersistentClass(Join join, AnnotatedJoinColumns joinColumns, MetadataBuildingContext context) {
        DependantValue key = new DependantValue(context, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(key);
        this.setForeignKeyNameIfDefined(join);
        key.setOnDeleteAction(null);
        TableBinder.bindForeignKey(this.persistentClass, null, joinColumns, key, false, context);
        key.sortProperties();
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setForeignKeyNameIfDefined(Join join) {
        String tableName = join.getTable().getQuotedName();
        AnnotationUsage<org.hibernate.annotations.Table> matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        SimpleValue key = (SimpleValue)join.getKey();
        if (matchingTable != null && !matchingTable.getNestedUsage("foreignKey").getString("name").isEmpty()) {
            key.setForeignKeyName(matchingTable.getNestedUsage("foreignKey").getString("name"));
        } else {
            AnnotationUsage<SecondaryTable> jpaSecondaryTable = this.findMatchingSecondaryTable(join);
            if (jpaSecondaryTable != null) {
                boolean noConstraintByDefault = this.context.getBuildingOptions().isNoConstraintByDefault();
                if (jpaSecondaryTable.getNestedUsage("foreignKey").getEnum("value") == ConstraintMode.NO_CONSTRAINT || jpaSecondaryTable.getNestedUsage("foreignKey").getEnum("value") == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                    key.disableForeignKey();
                } else {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(jpaSecondaryTable.getNestedUsage("foreignKey").getString("name")));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(jpaSecondaryTable.getNestedUsage("foreignKey").getString("foreignKeyDefinition")));
                }
            }
        }
    }

    private AnnotationUsage<SecondaryTable> findMatchingSecondaryTable(Join join) {
        String nameToMatch = join.getTable().getQuotedName();
        AnnotationUsage secondaryTable = this.annotatedClass.getSingleAnnotationUsage(SecondaryTable.class);
        if (secondaryTable != null && nameToMatch.equals(secondaryTable.getString("name"))) {
            return secondaryTable;
        }
        AnnotationUsage secondaryTables = this.annotatedClass.getAnnotationUsage(SecondaryTables.class);
        if (secondaryTables != null) {
            List nestedSecondaryTableList = secondaryTables.getList("value");
            for (AnnotationUsage nestedSecondaryTable : nestedSecondaryTableList) {
                if (nestedSecondaryTable == null || !nameToMatch.equals(nestedSecondaryTable.getString("name"))) continue;
                return nestedSecondaryTable;
            }
        }
        return null;
    }

    private AnnotationUsage<org.hibernate.annotations.Table> findMatchingComplementaryTableAnnotation(String tableName) {
        AnnotationUsage table = this.annotatedClass.getSingleAnnotationUsage(org.hibernate.annotations.Table.class);
        if (table != null && tableName.equals(table.getString("appliesTo"))) {
            return table;
        }
        AnnotationUsage tables = this.annotatedClass.getAnnotationUsage(Tables.class);
        if (tables != null) {
            for (AnnotationUsage nested : tables.getList("value")) {
                if (!tableName.equals(nested.getString("appliesTo"))) continue;
                return nested;
            }
        }
        return null;
    }

    private AnnotationUsage<SecondaryRow> findMatchingSecondaryRowAnnotation(String tableName) {
        AnnotationUsage row = this.annotatedClass.getSingleAnnotationUsage(SecondaryRow.class);
        if (row != null && (row.getString("table").isEmpty() || tableName.equals(row.getString("table")))) {
            return row;
        }
        AnnotationUsage tables = this.annotatedClass.getAnnotationUsage(SecondaryRows.class);
        if (tables != null) {
            List rowList = tables.getList("value");
            for (AnnotationUsage current : rowList) {
                if (!tableName.equals(current.getString("table"))) continue;
                return current;
            }
        }
        return null;
    }

    private <T extends Annotation, R extends Annotation> AnnotationUsage<T> findMatchingSqlAnnotation(String tableName, Class<T> annotationType, Class<R> repeatableType) {
        AnnotationUsage<T> sqlAnnotation = BinderHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, annotationType, this.context);
        if (sqlAnnotation != null && tableName.equals(sqlAnnotation.getString("table"))) {
            return sqlAnnotation;
        }
        AnnotationUsage repeatable = this.annotatedClass.getAnnotationUsage(repeatableType);
        if (repeatable != null) {
            for (AnnotationUsage nested : repeatable.getList("value")) {
                if (!tableName.equals(nested.getString("table"))) continue;
                return nested;
            }
        }
        return null;
    }

    public Join addJoinTable(AnnotationUsage<JoinTable> joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        return this.addJoin(holder, noDelayInPkColumnCreation, false, joinTable.getString("name"), joinTable.getString("schema"), joinTable.getString("catalog"), joinTable.getList("joinColumns"), joinTable.getList("uniqueConstraints"));
    }

    public Join addSecondaryTable(AnnotationUsage<SecondaryTable> secondaryTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, true, secondaryTable.getString("name"), secondaryTable.getString("schema"), secondaryTable.getString("catalog"), secondaryTable.getList("pkJoinColumns"), secondaryTable.getList("uniqueConstraints"));
        org.hibernate.mapping.Table table = join.getTable();
        new IndexBinder(this.context).bindIndexes(table, secondaryTable.getList("indexes"));
        return join;
    }

    private Join addJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, String name, String schema, String catalog, Object joinColumns, List<AnnotationUsage<UniqueConstraint>> uniqueConstraints) {
        QualifiedTableName logicalName = this.logicalTableName(name, schema, catalog);
        return this.createJoin(propertyHolder, noDelayInPkColumnCreation, secondaryTable, joinColumns, logicalName, TableBinder.buildAndFillTable(schema, catalog, logicalName.getTableName(), false, uniqueConstraints, this.context));
    }

    private QualifiedTableName logicalTableName(String name, String schema, String catalog) {
        return new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.context.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(name));
    }

    Join createJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, Object joinColumns, QualifiedTableName logicalName, org.hibernate.mapping.Table table) {
        Join join = new Join();
        this.persistentClass.addJoin(join);
        String entityName = this.persistentClass.getEntityName();
        InFlightMetadataCollector.EntityTableXref tableXref = this.context.getMetadataCollector().getEntityTableXref(entityName);
        assert (tableXref != null) : "Could not locate EntityTableXref for entity [" + entityName + "]";
        tableXref.addSecondaryTable(logicalName, join);
        join.setTable(table);
        LOG.debugf("Adding secondary table to entity %s -> %s", entityName, join.getTable().getName());
        this.handleSecondaryRowManagement(join);
        this.processSecondaryTableCustomSql(join);
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            String quotedName = table.getQuotedName();
            if (secondaryTable) {
                this.secondaryTablesFromAnnotation.put(quotedName, join);
                this.secondaryTableFromAnnotationJoins.put(quotedName, joinColumns);
            } else {
                this.secondaryTableJoins.put(quotedName, joinColumns);
            }
            this.secondaryTables.put(quotedName, join);
        }
        return join;
    }

    private void handleSecondaryRowManagement(Join join) {
        String tableName = join.getTable().getQuotedName();
        AnnotationUsage<org.hibernate.annotations.Table> matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        AnnotationUsage<SecondaryRow> matchingRow = this.findMatchingSecondaryRowAnnotation(tableName);
        if (matchingRow != null) {
            join.setInverse(matchingRow.getBoolean("owned") == false);
            join.setOptional(matchingRow.getBoolean("optional"));
        } else if (matchingTable != null) {
            join.setInverse(matchingTable.getBoolean("inverse"));
            join.setOptional(matchingTable.getBoolean("optional"));
        } else {
            join.setInverse(false);
            join.setOptional(true);
        }
    }

    private void processSecondaryTableCustomSql(Join join) {
        AnnotationUsage matchingTableDelete;
        String deleteSql;
        AnnotationUsage matchingTableUpdate;
        String matchingTableUpdateSql;
        AnnotationUsage matchingTableInsert;
        String matchingTableInsertSql;
        String tableName = join.getTable().getQuotedName();
        AnnotationUsage<org.hibernate.annotations.Table> matchingTable = this.findMatchingComplementaryTableAnnotation(tableName);
        AnnotationUsage<SQLInsert> sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, tableName);
        if (sqlInsert != null) {
            join.setCustomSQLInsert(sqlInsert.getString("sql").trim(), sqlInsert.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlInsert.getEnum("check")));
            Class expectationClass = sqlInsert.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                join.setInsertExpectation(expectationClass);
            }
        } else if (matchingTable != null && !(matchingTableInsertSql = (matchingTableInsert = matchingTable.getNestedUsage("sqlInsert")).getString("sql").trim()).isEmpty()) {
            join.setCustomSQLInsert(matchingTableInsertSql, matchingTableInsert.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)matchingTableInsert.getEnum("check")));
        }
        AnnotationUsage<SQLUpdate> sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, tableName);
        if (sqlUpdate != null) {
            join.setCustomSQLUpdate(sqlUpdate.getString("sql").trim(), sqlUpdate.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlUpdate.getEnum("check")));
            Class expectationClass = sqlUpdate.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                join.setUpdateExpectation(expectationClass);
            }
        } else if (matchingTable != null && !(matchingTableUpdateSql = (matchingTableUpdate = matchingTable.getNestedUsage("sqlUpdate")).getString("sql").trim()).isEmpty()) {
            join.setCustomSQLUpdate(matchingTableUpdateSql, matchingTableUpdate.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)matchingTableUpdate.getEnum("check")));
        }
        AnnotationUsage<SQLDelete> sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, tableName);
        if (sqlDelete != null) {
            join.setCustomSQLDelete(sqlDelete.getString("sql").trim(), sqlDelete.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)sqlDelete.getEnum("check")));
            Class expectationClass = sqlDelete.getClassDetails("verify").toJavaClass();
            if (expectationClass != Expectation.class) {
                join.setDeleteExpectation(expectationClass);
            }
        } else if (matchingTable != null && !(deleteSql = (matchingTableDelete = matchingTable.getNestedUsage("sqlDelete")).getString("sql").trim()).isEmpty()) {
            join.setCustomSQLDelete(deleteSql, matchingTableDelete.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)matchingTableDelete.getEnum("check")));
        }
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public void addFilter(AnnotationUsage<Filter> filter) {
        this.filters.add(filter);
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean ignoreIdAnnotations) {
        this.ignoreIdAnnotations = ignoreIdAnnotations;
    }

    private org.hibernate.mapping.Table findTable(String tableName) {
        for (org.hibernate.mapping.Table table : this.persistentClass.getTableClosure()) {
            if (!table.getQuotedName().equals(tableName)) continue;
            return table;
        }
        for (Join join : this.secondaryTables.values()) {
            if (!join.getTable().getQuotedName().equals(tableName)) continue;
            return join.getTable();
        }
        throw new AnnotationException("Entity '" + this.name + "' has a '@org.hibernate.annotations.Table' annotation which 'appliesTo' an unknown table named '" + tableName + "'");
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType propertyAccessType) {
        this.propertyAccessType = this.getExplicitAccessType((AnnotationTarget)this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = propertyAccessType;
        }
    }

    public AccessType getPropertyAccessor(AnnotationTarget element) {
        AccessType accessType = this.getExplicitAccessType(element);
        return accessType == null ? this.propertyAccessType : accessType;
    }

    public AccessType getExplicitAccessType(AnnotationTarget element) {
        AnnotationUsage access;
        AccessType accessType = null;
        if (element != null && (access = element.getAnnotationUsage(Access.class)) != null) {
            accessType = AccessType.getAccessStrategy((jakarta.persistence.AccessType)access.getEnum("value"));
        }
        return accessType;
    }

    public void bindFiltersInHierarchy() {
        AnnotatedClassType classType;
        this.bindFilters((AnnotationTarget)this.annotatedClass);
        for (ClassDetails classToProcess = this.annotatedClass.getSuperClass(); classToProcess != null && (classType = this.context.getMetadataCollector().getClassType(classToProcess)) == AnnotatedClassType.MAPPED_SUPERCLASS; classToProcess = classToProcess.getSuperClass()) {
            this.bindFilters((AnnotationTarget)classToProcess);
        }
    }

    private void bindFilters(AnnotationTarget element) {
        AnnotationUsage filter;
        AnnotationUsage<Filters> filters = BinderHelper.getOverridableAnnotation(element, Filters.class, this.context);
        if (filters != null) {
            for (AnnotationUsage filter2 : filters.getList("value")) {
                this.addFilter((AnnotationUsage<Filter>)filter2);
            }
        }
        if ((filter = element.getSingleAnnotationUsage(Filter.class)) != null) {
            this.addFilter((AnnotationUsage<Filter>)filter);
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements NamingStrategyHelper {
        private final String className;
        private final String entityName;
        private final String jpaEntityName;

        private EntityTableNamingStrategyHelper(String className, String entityName, String jpaEntityName) {
            this.className = className;
            this.entityName = entityName;
            this.jpaEntityName = jpaEntityName;
        }

        @Override
        public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(new ImplicitEntityNameSource(){
                private final EntityNaming entityNaming = new EntityNaming(){

                    @Override
                    public String getClassName() {
                        return className;
                    }

                    @Override
                    public String getEntityName() {
                        return entityName;
                    }

                    @Override
                    public String getJpaEntityName() {
                        return jpaEntityName;
                    }
                };

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return buildingContext;
                }
            });
        }

        @Override
        public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
            return EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext).getIdentifierHelper().toIdentifier(explicitName);
        }

        @Override
        public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext));
        }

        private static JdbcEnvironment jdbcEnvironment(MetadataBuildingContext buildingContext) {
            return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
        }
    }
}

