/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.FilterDef;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.usertype.UserType;

public class FilterDefBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FilterDefBinder.class);

    public static void bindFilterDefs(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(FilterDef.class, usage -> FilterDefBinder.bindFilterDef((AnnotationUsage<FilterDef>)usage, context));
    }

    public static void bindFilterDef(AnnotationUsage<FilterDef> filterDef, MetadataBuildingContext context) {
        Map<String, ManagedBean<Supplier<?>>> parameterResolvers;
        Map<String, JdbcMapping> paramJdbcMappings;
        String name = filterDef.getString("name");
        if (context.getMetadataCollector().getFilterDefinition(name) != null) {
            throw new AnnotationException("Multiple '@FilterDef' annotations define a filter named '" + name + "'");
        }
        List explicitParameters = filterDef.getList("parameters");
        if (explicitParameters.isEmpty()) {
            paramJdbcMappings = Collections.emptyMap();
            parameterResolvers = Collections.emptyMap();
        } else {
            paramJdbcMappings = new HashMap();
            parameterResolvers = new HashMap();
            for (AnnotationUsage explicitParameter : explicitParameters) {
                String parameterName = explicitParameter.getString("name");
                ClassDetails typeClassDetails = explicitParameter.getClassDetails("type");
                JdbcMapping jdbcMapping = FilterDefBinder.resolveFilterParamType(typeClassDetails.toJavaClass(), context);
                if (jdbcMapping == null) {
                    throw new MappingException(String.format(Locale.ROOT, "Unable to resolve type specified for parameter (%s) defined for @FilterDef (%s)", parameterName, name));
                }
                paramJdbcMappings.put(parameterName, jdbcMapping);
                ClassDetails resolverClassDetails = explicitParameter.getClassDetails("resolver");
                if (resolverClassDetails.getName().equals(Supplier.class.getName())) continue;
                parameterResolvers.put(explicitParameter.getString("name"), FilterDefBinder.resolveParamResolver(resolverClassDetails, context));
            }
        }
        FilterDefinition filterDefinition = new FilterDefinition(name, filterDef.getString("defaultCondition"), filterDef.getBoolean("autoEnabled"), paramJdbcMappings, parameterResolvers);
        LOG.debugf("Binding filter definition: %s", filterDefinition.getFilterName());
        context.getMetadataCollector().addFilterDefinition(filterDefinition);
    }

    private static ManagedBean<? extends Supplier<?>> resolveParamResolver(ClassDetails resolverClassDetails, MetadataBuildingContext context) {
        Class clazz = resolverClassDetails.toJavaClass();
        assert (clazz != Supplier.class);
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        return bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(clazz, bootstrapContext.getCustomTypeProducer());
    }

    public static JdbcMapping resolveFilterParamType(Class<?> type, MetadataBuildingContext context) {
        if (UserType.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveUserType(type, context);
        }
        if (AttributeConverter.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveAttributeConverter(type, context);
        }
        if (JavaType.class.isAssignableFrom(type)) {
            return AnnotationHelper.resolveJavaType(type, context);
        }
        return AnnotationHelper.resolveBasicType(type, context);
    }
}

