/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.boot.internal.GenerationStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.internal.IdentifierGeneratorUtil;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.IdentifierGeneratorCreator;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.jboss.logging.Logger;

public class GeneratorBinder {
    private static final Logger LOG = CoreLogging.logger(BinderHelper.class);

    public static void makeIdGenerator(SimpleValue id, MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext buildingContext, Map<String, IdentifierGeneratorDefinition> localGenerators) {
        LOG.debugf("#makeIdGenerator(%s, %s, %s, %s, ...)", new Object[]{id, idAttributeMember, generatorType, generatorName});
        Table table = id.getTable();
        table.setIdentifierValue(id);
        id.setIdentifierGeneratorStrategy(generatorType);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            parameters.put("target_column", id.getColumns().get(0).getName());
        }
        parameters.put("identifier_normalizer", buildingContext.getObjectNameNormalizer());
        parameters.put("GENERATOR_NAME", generatorName);
        if (!generatorName.isEmpty()) {
            boolean avoidOverriding;
            IdentifierGeneratorDefinition definition = GeneratorBinder.makeIdentifierGeneratorDefinition(generatorName, idAttributeMember, localGenerators, buildingContext);
            if (definition == null) {
                throw new AnnotationException("No id generator was declared with the name '" + generatorName + "' specified by '@GeneratedValue' (define a named generator using '@SequenceGenerator', '@TableGenerator', or '@GenericGenerator')");
            }
            String identifierGeneratorStrategy = definition.getStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo");
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
                if ("assigned".equals(identifierGeneratorStrategy)) {
                    id.setNullValue("undefined");
                }
            }
            parameters.putAll(definition.getParameters());
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorParameters(parameters);
    }

    public static void makeIdGenerator(SimpleValue id, MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition foreignKGeneratorDefinition) {
        HashMap<String, IdentifierGeneratorDefinition> localIdentifiers = null;
        if (foreignKGeneratorDefinition != null) {
            localIdentifiers = new HashMap<String, IdentifierGeneratorDefinition>();
            localIdentifiers.put(foreignKGeneratorDefinition.getName(), foreignKGeneratorDefinition);
        }
        GeneratorBinder.makeIdGenerator(id, idAttributeMember, generatorType, generatorName, buildingContext, localIdentifiers);
    }

    private static IdentifierGeneratorDefinition makeIdentifierGeneratorDefinition(String name, MemberDetails idAttributeMember, Map<String, IdentifierGeneratorDefinition> localGenerators, MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        LOG.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", (Object)name);
        AnnotationUsage generatedValue = idAttributeMember.getAnnotationUsage(GeneratedValue.class);
        if (generatedValue == null) {
            return new IdentifierGeneratorDefinition("assigned", "assigned");
        }
        return IdentifierGeneratorDefinition.createImplicit(name, idAttributeMember.getType().determineRawClass().toJavaClass(), generatedValue.getString("generator"), GeneratorBinder.interpretGenerationType((AnnotationUsage<GeneratedValue>)generatedValue));
    }

    private static GenerationType interpretGenerationType(AnnotationUsage<GeneratedValue> generatedValueAnn) {
        GenerationType strategy = (GenerationType)generatedValueAnn.getEnum("strategy");
        return strategy == null ? GenerationType.AUTO : strategy;
    }

    public static Map<String, IdentifierGeneratorDefinition> buildGenerators(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>();
        annotatedElement.forEachAnnotationUsage(TableGenerator.class, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildIdGenerator(usage, context);
            generators.put(idGenerator.getName(), idGenerator);
            metadataCollector.addIdentifierGenerator(idGenerator);
        });
        annotatedElement.forEachAnnotationUsage(SequenceGenerator.class, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildIdGenerator(usage, context);
            generators.put(idGenerator.getName(), idGenerator);
            metadataCollector.addIdentifierGenerator(idGenerator);
        });
        annotatedElement.forEachAnnotationUsage(GenericGenerator.class, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildIdGenerator(usage, context);
            generators.put(idGenerator.getName(), idGenerator);
            metadataCollector.addIdentifierGenerator(idGenerator);
        });
        return generators;
    }

    static String generatorType(MetadataBuildingContext context, ClassDetails entityXClass, boolean isComponent, AnnotationUsage<GeneratedValue> generatedValue) {
        if (isComponent) {
            return "assigned";
        }
        return generatedValue == null ? "assigned" : GeneratorBinder.generatorType(generatedValue, entityXClass, context);
    }

    static String generatorType(final AnnotationUsage<GeneratedValue> generatedValue, final ClassDetails javaClass, MetadataBuildingContext context) {
        return GenerationStrategyInterpreter.STRATEGY_INTERPRETER.determineGeneratorName((GenerationType)generatedValue.getEnum("strategy"), new GenerationStrategyInterpreter.GeneratorNameDeterminationContext(){
            Class<?> javaType = null;

            @Override
            public Class<?> getIdType() {
                if (this.javaType == null) {
                    this.javaType = javaClass.toJavaClass();
                }
                return this.javaType;
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValue.getString("generator");
            }
        });
    }

    static IdentifierGeneratorDefinition buildIdGenerator(AnnotationUsage<?> generatorAnnotation, MetadataBuildingContext context) {
        if (generatorAnnotation == null) {
            return null;
        }
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        if (TableGenerator.class.isAssignableFrom(generatorAnnotation.getAnnotationType())) {
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretTableGenerator(generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else if (SequenceGenerator.class.isAssignableFrom(generatorAnnotation.getAnnotationType())) {
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretSequenceGenerator(generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else if (GenericGenerator.class.isAssignableFrom(generatorAnnotation.getAnnotationType())) {
            AnnotationUsage<?> genericGenerator = generatorAnnotation;
            definitionBuilder.setName(genericGenerator.getString("name"));
            Class generatorClass = genericGenerator.getClassDetails("type").toJavaClass();
            String strategy = generatorClass.equals(Generator.class) ? genericGenerator.getString("strategy") : generatorClass.getName();
            definitionBuilder.setStrategy(strategy);
            definitionBuilder.addParams(AnnotationHelper.extractParameterMap(genericGenerator.getList("parameters")));
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + generatorAnnotation);
        }
        return definitionBuilder.build();
    }

    private static void checkGeneratorClass(Class<? extends Generator> generatorClass) {
        if (!BeforeExecutionGenerator.class.isAssignableFrom(generatorClass) && !OnExecutionGenerator.class.isAssignableFrom(generatorClass)) {
            throw new MappingException("Generator class '" + generatorClass.getName() + "' must implement either 'BeforeExecutionGenerator' or 'OnExecutionGenerator'");
        }
    }

    private static void checkGeneratorInterfaces(Class<? extends Generator> generatorClass) {
        if (IdentifierGenerator.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'IdentifierGenerator' and may not be used with '@ValueGenerationType'");
        }
        if (ExportableProducer.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'ExportableProducer' and may not be used with '@ValueGenerationType'");
        }
    }

    static GeneratorCreator generatorCreator(MemberDetails member, AnnotationUsage<?> annotation) {
        Class annotationType = annotation.getAnnotationType();
        ValueGenerationType generatorAnnotation = annotationType.getAnnotation(ValueGenerationType.class);
        if (generatorAnnotation == null) {
            return null;
        }
        Class<? extends Generator> generatorClass = generatorAnnotation.generatedBy();
        GeneratorBinder.checkGeneratorClass(generatorClass);
        GeneratorBinder.checkGeneratorInterfaces(generatorClass);
        return creationContext -> {
            Object generator = GeneratorBinder.instantiateGenerator(annotation, member, annotationType, creationContext, GeneratorCreationContext.class, generatorClass);
            GeneratorBinder.callInitialize(annotation, member, creationContext, generator);
            GeneratorBinder.checkVersionGenerationAlways(member, generator);
            return generator;
        };
    }

    static IdentifierGeneratorCreator identifierGeneratorCreator(MemberDetails idAttributeMember, AnnotationUsage<? extends Annotation> annotation) {
        Class annotationType = annotation.getAnnotationType();
        IdGeneratorType idGeneratorType = annotationType.getAnnotation(IdGeneratorType.class);
        assert (idGeneratorType != null);
        return creationContext -> {
            Class<? extends Generator> generatorClass = idGeneratorType.value();
            GeneratorBinder.checkGeneratorClass(generatorClass);
            Generator generator = GeneratorBinder.instantiateGenerator(annotation, idAttributeMember, annotationType, creationContext, CustomIdGeneratorCreationContext.class, generatorClass);
            GeneratorBinder.callInitialize(annotation, idAttributeMember, creationContext, generator);
            GeneratorBinder.callConfigure(creationContext, generator);
            GeneratorBinder.checkIdGeneratorTiming(annotationType, generator);
            return generator;
        };
    }

    private static <C, G extends Generator> G instantiateGenerator(AnnotationUsage<?> annotation, MemberDetails memberDetails, Class<? extends Annotation> annotationType, C creationContext, Class<C> contextClass, Class<? extends G> generatorClass) {
        try {
            try {
                return (G)((Generator)generatorClass.getConstructor(annotationType, Member.class, contextClass).newInstance(annotation.toAnnotation(), memberDetails.toJavaMember(), creationContext));
            }
            catch (NoSuchMethodException ignore) {
                try {
                    return (G)((Generator)generatorClass.getConstructor(annotationType).newInstance(annotation.toAnnotation()));
                }
                catch (NoSuchMethodException i) {
                    return (G)((Generator)generatorClass.newInstance());
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new HibernateException("Could not instantiate generator of type '" + generatorClass.getName() + "'", e);
        }
    }

    private static <A extends Annotation> void callInitialize(AnnotationUsage<A> annotation, MemberDetails memberDetails, GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof AnnotationBasedGenerator) {
            AnnotationBasedGenerator generation = (AnnotationBasedGenerator)generator;
            generation.initialize(annotation.toAnnotation(), memberDetails.toJavaMember(), creationContext);
        }
    }

    private static void checkVersionGenerationAlways(MemberDetails property, Generator generator) {
        if (property.hasAnnotationUsage(Version.class)) {
            if (!generator.generatesOnInsert()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on inserts");
            }
            if (!generator.generatesOnUpdate()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on updates");
            }
        }
    }

    private static void callConfigure(GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof Configurable) {
            Value value = creationContext.getProperty().getValue();
            ((Configurable)((Object)generator)).configure(value.getType(), IdentifierGeneratorUtil.collectParameters((SimpleValue)value, creationContext.getDatabase().getDialect(), creationContext.getDefaultCatalog(), creationContext.getDefaultSchema(), creationContext.getPersistentClass().getRootClass()), creationContext.getServiceRegistry());
        }
    }

    private static void checkIdGeneratorTiming(Class<? extends Annotation> annotationType, Generator generator) {
        if (!generator.generatesOnInsert()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' does not generate on inserts");
        }
        if (generator.generatesOnUpdate()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' generates on updates (it must generate only on inserts)");
        }
    }

    static void createIdGenerator(SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, ClassDetails entityClass, MemberDetails idAttributeMember) {
        String generatorName;
        AnnotationUsage generatedValue = idAttributeMember.getAnnotationUsage(GeneratedValue.class);
        String generatorType = GeneratorBinder.generatorType(context, entityClass, BinderHelper.isCompositeId(entityClass, idAttributeMember), (AnnotationUsage<GeneratedValue>)generatedValue);
        String string = generatorName = generatedValue == null ? "" : generatedValue.getString("generator");
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            GeneratorBinder.buildGenerators((AnnotationTarget)idAttributeMember, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass(idValue, idAttributeMember, generatorType, generatorName, context));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.putAll(GeneratorBinder.buildGenerators((AnnotationTarget)idAttributeMember, context));
            GeneratorBinder.makeIdGenerator(idValue, idAttributeMember, generatorType, generatorName, context, generators);
        }
    }

    static IdentifierGeneratorDefinition createForeignGenerator(PropertyData mapsIdProperty) {
        IdentifierGeneratorDefinition.Builder foreignGeneratorBuilder = new IdentifierGeneratorDefinition.Builder();
        foreignGeneratorBuilder.setName("Hibernate-local--foreign generator");
        foreignGeneratorBuilder.setStrategy("foreign");
        foreignGeneratorBuilder.addParam("property", mapsIdProperty.getPropertyName());
        return foreignGeneratorBuilder.build();
    }
}

