/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.MemberDetails;

public class IdGeneratorResolverSecondPass
implements SecondPass {
    private final SimpleValue id;
    private final MemberDetails idAttributeMember;
    private final String generatorType;
    private final String generatorName;
    private final MetadataBuildingContext buildingContext;
    private IdentifierGeneratorDefinition localIdentifierGeneratorDefinition;

    public IdGeneratorResolverSecondPass(SimpleValue id, MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext buildingContext) {
        this.id = id;
        this.idAttributeMember = idAttributeMember;
        this.generatorType = generatorType;
        this.generatorName = generatorName;
        this.buildingContext = buildingContext;
    }

    public IdGeneratorResolverSecondPass(SimpleValue id, MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition localIdentifierGeneratorDefinition) {
        this(id, idAttributeMember, generatorType, generatorName, buildingContext);
        this.localIdentifierGeneratorDefinition = localIdentifierGeneratorDefinition;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> idGeneratorDefinitionMap) throws MappingException {
        GeneratorBinder.makeIdGenerator(this.id, this.idAttributeMember, this.generatorType, this.generatorName, this.buildingContext, this.localIdentifierGeneratorDefinition);
    }
}

