/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.OrderBy;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.CollectionSecondPass;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.List;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;

public class ListBinder
extends CollectionBinder {
    public ListBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, false, buildingContext);
    }

    private List getList() {
        return (List)this.collection;
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new List(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    public void setSqlOrderBy(AnnotationUsage<OrderBy> orderByAnn) {
        if (orderByAnn != null) {
            throw new AnnotationException("A collection of type 'List' is annotated '@OrderBy'");
        }
    }

    @Override
    public SecondPass getSecondPass() {
        return new CollectionSecondPass(this.collection){

            @Override
            public void secondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
                ListBinder.this.bindStarToManySecondPass(persistentClasses);
                ListBinder.this.bindIndex();
            }
        };
    }

    private void bindIndex() {
        CollectionPropertyHolder valueHolder = PropertyHolderBuilder.buildPropertyHolder(this.collection, StringHelper.qualify(this.collection.getRole(), "key"), null, null, this.propertyHolder, this.getBuildingContext());
        if (!this.collection.isOneToMany()) {
            this.indexColumn.forceNotNull();
        }
        this.indexColumn.getParent().setPropertyHolder(valueHolder);
        BasicValueBinder valueBinder = new BasicValueBinder(BasicValueBinder.Kind.LIST_INDEX, this.buildingContext);
        valueBinder.setColumns(this.indexColumn.getParent());
        valueBinder.setReturnedClassName(Integer.class.getName());
        valueBinder.setType(this.property, this.getElementType(), null, null);
        BasicValue indexValue = valueBinder.make();
        this.indexColumn.linkWithValue(indexValue);
        List list = this.getList();
        list.setIndex(indexValue);
        list.setBaseIndex(this.indexColumn.getBase());
        this.createBackref();
    }

    private void createBackref() {
        if (this.collection.isOneToMany() && !this.collection.getKey().isNullable() && !this.collection.isInverse()) {
            String entityName = ((OneToMany)this.collection.getElement()).getReferencedEntityName();
            PersistentClass referenced = this.buildingContext.getMetadataCollector().getEntityBinding(entityName);
            IndexBackref backref = new IndexBackref();
            backref.setName("_" + this.propertyName + "IndexBackref");
            backref.setOptional(true);
            backref.setUpdateable(false);
            backref.setSelectable(false);
            backref.setCollectionRole(this.collection.getRole());
            backref.setEntityName(this.collection.getOwner().getEntityName());
            List list = this.getList();
            backref.setValue(list.getIndex());
            referenced.addProperty(backref);
        }
    }
}

