/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.MapKeyJoinColumns;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.MapKeyCompositeType;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.CollectionSecondPass;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantBasicValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserCollectionType;

public class MapBinder
extends CollectionBinder {
    public MapBinder(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, boolean sorted, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, sorted, buildingContext);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    private Map getMap() {
        return (Map)this.collection;
    }

    @Override
    protected Collection createCollection(PersistentClass owner) {
        return new Map(this.getCustomTypeBeanResolver(), owner, this.getBuildingContext());
    }

    @Override
    SecondPass getSecondPass() {
        return new CollectionSecondPass(this.collection){

            @Override
            public void secondPass(java.util.Map<String, PersistentClass> persistentClasses) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(persistentClasses);
                MapBinder.this.bindKeyFromAssociationTable(MapBinder.this.getElementType(), persistentClasses, MapBinder.this.hasMapKeyProperty, MapBinder.this.mapKeyPropertyName, MapBinder.this.property, MapBinder.this.isEmbedded, MapBinder.this.mapKeyColumns, MapBinder.this.mapKeyManyToManyColumns);
                MapBinder.this.makeOneToManyMapKeyColumnNullableIfNotInProperty(MapBinder.this.property);
            }
        };
    }

    private void makeOneToManyMapKeyColumnNullableIfNotInProperty(MemberDetails property) {
        Map map = (Map)this.collection;
        if (map.isOneToMany() && property.hasAnnotationUsage(MapKeyColumn.class)) {
            PersistentClass persistentClass;
            Value indexValue = map.getIndex();
            if (indexValue.getColumnSpan() != 1) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn does not have 1 column");
            }
            Selectable selectable = indexValue.getSelectables().get(0);
            if (selectable.isFormula()) {
                throw new AssertionFailure("Map key mapped by @MapKeyColumn is a Formula");
            }
            Column column = (Column)selectable;
            if (!column.isNullable() && !this.propertiesContainColumn((persistentClass = ((OneToMany)map.getElement()).getAssociatedClass()).getUnjoinedProperties(), column)) {
                column.setNullable(true);
            }
        }
    }

    private boolean propertiesContainColumn(List<Property> properties, Column column) {
        for (Property property : properties) {
            for (Selectable selectable : property.getSelectables()) {
                if (!column.equals(selectable)) continue;
                Column iteratedColumn = (Column)selectable;
                if (!column.getValue().getTable().equals(iteratedColumn.getValue().getTable())) continue;
                return true;
            }
        }
        return false;
    }

    private void bindKeyFromAssociationTable(TypeDetails elementType, java.util.Map<String, PersistentClass> persistentClasses, boolean hasMapKeyProperty, String mapKeyPropertyName, MemberDetails property, boolean isEmbedded, AnnotatedColumns mapKeyColumns, AnnotatedJoinColumns mapKeyManyToManyColumns) {
        if (hasMapKeyProperty) {
            this.handleMapKeyProperty(elementType, persistentClasses, mapKeyPropertyName);
        } else {
            this.handleMapKey(persistentClasses, property, isEmbedded, mapKeyColumns, mapKeyManyToManyColumns);
        }
    }

    private void handleMapKey(java.util.Map<String, PersistentClass> persistentClasses, MemberDetails property, boolean isEmbedded, AnnotatedColumns mapKeyColumns, AnnotatedJoinColumns mapKeyManyToManyColumns) {
        boolean isKeyedByEntities;
        String mapKeyType = MapBinder.getKeyType(property);
        PersistentClass collectionEntity = persistentClasses.get(mapKeyType);
        boolean bl = isKeyedByEntities = collectionEntity != null;
        if (isKeyedByEntities) {
            ManyToOne element = this.handleCollectionKeyedByEntities(mapKeyType);
            this.handleForeignKey(property, element);
            this.bindManyToManyInverseForeignKey(collectionEntity, mapKeyManyToManyColumns, element, false);
        } else {
            ClassDetails keyClass = this.mapKeyClass(mapKeyType);
            ClassTypeDetailsImpl keyTypeDetails = new ClassTypeDetailsImpl(keyClass, TypeDetails.Kind.CLASS);
            this.handleMapKey(property, mapKeyColumns, mapKeyType, (TypeDetails)keyTypeDetails, this.annotatedMapKeyType(property, isEmbedded, mapKeyType, (TypeDetails)keyTypeDetails), this.buildCollectionPropertyHolder(property, (TypeDetails)keyTypeDetails), MapBinder.accessType(property, this.collection.getOwner()));
        }
        if (!this.collection.isOneToMany()) {
            for (AnnotatedJoinColumn column : mapKeyManyToManyColumns.getJoinColumns()) {
                column.forceNotNull();
            }
        }
    }

    private AnnotatedClassType annotatedMapKeyType(MemberDetails property, boolean isEmbedded, String mapKeyType, TypeDetails keyTypeDetails) {
        if (BinderHelper.isPrimitive(mapKeyType)) {
            return AnnotatedClassType.NONE;
        }
        return isEmbedded || this.mappingDefinedAttributeOverrideOnMapKey(property) ? AnnotatedClassType.EMBEDDABLE : this.buildingContext.getMetadataCollector().getClassType(keyTypeDetails.determineRawClass());
    }

    private ClassDetails mapKeyClass(String mapKeyType) {
        if (BinderHelper.isPrimitive(mapKeyType)) {
            return null;
        }
        return this.buildingContext.getMetadataCollector().getSourceModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(mapKeyType);
    }

    private static String getKeyType(MemberDetails property) {
        AnnotationUsage mapKeyClassAnn = property.getAnnotationUsage(MapKeyClass.class);
        Class target = mapKeyClassAnn != null ? mapKeyClassAnn.getClassDetails("value").toJavaClass() : Void.TYPE;
        return Void.TYPE.equals(target) ? property.getMapKeyType().getName() : target.getName();
    }

    private void handleMapKeyProperty(TypeDetails elementType, java.util.Map<String, PersistentClass> persistentClasses, String mapKeyPropertyName) {
        PersistentClass associatedClass = persistentClasses.get(elementType.getName());
        if (associatedClass == null) {
            throw new AnnotationException("Association '" + this.safeCollectionRole() + "'" + MapBinder.targetEntityMessage(elementType));
        }
        Property mapProperty = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
        if (mapProperty == null) {
            throw new AnnotationException("Map key property '" + mapKeyPropertyName + "' not found in target entity '" + associatedClass.getEntityName() + "'");
        }
        InheritanceState inheritanceState = (InheritanceState)this.inheritanceStatePerClass.get(elementType.determineRawClass());
        PersistentClass targetEntity = InheritanceType.JOINED == inheritanceState.getType() ? mapProperty.getPersistentClass() : associatedClass;
        Value indexValue = this.createFormulatedValue(mapProperty.getValue(), this.collection, associatedClass, targetEntity);
        this.getMap().setIndex(indexValue);
        this.getMap().setMapKeyPropertyName(mapKeyPropertyName);
    }

    private CollectionPropertyHolder buildCollectionPropertyHolder(MemberDetails property, TypeDetails keyClass) {
        return this.buildCollectionPropertyHolder(property, keyClass.determineRawClass());
    }

    private CollectionPropertyHolder buildCollectionPropertyHolder(MemberDetails property, ClassDetails keyClass) {
        CollectionPropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(this.collection, StringHelper.qualify(this.collection.getRole(), "mapkey"), keyClass, property, this.propertyHolder, this.buildingContext);
        this.propertyHolder.startingProperty(property);
        holder.prepare(property, !(this.collection.getKey().getType() instanceof BasicType));
        return holder;
    }

    private void handleForeignKey(MemberDetails property, ManyToOne element) {
        AnnotationUsage<ForeignKey> foreignKey = this.getMapKeyForeignKey(property);
        if (foreignKey != null) {
            ConstraintMode constraintMode = (ConstraintMode)foreignKey.getEnum("value");
            if (constraintMode == ConstraintMode.NO_CONSTRAINT || constraintMode == ConstraintMode.PROVIDER_DEFAULT && this.getBuildingContext().getBuildingOptions().isNoConstraintByDefault()) {
                element.disableForeignKey();
            } else {
                element.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.getString("name")));
                element.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.getString("foreignKeyDefinition")));
            }
        }
    }

    private ManyToOne handleCollectionKeyedByEntities(String mapKeyType) {
        ManyToOne element = new ManyToOne(this.buildingContext, this.collection.getCollectionTable());
        this.getMap().setIndex(element);
        element.setReferencedEntityName(mapKeyType);
        element.setFetchMode(FetchMode.JOIN);
        element.setLazy(false);
        return element;
    }

    private void handleMapKey(MemberDetails property, AnnotatedColumns mapKeyColumns, String mapKeyType, TypeDetails keyTypeDetails, AnnotatedClassType classType, CollectionPropertyHolder holder, AccessType accessType) {
        Class<? extends CompositeUserType<?>> compositeUserType = MapBinder.resolveCompositeUserType(property, keyTypeDetails, this.buildingContext);
        if (classType == AnnotatedClassType.EMBEDDABLE || compositeUserType != null) {
            this.handleCompositeMapKey(keyTypeDetails, holder, accessType, compositeUserType);
        } else {
            this.handleMapKey(property, mapKeyColumns, mapKeyType, keyTypeDetails, holder, accessType);
        }
    }

    private void handleMapKey(MemberDetails property, AnnotatedColumns mapKeyColumns, String mapKeyType, TypeDetails keyTypeDetails, CollectionPropertyHolder holder, AccessType accessType) {
        BasicValueBinder elementBinder = new BasicValueBinder(BasicValueBinder.Kind.MAP_KEY, this.buildingContext);
        elementBinder.setReturnedClassName(mapKeyType);
        AnnotatedColumns keyColumns = MapBinder.createElementColumnsIfNecessary(this.collection, mapKeyColumns, "id", 255L, this.buildingContext);
        elementBinder.setColumns(keyColumns);
        elementBinder.setType(property, keyTypeDetails, this.collection.getOwnerEntityName(), holder.mapKeyAttributeConverterDescriptor(property, keyTypeDetails));
        elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
        elementBinder.setAccessType(accessType);
        this.getMap().setIndex(elementBinder.make());
    }

    private void handleCompositeMapKey(TypeDetails keyTypeDetails, CollectionPropertyHolder holder, AccessType accessType, Class<? extends CompositeUserType<?>> compositeUserType) {
        this.getMap().setIndex(EmbeddableBinder.fillEmbeddable(holder, this.propertyPreloadedData(keyTypeDetails), accessType, true, new EntityBinder(), false, false, true, null, compositeUserType, null, this.buildingContext, this.inheritanceStatePerClass));
    }

    private PropertyPreloadedData propertyPreloadedData(TypeDetails keyTypeDetails) {
        return this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "index", keyTypeDetails) : new PropertyPreloadedData(AccessType.PROPERTY, "key", keyTypeDetails);
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(MemberDetails property, TypeDetails returnedClass, MetadataBuildingContext context) {
        AnnotationUsage compositeType = property.getAnnotationUsage(MapKeyCompositeType.class);
        if (compositeType != null) {
            ClassDetails compositeTypeImplDetails = compositeType.getClassDetails("value");
            return compositeTypeImplDetails.toJavaClass();
        }
        if (returnedClass != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(returnedClass.determineRawClass().toJavaClass());
        }
        return null;
    }

    private AnnotationUsage<ForeignKey> getMapKeyForeignKey(MemberDetails property) {
        AnnotationUsage mapKeyJoinColumns = property.getAnnotationUsage(MapKeyJoinColumns.class);
        AnnotationUsage mapKeyJoinColumn = property.getSingleAnnotationUsage(MapKeyJoinColumn.class);
        if (mapKeyJoinColumns != null) {
            return mapKeyJoinColumns.getNestedUsage("foreignKey");
        }
        if (mapKeyJoinColumn != null) {
            return mapKeyJoinColumn.getNestedUsage("foreignKey");
        }
        return null;
    }

    private boolean mappingDefinedAttributeOverrideOnMapKey(MemberDetails property) {
        if (property.hasAnnotationUsage(AttributeOverride.class)) {
            return this.namedMapKey((AnnotationUsage<AttributeOverride>)property.getAnnotationUsage(AttributeOverride.class));
        }
        if (property.hasAnnotationUsage(AttributeOverrides.class)) {
            AnnotationUsage annotations = property.getAnnotationUsage(AttributeOverrides.class);
            for (AnnotationUsage attributeOverride : annotations.getList("value")) {
                if (!this.namedMapKey((AnnotationUsage<AttributeOverride>)attributeOverride)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean namedMapKey(AnnotationUsage<AttributeOverride> annotation) {
        return annotation.getString("name").startsWith("key.");
    }

    private Value createFormulatedValue(Value value, Collection collection, PersistentClass associatedClass, PersistentClass targetPropertyPersistentClass) {
        Table mapKeyTable;
        if (value instanceof Component) {
            return this.createIndexComponent(collection, associatedClass, (Component)value);
        }
        Table table = mapKeyTable = !associatedClass.equals(targetPropertyPersistentClass) ? targetPropertyPersistentClass.getTable() : associatedClass.getTable();
        if (value instanceof BasicValue) {
            return this.createDependantBasicValue(mapKeyTable, (BasicValue)value);
        }
        if (value instanceof SimpleValue) {
            return this.createTargetValue(mapKeyTable, (SimpleValue)value);
        }
        throw new AssertionFailure("Unknown type encountered for map key: " + value.getClass());
    }

    private SimpleValue createTargetValue(Table mapKeyTable, SimpleValue sourceValue) {
        SimpleValue targetValue;
        if (sourceValue instanceof ManyToOne) {
            ManyToOne sourceManyToOne = (ManyToOne)sourceValue;
            ManyToOne targetManyToOne = new ManyToOne(this.getBuildingContext(), mapKeyTable);
            targetManyToOne.setFetchMode(FetchMode.DEFAULT);
            targetManyToOne.setLazy(true);
            targetManyToOne.setReferencedEntityName(sourceManyToOne.getReferencedEntityName());
            targetValue = targetManyToOne;
        } else {
            targetValue = new BasicValue(this.getBuildingContext(), mapKeyTable);
            ((SimpleValue)targetValue).copyTypeFrom(sourceValue);
        }
        for (Selectable selectable : sourceValue.getSelectables()) {
            MapBinder.addSelectable(targetValue, selectable);
        }
        return targetValue;
    }

    private DependantBasicValue createDependantBasicValue(Table mapKeyTable, BasicValue sourceValue) {
        DependantBasicValue dependantBasicValue = new DependantBasicValue(this.getBuildingContext(), mapKeyTable, sourceValue, false, false);
        MapBinder.addSelectable(dependantBasicValue, sourceValue.getColumn());
        return dependantBasicValue;
    }

    private static void addSelectable(SimpleValue targetValue, Selectable selectable) {
        if (selectable instanceof Column) {
            targetValue.addColumn(((Column)selectable).clone(), false, false);
        } else if (selectable instanceof Formula) {
            targetValue.addFormula(new Formula(((Formula)selectable).getFormula()));
        } else {
            throw new AssertionFailure("Unknown element in column iterator: " + selectable.getClass());
        }
    }

    private Component createIndexComponent(Collection collection, PersistentClass associatedClass, Component component) {
        Component indexComponent = new Component(this.getBuildingContext(), collection);
        indexComponent.setComponentClassName(component.getComponentClassName());
        for (Property property : component.getProperties()) {
            Property newProperty = new Property();
            newProperty.setCascade(property.getCascade());
            newProperty.setValueGeneratorCreator(property.getValueGeneratorCreator());
            newProperty.setInsertable(false);
            newProperty.setUpdateable(false);
            newProperty.setMetaAttributes(property.getMetaAttributes());
            newProperty.setName(property.getName());
            newProperty.setNaturalIdentifier(false);
            newProperty.setOptional(false);
            newProperty.setPersistentClass(property.getPersistentClass());
            newProperty.setPropertyAccessorName(property.getPropertyAccessorName());
            newProperty.setSelectable(property.isSelectable());
            newProperty.setValue(this.createFormulatedValue(property.getValue(), collection, associatedClass, associatedClass));
            indexComponent.addProperty(newProperty);
        }
        return indexComponent;
    }
}

