/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Column;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyJoinColumn;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;

public class MapKeyJoinColumnDelegator
implements JoinColumn {
    private final MapKeyJoinColumn column;

    public MapKeyJoinColumnDelegator(AnnotationUsage<MapKeyJoinColumn> column) {
        this((MapKeyJoinColumn)column.toAnnotation());
    }

    public MapKeyJoinColumnDelegator(MapKeyJoinColumn column) {
        this.column = column;
    }

    public static MutableAnnotationUsage<JoinColumn> fromMapKeyJoinColumn(AnnotationUsage<MapKeyJoinColumn> mapKeyJoinColumn, MemberDetails attributeMember, MetadataBuildingContext context) {
        MutableAnnotationUsage joinColumn = JpaAnnotations.JOIN_COLUMN.createUsage((AnnotationTarget)attributeMember, context.getMetadataCollector().getSourceModelBuildingContext());
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", (String)mapKeyJoinColumn.getAttributeValue("name"), joinColumn);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("table", (String)mapKeyJoinColumn.getAttributeValue("table"), joinColumn);
        AnnotationUsageHelper.applyAttributeIfSpecified("unique", mapKeyJoinColumn.getAttributeValue("unique"), joinColumn);
        AnnotationUsageHelper.applyAttributeIfSpecified("nullable", mapKeyJoinColumn.getAttributeValue("nullable"), joinColumn);
        AnnotationUsageHelper.applyAttributeIfSpecified("insertable", mapKeyJoinColumn.getAttributeValue("insertable"), joinColumn);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("referencedColumnName", (String)mapKeyJoinColumn.getAttributeValue("referencedColumnName"), joinColumn);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("columnDefinition", (String)mapKeyJoinColumn.getAttributeValue("columnDefinition"), joinColumn);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("options", (String)mapKeyJoinColumn.getAttributeValue("options"), joinColumn);
        AnnotationUsageHelper.applyAttributeIfSpecified("foreignKey", mapKeyJoinColumn.getAttributeValue("foreignKey"), joinColumn);
        return joinColumn;
    }

    public String name() {
        return this.column.name();
    }

    public String referencedColumnName() {
        return this.column.referencedColumnName();
    }

    public boolean unique() {
        return this.column.unique();
    }

    public boolean nullable() {
        return this.column.nullable();
    }

    public boolean insertable() {
        return this.column.insertable();
    }

    public boolean updatable() {
        return this.column.updatable();
    }

    public String columnDefinition() {
        return this.column.columnDefinition();
    }

    public String options() {
        return this.column.options();
    }

    public String table() {
        return this.column.table();
    }

    public ForeignKey foreignKey() {
        return this.column.foreignKey();
    }

    public CheckConstraint[] check() {
        return new CheckConstraint[0];
    }

    public String comment() {
        return "";
    }

    public Class<? extends Annotation> annotationType() {
        return Column.class;
    }
}

