/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AttributeBinderType;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.AnyBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CannotForceNonNullableException;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.ColumnsBuilder;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.OptionalDeterminationSecondPass;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.usertype.CompositeUserType;
import org.jboss.logging.Logger;

public class PropertyBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PropertyBinder.class.getName());
    private MetadataBuildingContext buildingContext;
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String lazyGroup;
    private AccessType accessType;
    private AnnotatedColumns columns;
    private PropertyHolder holder;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private BasicValueBinder basicValueBinder;
    private ClassDetails declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean toMany;
    private String referencedEntityName;
    private MemberDetails memberDetails;
    private TypeDetails returnedClass;
    private boolean isId;
    private Map<ClassDetails, InheritanceState> inheritanceStatePerClass;

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setDeclaringClass(ClassDetails declaringClassDetails) {
        this.declaringClass = declaringClassDetails;
        this.declaringClassSet = true;
    }

    private boolean isToOneValue(Value value) {
        return value instanceof ToOne;
    }

    public void setMemberDetails(MemberDetails memberDetails) {
        this.memberDetails = memberDetails;
    }

    public void setReturnedClass(TypeDetails returnedClass) {
        this.returnedClass = returnedClass;
    }

    public BasicValueBinder getBasicValueBinder() {
        return this.basicValueBinder;
    }

    public Value getValue() {
        return this.value;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setInheritanceStatePerClass(Map<ClassDetails, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    private void validateBind() {
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        LOG.debugf("MetadataSourceProcessor property %s with lazy=%s", this.name, this.lazy);
        String containerClassName = this.holder.getClassName();
        this.holder.startingProperty(this.memberDetails);
        this.basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, this.buildingContext);
        this.basicValueBinder.setPropertyName(this.name);
        this.basicValueBinder.setReturnedClassName(this.returnedClassName);
        this.basicValueBinder.setColumns(this.columns);
        this.basicValueBinder.setPersistentClassName(containerClassName);
        this.basicValueBinder.setType(this.memberDetails, this.returnedClass, containerClassName, this.holder.resolveAttributeConverterDescriptor(this.memberDetails));
        this.basicValueBinder.setReferencedEntityName(this.referencedEntityName);
        this.basicValueBinder.setAccessType(this.accessType);
        this.value = this.basicValueBinder.make();
        return this.makeProperty();
    }

    private void callAttributeBinders(Property property, Map<String, PersistentClass> persistentClasses) {
        for (AnnotationUsage binderAnnotationUsage : this.memberDetails.getMetaAnnotated(AttributeBinderType.class)) {
            AttributeBinderType binderType = binderAnnotationUsage.getAnnotationType().getAnnotation(AttributeBinderType.class);
            try {
                AttributeBinder<?> binder = binderType.binder().getConstructor(new Class[0]).newInstance(new Object[0]);
                PersistentClass persistentClass = this.entityBinder != null ? this.entityBinder.getPersistentClass() : persistentClasses.get(this.holder.getEntityName());
                binder.bind(binderAnnotationUsage.toAnnotation(), this.buildingContext, persistentClass, property);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @AttributeBinderType annotation '" + binderAnnotationUsage.getAnnotationType() + "'", e);
            }
        }
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    public Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    private Property bind(Property property) {
        if (this.isId) {
            this.bindId(property);
        } else {
            this.holder.addProperty(property, this.memberDetails, this.columns, this.declaringClass);
        }
        this.callAttributeBindersInSecondPass(property);
        return property;
    }

    private void callAttributeBindersInSecondPass(Property property) {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        if (metadataCollector.isInSecondPass()) {
            this.callAttributeBinders(property, metadataCollector.getEntityBindingMap());
        } else {
            metadataCollector.addSecondPass(persistentClasses -> this.callAttributeBinders(property, persistentClasses));
        }
    }

    private void bindId(Property property) {
        RootClass rootClass = (RootClass)this.holder.getPersistentClass();
        if (this.toMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
            this.getOrCreateCompositeId(rootClass).addProperty(property);
        } else {
            rootClass.setIdentifier((KeyValue)this.getValue());
            if (this.embedded) {
                rootClass.setEmbeddedIdentifier(true);
            } else {
                rootClass.setIdentifierProperty(property);
                MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.buildingContext);
                this.setDeclaredIdentifier(rootClass, superclass, property);
            }
        }
    }

    private void setDeclaredIdentifier(RootClass rootClass, MappedSuperclass superclass, Property prop) {
        ClassPropertyHolder.handleGenericComponentProperty(prop, this.memberDetails, this.buildingContext);
        if (superclass == null) {
            rootClass.setDeclaredIdentifierProperty(prop);
        } else {
            ClassPropertyHolder.prepareActualProperty(prop, this.memberDetails, false, this.buildingContext, superclass::setDeclaredIdentifierProperty);
        }
    }

    private Component getOrCreateCompositeId(RootClass rootClass) {
        Component id = (Component)rootClass.getIdentifier();
        if (id == null) {
            Component identifier = EmbeddableBinder.createEmbeddable(this.holder, new PropertyPreloadedData(), true, false, this.resolveCustomInstantiator(this.memberDetails, this.returnedClass.determineRawClass()), this.buildingContext);
            rootClass.setIdentifier(identifier);
            identifier.setNullValue("undefined");
            rootClass.setEmbeddedIdentifier(true);
            rootClass.setIdentifierMapper(identifier);
            return identifier;
        }
        return id;
    }

    private Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> resolveCustomInstantiator(MemberDetails property, ClassDetails embeddableClass) {
        if (property.hasAnnotationUsage(EmbeddableInstantiator.class)) {
            AnnotationUsage annotationUsage = property.getAnnotationUsage(EmbeddableInstantiator.class);
            return annotationUsage.getClassDetails("value").toJavaClass();
        }
        if (embeddableClass.hasAnnotationUsage(EmbeddableInstantiator.class)) {
            AnnotationUsage annotationUsage = embeddableClass.getAnnotationUsage(EmbeddableInstantiator.class);
            return annotationUsage.getClassDetails("value").toJavaClass();
        }
        return null;
    }

    public Property makeProperty() {
        this.validateMake();
        LOG.debugf("Building property %s", this.name);
        Property property = new Property();
        property.setName(this.name);
        property.setValue(this.value);
        property.setLazy(this.lazy);
        property.setLazyGroup(this.lazyGroup);
        property.setCascade(this.cascade);
        property.setPropertyAccessorName(this.accessType.getType());
        property.setReturnedClassName(this.returnedClassName);
        this.handleValueGeneration(property);
        this.handleNaturalId(property);
        this.handleLob(property);
        this.handleMutability(property);
        this.handleOptional(property);
        this.inferOptimisticLocking(property);
        LOG.tracev("Cascading {0} with {1}", this.name, this.cascade);
        this.callAttributeBindersInSecondPass(property);
        return property;
    }

    private void handleValueGeneration(Property property) {
        if (this.memberDetails != null) {
            property.setValueGeneratorCreator(this.getValueGenerationFromAnnotations(this.memberDetails));
        }
    }

    private GeneratorCreator getValueGenerationFromAnnotations(MemberDetails property) {
        GeneratorCreator creator = null;
        for (AnnotationUsage usage : property.getAllAnnotationUsages()) {
            GeneratorCreator candidate = GeneratorBinder.generatorCreator(property, usage);
            if (candidate == null) continue;
            if (creator != null) {
                throw new AnnotationException(String.format("Property `%s` has multiple '@ValueGenerationType' annotations", StringHelper.qualify(this.holder.getPath(), this.name)));
            }
            creator = candidate;
        }
        return creator;
    }

    private void handleLob(Property property) {
        if (this.memberDetails != null) {
            property.setLob(this.memberDetails.hasAnnotationUsage(Lob.class));
        }
    }

    private void handleMutability(Property property) {
        if (this.memberDetails != null && this.memberDetails.hasAnnotationUsage(Immutable.class)) {
            this.updatable = false;
        }
        property.setInsertable(this.insertable);
        property.setUpdateable(this.updatable);
    }

    private void handleOptional(Property property) {
        if (this.memberDetails != null) {
            property.setOptional(!this.isId && PropertyBinder.isOptional(this.memberDetails, this.holder));
            if (property.isOptional()) {
                OptionalDeterminationSecondPass secondPass = persistentClasses -> {
                    if (property.getPersistentClass() != null) {
                        for (Join join : property.getPersistentClass().getJoins()) {
                            if (!join.getProperties().contains(property)) continue;
                            return;
                        }
                    }
                    if (!property.getValue().isNullable()) {
                        property.setOptional(false);
                    }
                };
                this.buildingContext.getMetadataCollector().addSecondPass(secondPass);
            }
        }
    }

    private void handleNaturalId(Property property) {
        AnnotationUsage naturalId;
        if (this.memberDetails != null && this.entityBinder != null && (naturalId = this.memberDetails.getAnnotationUsage(NaturalId.class)) != null) {
            if (!this.entityBinder.isRootEntity()) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' belongs to an entity subclass and may not be annotated '@NaturalId' (only a property of a root '@Entity' or a '@MappedSuperclass' may be a '@NaturalId')");
            }
            if (!naturalId.getBoolean("mutable").booleanValue()) {
                this.updatable = false;
            }
            property.setNaturalIdentifier(true);
        }
    }

    private void inferOptimisticLocking(Property property) {
        if (this.value instanceof Collection) {
            property.setOptimisticLocked(((Collection)this.value).isOptimisticLocked());
        } else if (this.memberDetails != null && this.memberDetails.hasAnnotationUsage(OptimisticLock.class)) {
            AnnotationUsage optimisticLock = this.memberDetails.getAnnotationUsage(OptimisticLock.class);
            boolean excluded = optimisticLock.getBoolean("excluded");
            this.validateOptimisticLock(excluded);
            property.setOptimisticLocked(!excluded);
        } else {
            property.setOptimisticLocked(!this.isToOneValue(this.value) || this.insertable);
        }
    }

    private void validateOptimisticLock(boolean excluded) {
        if (excluded) {
            if (this.memberDetails.hasAnnotationUsage(Version.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Version'");
            }
            if (this.memberDetails.hasAnnotationUsage(Id.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Id'");
            }
            if (this.memberDetails.hasAnnotationUsage(EmbeddedId.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@EmbeddedId'");
            }
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, PropertyContainer propertyContainer, MetadataBuildingContext context) {
        int idPropertyCounter = 0;
        for (MemberDetails property : propertyContainer.propertyIterator()) {
            idPropertyCounter += PropertyBinder.addProperty(propertyContainer, property, elements, context);
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, MemberDetails property, List<PropertyData> inFlightPropertyDataList, MetadataBuildingContext context) {
        for (PropertyData propertyData : inFlightPropertyDataList) {
            if (!propertyData.getPropertyName().equals(property.resolveAttributeName())) continue;
            PropertyBinder.checkIdProperty(property, propertyData);
            return 0;
        }
        ClassDetails declaringClass = propertyContainer.getDeclaringClass();
        TypeVariableScope ownerType = propertyContainer.getTypeAtStake();
        int idPropertyCounter = 0;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, ownerType, property, propertyContainer.getClassLevelAccessType().getType(), context);
        MemberDetails element = propertyAnnotatedElement.getAttributeMember();
        if (PropertyBinder.hasIdAnnotation(element)) {
            inFlightPropertyDataList.add(0, propertyAnnotatedElement);
            PropertyBinder.handleIdProperty(propertyContainer, context, declaringClass, ownerType, element);
            if (BinderHelper.hasToOneAnnotation((AnnotationTarget)element)) {
                context.getMetadataCollector().addToOneAndIdProperty(ownerType.determineRawClass(), propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            inFlightPropertyDataList.add(propertyAnnotatedElement);
        }
        if (element.hasAnnotationUsage(MapsId.class)) {
            context.getMetadataCollector().addPropertyAnnotatedWithMapsId(ownerType.determineRawClass(), propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static void checkIdProperty(MemberDetails property, PropertyData propertyData) {
        AnnotationUsage incomingIdProperty = property.getAnnotationUsage(Id.class);
        AnnotationUsage existingIdProperty = propertyData.getAttributeMember().getAnnotationUsage(Id.class);
        if (incomingIdProperty != null && existingIdProperty == null) {
            throw new MappingException(String.format("You cannot override the [%s] non-identifier property from the [%s] base class or @MappedSuperclass and make it an identifier in the [%s] subclass", propertyData.getAttributeMember().getName(), propertyData.getAttributeMember().getDeclaringType().getName(), property.getDeclaringType().getName()));
        }
    }

    private static void handleIdProperty(PropertyContainer propertyContainer, MetadataBuildingContext context, ClassDetails declaringClass, TypeVariableScope ownerType, MemberDetails element) {
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled() && element.hasAnnotationUsage(Id.class) && element.hasAnnotationUsage(Column.class)) {
            String columnName = element.getAnnotationUsage(Column.class).getString("name");
            declaringClass.forEachField((index, fieldDetails) -> {
                if (!element.hasAnnotationUsage(MapsId.class) && PropertyBinder.isJoinColumnPresent(columnName, element)) {
                    context.getMetadataCollector().addPropertyAnnotatedWithMapsIdSpecj(ownerType.determineRawClass(), new PropertyInferredData(declaringClass, ownerType, element, propertyContainer.getClassLevelAccessType().getType(), context), element.toString());
                }
            });
        }
    }

    private static boolean isJoinColumnPresent(String columnName, MemberDetails property) {
        List joinColumnAnnotations = property.getRepeatedAnnotationUsages(JoinColumn.class);
        for (AnnotationUsage joinColumnAnnotation : joinColumnAnnotations) {
            if (!joinColumnAnnotation.getString("name").equals(columnName)) continue;
            return true;
        }
        return false;
    }

    static boolean hasIdAnnotation(MemberDetails element) {
        return element.hasAnnotationUsage(Id.class) || element.hasAnnotationUsage(EmbeddedId.class);
    }

    public static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass) throws MappingException {
        if (PropertyBinder.alreadyProcessedBySuper(propertyHolder, inferredData, entityBinder)) {
            LOG.debugf("Skipping attribute [%s : %s] as it was already processed as part of super hierarchy", inferredData.getClassOrElementName(), inferredData.getPropertyName());
        } else {
            MemberDetails property;
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Processing annotations of {0}.{1}", propertyHolder.getEntityName(), inferredData.getPropertyName());
            }
            if ((property = inferredData.getAttributeMember()).hasAnnotationUsage(Parent.class)) {
                PropertyBinder.handleParentProperty(propertyHolder, inferredData, property);
            } else {
                PropertyBinder.buildProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property);
            }
        }
    }

    private static boolean alreadyProcessedBySuper(PropertyHolder holder, PropertyData data, EntityBinder binder) {
        return !holder.isComponent() && binder.isPropertyDefinedInSuperHierarchy(data.getPropertyName());
    }

    private static void handleParentProperty(PropertyHolder holder, PropertyData data, MemberDetails property) {
        if (!holder.isComponent()) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(holder, data) + "' is annotated '@Parent' but is not a member of an embeddable class");
        }
        holder.setParentProperty(property.resolveAttributeName());
    }

    private static void buildProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property) {
        TypeDetails attributeTypeDetails = inferredData.getAttributeMember().isPlural() ? inferredData.getAttributeMember().getType() : inferredData.getClassOrElementType();
        ClassDetails attributeClassDetails = attributeTypeDetails.determineRawClass();
        ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, context).extractMetadata();
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(inferredData.getPropertyName());
        propertyBinder.setReturnedClassName(inferredData.getTypeName());
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setMemberDetails(property);
        propertyBinder.setReturnedClass(attributeTypeDetails);
        propertyBinder.setBuildingContext(context);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        propertyBinder.setId(!entityBinder.isIgnoreIdAnnotations() && PropertyBinder.hasIdAnnotation(property));
        AnnotationUsage lazyGroupAnnotation = property.getAnnotationUsage(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            propertyBinder.setLazyGroup(lazyGroupAnnotation.getString("value"));
        }
        AnnotatedJoinColumns joinColumns = columnsBuilder.getJoinColumns();
        AnnotatedColumns columns = PropertyBinder.bindProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, attributeClassDetails, columnsBuilder, propertyBinder);
        PropertyBinder.addIndexes(inSecondPass, property, columns, joinColumns);
        PropertyBinder.addNaturalIds(inSecondPass, property, columns, joinColumns, context);
    }

    private static AnnotatedColumns bindProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, ClassDetails returnedClass, ColumnsBuilder columnsBuilder, PropertyBinder propertyBinder) {
        if (PropertyBinder.isVersion(property)) {
            PropertyBinder.bindVersionProperty(propertyHolder, inferredData, isIdentifierMapper, context, inheritanceStatePerClass, columnsBuilder.getColumns(), propertyBinder);
        } else if (PropertyBinder.isManyToOne(property)) {
            ToOneBinder.bindManyToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isOneToOne(property)) {
            ToOneBinder.bindOneToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isAny(property)) {
            AnyBinder.bindAny(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, context, property, columnsBuilder.getJoinColumns(), PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isCollection(property)) {
            CollectionBinder.bindCollection(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, context, inheritanceStatePerClass, property, columnsBuilder.getJoinColumns());
        } else if (!propertyBinder.isId() || !entityBinder.isIgnoreIdAnnotations()) {
            return PropertyBinder.bindBasic(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columnsBuilder, columnsBuilder.getColumns(), returnedClass, propertyBinder);
        }
        return columnsBuilder.getColumns();
    }

    private static boolean isVersion(MemberDetails property) {
        return property.hasAnnotationUsage(Version.class);
    }

    private static boolean isOneToOne(MemberDetails property) {
        return property.hasAnnotationUsage(OneToOne.class);
    }

    private static boolean isManyToOne(MemberDetails property) {
        return property.hasAnnotationUsage(ManyToOne.class);
    }

    private static boolean isAny(MemberDetails property) {
        return property.hasAnnotationUsage(Any.class);
    }

    private static boolean isCollection(MemberDetails property) {
        return property.hasAnnotationUsage(OneToMany.class) || property.hasAnnotationUsage(ManyToMany.class) || property.hasAnnotationUsage(ElementCollection.class) || property.hasAnnotationUsage(ManyToAny.class);
    }

    private static boolean isForcePersist(MemberDetails property) {
        return property.hasAnnotationUsage(MapsId.class) || property.hasAnnotationUsage(Id.class);
    }

    private static void bindVersionProperty(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, AnnotatedColumns columns, PropertyBinder propertyBinder) {
        PropertyBinder.checkVersionProperty(propertyHolder, isIdentifierMapper);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("{0} is a version property", inferredData.getPropertyName());
        }
        RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
        propertyBinder.setColumns(columns);
        Property property = propertyBinder.makePropertyValueAndBind();
        propertyBinder.getBasicValueBinder().setVersion(true);
        rootClass.setVersion(property);
        ClassDetails declaringClass = inferredData.getDeclaringClass();
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(declaringClass, inheritanceStatePerClass, context);
        if (superclass != null) {
            superclass.setDeclaredVersion(property);
        } else {
            rootClass.setDeclaredVersion(property);
        }
        SimpleValue simpleValue = (SimpleValue)property.getValue();
        simpleValue.setNullValue("undefined");
        rootClass.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
        if (LOG.isTraceEnabled()) {
            SimpleValue versionValue = (SimpleValue)rootClass.getVersion().getValue();
            LOG.tracev("Version name: {0}, unsavedValue: {1}", rootClass.getVersion().getName(), versionValue.getNullValue());
        }
    }

    private static void checkVersionProperty(PropertyHolder propertyHolder, boolean isIdentifierMapper) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Class '" + propertyHolder.getEntityName() + "' is annotated '@IdClass' and may not have a property annotated '@Version'");
        }
        if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
            throw new AnnotationException("Entity '" + propertyHolder.getEntityName() + "' is a subclass in an entity class hierarchy and may not have a property annotated '@Version'");
        }
        if (!propertyHolder.isEntity()) {
            throw new AnnotationException("Embedded class '" + propertyHolder.getEntityName() + "' may not have a property annotated '@Version'");
        }
    }

    private static AnnotatedColumns bindBasic(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, ColumnsBuilder columnsBuilder, AnnotatedColumns columns, ClassDetails returnedClass, PropertyBinder propertyBinder) {
        AnnotatedColumns actualColumns;
        boolean isComposite;
        boolean isOverridden;
        if (isIdentifierMapper || propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) {
            PropertyData overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.resolveAttributeName(), context);
            if (overridingProperty != null) {
                isOverridden = true;
                isComposite = PropertyBinder.isComposite(inheritanceStatePerClass, property, returnedClass, overridingProperty);
                actualColumns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(propertyBinder.isId());
            } else {
                isOverridden = false;
                isComposite = EmbeddableBinder.isEmbedded(property, returnedClass);
                actualColumns = columns;
            }
        } else {
            isOverridden = false;
            isComposite = EmbeddableBinder.isEmbedded(property, returnedClass);
            actualColumns = columns;
        }
        Class<? extends CompositeUserType<?>> compositeUserType = PropertyBinder.resolveCompositeUserType(inferredData, context);
        if (isComposite || compositeUserType != null) {
            propertyBinder = EmbeddableBinder.createCompositeBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, actualColumns, returnedClass, propertyBinder, isOverridden, compositeUserType);
        } else {
            if (property.isPlural() && property.getElementType() != null && EmbeddableBinder.isEmbedded(property, property.getElementType())) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is mapped as basic aggregate component array, but this is not yet supported.");
            }
            PropertyBinder.createBasicBinder(propertyHolder, inferredData, nullability, context, property, actualColumns, propertyBinder, isOverridden);
        }
        if (isOverridden) {
            PropertyBinder.handleGeneratorsForOverriddenId(propertyHolder, classGenerators, context, property, propertyBinder);
        } else if (propertyBinder.isId()) {
            PropertyBinder.processId(propertyHolder, inferredData, (SimpleValue)propertyBinder.getValue(), classGenerators, isIdentifierMapper, context);
        }
        return actualColumns;
    }

    private static boolean isComposite(Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MemberDetails property, ClassDetails returnedClass, PropertyData overridingProperty) {
        InheritanceState state = inheritanceStatePerClass.get(overridingProperty.getClassOrElementType().determineRawClass());
        return state != null ? state.hasIdClassOrEmbeddedId() : EmbeddableBinder.isEmbedded(property, returnedClass);
    }

    private static void handleGeneratorsForOverriddenId(PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, MemberDetails property, PropertyBinder propertyBinder) {
        PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.resolveAttributeName(), context);
        IdentifierGeneratorDefinition foreignGenerator = GeneratorBinder.createForeignGenerator(mapsIdProperty);
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, foreignGenerator));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.put(foreignGenerator.getName(), foreignGenerator);
            GeneratorBinder.makeIdGenerator((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, generators);
        }
    }

    private static void createBasicBinder(PropertyHolder propertyHolder, PropertyData inferredData, Nullability nullability, MetadataBuildingContext context, MemberDetails property, AnnotatedColumns columns, PropertyBinder propertyBinder, boolean isOverridden) {
        if (PropertyBinder.shouldForceNotNull(nullability, propertyBinder, PropertyBinder.isExplicitlyOptional(property))) {
            PropertyBinder.forceColumnsNotNull(propertyHolder, inferredData, columns, propertyBinder);
        }
        propertyBinder.setLazy(PropertyBinder.isLazy(property));
        propertyBinder.setColumns(columns);
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.resolveAttributeName(), context);
            propertyBinder.setReferencedEntityName(mapsIdProperty.getClassOrElementName());
        }
        propertyBinder.makePropertyValueAndBind();
    }

    private static void forceColumnsNotNull(PropertyHolder holder, PropertyData data, AnnotatedColumns columns, PropertyBinder binder) {
        for (AnnotatedColumn column : columns.getColumns()) {
            if (binder.isId() && column.isFormula()) {
                throw new CannotForceNonNullableException("Identifier property '" + BinderHelper.getPath(holder, data) + "' cannot map to a '@Formula'");
            }
            column.forceNotNull();
        }
    }

    private static boolean shouldForceNotNull(Nullability nullability, PropertyBinder binder, boolean optional) {
        return binder.isId() || !optional && nullability != Nullability.FORCED_NULL;
    }

    private static boolean isExplicitlyOptional(MemberDetails attributeMember) {
        AnnotationUsage basicAnn = attributeMember.getAnnotationUsage(Basic.class);
        if (basicAnn == null) {
            return true;
        }
        return basicAnn.getBoolean("optional");
    }

    public static boolean isOptional(MemberDetails attributeMember, PropertyHolder propertyHolder) {
        AnnotationUsage basicAnn = attributeMember.getAnnotationUsage(Basic.class);
        if (basicAnn != null) {
            return basicAnn.getBoolean("optional");
        }
        if (attributeMember.isArray()) {
            return true;
        }
        if (propertyHolder != null && propertyHolder.isComponent()) {
            return true;
        }
        if (attributeMember.isPlural()) {
            return attributeMember.getElementType().getTypeKind() != TypeDetails.Kind.PRIMITIVE;
        }
        return attributeMember.getType().getTypeKind() != TypeDetails.Kind.PRIMITIVE;
    }

    private static boolean isLazy(MemberDetails property) {
        AnnotationUsage annotationUsage = property.getAnnotationUsage(Basic.class);
        return annotationUsage != null && annotationUsage.getEnum("fetch") == FetchType.LAZY;
    }

    private static void addIndexes(boolean inSecondPass, MemberDetails property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns) {
        block4: {
            AnnotationUsage index;
            block3: {
                index = property.getAnnotationUsage(Index.class);
                if (index == null) {
                    return;
                }
                if (joinColumns == null) break block3;
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addIndex((AnnotationUsage<Index>)index, inSecondPass);
                }
                break block4;
            }
            if (columns == null) break block4;
            for (AnnotatedColumn column : columns.getColumns()) {
                column.addIndex((AnnotationUsage<Index>)index, inSecondPass);
            }
        }
    }

    private static void addNaturalIds(boolean inSecondPass, MemberDetails property, final AnnotatedColumns columns, final AnnotatedJoinColumns joinColumns, final MetadataBuildingContext context) {
        block4: {
            AnnotationUsage naturalId = property.getAnnotationUsage(NaturalId.class);
            if (naturalId == null) break block4;
            Database database = context.getMetadataCollector().getDatabase();
            ImplicitNamingStrategy implicitNamingStrategy = context.getBuildingOptions().getImplicitNamingStrategy();
            if (joinColumns != null) {
                Identifier name = implicitNamingStrategy.determineUniqueKeyName(new ImplicitUniqueKeyNameSource(){

                    @Override
                    public Identifier getTableName() {
                        return joinColumns.getTable().getNameIdentifier();
                    }

                    @Override
                    public List<Identifier> getColumnNames() {
                        return Collections.singletonList(Identifier.toIdentifier("_NaturalID"));
                    }

                    @Override
                    public Identifier getUserProvidedIdentifier() {
                        return null;
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return context;
                    }
                });
                String keyName = name.render(database.getDialect());
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            } else {
                Identifier name = implicitNamingStrategy.determineUniqueKeyName(new ImplicitUniqueKeyNameSource(){

                    @Override
                    public Identifier getTableName() {
                        return columns.getTable().getNameIdentifier();
                    }

                    @Override
                    public List<Identifier> getColumnNames() {
                        return Collections.singletonList(Identifier.toIdentifier("_NaturalID"));
                    }

                    @Override
                    public Identifier getUserProvidedIdentifier() {
                        return null;
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return context;
                    }
                });
                String keyName = name.render(database.getDialect());
                for (AnnotatedColumn column : columns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            }
        }
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(PropertyData inferredData, MetadataBuildingContext context) {
        Class embeddableClass;
        MemberDetails attributeMember = inferredData.getAttributeMember();
        TypeDetails classOrElementType = inferredData.getClassOrElementType();
        ClassDetails returnedClass = classOrElementType.determineRawClass();
        if (attributeMember != null) {
            AnnotationUsage compositeType = attributeMember.locateAnnotationUsage(CompositeType.class);
            if (compositeType != null) {
                return compositeType.getClassDetails("value").toJavaClass();
            }
            Class<? extends CompositeUserType<?>> compositeUserType = TimeZoneStorageHelper.resolveTimeZoneStorageCompositeUserType(attributeMember, returnedClass, context);
            if (compositeUserType != null) {
                return compositeUserType;
            }
        }
        if (returnedClass != null && (embeddableClass = returnedClass.toJavaClass()) != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, boolean isIdentifierMapper, MetadataBuildingContext context) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@IdClass' and may not be annotated '@Id' or '@EmbeddedId'");
        }
        MemberDetails idAttributeMember = inferredData.getAttributeMember();
        List idGeneratorAnnotations = idAttributeMember.getMetaAnnotated(IdGeneratorType.class);
        List generatorAnnotations = idAttributeMember.getMetaAnnotated(ValueGenerationType.class);
        PropertyBinder.removeIdGenerators(generatorAnnotations, idGeneratorAnnotations);
        if (idGeneratorAnnotations.size() + generatorAnnotations.size() > 1) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' has too many generator annotations " + CollectionHelper.combine(idGeneratorAnnotations, generatorAnnotations));
        }
        if (!idGeneratorAnnotations.isEmpty()) {
            idValue.setCustomIdGeneratorCreator(GeneratorBinder.identifierGeneratorCreator(idAttributeMember, (AnnotationUsage<? extends Annotation>)((AnnotationUsage)idGeneratorAnnotations.get(0))));
        } else {
            if (!generatorAnnotations.isEmpty()) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '" + ((AnnotationUsage)generatorAnnotations.get(0)).getAnnotationType() + "' which is not an '@IdGeneratorType'");
            }
            ClassDetails entityClass = inferredData.getClassOrElementType().determineRawClass();
            GeneratorBinder.createIdGenerator(idValue, classGenerators, context, entityClass, idAttributeMember);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Bind {0} on {1}", BinderHelper.isCompositeId(entityClass, idAttributeMember) ? "@EmbeddedId" : "@Id", inferredData.getPropertyName());
            }
        }
    }

    private static void removeIdGenerators(List<AnnotationUsage<? extends Annotation>> generatorAnnotations, List<AnnotationUsage<? extends Annotation>> idGeneratorAnnotations) {
        for (AnnotationUsage<? extends Annotation> id : idGeneratorAnnotations) {
            Iterator<AnnotationUsage<? extends Annotation>> iterator = generatorAnnotations.iterator();
            while (iterator.hasNext()) {
                AnnotationUsage<? extends Annotation> gen = iterator.next();
                if (!gen.getAnnotationType().equals(id.getAnnotationType())) continue;
                iterator.remove();
            }
        }
    }
}

