/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import org.hibernate.MappingException;
import org.hibernate.annotations.Target;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class PropertyInferredData
implements PropertyData {
    private final org.hibernate.boot.spi.AccessType defaultAccess;
    private final ClassDetails declaringClass;
    private final TypeVariableScope ownerType;
    private final MemberDetails propertyMember;
    private final MetadataBuildingContext buildingContext;

    public PropertyInferredData(ClassDetails declaringClass, TypeVariableScope ownerType, MemberDetails propertyMember, String propertyAccessor, MetadataBuildingContext buildingContext) {
        this.declaringClass = declaringClass;
        this.ownerType = ownerType;
        this.propertyMember = propertyMember;
        this.defaultAccess = org.hibernate.boot.spi.AccessType.getAccessStrategy(propertyAccessor);
        this.buildingContext = buildingContext;
    }

    public String toString() {
        return String.format("PropertyInferredData{property=%s, declaringClass=%s}", this.propertyMember, this.declaringClass);
    }

    @Override
    public org.hibernate.boot.spi.AccessType getDefaultAccess() throws MappingException {
        org.hibernate.boot.spi.AccessType accessType = this.defaultAccess;
        org.hibernate.boot.spi.AccessType jpaAccessType = org.hibernate.boot.spi.AccessType.DEFAULT;
        AnnotationUsage access = this.propertyMember.getAnnotationUsage(Access.class);
        if (access != null) {
            jpaAccessType = org.hibernate.boot.spi.AccessType.getAccessStrategy((AccessType)access.getEnum("value"));
        }
        if (jpaAccessType != org.hibernate.boot.spi.AccessType.DEFAULT) {
            accessType = jpaAccessType;
        }
        return accessType;
    }

    @Override
    public String getPropertyName() throws MappingException {
        return this.propertyMember.resolveAttributeName();
    }

    @Override
    public TypeDetails getPropertyType() throws MappingException {
        AnnotationUsage targetAnnotation = this.propertyMember.getAnnotationUsage(org.hibernate.boot.internal.Target.class);
        if (targetAnnotation != null) {
            String targetName = targetAnnotation.getString("value");
            SourceModelBuildingContext sourceModelBuildingContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
            ClassDetails classDetails = sourceModelBuildingContext.getClassDetailsRegistry().resolveClassDetails(targetName, name -> new DynamicClassDetails(targetName, sourceModelBuildingContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        AnnotationUsage legacyTargetAnnotation = this.propertyMember.getAnnotationUsage(Target.class);
        if (legacyTargetAnnotation != null) {
            return new ClassTypeDetailsImpl(legacyTargetAnnotation.getClassDetails("value"), TypeDetails.Kind.CLASS);
        }
        return this.propertyMember.resolveRelativeType(this.ownerType);
    }

    @Override
    public TypeDetails getClassOrElementType() throws MappingException {
        AnnotationUsage annotationUsage = this.propertyMember.getAnnotationUsage(org.hibernate.boot.internal.Target.class);
        if (annotationUsage != null) {
            String targetName = annotationUsage.getString("value");
            SourceModelBuildingContext sourceModelBuildingContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
            ClassDetails classDetails = sourceModelBuildingContext.getClassDetailsRegistry().resolveClassDetails(targetName, name -> new DynamicClassDetails(targetName, sourceModelBuildingContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        AnnotationUsage legacyAnnotationUsage = this.propertyMember.getAnnotationUsage(Target.class);
        if (legacyAnnotationUsage != null) {
            return new ClassTypeDetailsImpl(legacyAnnotationUsage.getClassDetails("value"), TypeDetails.Kind.CLASS);
        }
        return this.propertyMember.resolveRelativeAssociatedType(this.ownerType);
    }

    @Override
    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElementType().getName();
    }

    @Override
    public String getTypeName() throws MappingException {
        return this.getPropertyType().getName();
    }

    @Override
    public MemberDetails getAttributeMember() {
        return this.propertyMember;
    }

    @Override
    public ClassDetails getDeclaringClass() {
        return this.declaringClass;
    }
}

