/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.annotations;

import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterRegistry;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AnnotationBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.model.source.internal.annotations.AdditionalManagedResourcesImpl;
import org.hibernate.boot.model.source.internal.annotations.DomainModelSource;
import org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.hibernate.boot.models.categorize.spi.FilterDefRegistration;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.JpaOrmXmlPersistenceUnitDefaultAware;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.jboss.logging.Logger;

public class AnnotationMetadataSourceProcessorImpl
implements MetadataSourceProcessor {
    private static final Logger log = Logger.getLogger(AnnotationMetadataSourceProcessorImpl.class);
    private final DomainModelSource domainModelSource;
    private final MetadataBuildingContextRootImpl rootMetadataBuildingContext;
    private final ClassLoaderService classLoaderService;
    private final LinkedHashSet<String> annotatedPackages = new LinkedHashSet();
    private final LinkedHashSet<ClassDetails> knownClasses = new LinkedHashSet();

    public AnnotationMetadataSourceProcessorImpl(ManagedResources managedResources, DomainModelSource domainModelSource, MetadataBuildingContextRootImpl rootMetadataBuildingContext) {
        this.domainModelSource = domainModelSource;
        this.rootMetadataBuildingContext = rootMetadataBuildingContext;
        MetadataBuildingOptions metadataBuildingOptions = rootMetadataBuildingContext.getBuildingOptions();
        this.classLoaderService = metadataBuildingOptions.getServiceRegistry().getService(ClassLoaderService.class);
        assert (this.classLoaderService != null);
        ConverterRegistry converterRegistry = rootMetadataBuildingContext.getMetadataCollector().getConverterRegistry();
        domainModelSource.getConversionRegistrations().forEach(registration -> {
            Class<Void> domainType = registration.getExplicitDomainType() == ClassDetails.VOID_CLASS_DETAILS || registration.getExplicitDomainType() == ClassDetails.VOID_OBJECT_CLASS_DETAILS ? Void.TYPE : this.classLoaderService.classForName(registration.getExplicitDomainType().getClassName());
            converterRegistry.addRegisteredConversion(new RegisteredConversion(domainType, this.classLoaderService.classForName(registration.getConverterType().getClassName()), registration.isAutoApply(), rootMetadataBuildingContext));
        });
        domainModelSource.getConverterRegistrations().forEach(registration -> converterRegistry.addAttributeConverter(new ClassBasedConverterDescriptor(this.classLoaderService.classForName(registration.converterClass().getClassName()), registration.autoApply(), rootMetadataBuildingContext.getBootstrapContext().getClassmateContext())));
        AnnotationMetadataSourceProcessorImpl.applyManagedClasses(domainModelSource, this.knownClasses, rootMetadataBuildingContext);
        for (String string : managedResources.getAnnotatedClassNames()) {
            this.knownClasses.add(domainModelSource.getClassDetailsRegistry().resolveClassDetails(string));
        }
        for (Class clazz : managedResources.getAnnotatedClassReferences()) {
            this.knownClasses.add(domainModelSource.getClassDetailsRegistry().resolveClassDetails(clazz.getName()));
        }
        this.annotatedPackages.addAll(managedResources.getAnnotatedPackageNames());
    }

    public static void processAdditionalMappings(List<Class<?>> additionalClasses, List<ClassDetails> additionalClassDetails, List<JaxbEntityMappingsImpl> additionalJaxbMappings, MetadataBuildingContextRootImpl rootMetadataBuildingContext, MetadataBuildingOptions options) {
        AdditionalManagedResourcesImpl.Builder mrBuilder = new AdditionalManagedResourcesImpl.Builder();
        mrBuilder.addLoadedClasses(additionalClasses);
        mrBuilder.addClassDetails(additionalClassDetails);
        mrBuilder.addJaxbEntityMappings(additionalJaxbMappings);
        ManagedResources mr = mrBuilder.build();
        DomainModelSource additionalDomainModelSource = MetadataBuildingProcess.processManagedResources(mr, rootMetadataBuildingContext.getMetadataCollector(), rootMetadataBuildingContext.getBootstrapContext(), options.getMappingDefaults());
        AnnotationMetadataSourceProcessorImpl processor = new AnnotationMetadataSourceProcessorImpl(mr, additionalDomainModelSource, rootMetadataBuildingContext);
        processor.processEntityHierarchies(new LinkedHashSet<String>());
    }

    @Override
    public void prepare() {
        ((JpaOrmXmlPersistenceUnitDefaultAware)((Object)this.rootMetadataBuildingContext.getBuildingOptions())).apply(this.domainModelSource.getPersistenceUnitMetadata());
        this.rootMetadataBuildingContext.getMetadataCollector().getDatabase().adjustDefaultNamespace(this.rootMetadataBuildingContext.getBuildingOptions().getMappingDefaults().getImplicitCatalogName(), this.rootMetadataBuildingContext.getBuildingOptions().getMappingDefaults().getImplicitSchemaName());
        AnnotationBinder.bindDefaults(this.rootMetadataBuildingContext);
        for (String annotatedPackage : this.annotatedPackages) {
            AnnotationBinder.bindPackage(this.classLoaderService, annotatedPackage, this.rootMetadataBuildingContext);
        }
    }

    @Override
    public void processTypeDefinitions() {
    }

    @Override
    public void processQueryRenames() {
    }

    @Override
    public void processNamedQueries() {
    }

    @Override
    public void processAuxiliaryDatabaseObjectDefinitions() {
    }

    @Override
    public void processIdentifierGenerators() {
    }

    @Override
    public void processFilterDefinitions() {
        Map<String, FilterDefRegistration> filterDefRegistrations = this.domainModelSource.getGlobalRegistrations().getFilterDefRegistrations();
        for (Map.Entry<String, FilterDefRegistration> filterDefRegistrationEntry : filterDefRegistrations.entrySet()) {
            FilterDefRegistration filterDefRegistration = filterDefRegistrationEntry.getValue();
            FilterDefinition filterDefinition = filterDefRegistration.toFilterDefinition(this.rootMetadataBuildingContext);
            this.rootMetadataBuildingContext.getMetadataCollector().addFilterDefinition(filterDefinition);
        }
    }

    @Override
    public void processFetchProfiles() {
    }

    @Override
    public void prepareForEntityHierarchyProcessing() {
    }

    @Override
    public void processEntityHierarchies(Set<String> processedEntityNames) {
        List<ClassDetails> orderedClasses = this.orderAndFillHierarchy(this.knownClasses);
        Map<ClassDetails, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, this.rootMetadataBuildingContext);
        for (ClassDetails clazz : orderedClasses) {
            if (processedEntityNames.contains(clazz.getName())) {
                log.debugf("Skipping annotated class processing of entity [%s], as it has already been processed", (Object)clazz);
                continue;
            }
            if (clazz.getName().endsWith(".package-info")) continue;
            AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, this.rootMetadataBuildingContext);
            AnnotationBinder.bindFetchProfilesForClass((AnnotationTarget)clazz, this.rootMetadataBuildingContext);
            processedEntityNames.add(clazz.getName());
        }
    }

    private List<ClassDetails> orderAndFillHierarchy(LinkedHashSet<ClassDetails> original) {
        LinkedHashSet<ClassDetails> copy = new LinkedHashSet<ClassDetails>(original.size());
        this.insertMappedSuperclasses(original, copy);
        ArrayList<ClassDetails> workingCopy = new ArrayList<ClassDetails>(copy);
        ArrayList<ClassDetails> newList = new ArrayList<ClassDetails>(copy.size());
        while (!workingCopy.isEmpty()) {
            ClassDetails clazz = (ClassDetails)workingCopy.get(0);
            this.orderHierarchy(workingCopy, newList, copy, clazz);
        }
        return newList;
    }

    private void insertMappedSuperclasses(LinkedHashSet<ClassDetails> original, LinkedHashSet<ClassDetails> copy) {
        boolean debug = log.isDebugEnabled();
        for (ClassDetails clazz : original) {
            if (clazz.hasAnnotationUsage(MappedSuperclass.class)) {
                if (!debug) continue;
                log.debugf("Skipping explicit MappedSuperclass %s, the class will be discovered analyzing the implementing class", (Object)clazz);
                continue;
            }
            copy.add(clazz);
            for (ClassDetails superClass = clazz.getSuperClass(); superClass != null && !Object.class.getName().equals(superClass.getName()) && !copy.contains(superClass); superClass = superClass.getSuperClass()) {
                if (!superClass.hasAnnotationUsage(Entity.class) && !superClass.hasAnnotationUsage(MappedSuperclass.class)) continue;
                copy.add(superClass);
            }
        }
    }

    private void orderHierarchy(List<ClassDetails> copy, List<ClassDetails> newList, LinkedHashSet<ClassDetails> original, ClassDetails clazz) {
        if (clazz != null && !Object.class.getName().equals(clazz.getName())) {
            this.orderHierarchy(copy, newList, original, clazz.getSuperClass());
            if (original.contains(clazz)) {
                if (!newList.contains(clazz)) {
                    newList.add(clazz);
                }
                copy.remove(clazz);
            }
        }
    }

    @Override
    public void postProcessEntityHierarchies() {
        for (String annotatedPackage : this.annotatedPackages) {
            AnnotationBinder.bindFetchProfilesForPackage(this.classLoaderService, annotatedPackage, this.rootMetadataBuildingContext);
        }
    }

    @Override
    public void processResultSetMappings() {
    }

    @Override
    public void finishUp() {
    }

    private static void applyManagedClasses(DomainModelSource domainModelSource, LinkedHashSet<ClassDetails> knownClasses, MetadataBuildingContextRootImpl rootMetadataBuildingContext) {
        ClassDetailsRegistry classDetailsRegistry = domainModelSource.getClassDetailsRegistry();
        domainModelSource.getManagedClassNames().forEach(className -> knownClasses.add(classDetailsRegistry.resolveClassDetails(className)));
    }
}

