/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.lang.annotation.Annotation;
import java.util.EnumSet;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.QuotedIdentifierTarget;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class BindingOptionsImpl
implements BindingOptions {
    private final Identifier defaultCatalogName;
    private final Identifier defaultSchemaName;
    private final EnumSet<QuotedIdentifierTarget> globallyQuotedIdentifierTargets;

    public BindingOptionsImpl(MetadataBuildingContext metadataBuildingContext) {
        boolean globallyQuote = metadataBuildingContext.getEffectiveDefaults().isDefaultQuoteIdentifiers();
        boolean skipColumnDefinitions = metadataBuildingContext.getBootstrapContext().getServiceRegistry().getService(ConfigurationService.class).getSetting("hibernate.globally_quoted_identifiers_skip_column_definitions", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        if (!globallyQuote) {
            this.globallyQuotedIdentifierTargets = EnumSet.noneOf(QuotedIdentifierTarget.class);
        } else {
            this.globallyQuotedIdentifierTargets = EnumSet.allOf(QuotedIdentifierTarget.class);
            if (skipColumnDefinitions) {
                this.globallyQuotedIdentifierTargets.remove((Object)QuotedIdentifierTarget.COLUMN_DEFINITION);
            }
        }
        JdbcEnvironment jdbcEnvironment = metadataBuildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
        this.defaultCatalogName = BindingOptionsImpl.toIdentifier(metadataBuildingContext.getEffectiveDefaults().getDefaultCatalogName(), QuotedIdentifierTarget.CATALOG_NAME, this.globallyQuotedIdentifierTargets, jdbcEnvironment);
        this.defaultSchemaName = BindingOptionsImpl.toIdentifier(metadataBuildingContext.getEffectiveDefaults().getDefaultSchemaName(), QuotedIdentifierTarget.SCHEMA_NAME, this.globallyQuotedIdentifierTargets, jdbcEnvironment);
    }

    public static <A extends Annotation> Identifier toIdentifier(String name, QuotedIdentifierTarget target, EnumSet<QuotedIdentifierTarget> globallyQuotedIdentifierTargets, JdbcEnvironment jdbcEnvironment) {
        boolean globallyQuoted = globallyQuotedIdentifierTargets.contains((Object)target);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name, globallyQuoted);
    }

    public BindingOptionsImpl(Identifier defaultCatalogName, Identifier defaultSchemaName) {
        this(defaultCatalogName, defaultSchemaName, EnumSet.noneOf(QuotedIdentifierTarget.class));
    }

    public BindingOptionsImpl(Identifier defaultCatalogName, Identifier defaultSchemaName, EnumSet<QuotedIdentifierTarget> globallyQuotedIdentifierTargets) {
        this.defaultCatalogName = defaultCatalogName;
        this.defaultSchemaName = defaultSchemaName;
        this.globallyQuotedIdentifierTargets = globallyQuotedIdentifierTargets;
    }

    @Override
    public Identifier getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    @Override
    public Identifier getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public EnumSet<QuotedIdentifierTarget> getGloballyQuotedIdentifierTargets() {
        return this.globallyQuotedIdentifierTargets;
    }
}

