/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.util.Map;
import org.hibernate.boot.models.bind.internal.AttributeBinding;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.ManagedTypeBinding;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.IdentifiableTypeClass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.ModelsException;

public abstract class IdentifiableTypeBinding
extends ManagedTypeBinding {
    protected final IdentifiableTypeMetadata typeMetadata;
    protected final IdentifiableTypeBinding superTypeBinding;
    protected final IdentifiableTypeMetadata superTypeMetadata;
    private final Map<String, AttributeBinding> attributeBindings;

    public IdentifiableTypeBinding(IdentifiableTypeMetadata typeMetadata, IdentifiableTypeBinding superTypeBinding, EntityHierarchy.HierarchyRelation hierarchyRelation, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(typeMetadata.getClassDetails(), bindingOptions, bindingState, bindingContext);
        this.typeMetadata = typeMetadata;
        this.superTypeBinding = superTypeBinding;
        this.superTypeMetadata = superTypeBinding == null ? null : superTypeBinding.getTypeMetadata();
        this.attributeBindings = CollectionHelper.linkedMapOfSize(typeMetadata.getNumberOfAttributes());
    }

    public IdentifiableTypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    public IdentifiableTypeMetadata getSuperTypeMetadata() {
        return this.superTypeMetadata;
    }

    public IdentifiableTypeBinding getSuperTypeBinding() {
        return this.superTypeBinding;
    }

    @Override
    public abstract IdentifiableTypeClass getBinding();

    @Override
    public Map<String, AttributeBinding> getAttributeBindings() {
        return this.attributeBindings;
    }

    public EntityTypeMetadata findSuperEntityMetadata() {
        EntityBinding superEntityBinder = this.getSuperEntityBinding();
        if (superEntityBinder == null) {
            return null;
        }
        return superEntityBinder.getTypeMetadata();
    }

    public PersistentClass resolveSuperEntityPersistentClass(IdentifiableTypeClass superTypeBinding) {
        if (superTypeBinding instanceof PersistentClass) {
            return (PersistentClass)superTypeBinding;
        }
        if (superTypeBinding.getSuperType() != null) {
            return this.resolveSuperEntityPersistentClass(superTypeBinding.getSuperType());
        }
        throw new ModelsException("Unable to resolve super PersistentClass for " + superTypeBinding);
    }

    public EntityBinding getSuperEntityBinding() {
        IdentifiableTypeBinding check = this.superTypeBinding;
        if (check == null) {
            return null;
        }
        do {
            if (!(check.getBinding() instanceof PersistentClass)) continue;
            return (EntityBinding)check;
        } while ((check = check.getSuperTypeBinding()) != null);
        return null;
    }

    protected void prepareAttributeBindings(Table primaryTable) {
        this.typeMetadata.forEachAttribute((index, attributeMetadata) -> {
            if (this.excludeAttributeFromPreparation((AttributeMetadata)attributeMetadata)) {
                return;
            }
            AttributeBinding attributeBinding = this.createAttributeBinding((AttributeMetadata)attributeMetadata, primaryTable);
            this.attributeBindings.put(attributeMetadata.getName(), attributeBinding);
            this.getBinding().applyProperty(attributeBinding.getProperty());
        });
    }

    protected boolean excludeAttributeFromPreparation(AttributeMetadata attributeMetadata) {
        return false;
    }

    protected abstract AttributeBinding createAttributeBinding(AttributeMetadata var1, Table var2);
}

