/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.models.bind.internal.BasicValueHelper;
import org.hibernate.boot.models.bind.internal.Binding;
import org.hibernate.boot.models.bind.internal.ColumnHelper;
import org.hibernate.boot.models.bind.internal.Observable;
import org.hibernate.boot.models.bind.internal.ObservableHelper;
import org.hibernate.boot.models.bind.internal.ResolutionCallback;
import org.hibernate.boot.models.bind.internal.RootEntityBinding;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.categorize.spi.AggregatedKeyMapping;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.BasicKeyMapping;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.KeyMapping;
import org.hibernate.boot.models.categorize.spi.NonAggregatedKeyMapping;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.MemberDetails;

public class IdentifierBinding
extends Binding
implements Observable<KeyValue> {
    private final KeyValue keyValue;
    private boolean resolved;
    private List<ResolutionCallback<KeyValue>> resolutionCallbacks;

    public IdentifierBinding(RootEntityBinding rootEntityBinding, EntityTypeMetadata entityTypeMetadata, BindingOptions options, BindingState state, BindingContext context) {
        super(options, state, context);
        this.keyValue = IdentifierBinding.prepareMappingValue(rootEntityBinding, entityTypeMetadata, this, options, state, context);
    }

    public KeyValue getValue() {
        return this.keyValue;
    }

    @Override
    public KeyValue getBinding() {
        return this.getValue();
    }

    private static KeyValue prepareMappingValue(RootEntityBinding rootEntityBinding, EntityTypeMetadata entityTypeMetadata, IdentifierBinding binding, BindingOptions options, BindingState state, BindingContext context) {
        RootClass rootClass = rootEntityBinding.getPersistentClass();
        EntityHierarchy hierarchy = entityTypeMetadata.getHierarchy();
        KeyMapping idMapping = hierarchy.getIdMapping();
        Table table = rootClass.getTable();
        if (idMapping instanceof BasicKeyMapping) {
            BasicKeyMapping basicKeyMapping = (BasicKeyMapping)idMapping;
            return IdentifierBinding.prepareBasicIdentifier(basicKeyMapping, table, rootClass, binding, options, state, context);
        }
        if (idMapping instanceof AggregatedKeyMapping) {
            AggregatedKeyMapping aggregatedKeyMapping = (AggregatedKeyMapping)idMapping;
            return IdentifierBinding.bindAggregatedIdentifier(aggregatedKeyMapping, table, rootClass, options, state, context);
        }
        return IdentifierBinding.bindNonAggregatedIdentifier((NonAggregatedKeyMapping)idMapping, table, rootClass, options, state, context);
    }

    private static KeyValue prepareBasicIdentifier(BasicKeyMapping basicKeyMapping, Table table, RootClass rootClass, IdentifierBinding binding, BindingOptions options, BindingState state, BindingContext context) {
        AttributeMetadata idAttribute = basicKeyMapping.getAttribute();
        MemberDetails idAttributeMember = idAttribute.getMember();
        BasicValue idValue = new BasicValue(state.getMetadataBuildingContext(), table);
        rootClass.setIdentifier(idValue);
        idValue.setTable(table);
        Property idProperty = new Property();
        idProperty.setName(idAttribute.getName());
        idProperty.setValue(idValue);
        idProperty.setPersistentClass(rootClass);
        rootClass.addProperty(idProperty);
        rootClass.setIdentifierProperty(idProperty);
        PrimaryKey primaryKey = table.getPrimaryKey();
        AnnotationUsage idColumnAnn = idAttributeMember.getAnnotationUsage(jakarta.persistence.Column.class);
        Column column = ColumnHelper.bindColumn(idColumnAnn, () -> "id", true, false);
        idValue.addColumn(column, true, false);
        primaryKey.addColumn(column);
        BasicValueHelper.bindImplicitJavaType(idAttributeMember, idValue, options, state, context);
        BasicValueHelper.bindJavaType(idAttributeMember, idValue, options, state, context);
        BasicValueHelper.bindJdbcType(idAttributeMember, idValue, options, state, context);
        BasicValueHelper.bindNationalized(idAttributeMember, idValue, options, state, context);
        binding.resolve();
        return idValue;
    }

    private static KeyValue bindAggregatedIdentifier(AggregatedKeyMapping aggregatedKeyMapping, Table table, RootClass rootClass, BindingOptions options, BindingState state, BindingContext context) {
        Component idValue = new Component(state.getMetadataBuildingContext(), rootClass);
        rootClass.setIdentifier(idValue);
        idValue.setTable(table);
        Property idProperty = new Property();
        idProperty.setValue(idValue);
        rootClass.setIdentifierProperty(idProperty);
        return idValue;
    }

    private static KeyValue bindNonAggregatedIdentifier(NonAggregatedKeyMapping idMapping, Table table, RootClass rootClass, BindingOptions options, BindingState state, BindingContext context) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void whenResolved(ResolutionCallback<KeyValue> callback) {
        if (this.resolved) {
            callback.handleResolution(this.keyValue);
            return;
        }
        if (this.resolutionCallbacks == null) {
            this.resolutionCallbacks = new ArrayList<ResolutionCallback<KeyValue>>();
        }
        this.resolutionCallbacks.add(callback);
    }

    public void resolve() {
        ObservableHelper.processCallbacks(this.keyValue, this.resolutionCallbacks);
        this.resolutionCallbacks = null;
        this.resolved = true;
    }
}

