/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.InheritanceType;
import java.lang.reflect.Type;
import org.hibernate.MappingException;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.models.bind.ModelBindingLogging;
import org.hibernate.boot.models.bind.internal.BasicValueHelper;
import org.hibernate.boot.models.bind.internal.ColumnHelper;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.IdentifiableTypeBinding;
import org.hibernate.boot.models.bind.internal.IdentifierBinding;
import org.hibernate.boot.models.bind.internal.MappedSuperclassBinding;
import org.hibernate.boot.models.bind.internal.TableHelper;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.TableReference;
import org.hibernate.boot.models.categorize.spi.CacheRegion;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.MappedSuperclassTypeMetadata;
import org.hibernate.boot.models.categorize.spi.NaturalIdCacheRegion;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.type.spi.TypeConfiguration;

public class RootEntityBinding
extends EntityBinding {
    private final RootClass rootClass;
    private final IdentifierBinding identifierBinding;
    private final TableReference tableReference;

    public RootEntityBinding(EntityTypeMetadata typeMetadata, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(typeMetadata, RootEntityBinding.resolveSuperTypeBinding((MappedSuperclassTypeMetadata)typeMetadata.getSuperType(), bindingOptions, bindingState, bindingContext), EntityHierarchy.HierarchyRelation.ROOT, bindingOptions, bindingState, bindingContext);
        this.rootClass = new RootClass(bindingState.getMetadataBuildingContext());
        RootEntityBinding.applyNaming(typeMetadata, this.rootClass, bindingState);
        this.tableReference = TableHelper.bindPrimaryTable(typeMetadata, EntityHierarchy.HierarchyRelation.ROOT, bindingOptions, bindingState, bindingContext);
        this.rootClass.setTable(this.tableReference.table());
        this.identifierBinding = new IdentifierBinding(this, typeMetadata, bindingOptions, bindingState, bindingContext);
        this.rootClass.setIdentifier(this.identifierBinding.getValue());
        TableHelper.bindSecondaryTables(this, bindingOptions, bindingState, bindingContext);
        bindingState.registerTypeBinding(typeMetadata, this);
        this.rootClass.setTable(this.tableReference.table());
        if (this.getSuperTypeBinding() != null) {
            this.rootClass.setSuperMappedSuperclass((MappedSuperclass)this.getSuperTypeBinding().getBinding());
        }
        if (typeMetadata.hasSubTypes()) {
            RootEntityBinding.bindDiscriminator(typeMetadata, this.rootClass, bindingOptions, bindingState, bindingContext);
            RootEntityBinding.applyDiscriminatorValue(typeMetadata, this.rootClass);
        }
        BasicValueHelper.bindVersion(typeMetadata, this.rootClass, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindTenantId(typeMetadata, this.rootClass, bindingOptions, bindingState, bindingContext);
        this.applyOptimisticLocking(typeMetadata, this.rootClass);
        this.applyCacheRegions(typeMetadata, this.rootClass);
        this.applySoftDelete(typeMetadata, this.rootClass, this.tableReference.table());
        RootEntityBinding.applyCommonInformation(typeMetadata, this.rootClass, bindingState);
        this.prepareAttributeBindings(this.tableReference.table());
        this.prepareSubclassBindings();
    }

    private static IdentifiableTypeBinding resolveSuperTypeBinding(MappedSuperclassTypeMetadata superTypeMetadata, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (superTypeMetadata == null) {
            return null;
        }
        IdentifiableTypeBinding superTypeSuperTypeBinding = superTypeMetadata.getSuperType() == null ? null : RootEntityBinding.resolveSuperTypeBinding((MappedSuperclassTypeMetadata)superTypeMetadata.getSuperType(), bindingOptions, bindingState, bindingContext);
        return new MappedSuperclassBinding(superTypeMetadata, superTypeSuperTypeBinding, EntityHierarchy.HierarchyRelation.SUPER, bindingOptions, bindingState, bindingContext);
    }

    @Override
    public RootClass getPersistentClass() {
        return this.rootClass;
    }

    @Override
    public RootClass getBinding() {
        return this.getPersistentClass();
    }

    public TableReference getTableReference() {
        return this.tableReference;
    }

    public IdentifierBinding getIdentifierBinding() {
        return this.identifierBinding;
    }

    @Override
    public RootEntityBinding getRootEntityBinding() {
        return this;
    }

    private void applyCacheRegions(EntityTypeMetadata source, RootClass rootClass) {
        EntityHierarchy hierarchy = source.getHierarchy();
        CacheRegion cacheRegion = hierarchy.getCacheRegion();
        NaturalIdCacheRegion naturalIdCacheRegion = hierarchy.getNaturalIdCacheRegion();
        if (cacheRegion != null) {
            rootClass.setCacheRegionName(cacheRegion.getRegionName());
            rootClass.setCacheConcurrencyStrategy(cacheRegion.getAccessType().getExternalName());
            rootClass.setLazyPropertiesCacheable(cacheRegion.isCacheLazyProperties());
        }
        if (naturalIdCacheRegion != null) {
            rootClass.setNaturalIdCacheRegionName(naturalIdCacheRegion.getRegionName());
        }
    }

    private void applyOptimisticLocking(EntityTypeMetadata source, RootClass rootClass) {
        ClassDetails classDetails = source.getClassDetails();
        AnnotationUsage optimisticLocking = classDetails.getAnnotationUsage(OptimisticLocking.class);
        if (optimisticLocking != null) {
            OptimisticLockType optimisticLockingType = (OptimisticLockType)optimisticLocking.getEnum("type", (Enum)OptimisticLockType.VERSION);
            rootClass.setOptimisticLockStyle(OptimisticLockStyle.valueOf(optimisticLockingType.name()));
        }
    }

    private void applySoftDelete(EntityTypeMetadata source, RootClass rootClass, Table primaryTable) {
        ClassDetails classDetails = source.getClassDetails();
        AnnotationUsage softDeleteConfig = classDetails.getAnnotationUsage(SoftDelete.class);
        if (softDeleteConfig == null) {
            return;
        }
        BasicValue softDeleteIndicatorValue = this.createSoftDeleteIndicatorValue((AnnotationUsage<SoftDelete>)softDeleteConfig, primaryTable);
        Column softDeleteIndicatorColumn = this.createSoftDeleteIndicatorColumn((AnnotationUsage<SoftDelete>)softDeleteConfig, softDeleteIndicatorValue);
        primaryTable.addColumn(softDeleteIndicatorColumn);
        rootClass.enableSoftDelete(softDeleteIndicatorColumn);
    }

    private BasicValue createSoftDeleteIndicatorValue(AnnotationUsage<SoftDelete> softDeleteAnn, Table table) {
        assert (softDeleteAnn != null);
        ClassDetails converterClassDetails = softDeleteAnn.getClassDetails("converter");
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClassDetails.toJavaClass(), this.bindingContext.getBootstrapContext().getClassmateContext());
        BasicValue softDeleteIndicatorValue = new BasicValue(this.bindingState.getMetadataBuildingContext(), table);
        softDeleteIndicatorValue.makeSoftDelete((SoftDeleteType)softDeleteAnn.getEnum("strategy"));
        softDeleteIndicatorValue.setJpaAttributeConverterDescriptor(converterDescriptor);
        softDeleteIndicatorValue.setImplicitJavaTypeAccess(typeConfiguration -> converterDescriptor.getRelationalValueResolvedType().getErasedType());
        return softDeleteIndicatorValue;
    }

    private Column createSoftDeleteIndicatorColumn(AnnotationUsage<SoftDelete> softDeleteConfig, BasicValue softDeleteIndicatorValue) {
        Column softDeleteColumn = new Column();
        this.applyColumnName(softDeleteColumn, softDeleteConfig);
        softDeleteColumn.setLength(1);
        softDeleteColumn.setNullable(false);
        softDeleteColumn.setUnique(false);
        softDeleteColumn.setComment("Soft-delete indicator");
        softDeleteColumn.setValue(softDeleteIndicatorValue);
        softDeleteIndicatorValue.addColumn(softDeleteColumn);
        return softDeleteColumn;
    }

    private void applyColumnName(Column softDeleteColumn, AnnotationUsage<SoftDelete> softDeleteConfig) {
        Database database = this.bindingState.getMetadataBuildingContext().getMetadataCollector().getDatabase();
        PhysicalNamingStrategy namingStrategy = this.bindingState.getMetadataBuildingContext().getBuildingOptions().getPhysicalNamingStrategy();
        SoftDeleteType strategy = (SoftDeleteType)softDeleteConfig.getEnum("strategy");
        String logicalColumnName = StringHelper.coalesce(strategy.getDefaultColumnName(), softDeleteConfig.getString("columnName"));
        Identifier physicalColumnName = namingStrategy.toPhysicalColumnName(database.toIdentifier(logicalColumnName), database.getJdbcEnvironment());
        softDeleteColumn.setName(physicalColumnName.render(database.getDialect()));
    }

    public static void bindDiscriminator(EntityTypeMetadata typeMetadata, RootClass rootClass, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        InheritanceType inheritanceType = typeMetadata.getHierarchy().getInheritanceType();
        AnnotationUsage columnAnn = typeMetadata.getClassDetails().getAnnotationUsage(DiscriminatorColumn.class);
        AnnotationUsage formulaAnn = typeMetadata.getClassDetails().getAnnotationUsage(DiscriminatorFormula.class);
        if (columnAnn != null && formulaAnn != null) {
            throw new MappingException("Entity defined both @DiscriminatorColumn and @DiscriminatorFormula - " + typeMetadata.getEntityName());
        }
        if (inheritanceType == InheritanceType.TABLE_PER_CLASS) {
            return;
        }
        if (inheritanceType == InheritanceType.JOINED) {
            MetadataBuildingOptions buildingOptions = bindingState.getMetadataBuildingContext().getBuildingOptions();
            if (buildingOptions.ignoreExplicitDiscriminatorsForJoinedInheritance()) {
                if (columnAnn != null || formulaAnn != null) {
                    ModelBindingLogging.MODEL_BINDING_LOGGER.debugf("Skipping explicit discriminator for JOINED hierarchy due to configuration - " + rootClass.getEntityName(), new Object[0]);
                }
                return;
            }
            if (!buildingOptions.createImplicitDiscriminatorsForJoinedInheritance() && columnAnn == null && formulaAnn == null) {
                return;
            }
        }
        if (inheritanceType == InheritanceType.SINGLE_TABLE && !typeMetadata.hasSubTypes()) {
            return;
        }
        BasicValue value = new BasicValue(bindingState.getMetadataBuildingContext(), rootClass.getIdentityTable());
        rootClass.setDiscriminator(value);
        DiscriminatorType discriminatorType = ColumnHelper.bindDiscriminatorColumn(bindingContext, (AnnotationUsage<DiscriminatorFormula>)formulaAnn, value, (AnnotationUsage<DiscriminatorColumn>)columnAnn, bindingOptions, bindingState);
        value.setImplicitJavaTypeAccess(arg_0 -> RootEntityBinding.lambda$bindDiscriminator$1(switch (discriminatorType) {
            case DiscriminatorType.STRING -> String.class;
            case DiscriminatorType.CHAR -> Character.TYPE;
            case DiscriminatorType.INTEGER -> Integer.TYPE;
            default -> throw new IllegalStateException("Unexpected DiscriminatorType - " + discriminatorType);
        }, arg_0));
    }

    private static /* synthetic */ Type lambda$bindDiscriminator$1(Class discriminatorJavaType, TypeConfiguration typeConfiguration) {
        return discriminatorJavaType;
    }
}

