/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.SecondaryTable;
import java.util.List;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.ResolutionCallback;
import org.hibernate.boot.models.bind.internal.RootEntityBinding;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.models.spi.AnnotationUsage;

public record SecondaryTableKeyHandler(AnnotationUsage<SecondaryTable> annotationUsage, Join join, EntityBinding entityBinding, MetadataBuildingContext buildingContext) implements ResolutionCallback<KeyValue>
{
    @Override
    public boolean handleResolution(KeyValue targetKeyValue) {
        DependantValue fkValue = new DependantValue(this.buildingContext(), this.join.getTable(), targetKeyValue);
        this.join.setKey(fkValue);
        List pkJoinColumns = this.annotationUsage.getList("pkJoinColumns");
        if (!CollectionHelper.isEmpty(pkJoinColumns)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.handleImplicitJoinColumns(targetKeyValue, fkValue);
        AnnotationUsage foreignKeyAnn = (AnnotationUsage)this.annotationUsage.getAttributeValue("foreignKey");
        String foreignKeyName = foreignKeyAnn == null ? "" : foreignKeyAnn.getString("name");
        String foreignKeyDefinition = foreignKeyAnn == null ? "" : foreignKeyAnn.getString("foreignKeyDefinition");
        RootEntityBinding rootEntityBinding = this.entityBinding.getRootEntityBinding();
        ForeignKey foreignKey = this.join.getTable().createForeignKey(foreignKeyName, targetKeyValue.getColumns(), rootEntityBinding.getPersistentClass().getEntityName(), foreignKeyDefinition, rootEntityBinding.getTableReference().table().getPrimaryKey().getColumns());
        foreignKey.setReferencedTable(rootEntityBinding.getTableReference().table());
        return true;
    }

    private void handleImplicitJoinColumns(KeyValue targetKeyValue, DependantValue fkValue) {
        targetKeyValue.getColumns().forEach(column -> {
            Column fkColumn = column.clone();
            this.join.getTable().getPrimaryKey().addColumn(fkColumn);
            fkValue.addColumn(fkColumn);
        });
    }
}

