/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.InheritanceType;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.IdentifiableTypeBinding;
import org.hibernate.boot.models.bind.internal.JoinedSubclassKeyHandler;
import org.hibernate.boot.models.bind.internal.RootEntityBinding;
import org.hibernate.boot.models.bind.internal.TableHelper;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.TableReference;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.mapping.IdentifiableTypeClass;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;

public class SubclassEntityBinding
extends EntityBinding {
    private final Subclass subclass = this.createSubclass();

    public SubclassEntityBinding(EntityTypeMetadata typeMetadata, IdentifiableTypeBinding superTypeBinding, EntityHierarchy.HierarchyRelation hierarchyRelation, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(typeMetadata, superTypeBinding, hierarchyRelation, bindingOptions, bindingState, bindingContext);
        SubclassEntityBinding.applyNaming(typeMetadata, this.subclass, bindingState);
        bindingState.registerTypeBinding(this.getTypeMetadata(), this);
        this.applyTable(typeMetadata, this.subclass, bindingOptions, bindingState, bindingContext);
        TableHelper.bindSecondaryTables(this, bindingOptions, bindingState, bindingContext);
        SubclassEntityBinding.applyDiscriminatorValue(typeMetadata, this.subclass);
        SubclassEntityBinding.applyCommonInformation(typeMetadata, this.subclass, bindingState);
        this.prepareAttributeBindings(this.subclass.getTable());
        this.prepareSubclassBindings();
    }

    @Override
    public Subclass getPersistentClass() {
        return this.subclass;
    }

    @Override
    public RootEntityBinding getRootEntityBinding() {
        return this.getSuperEntityBinding().getRootEntityBinding();
    }

    @Override
    public Subclass getBinding() {
        return this.getPersistentClass();
    }

    private Subclass createSubclass() {
        IdentifiableTypeMetadata superType = this.getSuperTypeMetadata();
        InheritanceType inheritanceType = superType.getHierarchy().getInheritanceType();
        if (inheritanceType == InheritanceType.JOINED) {
            return this.createJoinedSubclass(this.superTypeBinding.getBinding());
        }
        if (inheritanceType == InheritanceType.TABLE_PER_CLASS) {
            return this.createUnionSubclass(this.superTypeBinding.getBinding());
        }
        assert (inheritanceType == null || inheritanceType == InheritanceType.SINGLE_TABLE);
        return this.createSingleTableSubclass(this.superTypeBinding.getBinding());
    }

    private UnionSubclass createUnionSubclass(IdentifiableTypeClass superTypeMapping) {
        UnionSubclass unionSubclass;
        if (superTypeMapping instanceof PersistentClass) {
            PersistentClass superEntity = (PersistentClass)superTypeMapping;
            unionSubclass = new UnionSubclass(superEntity, this.bindingState.getMetadataBuildingContext());
        } else {
            assert (superTypeMapping instanceof MappedSuperclass);
            PersistentClass superEntity = this.resolveSuperEntityPersistentClass(superTypeMapping);
            unionSubclass = new UnionSubclass(superEntity, this.bindingState.getMetadataBuildingContext());
            unionSubclass.setSuperMappedSuperclass((MappedSuperclass)superTypeMapping);
        }
        return unionSubclass;
    }

    private JoinedSubclass createJoinedSubclass(IdentifiableTypeClass superTypeMapping) {
        JoinedSubclass joinedSubclass;
        PersistentClass superTypePersistentClass = this.getSuperEntityBinding().getPersistentClass();
        if (superTypeMapping instanceof PersistentClass) {
            PersistentClass superEntity = (PersistentClass)superTypeMapping;
            joinedSubclass = new JoinedSubclass(superEntity, this.bindingState.getMetadataBuildingContext());
        } else {
            assert (superTypeMapping instanceof MappedSuperclass);
            joinedSubclass = new JoinedSubclass(superTypePersistentClass, this.bindingState.getMetadataBuildingContext());
            joinedSubclass.setSuperMappedSuperclass((MappedSuperclass)superTypeMapping);
        }
        TableReference joinTableReference = TableHelper.bindPrimaryTable(this.getTypeMetadata(), EntityHierarchy.HierarchyRelation.SUB, this.bindingOptions, this.bindingState, this.bindingContext);
        joinedSubclass.setTable(joinTableReference.table());
        PrimaryKey primaryKey = new PrimaryKey(joinTableReference.table());
        joinTableReference.table().setPrimaryKey(primaryKey);
        this.getRootEntityBinding().getIdentifierBinding().whenResolved(new JoinedSubclassKeyHandler(this.getTypeMetadata().getClassDetails(), joinedSubclass, this.bindingState.getMetadataBuildingContext()));
        return joinedSubclass;
    }

    private SingleTableSubclass createSingleTableSubclass(IdentifiableTypeClass superTypeBinding) {
        if (superTypeBinding instanceof PersistentClass) {
            PersistentClass superEntity = (PersistentClass)superTypeBinding;
            return new SingleTableSubclass(superEntity, this.bindingState.getMetadataBuildingContext());
        }
        assert (superTypeBinding instanceof MappedSuperclass);
        PersistentClass superEntity = this.resolveSuperEntityPersistentClass(superTypeBinding);
        SingleTableSubclass binding = new SingleTableSubclass(superEntity, this.bindingState.getMetadataBuildingContext());
        binding.setSuperMappedSuperclass((MappedSuperclass)superTypeBinding);
        return binding;
    }

    protected void applyTable(EntityTypeMetadata typeMetadata, Subclass subclass, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (subclass instanceof UnionSubclass) {
            UnionSubclass unionSubclass = (UnionSubclass)subclass;
            TableReference unionTableReference = TableHelper.bindPrimaryTable(this.getTypeMetadata(), EntityHierarchy.HierarchyRelation.SUB, bindingOptions, bindingState, bindingContext);
            unionSubclass.setTable(unionTableReference.table());
            PrimaryKey primaryKey = new PrimaryKey(unionTableReference.table());
            unionTableReference.table().setPrimaryKey(primaryKey);
        } else if (subclass instanceof JoinedSubclass) {
            JoinedSubclass joinedSubclass = (JoinedSubclass)subclass;
        }
    }
}

