/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinTable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.annotations.Subselect;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.models.AnnotationPlacementException;
import org.hibernate.boot.models.bind.internal.BindingHelper;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.InLineView;
import org.hibernate.boot.models.bind.internal.PhysicalTable;
import org.hibernate.boot.models.bind.internal.SecondaryTable;
import org.hibernate.boot.models.bind.internal.SecondaryTableKeyHandler;
import org.hibernate.boot.models.bind.internal.UnionTable;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.PhysicalTableReference;
import org.hibernate.boot.models.bind.spi.QuotedIdentifierTarget;
import org.hibernate.boot.models.bind.spi.TableReference;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;

public class TableHelper {
    public static TableReference bindPrimaryTable(EntityTypeMetadata entityTypeMetadata, EntityHierarchy.HierarchyRelation hierarchyRelation, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        TableReference tableReference;
        ClassDetails typeClassDetails = entityTypeMetadata.getClassDetails();
        AnnotationUsage tableAnn = typeClassDetails.getAnnotationUsage(jakarta.persistence.Table.class);
        AnnotationUsage joinTableAnn = typeClassDetails.getAnnotationUsage(JoinTable.class);
        AnnotationUsage subselectAnn = typeClassDetails.getAnnotationUsage(Subselect.class);
        if (tableAnn != null && joinTableAnn != null) {
            throw new AnnotationPlacementException("Illegal combination of @Table and @JoinTable on " + typeClassDetails.getName());
        }
        if (tableAnn != null && subselectAnn != null) {
            throw new AnnotationPlacementException("Illegal combination of @Table and @Subselect on " + typeClassDetails.getName());
        }
        if (joinTableAnn != null && subselectAnn != null) {
            throw new AnnotationPlacementException("Illegal combination of @JoinTable and @Subselect on " + typeClassDetails.getName());
        }
        if (entityTypeMetadata.getHierarchy().getInheritanceType() == InheritanceType.TABLE_PER_CLASS) {
            assert (subselectAnn == null);
            tableReference = hierarchyRelation == EntityHierarchy.HierarchyRelation.ROOT ? TableHelper.bindPhysicalTable(entityTypeMetadata, tableAnn, true, bindingOptions, bindingState, bindingContext) : TableHelper.bindUnionTable(entityTypeMetadata, (AnnotationUsage<jakarta.persistence.Table>)tableAnn, bindingOptions, bindingState, bindingContext);
        } else if (entityTypeMetadata.getHierarchy().getInheritanceType() == InheritanceType.SINGLE_TABLE) {
            tableReference = hierarchyRelation == EntityHierarchy.HierarchyRelation.ROOT ? TableHelper.normalTableDetermination(entityTypeMetadata, (AnnotationUsage<Subselect>)subselectAnn, tableAnn, jakarta.persistence.Table.class, typeClassDetails, bindingOptions, bindingState, bindingContext) : null;
        } else {
            assert (entityTypeMetadata.getHierarchy().getInheritanceType() == InheritanceType.JOINED);
            tableReference = TableHelper.normalTableDetermination(entityTypeMetadata, (AnnotationUsage<Subselect>)subselectAnn, joinTableAnn, JoinTable.class, typeClassDetails, bindingOptions, bindingState, bindingContext);
        }
        if (tableReference != null) {
            bindingState.addTable(entityTypeMetadata, tableReference);
            PrimaryKey primaryKey = new PrimaryKey(tableReference.table());
            tableReference.table().setPrimaryKey(primaryKey);
        }
        return tableReference;
    }

    public static Map<String, SecondaryTable> bindSecondaryTables(EntityBinding entityBinding, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        ClassDetails typeClassDetails = entityBinding.getTypeMetadata().getClassDetails();
        List annotationUsages = typeClassDetails.getRepeatedAnnotationUsages(jakarta.persistence.SecondaryTable.class);
        if (CollectionHelper.isEmpty(annotationUsages)) {
            return Collections.emptyMap();
        }
        HashMap<String, SecondaryTable> secondaryTableMap = CollectionHelper.mapOfSize(annotationUsages.size());
        annotationUsages.forEach(secondaryTableAnn -> {
            AnnotationUsage secondaryRowAnn = typeClassDetails.getNamedAnnotationUsage(SecondaryRow.class, secondaryTableAnn.getString("name"), "table");
            SecondaryTable binding = TableHelper.bindSecondaryTable(entityBinding, (AnnotationUsage<jakarta.persistence.SecondaryTable>)secondaryTableAnn, (AnnotationUsage<SecondaryRow>)secondaryRowAnn, bindingOptions, bindingState, bindingContext);
            secondaryTableMap.put(binding.logicalName().getCanonicalName(), binding);
            bindingState.addSecondaryTable(binding);
        });
        return secondaryTableMap;
    }

    public static SecondaryTable bindSecondaryTable(EntityBinding entityBinding, AnnotationUsage<jakarta.persistence.SecondaryTable> secondaryTableAnn, AnnotationUsage<SecondaryRow> secondaryRowAnn, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        Identifier logicalName = TableHelper.determineLogicalName(entityBinding.getTypeMetadata(), secondaryTableAnn, bindingOptions, bindingState, bindingContext);
        Identifier schemaName = TableHelper.resolveDatabaseIdentifier(secondaryTableAnn, "schema", bindingOptions.getDefaultSchemaName(), QuotedIdentifierTarget.SCHEMA_NAME, bindingOptions, bindingState, bindingContext);
        Identifier catalogName = TableHelper.resolveDatabaseIdentifier(secondaryTableAnn, "catalog", bindingOptions.getDefaultCatalogName(), QuotedIdentifierTarget.CATALOG_NAME, bindingOptions, bindingState, bindingContext);
        MetadataBuildingContext buildingContext = bindingState.getMetadataBuildingContext();
        Table secondaryTable = buildingContext.getMetadataCollector().addTable(TableHelper.toCanonicalName(schemaName), TableHelper.toCanonicalName(catalogName), logicalName.getCanonicalName(), null, false, buildingContext);
        secondaryTable.setPrimaryKey(new PrimaryKey(secondaryTable));
        TableHelper.applyComment(secondaryTable, secondaryTableAnn, TableHelper.findCommentAnnotation(entityBinding.getTypeMetadata(), logicalName, false));
        TableHelper.applyOptions(secondaryTable, secondaryTableAnn);
        Join join = new Join();
        join.setTable(secondaryTable);
        join.setOptional(BindingHelper.getValue(secondaryRowAnn, "optional", true));
        join.setInverse(BindingHelper.getValue(secondaryRowAnn, "owned", true) == false);
        join.setPersistentClass(entityBinding.getPersistentClass());
        entityBinding.getPersistentClass().addJoin(join);
        entityBinding.getRootEntityBinding().getIdentifierBinding().whenResolved(new SecondaryTableKeyHandler(secondaryTableAnn, join, entityBinding, buildingContext));
        JdbcEnvironment jdbcEnvironment = TableHelper.jdbcEnvironment(bindingContext);
        PhysicalNamingStrategy physicalNamingStrategy = TableHelper.physicalNamingStrategy(bindingContext);
        return new SecondaryTable(logicalName, catalogName, schemaName, physicalNamingStrategy.toPhysicalTableName(logicalName, jdbcEnvironment), physicalNamingStrategy.toPhysicalCatalogName(catalogName, jdbcEnvironment), physicalNamingStrategy.toPhysicalSchemaName(schemaName, jdbcEnvironment), BindingHelper.getValue(secondaryRowAnn, "optional", true), BindingHelper.getValue(secondaryRowAnn, "owned", true), secondaryTable);
    }

    private static <A extends Annotation> TableReference normalTableDetermination(EntityTypeMetadata type, AnnotationUsage<Subselect> subselectAnn, AnnotationUsage<A> tableAnn, Class<A> annotationType, ClassDetails typeClassDetails, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        TableReference tableReference = subselectAnn != null ? TableHelper.bindVirtualTable(type, subselectAnn, bindingOptions, bindingState, bindingContext) : TableHelper.bindPhysicalTable(type, tableAnn, true, bindingOptions, bindingState, bindingContext);
        return tableReference;
    }

    private static InLineView bindVirtualTable(final EntityTypeMetadata type, AnnotationUsage<Subselect> subselectAnn, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        final MetadataBuildingContext metadataBuildingContext = bindingState.getMetadataBuildingContext();
        Identifier logicalName = TableHelper.implicitNamingStrategy(bindingContext).determinePrimaryTableName(new ImplicitEntityNameSource(){

            @Override
            public EntityNaming getEntityNaming() {
                return type;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return metadataBuildingContext;
            }
        });
        InFlightMetadataCollector metadataCollector = metadataBuildingContext.getMetadataCollector();
        Table table = metadataCollector.addTable(null, null, logicalName.getCanonicalName(), subselectAnn.getString("value"), true, metadataBuildingContext);
        PrimaryKey primaryKey = new PrimaryKey(table);
        table.setPrimaryKey(primaryKey);
        primaryKey.setTable(table);
        return new InLineView(logicalName, table);
    }

    private static <A extends Annotation> PhysicalTableReference bindPhysicalTable(EntityTypeMetadata type, AnnotationUsage<A> tableAnn, boolean isPrimary, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (tableAnn != null) {
            return TableHelper.bindExplicitPhysicalTable(type, tableAnn, isPrimary, bindingOptions, bindingState, bindingContext);
        }
        return TableHelper.bindImplicitPhysicalTable(type, isPrimary, bindingOptions, bindingState, bindingContext);
    }

    private static <A extends Annotation> PhysicalTable bindExplicitPhysicalTable(EntityTypeMetadata type, AnnotationUsage<A> tableAnn, boolean isPrimary, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        Identifier logicalName = TableHelper.determineLogicalName(type, tableAnn, bindingOptions, bindingState, bindingContext);
        Identifier logicalSchemaName = TableHelper.resolveDatabaseIdentifier(tableAnn, "schema", bindingOptions.getDefaultSchemaName(), QuotedIdentifierTarget.SCHEMA_NAME, bindingOptions, bindingState, bindingContext);
        Identifier logicalCatalogName = TableHelper.resolveDatabaseIdentifier(tableAnn, "catalog", bindingOptions.getDefaultCatalogName(), QuotedIdentifierTarget.CATALOG_NAME, bindingOptions, bindingState, bindingContext);
        Table table = bindingState.getMetadataBuildingContext().getMetadataCollector().addTable(logicalSchemaName == null ? null : logicalSchemaName.getCanonicalName(), logicalCatalogName == null ? null : logicalCatalogName.getCanonicalName(), logicalName.getCanonicalName(), null, type.isAbstract(), bindingState.getMetadataBuildingContext());
        PrimaryKey primaryKey = new PrimaryKey(table);
        table.setPrimaryKey(primaryKey);
        TableHelper.applyComment(table, tableAnn, TableHelper.findCommentAnnotation(type, logicalName, isPrimary));
        TableHelper.applyOptions(table, tableAnn);
        JdbcEnvironment jdbcEnvironment = TableHelper.jdbcEnvironment(bindingContext);
        PhysicalNamingStrategy physicalNamingStrategy = TableHelper.physicalNamingStrategy(bindingContext);
        return new PhysicalTable(logicalName, logicalCatalogName, logicalSchemaName, physicalNamingStrategy.toPhysicalTableName(logicalName, jdbcEnvironment), logicalCatalogName == null ? null : physicalNamingStrategy.toPhysicalCatalogName(logicalCatalogName, jdbcEnvironment), logicalSchemaName == null ? null : physicalNamingStrategy.toPhysicalSchemaName(logicalSchemaName, jdbcEnvironment), table);
    }

    private static PhysicalTable bindImplicitPhysicalTable(EntityTypeMetadata type, boolean isPrimary, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        Identifier logicalName = TableHelper.determineLogicalName(type, null, bindingOptions, bindingState, bindingContext);
        Table table = bindingState.getMetadataBuildingContext().getMetadataCollector().addTable(bindingOptions.getDefaultSchemaName() == null ? null : bindingOptions.getDefaultSchemaName().getCanonicalName(), bindingOptions.getDefaultCatalogName() == null ? null : bindingOptions.getDefaultCatalogName().getCanonicalName(), logicalName.getCanonicalName(), null, type.isAbstract(), bindingState.getMetadataBuildingContext());
        PrimaryKey primaryKey = new PrimaryKey(table);
        table.setPrimaryKey(primaryKey);
        TableHelper.applyComment(table, null, TableHelper.findCommentAnnotation(type, logicalName, isPrimary));
        JdbcEnvironment jdbcEnvironment = TableHelper.jdbcEnvironment(bindingContext);
        PhysicalNamingStrategy physicalNamingStrategy = TableHelper.physicalNamingStrategy(bindingContext);
        return new PhysicalTable(logicalName, bindingOptions.getDefaultCatalogName(), bindingOptions.getDefaultSchemaName(), physicalNamingStrategy.toPhysicalTableName(logicalName, jdbcEnvironment), physicalNamingStrategy.toPhysicalCatalogName(bindingOptions.getDefaultCatalogName(), jdbcEnvironment), physicalNamingStrategy.toPhysicalSchemaName(bindingOptions.getDefaultSchemaName(), jdbcEnvironment), table);
    }

    private static TableReference bindUnionTable(EntityTypeMetadata type, AnnotationUsage<jakarta.persistence.Table> tableAnn, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        assert (type.getSuperType() != null);
        Object superTypeTable = bindingState.getTableByOwner(type.getSuperType());
        Table unionBaseTable = superTypeTable.table();
        Identifier logicalName = TableHelper.determineLogicalName(type, tableAnn, bindingOptions, bindingState, bindingContext);
        Identifier logicalSchemaName = TableHelper.resolveDatabaseIdentifier(tableAnn, "schema", bindingOptions.getDefaultSchemaName(), QuotedIdentifierTarget.SCHEMA_NAME, bindingOptions, bindingState, bindingContext);
        Identifier logicalCatalogName = TableHelper.resolveDatabaseIdentifier(tableAnn, "catalog", bindingOptions.getDefaultCatalogName(), QuotedIdentifierTarget.CATALOG_NAME, bindingOptions, bindingState, bindingContext);
        MetadataBuildingContext buildingContext = bindingState.getMetadataBuildingContext();
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        DenormalizedTable table = (DenormalizedTable)metadataCollector.addDenormalizedTable(logicalSchemaName == null ? null : logicalSchemaName.getCanonicalName(), logicalCatalogName == null ? null : logicalCatalogName.getCanonicalName(), logicalName.getCanonicalName(), type.isAbstract(), null, unionBaseTable, buildingContext);
        PrimaryKey primaryKey = new PrimaryKey(table);
        table.setPrimaryKey(primaryKey);
        return new UnionTable(logicalName, (TableReference)superTypeTable, table, !type.hasSubTypes());
    }

    private static Identifier determineLogicalName(final EntityTypeMetadata type, AnnotationUsage<?> tableAnn, BindingOptions bindingOptions, final BindingState bindingState, BindingContext bindingContext) {
        String name;
        if (tableAnn != null && (name = StringHelper.nullIfEmpty(tableAnn.getString("name"))) != null) {
            return BindingHelper.toIdentifier(name, QuotedIdentifierTarget.TABLE_NAME, bindingOptions, TableHelper.jdbcEnvironment(bindingContext));
        }
        return TableHelper.implicitNamingStrategy(bindingContext).determinePrimaryTableName(new ImplicitEntityNameSource(){

            @Override
            public EntityNaming getEntityNaming() {
                return type;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return bindingState.getMetadataBuildingContext();
            }
        });
    }

    private static String toCanonicalName(Identifier name) {
        if (name == null) {
            return null;
        }
        return name.getCanonicalName();
    }

    private static <A extends Annotation> Identifier resolveDatabaseIdentifier(AnnotationUsage<A> annotationUsage, String attributeName, Identifier fallback, QuotedIdentifierTarget target, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (annotationUsage == null) {
            return fallback;
        }
        String explicitValue = annotationUsage.getString(attributeName);
        if (StringHelper.isEmpty(explicitValue)) {
            return fallback;
        }
        return BindingHelper.toIdentifier(explicitValue, target, bindingOptions, TableHelper.jdbcEnvironment(bindingContext));
    }

    private static AnnotationUsage<Comment> findCommentAnnotation(EntityTypeMetadata type, Identifier logicalTableName, boolean isPrimary) {
        AnnotationUsage unnamed;
        if (isPrimary && (unnamed = type.getClassDetails().getNamedAnnotationUsage(Comment.class, "", "on")) != null) {
            return unnamed;
        }
        return type.getClassDetails().getNamedAnnotationUsage(Comment.class, logicalTableName.getCanonicalName(), "on");
    }

    private static void applyComment(Table table, AnnotationUsage<?> tableAnn, AnnotationUsage<Comment> commentAnn) {
        String comment;
        if (commentAnn != null) {
            table.setComment(commentAnn.getString("value"));
        } else if (tableAnn != null && StringHelper.isNotEmpty(comment = tableAnn.getString("comment"))) {
            table.setComment(comment);
        }
    }

    private static void applyOptions(Table table, AnnotationUsage<?> tableAnn) {
        String options;
        if (tableAnn != null && StringHelper.isNotEmpty(options = tableAnn.getString("options"))) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private static ImplicitNamingStrategy implicitNamingStrategy(BindingContext bindingContext) {
        return bindingContext.getBootstrapContext().getMetadataBuildingOptions().getImplicitNamingStrategy();
    }

    private static PhysicalNamingStrategy physicalNamingStrategy(BindingContext bindingContext) {
        return bindingContext.getBootstrapContext().getMetadataBuildingOptions().getPhysicalNamingStrategy();
    }

    private static JdbcEnvironment jdbcEnvironment(BindingContext bindingContext) {
        return bindingContext.getServiceRegistry().getService(JdbcEnvironment.class);
    }
}

