/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.spi;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.boot.models.AnnotationPlacementException;
import org.hibernate.boot.models.bind.ModelBindingLogging;
import org.hibernate.boot.models.bind.internal.RootEntityBinding;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.CategorizedDomainModel;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.FilterDefRegistration;
import org.hibernate.boot.models.categorize.spi.GlobalRegistrations;
import org.hibernate.models.spi.AnnotationUsage;

public class BindingCoordinator {
    private final CategorizedDomainModel categorizedDomainModel;
    private final BindingState bindingState;
    private final BindingOptions bindingOptions;
    private final BindingContext bindingContext;

    public BindingCoordinator(CategorizedDomainModel categorizedDomainModel, BindingState bindingState, BindingOptions bindingOptions, BindingContext bindingContext) {
        this.categorizedDomainModel = categorizedDomainModel;
        this.bindingOptions = bindingOptions;
        this.bindingState = bindingState;
        this.bindingContext = bindingContext;
    }

    public static void coordinateBinding(CategorizedDomainModel categorizedDomainModel, BindingState state, BindingOptions options, BindingContext bindingContext) {
        BindingCoordinator coordinator = new BindingCoordinator(categorizedDomainModel, state, options, bindingContext);
        coordinator.coordinateBinding();
    }

    private void coordinateBinding() {
        this.coordinateGlobalBindings();
        this.coordinateModelBindings();
    }

    private void coordinateModelBindings() {
        this.categorizedDomainModel.forEachEntityHierarchy(this::processHierarchy);
    }

    private void coordinateGlobalBindings() {
        this.processGenerators(this.categorizedDomainModel.getGlobalRegistrations());
        this.processConverters(this.categorizedDomainModel.getGlobalRegistrations());
        this.processJavaTypeRegistrations(this.categorizedDomainModel.getGlobalRegistrations());
        this.processJdbcTypeRegistrations(this.categorizedDomainModel.getGlobalRegistrations());
        this.processCustomTypes(this.categorizedDomainModel.getGlobalRegistrations());
        this.processInstantiators(this.categorizedDomainModel.getGlobalRegistrations());
        this.processEventListeners(this.categorizedDomainModel.getGlobalRegistrations());
        this.processFilterDefinitions(this.categorizedDomainModel.getGlobalRegistrations());
    }

    private RootEntityBinding processHierarchy(int index, EntityHierarchy hierarchy) {
        EntityTypeMetadata rootTypeMetadata = hierarchy.getRoot();
        ModelBindingLogging.MODEL_BINDING_LOGGER.tracef("Creating root entity table - %s", (Object)rootTypeMetadata.getEntityName());
        return new RootEntityBinding(rootTypeMetadata, this.bindingOptions, this.bindingState, this.bindingContext);
    }

    private void processGenerators(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getSequenceGeneratorRegistrations();
        globalRegistrations.getTableGeneratorRegistrations();
        globalRegistrations.getGenericGeneratorRegistrations();
    }

    private void processConverters(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getConverterRegistrations();
    }

    private void processJavaTypeRegistrations(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getJavaTypeRegistrations();
    }

    private void processJdbcTypeRegistrations(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getJdbcTypeRegistrations();
    }

    private void processCustomTypes(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getUserTypeRegistrations();
        globalRegistrations.getCompositeUserTypeRegistrations();
        globalRegistrations.getCollectionTypeRegistrations();
    }

    private void processInstantiators(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getEmbeddableInstantiatorRegistrations();
    }

    private void processEventListeners(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getEntityListenerRegistrations();
    }

    private void processFilterDefinitions(GlobalRegistrations globalRegistrations) {
        globalRegistrations.getFilterDefRegistrations().forEach((s, filterDefRegistration) -> this.bindingState.apply((FilterDefRegistration)filterDefRegistration));
    }

    private void processTables(AttributeMetadata attribute) {
        boolean hasAnyAssociationAnnotations;
        AnnotationUsage joinTableAnn = attribute.getMember().getAnnotationUsage(JoinTable.class);
        AnnotationUsage collectionTableAnn = attribute.getMember().getAnnotationUsage(CollectionTable.class);
        AnnotationUsage oneToOneAnn = attribute.getMember().getAnnotationUsage(OneToOne.class);
        AnnotationUsage manyToOneAnn = attribute.getMember().getAnnotationUsage(ManyToOne.class);
        AnnotationUsage elementCollectionAnn = attribute.getMember().getAnnotationUsage(ElementCollection.class);
        AnnotationUsage oneToManyAnn = attribute.getMember().getAnnotationUsage(OneToMany.class);
        AnnotationUsage anyAnn = attribute.getMember().getAnnotationUsage(Any.class);
        AnnotationUsage manyToAnyAnn = attribute.getMember().getAnnotationUsage(ManyToAny.class);
        boolean hasAnyTableAnnotations = joinTableAnn != null || collectionTableAnn != null;
        boolean bl = hasAnyAssociationAnnotations = oneToOneAnn != null || manyToOneAnn != null || elementCollectionAnn != null || oneToManyAnn != null || anyAnn != null || manyToAnyAnn != null;
        if (!hasAnyAssociationAnnotations && hasAnyTableAnnotations) {
            throw new AnnotationPlacementException("@JoinTable or @CollectionTable used on non-association attribute - " + attribute.getMember());
        }
        if (elementCollectionAnn != null && joinTableAnn != null) {
            throw new AnnotationPlacementException("@JoinTable should not be used with @ElementCollection; use @CollectionTable instead - " + attribute.getMember());
        }
    }
}

