/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.AccessType;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.ExcludeDefaultListeners;
import jakarta.persistence.ExcludeSuperclassListeners;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.boot.models.categorize.internal.AbstractManagedTypeMetadata;
import org.hibernate.boot.models.categorize.internal.CategorizationHelper;
import org.hibernate.boot.models.categorize.internal.EntityTypeMetadataImpl;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.internal.MappedSuperclassTypeMetadataImpl;
import org.hibernate.boot.models.categorize.spi.ClassAttributeAccessType;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.categorize.spi.MappedSuperclassTypeMetadata;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;

public abstract class AbstractIdentifiableTypeMetadata
extends AbstractManagedTypeMetadata
implements IdentifiableTypeMetadata {
    private final EntityHierarchy hierarchy;
    private final IdentifiableTypeMetadata superType;
    private final Set<IdentifiableTypeMetadata> subTypes = new HashSet<IdentifiableTypeMetadata>();
    private final ClassAttributeAccessType classLevelAccessType;

    public AbstractIdentifiableTypeMetadata(ClassDetails classDetails, EntityHierarchy hierarchy, MappedSuperclassTypeMetadata superTypeMetadata, AccessType implicitAccessType, ModelCategorizationContext processingContext) {
        super(classDetails, processingContext);
        this.hierarchy = hierarchy;
        this.superType = superTypeMetadata;
        this.classLevelAccessType = CategorizationHelper.determineAccessType(classDetails, implicitAccessType);
    }

    public AbstractIdentifiableTypeMetadata(ClassDetails classDetails, EntityHierarchy hierarchy, IdentifiableTypeMetadata superType, ModelCategorizationContext processingContext) {
        super(classDetails, processingContext);
        assert (superType != null);
        this.hierarchy = hierarchy;
        this.superType = superType;
        this.classLevelAccessType = CategorizationHelper.determineAccessType(classDetails, hierarchy.getDefaultAccessType());
    }

    protected void postInstantiate(boolean rootEntityOrSubclass, HierarchyTypeConsumer typeConsumer) {
        typeConsumer.acceptType(this);
        if (rootEntityOrSubclass) {
            this.walkSubclasses(typeConsumer);
        }
        this.collectConversionInfo();
        this.collectAttributeOverrides();
        this.collectAssociationOverrides();
    }

    private void walkSubclasses(HierarchyTypeConsumer typeConsumer) {
        this.walkSubclasses(this.getClassDetails(), typeConsumer);
    }

    private void walkSubclasses(ClassDetails base, HierarchyTypeConsumer typeConsumer) {
        ClassDetailsRegistry classDetailsRegistry = this.getModelContext().getClassDetailsRegistry();
        classDetailsRegistry.forEachDirectSubType(base.getName(), subClassDetails -> {
            if (CategorizationHelper.isEntity(subClassDetails)) {
                EntityTypeMetadataImpl subTypeMetadata = new EntityTypeMetadataImpl(subClassDetails, this.getHierarchy(), this, typeConsumer, this.getModelContext());
                this.addSubclass(subTypeMetadata);
            } else if (CategorizationHelper.isMappedSuperclass(subClassDetails)) {
                MappedSuperclassTypeMetadataImpl subTypeMetadata = new MappedSuperclassTypeMetadataImpl(subClassDetails, this.getHierarchy(), this, typeConsumer, this.getModelContext());
                this.addSubclass(subTypeMetadata);
            } else {
                this.walkSubclasses(subClassDetails, typeConsumer);
            }
        });
    }

    protected void addSubclass(IdentifiableTypeMetadata subclass) {
        this.subTypes.add(subclass);
    }

    @Override
    public EntityHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public IdentifiableTypeMetadata getSuperType() {
        return this.superType;
    }

    @Override
    public boolean isAbstract() {
        return this.getClassDetails().isAbstract();
    }

    @Override
    public boolean hasSubTypes() {
        return !this.subTypes.isEmpty();
    }

    @Override
    public int getNumberOfSubTypes() {
        return this.subTypes.size();
    }

    @Override
    public void forEachSubType(Consumer<IdentifiableTypeMetadata> consumer) {
        this.subTypes.forEach(consumer);
    }

    @Override
    public Iterable<IdentifiableTypeMetadata> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public ClassAttributeAccessType getClassLevelAccessType() {
        return this.classLevelAccessType;
    }

    protected void collectConversionInfo() {
    }

    protected void collectAttributeOverrides() {
    }

    protected void collectAssociationOverrides() {
    }

    protected List<JpaEventListener> collectHierarchyEventListeners(JpaEventListener localCallback) {
        IdentifiableTypeMetadata superType;
        ClassDetails classDetails = this.getClassDetails();
        ArrayList<JpaEventListener> combined = new ArrayList<JpaEventListener>();
        if (classDetails.getAnnotationUsage(ExcludeSuperclassListeners.class) == null && (superType = this.getSuperType()) != null) {
            combined.addAll(superType.getHierarchyJpaEventListeners());
        }
        this.applyLocalEventListeners(combined::add);
        if (localCallback != null) {
            combined.add(localCallback);
        }
        return combined;
    }

    private void applyLocalEventListeners(Consumer<JpaEventListener> consumer) {
        ClassDetails classDetails = this.getClassDetails();
        AnnotationUsage entityListenersAnnotation = classDetails.getAnnotationUsage(EntityListeners.class);
        if (entityListenersAnnotation == null) {
            return;
        }
        List entityListenerClasses = (List)entityListenersAnnotation.getAttributeValue("value");
        if (CollectionHelper.isEmpty(entityListenerClasses)) {
            return;
        }
        entityListenerClasses.forEach(listenerClass -> consumer.accept(JpaEventListener.from(JpaEventListenerStyle.LISTENER, listenerClass)));
    }

    protected List<JpaEventListener> collectCompleteEventListeners(ModelCategorizationContext modelContext) {
        ClassDetails classDetails = this.getClassDetails();
        if (classDetails.getAnnotationUsage(ExcludeDefaultListeners.class) != null) {
            return this.getHierarchyJpaEventListeners();
        }
        ArrayList<JpaEventListener> combined = new ArrayList<JpaEventListener>();
        combined.addAll(modelContext.getDefaultEventListeners());
        combined.addAll(this.getHierarchyJpaEventListeners());
        return combined;
    }
}

