/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.models.categorize.ModelCategorizationLogging;
import org.hibernate.boot.models.categorize.internal.AggregatedKeyMappingImpl;
import org.hibernate.boot.models.categorize.internal.BasicKeyMappingImpl;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.internal.NonAggregatedKeyMappingImpl;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.KeyMapping;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public class HierarchyMetadataCollector
implements HierarchyTypeConsumer {
    private final EntityHierarchy entityHierarchy;
    private final ClassDetails rootEntityClassDetails;
    private final HierarchyTypeConsumer delegateConsumer;
    private boolean belowRootEntity;
    private EntityTypeMetadata rootEntityMetadata;
    private AnnotationUsage<Inheritance> inheritanceAnnotation;
    private AnnotationUsage<OptimisticLocking> optimisticLockingAnnotation;
    private AnnotationUsage<Cache> cacheAnnotation;
    private AnnotationUsage<NaturalIdCache> naturalIdCacheAnnotation;
    private KeyMapping idMapping;
    private AttributeMetadata versionAttribute;
    private AttributeMetadata tenantIdAttribute;
    private AnnotationUsage<IdClass> idClassAnnotation;
    private Object collectedIdAttributes;
    private Object collectedNaturalIdAttributes;

    public HierarchyMetadataCollector(EntityHierarchy entityHierarchy, ClassDetails rootEntityClassDetails, HierarchyTypeConsumer delegateConsumer) {
        this.entityHierarchy = entityHierarchy;
        this.rootEntityClassDetails = rootEntityClassDetails;
        this.delegateConsumer = delegateConsumer;
    }

    public EntityTypeMetadata getRootEntityMetadata() {
        return this.rootEntityMetadata;
    }

    public KeyMapping getIdMapping() {
        if (this.idMapping == null) {
            this.idMapping = this.buildIdMapping();
        }
        return this.idMapping;
    }

    public AnnotationUsage<Inheritance> getInheritanceAnnotation() {
        return this.inheritanceAnnotation;
    }

    public AttributeMetadata getVersionAttribute() {
        return this.versionAttribute;
    }

    public AttributeMetadata getTenantIdAttribute() {
        return this.tenantIdAttribute;
    }

    public AnnotationUsage<OptimisticLocking> getOptimisticLockingAnnotation() {
        return this.optimisticLockingAnnotation;
    }

    public AnnotationUsage<Cache> getCacheAnnotation() {
        return this.cacheAnnotation;
    }

    public AnnotationUsage<NaturalIdCache> getNaturalIdCacheAnnotation() {
        return this.naturalIdCacheAnnotation;
    }

    private KeyMapping buildIdMapping() {
        if (this.collectedIdAttributes == null) {
            throw new AnnotationException("Unable to determine id attribute(s) - " + this.rootEntityClassDetails.getName());
        }
        if (this.collectedIdAttributes instanceof List) {
            List idAttributes = (List)this.collectedIdAttributes;
            ClassDetails idClassDetails = this.idClassAnnotation == null ? null : (ClassDetails)this.idClassAnnotation.getAttributeValue("value");
            return new NonAggregatedKeyMappingImpl(idAttributes, idClassDetails);
        }
        AttributeMetadata idAttribute = (AttributeMetadata)this.collectedIdAttributes;
        if (idAttribute.getNature() == AttributeMetadata.AttributeNature.BASIC) {
            return new BasicKeyMappingImpl(idAttribute);
        }
        if (idAttribute.getNature() == AttributeMetadata.AttributeNature.EMBEDDED) {
            return new AggregatedKeyMappingImpl(idAttribute);
        }
        if (idAttribute.getNature() == AttributeMetadata.AttributeNature.TO_ONE) {
            List<AttributeMetadata> idAttributes = List.of(idAttribute);
            ClassDetails idClassDetails = this.idClassAnnotation == null ? null : (ClassDetails)this.idClassAnnotation.getAttributeValue("value");
            return new NonAggregatedKeyMappingImpl(idAttributes, idClassDetails);
        }
        throw new ModelsException(String.format(Locale.ROOT, "Unexpected attribute nature [%s] - %s", new Object[]{idAttribute.getNature(), this.entityHierarchy.getRoot().getEntityName()}));
    }

    public KeyMapping getNaturalIdMapping() {
        if (this.collectedNaturalIdAttributes == null) {
            return null;
        }
        if (this.collectedNaturalIdAttributes instanceof List) {
            List attributes = (List)this.collectedNaturalIdAttributes;
            return new NonAggregatedKeyMappingImpl(attributes, null);
        }
        AttributeMetadata attribute = (AttributeMetadata)this.collectedNaturalIdAttributes;
        if (attribute.getNature() == AttributeMetadata.AttributeNature.BASIC) {
            return new BasicKeyMappingImpl(attribute);
        }
        if (attribute.getNature() == AttributeMetadata.AttributeNature.EMBEDDED) {
            return new AggregatedKeyMappingImpl(attribute);
        }
        if (attribute.getNature() == AttributeMetadata.AttributeNature.TO_ONE) {
            return new BasicKeyMappingImpl(attribute);
        }
        throw new ModelsException(String.format(Locale.ROOT, "Unexpected attribute nature [%s] - %s", new Object[]{attribute.getNature(), this.entityHierarchy.getRoot().getEntityName()}));
    }

    @Override
    public void acceptType(IdentifiableTypeMetadata typeMetadata) {
        boolean collectIds;
        if (this.delegateConsumer != null) {
            this.delegateConsumer.acceptType(typeMetadata);
        }
        if (this.belowRootEntity) {
            return;
        }
        ClassDetails classDetails = typeMetadata.getClassDetails();
        if (classDetails == this.rootEntityClassDetails) {
            this.rootEntityMetadata = (EntityTypeMetadata)typeMetadata;
            this.belowRootEntity = true;
        }
        this.inheritanceAnnotation = this.applyLocalAnnotation(Inheritance.class, classDetails, this.inheritanceAnnotation);
        this.optimisticLockingAnnotation = this.applyLocalAnnotation(OptimisticLocking.class, classDetails, this.optimisticLockingAnnotation);
        this.cacheAnnotation = this.applyLocalAnnotation(Cache.class, classDetails, this.cacheAnnotation);
        this.naturalIdCacheAnnotation = this.applyLocalAnnotation(NaturalIdCache.class, classDetails, this.naturalIdCacheAnnotation);
        this.idClassAnnotation = this.applyLocalAnnotation(IdClass.class, classDetails, this.idClassAnnotation);
        boolean bl = collectIds = this.collectedIdAttributes == null;
        if (collectIds || this.versionAttribute == null || this.tenantIdAttribute == null) {
            typeMetadata.forEachAttribute((index, attributeMetadata) -> {
                MemberDetails attributeMember = attributeMetadata.getMember();
                if (collectIds) {
                    AnnotationUsage idAnn;
                    AnnotationUsage eIdAnn = attributeMember.getAnnotationUsage(EmbeddedId.class);
                    if (eIdAnn != null) {
                        this.collectIdAttribute((AttributeMetadata)attributeMetadata);
                    }
                    if ((idAnn = attributeMember.getAnnotationUsage(Id.class)) != null) {
                        this.collectIdAttribute((AttributeMetadata)attributeMetadata);
                    }
                }
                if (attributeMember.getAnnotationUsage(NaturalId.class) != null) {
                    this.collectNaturalIdAttribute((AttributeMetadata)attributeMetadata);
                }
                if (this.versionAttribute == null && attributeMember.getAnnotationUsage(Version.class) != null) {
                    this.versionAttribute = attributeMetadata;
                }
                if (this.tenantIdAttribute == null && attributeMember.getAnnotationUsage(TenantId.class) != null) {
                    this.tenantIdAttribute = attributeMetadata;
                }
            });
        }
    }

    private <A extends Annotation> AnnotationUsage<A> applyLocalAnnotation(Class<A> annotationType, ClassDetails classDetails, AnnotationUsage<A> currentValue) {
        AnnotationUsage localInheritanceAnnotation = classDetails.getAnnotationUsage(annotationType);
        if (localInheritanceAnnotation != null) {
            if (currentValue != null) {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Ignoring @%s from %s in favor of usage from %s", (Object)annotationType.getSimpleName(), (Object)classDetails.getName(), (Object)currentValue.getAnnotationTarget().getName());
            }
            return localInheritanceAnnotation;
        }
        return currentValue;
    }

    public void collectIdAttribute(AttributeMetadata member) {
        assert (member != null);
        if (this.collectedIdAttributes == null) {
            this.collectedIdAttributes = member;
        } else if (this.collectedIdAttributes instanceof List) {
            List membersList = (List)this.collectedIdAttributes;
            membersList.add(member);
        } else if (this.collectedIdAttributes instanceof AttributeMetadata) {
            ArrayList<AttributeMetadata> combined = new ArrayList<AttributeMetadata>();
            combined.add((AttributeMetadata)this.collectedIdAttributes);
            combined.add(member);
            this.collectedIdAttributes = combined;
        }
    }

    public void collectNaturalIdAttribute(AttributeMetadata member) {
        assert (member != null);
        if (this.collectedNaturalIdAttributes == null) {
            this.collectedNaturalIdAttributes = member;
        } else if (this.collectedNaturalIdAttributes instanceof List) {
            List membersList = (List)this.collectedNaturalIdAttributes;
            membersList.add(member);
        } else if (this.collectedNaturalIdAttributes instanceof AttributeMetadata) {
            ArrayList<AttributeMetadata> combined = new ArrayList<AttributeMetadata>();
            combined.add((AttributeMetadata)this.collectedNaturalIdAttributes);
            combined.add(member);
            this.collectedNaturalIdAttributes = combined;
        }
    }
}

