/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorStandardImpl;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.models.Copied;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

@Copied(value=RegisteredConversion.class)
public class ConversionRegistration {
    private final ClassDetails explicitDomainType;
    private final ClassDetails converterType;
    private final boolean autoApply;
    private final AnnotationDescriptor<? extends Annotation> source;

    public ConversionRegistration(ClassDetails explicitDomainType, ClassDetails converterType, boolean autoApply, AnnotationDescriptor<? extends Annotation> source) {
        assert (converterType != null);
        this.explicitDomainType = explicitDomainType;
        this.converterType = converterType;
        this.autoApply = autoApply;
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionRegistration that = (ConversionRegistration)o;
        return this.autoApply == that.autoApply && Objects.equals(this.explicitDomainType, that.explicitDomainType) && this.converterType.equals(that.converterType);
    }

    public int hashCode() {
        return Objects.hash(this.explicitDomainType, this.converterType);
    }

    public ClassDetails getExplicitDomainType() {
        return this.explicitDomainType;
    }

    public ClassDetails getConverterType() {
        return this.converterType;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public AnnotationDescriptor<? extends Annotation> getSource() {
        return this.source;
    }

    public String toString() {
        return "ConversionRegistration( " + this.converterType.getClassName() + ", " + this.source.getAnnotationType().getSimpleName() + ", " + this.autoApply + ")";
    }

    public ConverterDescriptor makeConverterDescriptor(ClassmateContext classmateContext) {
        Class explicitDomainType = this.explicitDomainType.toJavaClass();
        Class converterType = this.converterType.toJavaClass();
        List<ResolvedType> resolvedParamTypes = ConverterHelper.resolveConverterClassParamTypes(converterType, classmateContext);
        ResolvedType relationalType = resolvedParamTypes.get(1);
        ResolvedType domainTypeToMatch = !Void.TYPE.equals(explicitDomainType) ? classmateContext.getTypeResolver().resolve((Type)explicitDomainType, new Type[0]) : resolvedParamTypes.get(0);
        return new ConverterDescriptorImpl(converterType, domainTypeToMatch, relationalType, this.autoApply);
    }

    private static class ConverterDescriptorImpl
    implements ConverterDescriptor {
        private final Class<? extends AttributeConverter<?, ?>> converterType;
        private final ResolvedType domainTypeToMatch;
        private final ResolvedType relationalType;
        private final boolean autoApply;
        private final AutoApplicableConverterDescriptor autoApplyDescriptor;

        public ConverterDescriptorImpl(Class<? extends AttributeConverter<?, ?>> converterType, ResolvedType domainTypeToMatch, ResolvedType relationalType, boolean autoApply) {
            this.converterType = converterType;
            this.domainTypeToMatch = domainTypeToMatch;
            this.relationalType = relationalType;
            this.autoApply = autoApply;
            this.autoApplyDescriptor = autoApply ? new AutoApplicableConverterDescriptorStandardImpl(this) : AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
        }

        @Override
        public Class<? extends AttributeConverter<?, ?>> getAttributeConverterClass() {
            return this.converterType;
        }

        @Override
        public ResolvedType getDomainValueResolvedType() {
            return this.domainTypeToMatch;
        }

        @Override
        public ResolvedType getRelationalValueResolvedType() {
            return this.relationalType;
        }

        @Override
        public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
            return this.autoApplyDescriptor;
        }

        @Override
        public JpaAttributeConverter<?, ?> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
            ManagedBean<AttributeConverter<?, ?>> converterBean = context.getManagedBeanRegistry().getBean(this.converterType);
            TypeConfiguration typeConfiguration = context.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            javaTypeRegistry.resolveDescriptor(this.domainTypeToMatch.getErasedType());
            return new JpaAttributeConverterImpl(converterBean, javaTypeRegistry.getDescriptor(converterBean.getBeanClass()), javaTypeRegistry.resolveDescriptor(this.domainTypeToMatch.getErasedType()), javaTypeRegistry.resolveDescriptor(this.relationalType.getErasedType()));
        }
    }
}

