/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.boot.model.internal.FilterDefBinder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;

public class FilterDefRegistration {
    private final String name;
    private final String defaultCondition;
    private final boolean autoEnabled;
    private final Map<String, ClassDetails> parameterTypes;
    private final Map<String, ClassDetails> parameterResolvers;

    public FilterDefRegistration(String name, String defaultCondition, boolean autoEnabled, Map<String, ClassDetails> parameterTypes, Map<String, ClassDetails> parameterResolvers) {
        this.name = name;
        this.defaultCondition = defaultCondition;
        this.autoEnabled = autoEnabled;
        this.parameterTypes = parameterTypes;
        this.parameterResolvers = parameterResolvers;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultCondition() {
        return this.defaultCondition;
    }

    public boolean isAutoEnabled() {
        return this.autoEnabled;
    }

    public Map<String, ClassDetails> getParameterTypes() {
        return this.parameterTypes;
    }

    public Map<String, ClassDetails> getParameterResolvers() {
        return this.parameterResolvers;
    }

    public FilterDefinition toFilterDefinition(MetadataBuildingContext buildingContext) {
        Map<String, ManagedBean<? extends Supplier<?>>> parameterResolvers;
        Map<String, JdbcMapping> parameterJdbcMappings;
        ManagedBeanRegistry beanRegistry = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        if (CollectionHelper.isEmpty(this.parameterTypes)) {
            parameterJdbcMappings = Collections.emptyMap();
        } else {
            parameterJdbcMappings = new HashMap();
            this.parameterTypes.forEach((key, value) -> parameterJdbcMappings.put((String)key, FilterDefBinder.resolveFilterParamType(value.toJavaClass(), buildingContext)));
        }
        if (CollectionHelper.isEmpty(this.parameterResolvers)) {
            parameterResolvers = Collections.emptyMap();
        } else {
            parameterResolvers = new HashMap();
            this.parameterResolvers.forEach((key, value) -> parameterResolvers.put((String)key, beanRegistry.getBean(value.toJavaClass())));
        }
        return new FilterDefinition(this.getName(), this.getDefaultCondition(), this.isAutoEnabled(), parameterJdbcMappings, parameterResolvers);
    }
}

