/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Internal;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.RootMappingDefaults;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.models.categorize.ModelCategorizationLogging;
import org.hibernate.boot.models.categorize.internal.ClassLoaderServiceLoading;
import org.hibernate.boot.models.categorize.internal.DomainModelCategorizationCollector;
import org.hibernate.boot.models.categorize.internal.EntityHierarchyBuilder;
import org.hibernate.boot.models.categorize.internal.GlobalRegistrationsImpl;
import org.hibernate.boot.models.categorize.internal.ModelCategorizationContextImpl;
import org.hibernate.boot.models.categorize.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.categorize.spi.CategorizedDomainModel;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.MappedSuperclassTypeMetadata;
import org.hibernate.boot.models.xml.internal.PersistenceUnitMetadataImpl;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlPreProcessor;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlProcessor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.internal.SourceModelBuildingContextImpl;
import org.hibernate.models.internal.jandex.JandexClassDetails;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;

public class ManagedResourcesProcessor {
    public static CategorizedDomainModel processManagedResources(ManagedResources managedResources, MetadataBuildingOptions metadataBuildingOptions, BootstrapContext bootstrapContext) {
        Set<EntityHierarchy> entityHierarchies;
        ClassLoaderService classLoaderService = bootstrapContext.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderServiceLoading classLoading = new ClassLoaderServiceLoading(classLoaderService);
        PersistenceUnitMetadataImpl persistenceUnitMetadata = new PersistenceUnitMetadataImpl();
        XmlPreProcessingResult xmlPreProcessingResult = XmlPreProcessor.preProcessXmlResources(managedResources, persistenceUnitMetadata);
        List<String> allKnownClassNames = CollectionHelper.mutableJoin((Collection)managedResources.getAnnotatedClassReferences().stream().map(Class::getName).collect(Collectors.toList()), managedResources.getAnnotatedClassNames(), xmlPreProcessingResult.getMappedClasses());
        managedResources.getAnnotatedPackageNames().forEach(packageName -> {
            try {
                Class packageInfoClass = classLoading.classForName(packageName + ".package-info");
                allKnownClassNames.add(packageInfoClass.getName());
            }
            catch (ClassLoadingException classLoadingException) {
                // empty catch block
            }
        });
        managedResources.getAnnotatedClassReferences().forEach(clazz -> allKnownClassNames.add(clazz.getName()));
        IndexView jandexIndex = ManagedResourcesProcessor.resolveJandexIndex(allKnownClassNames, bootstrapContext.getJandexView(), classLoading);
        SourceModelBuildingContextImpl sourceModelBuildingContext = new SourceModelBuildingContextImpl((ClassLoading)classLoading, jandexIndex, ManagedResourcesProcessor::preFillRegistries);
        boolean areIdGeneratorsGlobal = true;
        ClassDetailsRegistry classDetailsRegistry = sourceModelBuildingContext.getClassDetailsRegistry();
        AnnotationDescriptorRegistry descriptorRegistry = sourceModelBuildingContext.getAnnotationDescriptorRegistry();
        GlobalRegistrationsImpl globalRegistrations = new GlobalRegistrationsImpl((SourceModelBuildingContext)sourceModelBuildingContext, bootstrapContext);
        DomainModelCategorizationCollector modelCategorizationCollector = new DomainModelCategorizationCollector(true, globalRegistrations, jandexIndex, (SourceModelBuildingContext)sourceModelBuildingContext);
        RootMappingDefaults rootMappingDefaults = new RootMappingDefaults(metadataBuildingOptions.getMappingDefaults(), persistenceUnitMetadata);
        XmlProcessingResult xmlProcessingResult = XmlProcessor.processXml(xmlPreProcessingResult, modelCategorizationCollector, (SourceModelBuildingContext)sourceModelBuildingContext, bootstrapContext, rootMappingDefaults);
        allKnownClassNames.forEach(className -> {
            ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(className);
            modelCategorizationCollector.apply(classDetails);
        });
        xmlPreProcessingResult.getMappedNames().forEach(className -> {
            ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(className);
            modelCategorizationCollector.apply(classDetails);
        });
        xmlProcessingResult.apply(xmlPreProcessingResult.getPersistenceUnitMetadata());
        ClassDetailsRegistry classDetailsRegistryImmutable = classDetailsRegistry.makeImmutableCopy();
        AnnotationDescriptorRegistry annotationDescriptorRegistryImmutable = descriptorRegistry.makeImmutableCopy();
        ModelCategorizationContextImpl mappingBuildingContext = new ModelCategorizationContextImpl(classDetailsRegistryImmutable, annotationDescriptorRegistryImmutable, globalRegistrations);
        if (ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.isDebugEnabled()) {
            HashMap<String, ClassDetails> unusedMappedSuperClasses = new HashMap<String, ClassDetails>(modelCategorizationCollector.getMappedSuperclasses());
            entityHierarchies = EntityHierarchyBuilder.createEntityHierarchies(modelCategorizationCollector.getRootEntities(), identifiableType -> {
                if (identifiableType instanceof MappedSuperclassTypeMetadata) {
                    unusedMappedSuperClasses.remove(identifiableType.getClassDetails().getClassName());
                }
            }, mappingBuildingContext);
            ManagedResourcesProcessor.warnAboutUnusedMappedSuperclasses(unusedMappedSuperClasses);
        } else {
            entityHierarchies = EntityHierarchyBuilder.createEntityHierarchies(modelCategorizationCollector.getRootEntities(), ManagedResourcesProcessor::ignore, mappingBuildingContext);
        }
        return modelCategorizationCollector.createResult(entityHierarchies, xmlPreProcessingResult.getPersistenceUnitMetadata(), classDetailsRegistryImmutable, annotationDescriptorRegistryImmutable);
    }

    private static void ignore(IdentifiableTypeMetadata identifiableTypeMetadata) {
    }

    private static void warnAboutUnusedMappedSuperclasses(Map<String, ClassDetails> mappedSuperClasses) {
        assert (ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.isDebugEnabled());
        for (Map.Entry<String, ClassDetails> entry : mappedSuperClasses.entrySet()) {
            ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Encountered MappedSuperclass [%s] which was unused in any entity hierarchies", (Object)entry.getKey());
        }
    }

    public static IndexView resolveJandexIndex(List<String> allKnownClassNames, IndexView suppliedJandexIndex, ClassLoading classLoading) {
        return suppliedJandexIndex;
    }

    public static void preFillRegistries(RegistryPrimer.Contributions contributions, SourceModelBuildingContext buildingContext) {
        OrmAnnotationHelper.forEachOrmAnnotation(arg_0 -> ((RegistryPrimer.Contributions)contributions).registerAnnotation(arg_0));
        buildingContext.getAnnotationDescriptorRegistry().getDescriptor(TenantId.class);
        IndexView jandexIndex = buildingContext.getJandexIndex();
        if (jandexIndex == null) {
            return;
        }
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        AnnotationDescriptorRegistry annotationDescriptorRegistry = buildingContext.getAnnotationDescriptorRegistry();
        for (ClassInfo knownClass : jandexIndex.getKnownClasses()) {
            String className = knownClass.name().toString();
            if (knownClass.isAnnotation()) {
                Class annotationClass = buildingContext.getClassLoading().classForName(className);
                annotationDescriptorRegistry.resolveDescriptor(annotationClass, t -> JdkBuilders.buildAnnotationDescriptor((Class)annotationClass, (AnnotationDescriptorRegistry)buildingContext.getAnnotationDescriptorRegistry()));
            }
            classDetailsRegistry.resolveClassDetails(className, name -> new JandexClassDetails(knownClass, buildingContext));
        }
    }

    @Internal
    public static CategorizedDomainModel processManagedResources(ManagedResources managedResources, BootstrapContext bootstrapContext) {
        return ManagedResourcesProcessor.processManagedResources(managedResources, new MetadataBuilderImpl.MetadataBuildingOptionsImpl(bootstrapContext.getServiceRegistry()), bootstrapContext);
    }
}

