/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.boot.models.categorize.spi.CacheRegion;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationUsage;

public class NaturalIdCacheRegion {
    private final String regionName;

    public NaturalIdCacheRegion(AnnotationUsage<NaturalIdCache> cacheAnnotation, CacheRegion cacheRegion) {
        this.regionName = NaturalIdCacheRegion.determineRegionName(cacheAnnotation, cacheRegion);
    }

    private static String determineRegionName(AnnotationUsage<NaturalIdCache> cacheAnnotation, CacheRegion cacheRegion) {
        String explicitRegionName;
        if (cacheAnnotation != null && StringHelper.isNotEmpty(explicitRegionName = (String)cacheAnnotation.getAttributeValue("region"))) {
            return explicitRegionName;
        }
        return cacheRegion.getRegionName() + "##NaturalId";
    }

    public String getRegionName() {
        return this.regionName;
    }
}

