/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedAttributeNodeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedEntityGraphImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedSubgraphImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class EntityGraphProcessing {
    public static void applyEntityGraphs(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbNamedEntityGraphImpl> jaxbEntityGraphs = jaxbEntity.getNamedEntityGraphs();
        if (CollectionHelper.isEmpty(jaxbEntityGraphs)) {
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        MutableAnnotationUsage entityGraphsUsage = JpaAnnotations.NAMED_ENTITY_GRAPHS.createUsage((AnnotationTarget)classDetails, modelBuildingContext);
        classDetails.addAnnotationUsage((AnnotationUsage)entityGraphsUsage);
        ArrayList entityGraphList = CollectionHelper.arrayList(jaxbEntityGraphs.size());
        entityGraphsUsage.setAttributeValue("value", entityGraphList);
        for (JaxbNamedEntityGraphImpl namedEntityGraph : jaxbEntityGraphs) {
            AnnotationUsage<NamedEntityGraph> graphUsage = EntityGraphProcessing.extractGraph(namedEntityGraph, (ClassDetails)classDetails, modelBuildingContext, xmlDocumentContext);
            entityGraphList.add(graphUsage);
        }
    }

    private static AnnotationUsage<NamedEntityGraph> extractGraph(JaxbNamedEntityGraphImpl jaxbEntityGraph, ClassDetails classDetails, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        List<MutableAnnotationUsage<NamedSubgraph>> subgraphList;
        MutableAnnotationUsage graphUsage = JpaAnnotations.NAMED_ENTITY_GRAPH.createUsage((AnnotationTarget)classDetails, modelBuildingContext);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbEntityGraph.getName(), graphUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("includeAllAttributes", jaxbEntityGraph.isIncludeAllAttributes(), graphUsage);
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getNamedAttributeNode())) {
            List<MutableAnnotationUsage<NamedAttributeNode>> attributeNodeList = EntityGraphProcessing.extractAttributeNodes(jaxbEntityGraph.getNamedAttributeNode(), classDetails, modelBuildingContext, xmlDocumentContext);
            graphUsage.setAttributeValue("attributeNodes", attributeNodeList);
        }
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getSubgraph())) {
            subgraphList = EntityGraphProcessing.extractSubgraphNodes(jaxbEntityGraph.getSubgraph(), classDetails, modelBuildingContext, xmlDocumentContext);
            graphUsage.setAttributeValue("subgraphs", subgraphList);
        }
        if (CollectionHelper.isNotEmpty(jaxbEntityGraph.getSubclassSubgraph())) {
            subgraphList = EntityGraphProcessing.extractSubgraphNodes(jaxbEntityGraph.getSubclassSubgraph(), classDetails, modelBuildingContext, xmlDocumentContext);
            graphUsage.setAttributeValue("subclassSubgraphs", subgraphList);
        }
        return graphUsage;
    }

    private static List<MutableAnnotationUsage<NamedAttributeNode>> extractAttributeNodes(List<JaxbNamedAttributeNodeImpl> jaxbAttributeNodes, ClassDetails classDetails, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbAttributeNodes));
        ArrayList<MutableAnnotationUsage<NamedAttributeNode>> attributeNodeList = CollectionHelper.arrayList(jaxbAttributeNodes.size());
        for (JaxbNamedAttributeNodeImpl jaxbAttributeNode : jaxbAttributeNodes) {
            MutableAnnotationUsage namedAttributeNodeAnn = JpaAnnotations.NAMED_ATTRIBUTE_NODE.createUsage((AnnotationTarget)classDetails, modelBuildingContext);
            attributeNodeList.add((MutableAnnotationUsage<NamedAttributeNode>)namedAttributeNodeAnn);
            namedAttributeNodeAnn.setAttributeValue("value", (Object)jaxbAttributeNode.getName());
            AnnotationUsageHelper.applyStringAttributeIfSpecified("subgraph", jaxbAttributeNode.getSubgraph(), namedAttributeNodeAnn);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("keySubgraph", jaxbAttributeNode.getKeySubgraph(), namedAttributeNodeAnn);
        }
        return attributeNodeList;
    }

    private static List<MutableAnnotationUsage<NamedSubgraph>> extractSubgraphNodes(List<JaxbNamedSubgraphImpl> jaxbSubgraphs, ClassDetails classDetails, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbSubgraphs));
        ArrayList<MutableAnnotationUsage<NamedSubgraph>> subgraphAnnotations = CollectionHelper.arrayList(jaxbSubgraphs.size());
        for (JaxbNamedSubgraphImpl jaxbSubgraph : jaxbSubgraphs) {
            MutableAnnotationUsage namedSubGraphUsage = JpaAnnotations.NAMED_SUB_GRAPH.createUsage((AnnotationTarget)classDetails, modelBuildingContext);
            subgraphAnnotations.add((MutableAnnotationUsage<NamedSubgraph>)namedSubGraphUsage);
            namedSubGraphUsage.setAttributeValue("name", (Object)jaxbSubgraph.getName());
            Object typeDetails = jaxbSubgraph.getClazz() == null ? ClassDetails.VOID_CLASS_DETAILS : xmlDocumentContext.resolveJavaType(jaxbSubgraph.getClazz());
            namedSubGraphUsage.setAttributeValue("type", typeDetails);
            if (!CollectionHelper.isNotEmpty(jaxbSubgraph.getNamedAttributeNode())) continue;
            namedSubGraphUsage.setAttributeValue("attributeNodes", EntityGraphProcessing.extractAttributeNodes(jaxbSubgraph.getNamedAttributeNode(), classDetails, modelBuildingContext, xmlDocumentContext));
        }
        return subgraphAnnotations;
    }
}

