/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.AttributeAccessor;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionType;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLJoinTableRestriction;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.boot.internal.Target;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributeOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCascadeTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCheckConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConvertImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCustomSqlImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorFormulaImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGeneratedValueImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHbmFilterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdClassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIndexImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallback;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallbackContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLobImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNationalizedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalId;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSchemaAware;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSequenceGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUniqueConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUuidGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbCheckable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbTableMapping;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.KeyedConsumer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.SqlTypes;

public class XmlAnnotationHelper {
    public static void applyOptionalAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, Object value) {
        if (value != null) {
            annotationUsage.setAttributeValue(attributeName, value);
        }
    }

    public static void applyOptionalAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, String value) {
        if (StringHelper.isNotEmpty(value)) {
            annotationUsage.setAttributeValue(attributeName, (Object)value);
        }
    }

    public static <S> void applyOptionalAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, S valueSource, Function<S, Object> valueExtractor) {
        if (valueSource == null) {
            return;
        }
        Object value = valueExtractor.apply(valueSource);
        if (value == null) {
            return;
        }
        annotationUsage.setAttributeValue(attributeName, value);
    }

    public static <S> void applyOptionalStringAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, S valueSource, Function<S, String> valueExtractor) {
        if (valueSource == null) {
            return;
        }
        String value = valueExtractor.apply(valueSource);
        if (StringHelper.isEmpty(value)) {
            return;
        }
        annotationUsage.setAttributeValue(attributeName, (Object)value);
    }

    public static void applyEntity(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<Entity> entityUsage = XmlProcessingHelper.getOrMakeAnnotation(Entity.class, (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlProcessingHelper.applyAttributeIfSpecified("name", jaxbEntity.getName(), entityUsage);
    }

    public static MutableAnnotationUsage<Access> createAccessAnnotation(AccessType accessType, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<Access> annotationUsage = XmlProcessingHelper.makeAnnotation(Access.class, target, xmlDocumentContext);
        annotationUsage.setAttributeValue("value", (Object)accessType);
        return annotationUsage;
    }

    public static void applyAttributeAccessor(String attributeAccessor, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<AttributeAccessor> accessorAnn = XmlProcessingHelper.makeAnnotation(AttributeAccessor.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(accessorAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("value", attributeAccessor, accessorAnn);
    }

    public static void applyColumn(JaxbColumnImpl jaxbColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        XmlAnnotationHelper.createColumnAnnotation(jaxbColumn, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
    }

    public static MutableAnnotationUsage<JoinColumn> applyJoinColumn(JaxbJoinColumnImpl jaxbJoinColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbJoinColumn == null) {
            return null;
        }
        return JoinColumnProcessing.createJoinColumnAnnotation(jaxbJoinColumn, memberDetails, JoinColumn.class, xmlDocumentContext);
    }

    public static <T, N> void applyOr(N jaxbNode, Function<N, T> jaxbValueAccess, String name, KeyedConsumer<String, T> valueConsumer, Supplier<T> defaultValueProvider) {
        T value;
        if (jaxbNode != null && (value = jaxbValueAccess.apply(jaxbNode)) != null) {
            valueConsumer.accept(name, value);
            return;
        }
        valueConsumer.accept(name, defaultValueProvider.get());
    }

    public static <T, N, A extends Annotation> void applyOr(N jaxbNode, Function<N, T> jaxbValueAccess, String name, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor) {
        XmlAnnotationHelper.applyOr(jaxbNode, jaxbValueAccess, name, (String key, T value) -> annotationUsage.setAttributeValue(name, value), () -> annotationDescriptor.getAttribute(name).getAttributeMethod().getDefaultValue());
    }

    private static MutableAnnotationUsage<Column> createColumnAnnotation(JaxbColumnImpl jaxbColumn, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<Column> columnAnn = XmlProcessingHelper.getOrMakeAnnotation(Column.class, target, xmlDocumentContext);
        ColumnProcessing.applyColumnDetails(jaxbColumn, target, columnAnn, xmlDocumentContext);
        return columnAnn;
    }

    public static void applyUserType(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null) {
            return;
        }
        MutableAnnotationUsage<Type> typeAnn = XmlProcessingHelper.makeAnnotation(Type.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(typeAnn);
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getValue(), xmlDocumentContext);
        typeAnn.setAttributeValue("value", (Object)userTypeImpl);
        typeAnn.setAttributeValue("parameters", XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
    }

    public static List<AnnotationUsage<Parameter>> collectParameters(List<JaxbConfigurationParameterImpl> jaxbParameters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbParameters)) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUsage<Parameter>> parameterAnnList = new ArrayList<AnnotationUsage<Parameter>>(jaxbParameters.size());
        jaxbParameters.forEach(jaxbParam -> {
            MutableAnnotationUsage<Parameter> annotationUsage = XmlProcessingHelper.makeNestedAnnotation(Parameter.class, target, xmlDocumentContext);
            parameterAnnList.add((AnnotationUsage<Parameter>)annotationUsage);
            annotationUsage.setAttributeValue("name", (Object)jaxbParam.getName());
            annotationUsage.setAttributeValue("value", (Object)jaxbParam.getValue());
        });
        return parameterAnnList;
    }

    public static void applyCollectionUserType(JaxbCollectionUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null) {
            return;
        }
        MutableAnnotationUsage<CollectionType> typeAnn = XmlProcessingHelper.makeAnnotation(CollectionType.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(typeAnn);
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getType(), xmlDocumentContext);
        typeAnn.setAttributeValue("type", (Object)userTypeImpl);
        typeAnn.setAttributeValue("parameters", XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
    }

    public static void applyCollectionId(JaxbCollectionIdImpl jaxbCollectionId, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCollectionId == null) {
            return;
        }
        MutableAnnotationUsage<CollectionId> collectionIdAnn = XmlProcessingHelper.getOrMakeAnnotation(CollectionId.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        AnnotationDescriptor collectionIdDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(CollectionId.class);
        JaxbColumnImpl jaxbColumn = jaxbCollectionId.getColumn();
        if (jaxbColumn != null) {
            collectionIdAnn.setAttributeValue("column", XmlAnnotationHelper.createColumnAnnotation(jaxbColumn, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        }
        XmlAnnotationHelper.applyOr(jaxbCollectionId, JaxbCollectionIdImpl::getGenerator, "generator", collectionIdAnn, collectionIdDescriptor);
    }

    public static void applyCascading(JaxbCascadeTypeImpl jaxbCascadeType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCascadeType == null) {
            return;
        }
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(xmlDocumentContext.getEffectiveDefaults().getDefaultCascadeTypes());
        if (jaxbCascadeType.getCascadeAll() != null) {
            cascadeTypes.add(CascadeType.ALL);
        }
        if (jaxbCascadeType.getCascadePersist() != null) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        if (jaxbCascadeType.getCascadeMerge() != null) {
            cascadeTypes.add(CascadeType.MERGE);
        }
        if (jaxbCascadeType.getCascadeRemove() != null) {
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (jaxbCascadeType.getCascadeRefresh() != null) {
            cascadeTypes.add(CascadeType.REFRESH);
        }
        if (jaxbCascadeType.getCascadeDetach() != null) {
            cascadeTypes.add(CascadeType.DETACH);
        }
        if (jaxbCascadeType.getCascadeReplicate() != null) {
            cascadeTypes.add(CascadeType.REPLICATE);
        }
        if (jaxbCascadeType.getCascadeLock() != null) {
            cascadeTypes.add(CascadeType.LOCK);
        }
        if (!cascadeTypes.isEmpty()) {
            XmlProcessingHelper.getOrMakeAnnotation(Cascade.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("value", cascadeTypes);
        }
    }

    public static <A extends Annotation> void applyUniqueConstraints(List<JaxbUniqueConstraintImpl> jaxbUniqueConstraints, MutableAnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbUniqueConstraints)) {
            return;
        }
        ArrayList uniqueConstraintUsages = new ArrayList(jaxbUniqueConstraints.size());
        annotationUsage.setAttributeValue("uniqueConstraints", uniqueConstraintUsages);
        jaxbUniqueConstraints.forEach(jaxbUniqueConstraint -> {
            MutableAnnotationUsage ucUsage = JpaAnnotations.UNIQUE_CONSTRAINT.createUsage((AnnotationTarget)target, xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)ucUsage, "name", jaxbUniqueConstraint.getName());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)ucUsage, "options", jaxbUniqueConstraint.getOptions());
            ucUsage.setAttributeValue("columnNames", jaxbUniqueConstraint.getColumnName());
            uniqueConstraintUsages.add(ucUsage);
        });
    }

    public static <A extends Annotation> void applyIndexes(List<JaxbIndexImpl> jaxbIndexes, MutableAnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbIndexes)) {
            return;
        }
        ArrayList indexes = new ArrayList(jaxbIndexes.size());
        AnnotationDescriptor indexDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(Index.class);
        jaxbIndexes.forEach(jaxbIndex -> {
            MutableAnnotationUsage indexAnn = indexDescriptor.createUsage((AnnotationTarget)target, xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::getName, "name", indexAnn, indexDescriptor);
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::getColumnList, "columnList", indexAnn, indexDescriptor);
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::isUnique, "unique", indexAnn, indexDescriptor);
            indexes.add(indexAnn);
        });
        annotationUsage.setAttributeValue("indexes", indexes);
    }

    public static <A extends Annotation> void applyCheckConstraints(JaxbCheckable jaxbCheckable, MutableAnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCheckable != null && CollectionHelper.isNotEmpty(jaxbCheckable.getCheckConstraints())) {
            ArrayList<MutableAnnotationUsage<CheckConstraint>> checks = new ArrayList<MutableAnnotationUsage<CheckConstraint>>(jaxbCheckable.getCheckConstraints().size());
            AnnotationDescriptor checkConstraintDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(CheckConstraint.class);
            for (JaxbCheckConstraintImpl jaxbCheck : jaxbCheckable.getCheckConstraints()) {
                MutableAnnotationUsage<CheckConstraint> checkAnn = XmlProcessingHelper.getOrMakeAnnotation(CheckConstraint.class, target, xmlDocumentContext);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getName, "name", checkAnn, checkConstraintDescriptor);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getConstraint, "constraint", checkAnn, checkConstraintDescriptor);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getOptions, "options", checkAnn, checkConstraintDescriptor);
                checks.add(checkAnn);
            }
            annotationUsage.setAttributeValue("check", checks);
        }
    }

    public static <A extends Annotation> void applyCheckConstraints(JaxbCheckable jaxbCheckable, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isNotEmpty(jaxbCheckable.getCheckConstraints())) {
            ArrayList<MutableAnnotationUsage<CheckConstraint>> checks = new ArrayList<MutableAnnotationUsage<CheckConstraint>>(jaxbCheckable.getCheckConstraints().size());
            AnnotationDescriptor checkConstraintDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(CheckConstraint.class);
            for (JaxbCheckConstraintImpl jaxbCheck : jaxbCheckable.getCheckConstraints()) {
                MutableAnnotationUsage<CheckConstraint> checkAnn = XmlProcessingHelper.getOrMakeAnnotation(CheckConstraint.class, xmlDocumentContext);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getName, "name", checkAnn, checkConstraintDescriptor);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getConstraint, "constraint", checkAnn, checkConstraintDescriptor);
                XmlAnnotationHelper.applyOr(jaxbCheck, JaxbCheckConstraintImpl::getOptions, "options", checkAnn, checkConstraintDescriptor);
                checks.add(checkAnn);
            }
            annotationUsage.setAttributeValue("check", checks);
        }
    }

    public static void applyTargetClass(String name, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails classDetails = XmlAnnotationHelper.resolveJavaType(name, xmlDocumentContext);
        MutableAnnotationUsage<Target> targetAnn = XmlProcessingHelper.makeAnnotation(Target.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        targetAnn.setAttributeValue("value", (Object)classDetails);
    }

    public static void applyTemporal(TemporalType temporalType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (temporalType == null) {
            return;
        }
        MutableAnnotationUsage<Temporal> annotationUsage = XmlProcessingHelper.makeAnnotation(Temporal.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        annotationUsage.setAttributeValue("value", (Object)temporalType);
    }

    public static void applyLob(JaxbLobImpl jaxbLob, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbLob == null) {
            return;
        }
        XmlProcessingHelper.makeAnnotation(Lob.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
    }

    public static void applyEnumerated(EnumType enumType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (enumType == null) {
            return;
        }
        MutableAnnotationUsage<Enumerated> annotationUsage = XmlProcessingHelper.makeAnnotation(Enumerated.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        annotationUsage.setAttributeValue("value", (Object)enumType);
    }

    public static void applyNationalized(JaxbNationalizedImpl jaxbNationalized, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNationalized == null) {
            return;
        }
        XmlProcessingHelper.makeAnnotation(Nationalized.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
    }

    public static void applyGeneratedValue(JaxbGeneratedValueImpl jaxbGeneratedValue, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGeneratedValue == null) {
            return;
        }
        MutableAnnotationUsage<GeneratedValue> generatedValueAnn = XmlProcessingHelper.makeAnnotation(GeneratedValue.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(generatedValueAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("strategy", jaxbGeneratedValue.getStrategy(), generatedValueAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("generator", jaxbGeneratedValue.getGenerator(), generatedValueAnn);
    }

    public static void applySequenceGenerator(JaxbSequenceGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage<SequenceGenerator> sequenceAnn = XmlProcessingHelper.getOrMakeNamedAnnotation(SequenceGenerator.class, jaxbGenerator.getName(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlProcessingHelper.applyAttributeIfSpecified("sequenceName", jaxbGenerator.getSequenceName(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("catalog", jaxbGenerator.getCatalog(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("schema", jaxbGenerator.getSchema(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("initialValue", jaxbGenerator.getInitialValue(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("allocationSize", jaxbGenerator.getInitialValue(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("options", jaxbGenerator.getOptions(), sequenceAnn);
    }

    public static void applyTableGenerator(JaxbTableGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage<TableGenerator> annotationUsage = XmlProcessingHelper.makeAnnotation(TableGenerator.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("name", jaxbGenerator.getName(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("table", jaxbGenerator.getTable(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("catalog", jaxbGenerator.getCatalog(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("schema", jaxbGenerator.getSchema(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("pkColumnName", jaxbGenerator.getPkColumnName(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("valueColumnName", jaxbGenerator.getValueColumnName(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("pkColumnValue", jaxbGenerator.getPkColumnValue(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("initialValue", jaxbGenerator.getInitialValue(), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("allocationSize", jaxbGenerator.getInitialValue(), annotationUsage);
        XmlAnnotationHelper.applyUniqueConstraints(jaxbGenerator.getUniqueConstraints(), (MutableAnnotationTarget)memberDetails, annotationUsage, xmlDocumentContext);
        XmlAnnotationHelper.applyIndexes(jaxbGenerator.getIndexes(), (MutableAnnotationTarget)memberDetails, annotationUsage, xmlDocumentContext);
    }

    public static void applyUuidGenerator(JaxbUuidGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage<UuidGenerator> annotationUsage = XmlProcessingHelper.makeAnnotation(UuidGenerator.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
        annotationUsage.setAttributeValue("style", (Object)jaxbGenerator.getStyle());
    }

    public static void applyAttributeOverrides(JaxbPluralAttribute pluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbAttributeOverrideImpl> jaxbElementOverrides;
        List<JaxbAttributeOverrideImpl> jaxbMapKeyOverrides = pluralAttribute.getMapKeyAttributeOverrides();
        List<JaxbAttributeOverrideImpl> list = jaxbElementOverrides = pluralAttribute instanceof JaxbElementCollectionImpl ? ((JaxbElementCollectionImpl)pluralAttribute).getAttributeOverrides() : Collections.emptyList();
        if (CollectionHelper.isEmpty(jaxbMapKeyOverrides) && CollectionHelper.isEmpty(jaxbElementOverrides)) {
            return;
        }
        int numberOfOverrides = jaxbMapKeyOverrides.size() + jaxbElementOverrides.size();
        if (numberOfOverrides == 1) {
            MutableAnnotationUsage<AttributeOverride> overrideUsage;
            if (memberDetails.getMapKeyType() != null) {
                if (jaxbMapKeyOverrides.size() == 1) {
                    overrideUsage = XmlAnnotationHelper.createAttributeOverrideUsage(jaxbMapKeyOverrides.get(0), "key", memberDetails, xmlDocumentContext);
                } else {
                    assert (jaxbElementOverrides.size() == 1);
                    overrideUsage = XmlAnnotationHelper.createAttributeOverrideUsage((JaxbAttributeOverrideImpl)jaxbElementOverrides.get(0), "value", memberDetails, xmlDocumentContext);
                }
            } else {
                assert (jaxbElementOverrides.size() == 1);
                overrideUsage = XmlAnnotationHelper.createAttributeOverrideUsage((JaxbAttributeOverrideImpl)jaxbElementOverrides.get(0), null, memberDetails, xmlDocumentContext);
            }
            memberDetails.addAnnotationUsage(overrideUsage);
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        MutableAnnotationUsage overridesUsage = JpaAnnotations.ATTRIBUTE_OVERRIDES.createUsage((AnnotationTarget)memberDetails, modelBuildingContext);
        memberDetails.addAnnotationUsage((AnnotationUsage)overridesUsage);
        ArrayList overrideUsages = CollectionHelper.arrayList(numberOfOverrides);
        overridesUsage.setAttributeValue("value", overrideUsages);
        if (memberDetails.getMapKeyType() != null) {
            jaxbMapKeyOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "key", memberDetails, xmlDocumentContext)));
            jaxbElementOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "value", memberDetails, xmlDocumentContext)));
        } else {
            assert (CollectionHelper.isEmpty(jaxbMapKeyOverrides));
            jaxbElementOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, null, memberDetails, xmlDocumentContext)));
        }
    }

    private static MutableAnnotationUsage<AttributeOverride> createAttributeOverrideUsage(JaxbAttributeOverrideImpl jaxbOverride, String namePrefix, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        MutableAnnotationUsage overrideUsage = JpaAnnotations.ATTRIBUTE_OVERRIDE.createUsage((AnnotationTarget)memberDetails, modelBuildingContext);
        String name = StringHelper.qualifyConditionally(namePrefix, jaxbOverride.getName());
        overrideUsage.setAttributeValue("name", (Object)name);
        MutableAnnotationUsage columnAnn = JpaAnnotations.COLUMN.createUsage((AnnotationTarget)memberDetails, modelBuildingContext);
        overrideUsage.setAttributeValue("column", (Object)columnAnn);
        ColumnProcessing.applyColumnDetails(jaxbOverride.getColumn(), (MutableAnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
        return overrideUsage;
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOverrides, memberDetails, null, xmlDocumentContext);
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableMemberDetails memberDetails, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        MutableAnnotationUsage<AttributeOverrides> attributeOverridesAnn = XmlProcessingHelper.makeAnnotation(AttributeOverrides.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(attributeOverridesAnn);
        ArrayList overrideUsages = CollectionHelper.arrayList(jaxbOverrides.size());
        attributeOverridesAnn.setAttributeValue("value", overrideUsages);
        jaxbOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, namePrefix, memberDetails, xmlDocumentContext)));
    }

    public static void applyAssociationOverrides(List<JaxbAssociationOverrideImpl> jaxbOverrides, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        if (jaxbOverrides.size() == 1) {
            MutableAnnotationUsage overrideUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.ASSOCIATION_OVERRIDE, xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.transferAssociationOverride(jaxbOverrides.get(0), (MutableAnnotationUsage<AssociationOverride>)overrideUsage, memberDetails, xmlDocumentContext);
        } else {
            MutableAnnotationUsage overridesUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.ASSOCIATION_OVERRIDES, xmlDocumentContext.getModelBuildingContext());
            ArrayList overrideUsages = CollectionHelper.arrayList(jaxbOverrides.size());
            overridesUsage.setAttributeValue("value", overrideUsages);
            jaxbOverrides.forEach(jaxbOverride -> {
                MutableAnnotationUsage overrideUsage = JpaAnnotations.ASSOCIATION_OVERRIDE.createUsage((AnnotationTarget)memberDetails, xmlDocumentContext.getModelBuildingContext());
                XmlAnnotationHelper.transferAssociationOverride(jaxbOverride, (MutableAnnotationUsage<AssociationOverride>)overrideUsage, memberDetails, xmlDocumentContext);
                overrideUsages.add(overrideUsage);
            });
        }
    }

    private static void transferAssociationOverride(JaxbAssociationOverrideImpl jaxbOverride, MutableAnnotationUsage<AssociationOverride> overrideUsage, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        overrideUsage.setAttributeValue("name", (Object)jaxbOverride.getName());
        List<JaxbJoinColumnImpl> joinColumns = jaxbOverride.getJoinColumns();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            overrideUsage.setAttributeValue("joinColumns", JoinColumnProcessing.transformJoinColumnList(joinColumns, memberDetails, xmlDocumentContext));
        }
        if (jaxbOverride.getJoinTable() != null) {
            overrideUsage.setAttributeValue("joinTable", TableProcessing.transformJoinTable(jaxbOverride.getJoinTable(), memberDetails, xmlDocumentContext));
        }
        if (jaxbOverride.getForeignKeys() != null) {
            overrideUsage.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbOverride.getForeignKeys(), (MemberDetails)memberDetails, xmlDocumentContext));
        }
    }

    public static void applyOptimisticLockInclusion(boolean inclusion, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<OptimisticLock> annotationUsage = XmlProcessingHelper.makeAnnotation(OptimisticLock.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
        annotationUsage.setAttributeValue("exclude", (Object)(!inclusion ? 1 : 0));
    }

    public static void applyConvert(JaxbConvertImpl jaxbConvert, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyConvert(jaxbConvert, memberDetails, null, xmlDocumentContext);
    }

    public static void applyConvert(JaxbConvertImpl jaxbConvert, MutableMemberDetails memberDetails, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (jaxbConvert == null) {
            return;
        }
        MutableAnnotationUsage<Convert> annotationUsage = XmlProcessingHelper.makeAnnotation(Convert.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isNotEmpty(jaxbConvert.getConverter())) {
            ClassDetails converter = classDetailsRegistry.resolveClassDetails(jaxbConvert.getConverter());
            annotationUsage.setAttributeValue("converter", (Object)converter);
        }
        XmlProcessingHelper.applyAttributeIfSpecified("attributeName", XmlAnnotationHelper.prefixIfNotAlready(jaxbConvert.getAttributeName(), namePrefix), annotationUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("disableConversion", jaxbConvert.isDisableConversion(), annotationUsage);
    }

    public static void applyTable(JaxbTableImpl jaxbTable, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbTable == null) {
            XmlDocument.Defaults defaults = xmlDocumentContext.getXmlDocument().getDefaults();
            String catalog = defaults.getCatalog();
            String schema = defaults.getSchema();
            if (StringHelper.isNotEmpty(catalog) || StringHelper.isNotEmpty(schema)) {
                MutableAnnotationUsage<Table> tableAnn = XmlProcessingHelper.makeAnnotation(Table.class, target, xmlDocumentContext);
                if (StringHelper.isNotEmpty(catalog)) {
                    tableAnn.setAttributeValue("catalog", (Object)catalog);
                }
                if (StringHelper.isNotEmpty(schema)) {
                    tableAnn.setAttributeValue("schema", (Object)schema);
                }
            }
        } else {
            MutableAnnotationUsage<Table> tableAnn = XmlProcessingHelper.makeAnnotation(Table.class, target, xmlDocumentContext);
            AnnotationDescriptor tableDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(Table.class);
            XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableImpl::getName, "name", tableAnn, tableDescriptor);
            XmlAnnotationHelper.applyTableAttributes(jaxbTable, target, tableAnn, tableDescriptor, xmlDocumentContext);
        }
    }

    public static void applyTableOverride(JaxbTableImpl jaxbTable, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbTable == null) {
            return;
        }
        MutableAnnotationUsage<Table> tableAnn = XmlProcessingHelper.getOrMakeAnnotation(Table.class, target, xmlDocumentContext);
        AnnotationDescriptor tableDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(Table.class);
        XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableImpl::getName, "name", tableAnn, tableDescriptor);
        XmlAnnotationHelper.applyTableAttributes(jaxbTable, target, tableAnn, tableDescriptor, xmlDocumentContext);
    }

    public static <A extends Annotation> void applyTableAttributes(JaxbTableMapping jaxbTable, MutableAnnotationTarget target, MutableAnnotationUsage<A> tableAnn, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOrCatalog(jaxbTable, tableAnn, annotationDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOrSchema(jaxbTable, tableAnn, annotationDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableMapping::getOptions, "options", tableAnn, annotationDescriptor);
        XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableMapping::getComment, "comment", tableAnn, annotationDescriptor);
        XmlAnnotationHelper.applyCheckConstraints(jaxbTable, target, tableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyUniqueConstraints(jaxbTable.getUniqueConstraints(), target, tableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyIndexes(jaxbTable.getIndexes(), target, tableAnn, xmlDocumentContext);
    }

    public static void applyNaturalId(JaxbNaturalId jaxbNaturalId, MutableMemberDetails backingMember, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNaturalId == null) {
            return;
        }
        MutableAnnotationUsage<NaturalId> annotationUsage = XmlProcessingHelper.makeAnnotation(NaturalId.class, (MutableAnnotationTarget)backingMember, xmlDocumentContext);
        backingMember.addAnnotationUsage(annotationUsage);
        annotationUsage.setAttributeValue("mutable", (Object)jaxbNaturalId.isMutable());
    }

    public static void applyNaturalIdCache(JaxbNaturalId jaxbNaturalId, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNaturalId == null || jaxbNaturalId.getCaching() == null) {
            return;
        }
        MutableAnnotationUsage<NaturalIdCache> annotationUsage = XmlProcessingHelper.makeAnnotation(NaturalIdCache.class, (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        classDetails.addAnnotationUsage(annotationUsage);
        JaxbCachingImpl jaxbCaching = jaxbNaturalId.getCaching();
        XmlProcessingHelper.applyAttributeIfSpecified("region", jaxbCaching.getRegion(), annotationUsage);
    }

    public static void applyId(JaxbIdImpl jaxbId, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbId == null) {
            return;
        }
        MutableAnnotationUsage<Id> annotationUsage = XmlProcessingHelper.makeAnnotation(Id.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
    }

    public static void applyEmbeddedId(JaxbEmbeddedIdImpl jaxbEmbeddedId, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbEmbeddedId == null) {
            return;
        }
        MutableAnnotationUsage<EmbeddedId> annotationUsage = XmlProcessingHelper.makeAnnotation(EmbeddedId.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(annotationUsage);
    }

    static void applyInheritance(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbEntity.getInheritance() == null) {
            return;
        }
        MutableAnnotationUsage<Inheritance> inheritanceAnn = XmlProcessingHelper.getOrMakeAnnotation(Inheritance.class, (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlProcessingHelper.applyAttributeIfSpecified("strategy", jaxbEntity.getInheritance().getStrategy(), inheritanceAnn);
    }

    public static ClassDetails resolveJavaType(String value, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.resolveJavaType(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), value, xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry());
    }

    public static ClassDetails resolveJavaType(String value, SourceModelBuildingContext sourceModelBuildingContext) {
        return XmlAnnotationHelper.resolveJavaType(value, sourceModelBuildingContext.getClassDetailsRegistry());
    }

    public static ClassDetails resolveJavaType(String value, ClassDetailsRegistry classDetailsRegistry) {
        return XmlAnnotationHelper.resolveJavaType(null, value, classDetailsRegistry);
    }

    public static ClassDetails resolveJavaType(String packageName, String name, ClassDetailsRegistry classDetailsRegistry) {
        if (StringHelper.isEmpty(name)) {
            name = Object.class.getName();
        } else if (!(Byte.TYPE.getName().equals(name) || Boolean.TYPE.getName().equals(name) || Short.TYPE.getName().equals(name) || Integer.TYPE.getName().equals(name) || Long.TYPE.getName().equals(name) || Double.TYPE.getName().equals(name) || Float.TYPE.getName().equals(name))) {
            name = Byte.class.getSimpleName().equalsIgnoreCase(name) ? Byte.class.getName() : (Boolean.class.getSimpleName().equalsIgnoreCase(name) ? Boolean.class.getName() : (Short.class.getSimpleName().equalsIgnoreCase(name) ? Short.class.getName() : (Integer.class.getSimpleName().equalsIgnoreCase(name) ? Integer.class.getName() : (Long.class.getSimpleName().equalsIgnoreCase(name) ? Long.class.getName() : (Double.class.getSimpleName().equalsIgnoreCase(name) ? Double.class.getName() : (Float.class.getSimpleName().equalsIgnoreCase(name) ? Float.class.getName() : (BigInteger.class.getSimpleName().equalsIgnoreCase(name) ? BigInteger.class.getName() : (BigDecimal.class.getSimpleName().equalsIgnoreCase(name) ? BigDecimal.class.getName() : (String.class.getSimpleName().equalsIgnoreCase(name) ? String.class.getName() : (Character.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : (UUID.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : StringHelper.qualifyConditionallyIfNot(packageName, name))))))))))));
        }
        return classDetailsRegistry.resolveClassDetails(name);
    }

    public static void applyBasicTypeComposition(JaxbBasicMapping jaxbBasicMapping, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbBasicMapping.getType() != null) {
            XmlAnnotationHelper.applyUserType(jaxbBasicMapping.getType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJavaType() != null) {
            XmlAnnotationHelper.applyJavaTypeDescriptor(jaxbBasicMapping.getJavaType(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getTarget())) {
            XmlAnnotationHelper.applyTargetClass(jaxbBasicMapping.getTarget(), memberDetails, xmlDocumentContext);
        }
        if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcType())) {
            XmlAnnotationHelper.applyJdbcTypeDescriptor(jaxbBasicMapping.getJdbcType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJdbcTypeCode() != null) {
            XmlAnnotationHelper.applyJdbcTypeCode(jaxbBasicMapping.getJdbcTypeCode(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcTypeName())) {
            XmlAnnotationHelper.applyJdbcTypeCode(XmlAnnotationHelper.resolveJdbcTypeName(jaxbBasicMapping.getJdbcTypeName()), memberDetails, xmlDocumentContext);
        }
    }

    private static int resolveJdbcTypeName(String name) {
        try {
            Field matchingField = SqlTypes.class.getDeclaredField(name);
            return matchingField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ModelsException("Could not resolve <jdbc-type-name>" + name + "</jdbc-type-name>", (Throwable)e);
        }
    }

    public static void applyJavaTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<JavaType> typeAnn = XmlProcessingHelper.makeAnnotation(JavaType.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(typeAnn);
        ClassDetails descriptorClass = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        typeAnn.setAttributeValue("value", (Object)descriptorClass);
    }

    private static void applyJdbcTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails descriptorClassDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        MutableAnnotationUsage<JdbcType> jdbcTypeAnn = XmlProcessingHelper.makeAnnotation(JdbcType.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        jdbcTypeAnn.setAttributeValue("value", (Object)descriptorClassDetails);
    }

    public static void applyJdbcTypeCode(Integer jdbcTypeCode, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jdbcTypeCode == null) {
            return;
        }
        MutableAnnotationUsage<JdbcTypeCode> typeCodeAnn = XmlProcessingHelper.makeAnnotation(JdbcTypeCode.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        memberDetails.addAnnotationUsage(typeCodeAnn);
        typeCodeAnn.setAttributeValue("value", (Object)jdbcTypeCode);
    }

    public static void applyFilter(JaxbHbmFilterImpl jaxbFilter, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyFilter(jaxbFilter, target, Filter.class, xmlDocumentContext);
    }

    public static void applyJoinTableFilter(JaxbHbmFilterImpl jaxbFilter, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyFilter(jaxbFilter, target, FilterJoinTable.class, xmlDocumentContext);
    }

    private static <F extends Annotation> void applyFilter(JaxbHbmFilterImpl jaxbFilter, MutableAnnotationTarget target, Class<F> filterAnnotationClass, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<F> filterAnn = XmlProcessingHelper.getOrMakeNamedAnnotation(filterAnnotationClass, jaxbFilter.getName(), target, xmlDocumentContext);
        XmlProcessingHelper.applyAttributeIfSpecified("condition", jaxbFilter.getCondition(), filterAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("deduceAliasInjectionPoints", jaxbFilter.isAutoAliasInjection(), filterAnn);
        List<JaxbHbmFilterImpl.JaxbAliasesImpl> aliases = jaxbFilter.getAliases();
        if (!CollectionHelper.isEmpty(aliases)) {
            filterAnn.setAttributeValue("aliases", XmlAnnotationHelper.getSqlFragmentAliases(aliases, target, xmlDocumentContext));
        }
    }

    private static List<AnnotationUsage<SqlFragmentAlias>> getSqlFragmentAliases(List<JaxbHbmFilterImpl.JaxbAliasesImpl> aliases, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        ArrayList<AnnotationUsage<SqlFragmentAlias>> sqlFragmentAliases = new ArrayList<AnnotationUsage<SqlFragmentAlias>>(aliases.size());
        for (JaxbHbmFilterImpl.JaxbAliasesImpl alias : aliases) {
            MutableAnnotationUsage<SqlFragmentAlias> aliasAnn = XmlProcessingHelper.makeNestedAnnotation(SqlFragmentAlias.class, target, xmlDocumentContext);
            aliasAnn.setAttributeValue("alias", (Object)alias.getAlias());
            XmlProcessingHelper.applyAttributeIfSpecified("table", alias.getTable(), aliasAnn);
            if (StringHelper.isNotEmpty(alias.getEntity())) {
                aliasAnn.setAttributeValue("entity", (Object)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(alias.getEntity()));
            }
            sqlFragmentAliases.add((AnnotationUsage<SqlFragmentAlias>)aliasAnn);
        }
        return sqlFragmentAliases;
    }

    public static void applySqlRestriction(String sqlRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applySqlRestriction(sqlRestriction, target, SQLRestriction.class, xmlDocumentContext);
    }

    public static void applySqlJoinTableRestriction(String sqlJoinTableRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applySqlRestriction(sqlJoinTableRestriction, target, SQLJoinTableRestriction.class, xmlDocumentContext);
    }

    private static <A extends Annotation> void applySqlRestriction(String sqlRestriction, MutableAnnotationTarget target, Class<A> annotationType, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(sqlRestriction)) {
            MutableAnnotationUsage<A> annotation = XmlProcessingHelper.getOrMakeAnnotation(annotationType, target, xmlDocumentContext);
            annotation.setAttributeValue("value", (Object)sqlRestriction);
        }
    }

    public static <A extends Annotation> void applyCustomSql(JaxbCustomSqlImpl jaxbCustomSql, MutableAnnotationTarget target, Class<A> annotationType, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCustomSql != null) {
            MutableAnnotationUsage<A> annotation = XmlProcessingHelper.getOrMakeAnnotation(annotationType, target, xmlDocumentContext);
            annotation.setAttributeValue("sql", (Object)jaxbCustomSql.getValue());
            annotation.setAttributeValue("callable", (Object)jaxbCustomSql.isCallable());
            XmlProcessingHelper.applyAttributeIfSpecified("table", jaxbCustomSql.getTable(), annotation);
            if (jaxbCustomSql.getResultCheck() != null) {
                annotation.setAttributeValue("check", (Object)XmlAnnotationHelper.getResultCheckStyle(jaxbCustomSql.getResultCheck()));
            }
        }
    }

    private static ResultCheckStyle getResultCheckStyle(ExecuteUpdateResultCheckStyle style) {
        switch (style) {
            case NONE: {
                return ResultCheckStyle.NONE;
            }
            case COUNT: {
                return ResultCheckStyle.COUNT;
            }
            case PARAM: {
                return ResultCheckStyle.PARAM;
            }
        }
        return null;
    }

    static void applyIdClass(JaxbIdClassImpl jaxbIdClass, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbIdClass != null) {
            XmlProcessingHelper.getOrMakeAnnotation(IdClass.class, (MutableAnnotationTarget)target, xmlDocumentContext).setAttributeValue("value", (Object)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(jaxbIdClass.getClazz()));
        }
    }

    static void applyEntityListener(JaxbEntityListenerImpl jaxbEntityListener, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<EntityListeners> entityListeners = XmlProcessingHelper.getOrMakeAnnotation(EntityListeners.class, (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        MutableClassDetails entityListenerClass = xmlDocumentContext.resolveJavaType(jaxbEntityListener.getClazz());
        XmlAnnotationHelper.applyLifecycleCallbacks(jaxbEntityListener, JpaEventListenerStyle.LISTENER, entityListenerClass, xmlDocumentContext);
        List values = (List)entityListeners.getAttributeValue("value");
        if (values != null) {
            values.add(entityListenerClass);
        } else {
            entityListeners.setAttributeValue("value", new ArrayList<MutableClassDetails>(List.of(entityListenerClass)));
        }
    }

    static void applyLifecycleCallbacks(JaxbLifecycleCallbackContainer lifecycleCallbackContainer, JpaEventListenerStyle callbackType, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPrePersist(), callbackType, PrePersist.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostPersist(), callbackType, PostPersist.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreRemove(), callbackType, PreRemove.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostRemove(), callbackType, PostRemove.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreUpdate(), callbackType, PreUpdate.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostUpdate(), callbackType, PostUpdate.class, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostLoad(), callbackType, PostLoad.class, classDetails, xmlDocumentContext);
    }

    private static <A extends Annotation> void applyLifecycleCallback(JaxbLifecycleCallback lifecycleCallback, JpaEventListenerStyle callbackType, Class<A> lifecycleAnnotation, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (lifecycleCallback != null) {
            MethodDetails methodDetails = XmlAnnotationHelper.getCallbackMethodDetails(lifecycleCallback.getMethodName(), callbackType, (ClassDetails)classDetails);
            if (methodDetails == null) {
                throw new AnnotationException(String.format("Lifecycle callback method not found - %s (%s)", lifecycleCallback.getMethodName(), classDetails.getName()));
            }
            XmlProcessingHelper.makeAnnotation(lifecycleAnnotation, (MutableAnnotationTarget)((MutableMemberDetails)methodDetails), xmlDocumentContext);
        }
    }

    private static MethodDetails getCallbackMethodDetails(String name, JpaEventListenerStyle callbackType, ClassDetails classDetails) {
        for (MethodDetails method : classDetails.getMethods()) {
            if (!method.getName().equals(name) || !JpaEventListener.matchesSignature(callbackType, method)) continue;
            return method;
        }
        return null;
    }

    static void applyRowId(String rowId, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (rowId != null) {
            MutableAnnotationUsage<RowId> rowIdAnn = XmlProcessingHelper.getOrMakeAnnotation(RowId.class, (MutableAnnotationTarget)target, xmlDocumentContext);
            XmlProcessingHelper.applyAttributeIfSpecified("value", rowId, rowIdAnn);
        }
    }

    private static String prefixIfNotAlready(String value, String prefix) {
        String previous;
        if (StringHelper.isNotEmpty(prefix) && !(previous = StringHelper.unqualify(value)).equalsIgnoreCase(prefix)) {
            return StringHelper.qualify(prefix, value);
        }
        return value;
    }

    static void applyDiscriminatorValue(String discriminatorValue, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (discriminatorValue != null) {
            MutableAnnotationUsage<DiscriminatorValue> rowIdAnn = XmlProcessingHelper.getOrMakeAnnotation(DiscriminatorValue.class, (MutableAnnotationTarget)target, xmlDocumentContext);
            XmlProcessingHelper.applyAttributeIfSpecified("value", discriminatorValue, rowIdAnn);
        }
    }

    static void applyDiscriminatorColumn(JaxbDiscriminatorColumnImpl jaxbDiscriminatorColumn, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorColumn == null) {
            return;
        }
        MutableAnnotationUsage<DiscriminatorColumn> discriminatorColumnAnn = XmlProcessingHelper.getOrMakeAnnotation(DiscriminatorColumn.class, (MutableAnnotationTarget)target, xmlDocumentContext);
        AnnotationDescriptor discriminatorColumnDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(DiscriminatorColumn.class);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbDiscriminatorColumn.getName(), discriminatorColumnAnn);
        AnnotationUsageHelper.applyAttributeIfSpecified("discriminatorType", jaxbDiscriminatorColumn.getDiscriminatorType(), discriminatorColumnAnn);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getColumnDefinition, "columnDefinition", discriminatorColumnAnn, discriminatorColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getOptions, "options", discriminatorColumnAnn, discriminatorColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getLength, "length", discriminatorColumnAnn, discriminatorColumnDescriptor);
        if (jaxbDiscriminatorColumn.isForceSelection() || jaxbDiscriminatorColumn.isInsertable() == Boolean.FALSE) {
            MutableAnnotationUsage<DiscriminatorOptions> optionsAnn = XmlProcessingHelper.getOrMakeAnnotation(DiscriminatorOptions.class, (MutableAnnotationTarget)target, xmlDocumentContext);
            optionsAnn.setAttributeValue("force", (Object)true);
            AnnotationUsageHelper.applyAttributeIfSpecified("insert", jaxbDiscriminatorColumn.isInsertable(), discriminatorColumnAnn);
        }
    }

    public static void applyDiscriminatorFormula(JaxbDiscriminatorFormulaImpl jaxbDiscriminatorFormula, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorFormula == null) {
            return;
        }
        if (StringHelper.isEmpty(jaxbDiscriminatorFormula.getFragment())) {
            return;
        }
        MutableAnnotationUsage<DiscriminatorFormula> discriminatorFormulaAnn = XmlProcessingHelper.getOrMakeAnnotation(DiscriminatorFormula.class, (MutableAnnotationTarget)target, xmlDocumentContext);
        discriminatorFormulaAnn.setAttributeValue("value", (Object)jaxbDiscriminatorFormula.getFragment());
        XmlProcessingHelper.applyAttributeIfSpecified("discriminatorType", jaxbDiscriminatorFormula.getDiscriminatorType(), discriminatorFormulaAnn);
        if (jaxbDiscriminatorFormula.isForceSelection()) {
            MutableAnnotationUsage<DiscriminatorOptions> optionsAnn = XmlProcessingHelper.getOrMakeAnnotation(DiscriminatorOptions.class, (MutableAnnotationTarget)target, xmlDocumentContext);
            optionsAnn.setAttributeValue("force", (Object)true);
        }
    }

    public static String determineTargetName(String explicitName, XmlDocumentContext xmlDocumentContext) {
        String qualifiedName = StringHelper.qualifyConditionallyIfNot(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), explicitName);
        ClassDetails classDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(qualifiedName);
        if (classDetails != null) {
            return classDetails.getName();
        }
        return explicitName;
    }

    public static <T, N, A extends Annotation> void applyOrSchema(JaxbSchemaAware jaxbNode, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOr(jaxbNode, (N table) -> {
            if (StringHelper.isNotEmpty(table.getSchema())) {
                return table.getSchema();
            }
            if (StringHelper.isNotEmpty(XmlAnnotationHelper.defaultSchema(xmlDocumentContext))) {
                return XmlAnnotationHelper.defaultSchema(xmlDocumentContext);
            }
            return null;
        }, "schema", annotationUsage, annotationDescriptor);
    }

    private static String defaultSchema(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getSchema();
    }

    public static <T, N, A extends Annotation> void applyOrCatalog(JaxbSchemaAware jaxbNode, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOr(jaxbNode, (N table) -> {
            if (StringHelper.isNotEmpty(table.getCatalog())) {
                return table.getCatalog();
            }
            if (StringHelper.isNotEmpty(XmlAnnotationHelper.defaultCatalog(xmlDocumentContext))) {
                return XmlAnnotationHelper.defaultCatalog(xmlDocumentContext);
            }
            return null;
        }, "catalog", annotationUsage, annotationDescriptor);
    }

    private static String defaultCatalog(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getCatalog();
    }
}

