/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.boot.internal.AnyKeyType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyDiscriminatorValueMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingDiscriminatorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class AnyMappingAttributeProcessing {
    public static MutableMemberDetails processAnyMappingAttribute(JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbHbmAnyMapping.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbHbmAnyMapping.getName(), accessType, declarer);
        MutableAnnotationUsage<Any> anyAnn = XmlProcessingHelper.makeAnnotation(Any.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbHbmAnyMapping, memberDetails, anyAnn, accessType, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyDiscriminator(memberDetails, jaxbHbmAnyMapping, anyAnn, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyKey(memberDetails, jaxbHbmAnyMapping, anyAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbHbmAnyMapping.getCascade(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static void applyDiscriminator(MutableMemberDetails memberDetails, JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableAnnotationUsage<Any> anyAnn, XmlDocumentContext xmlDocumentContext) {
        List<JaxbAnyDiscriminatorValueMappingImpl> valueMappings;
        JaxbAnyMappingDiscriminatorImpl jaxbDiscriminator = jaxbHbmAnyMapping.getDiscriminator();
        MutableAnnotationUsage<AnyDiscriminator> anyDiscriminatorAnn = XmlProcessingHelper.makeAnnotation(AnyDiscriminator.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        if (jaxbDiscriminator == null) {
            return;
        }
        DiscriminatorType discriminatorType = jaxbDiscriminator.getType();
        XmlProcessingHelper.applyAttributeIfSpecified("value", discriminatorType, anyDiscriminatorAnn);
        JaxbColumnImpl jaxbColumn = jaxbDiscriminator.getColumn();
        MutableAnnotationUsage<Column> columnAnn = XmlProcessingHelper.makeAnnotation(Column.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        if (jaxbColumn != null) {
            ColumnProcessing.applyColumnDetails(jaxbColumn, (MutableAnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
        }
        if (CollectionHelper.isNotEmpty(valueMappings = jaxbDiscriminator.getValueMappings())) {
            MutableAnnotationUsage<AnyDiscriminatorValues> valuesAnn = XmlProcessingHelper.makeAnnotation(AnyDiscriminatorValues.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            ArrayList valueList = CollectionHelper.arrayList(valueMappings.size());
            ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
            valuesAnn.setAttributeValue("value", valueList);
            valueMappings.forEach(valueMapping -> {
                MutableAnnotationUsage<AnyDiscriminatorValue> valueAnn = XmlProcessingHelper.makeNestedAnnotation(AnyDiscriminatorValue.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
                valueList.add(valueAnn);
                valueAnn.setAttributeValue("discriminator", (Object)valueMapping.getDiscriminatorValue());
                String name = StringHelper.qualifyConditionally(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), valueMapping.getCorrespondingEntityName());
                ClassDetails entityClassDetails = classDetailsRegistry.resolveClassDetails(name);
                valueAnn.setAttributeValue("entity", (Object)entityClassDetails);
            });
        }
    }

    private static void applyKey(MutableMemberDetails memberDetails, JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableAnnotationUsage<Any> anyAnn, XmlDocumentContext xmlDocumentContext) {
        JaxbAnyMappingKeyImpl jaxbKey = jaxbHbmAnyMapping.getKey();
        if (StringHelper.isNotEmpty(jaxbKey.getType())) {
            MutableAnnotationUsage<AnyKeyType> keyTypeAnn = XmlProcessingHelper.makeAnnotation(AnyKeyType.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            keyTypeAnn.setAttributeValue("value", (Object)jaxbKey.getType());
        }
        if (jaxbKey.getColumns().isEmpty()) {
            XmlProcessingHelper.makeAnnotation(JoinColumn.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        } else {
            MutableAnnotationUsage<JoinColumns> columnsAnn = XmlProcessingHelper.makeAnnotation(JoinColumns.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            ArrayList columnAnnList = CollectionHelper.arrayList(jaxbKey.getColumns().size());
            columnsAnn.setAttributeValue("value", columnAnnList);
            jaxbKey.getColumns().forEach(jaxbColumn -> {
                MutableAnnotationUsage<JoinColumn> columnAnn = XmlProcessingHelper.makeNestedAnnotation(JoinColumn.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
                columnAnnList.add(columnAnn);
                ColumnProcessing.applyColumnDetails(jaxbColumn, (MutableAnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
            });
        }
    }
}

