/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.OrderBy;
import jakarta.persistence.OrderColumn;
import org.hibernate.annotations.Bag;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SortComparator;
import org.hibernate.annotations.SortNatural;
import org.hibernate.boot.internal.CollectionClassification;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class CommonPluralAttributeProcessing {
    public static void applyPluralAttributeStructure(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext buildingContext = xmlDocumentContext.getModelBuildingContext();
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        if (jaxbPluralAttribute.getFetchMode() != null) {
            MutableAnnotationUsage<Fetch> fetchAnn = XmlProcessingHelper.getOrMakeAnnotation(Fetch.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            fetchAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getFetchMode());
        }
        if (jaxbPluralAttribute.getClassification() != null) {
            MutableAnnotationUsage<CollectionClassification> collectionClassificationAnn = XmlProcessingHelper.getOrMakeAnnotation(CollectionClassification.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            collectionClassificationAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getClassification());
            if (jaxbPluralAttribute.getClassification() == LimitedCollectionClassification.BAG) {
                XmlProcessingHelper.getOrMakeAnnotation(Bag.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            }
        }
        XmlAnnotationHelper.applyCollectionUserType(jaxbPluralAttribute.getCollectionType(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCollectionId(jaxbPluralAttribute.getCollectionId(), memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getOrderBy())) {
            MutableAnnotationUsage<OrderBy> orderByAnn = XmlProcessingHelper.getOrMakeAnnotation(OrderBy.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            orderByAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getOrderBy());
        }
        CommonPluralAttributeProcessing.applyOrderColumn(jaxbPluralAttribute, memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getSort())) {
            MutableAnnotationUsage<SortComparator> sortAnn = XmlProcessingHelper.getOrMakeAnnotation(SortComparator.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            ClassDetails comparatorClassDetails = classDetailsRegistry.resolveClassDetails(jaxbPluralAttribute.getSort());
            sortAnn.setAttributeValue("value", (Object)comparatorClassDetails);
        }
        if (jaxbPluralAttribute.getSortNatural() != null) {
            XmlProcessingHelper.getOrMakeAnnotation(SortNatural.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        }
        if (jaxbPluralAttribute.getMapKey() != null) {
            MutableAnnotationUsage<MapKey> mapKeyAnn = XmlProcessingHelper.getOrMakeAnnotation(MapKey.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            XmlAnnotationHelper.applyOr(jaxbPluralAttribute.getMapKey(), JaxbMapKeyImpl::getName, "name", mapKeyAnn, buildingContext.getAnnotationDescriptorRegistry().getDescriptor(MapKey.class));
        }
        if (jaxbPluralAttribute.getMapKeyClass() != null) {
            String className = xmlDocumentContext.resolveClassName(jaxbPluralAttribute.getMapKeyClass().getClazz());
            ClassDetails mapKeyClass = classDetailsRegistry.resolveClassDetails(className);
            XmlProcessingHelper.getOrMakeAnnotation(MapKeyClass.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("value", (Object)mapKeyClass);
        }
        if (jaxbPluralAttribute.getMapKeyTemporal() != null) {
            XmlProcessingHelper.getOrMakeAnnotation(MapKeyTemporal.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("value", (Object)jaxbPluralAttribute.getMapKeyTemporal());
        }
        if (jaxbPluralAttribute.getMapKeyEnumerated() != null) {
            XmlProcessingHelper.getOrMakeAnnotation(MapKeyEnumerated.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("value", (Object)jaxbPluralAttribute.getMapKeyEnumerated());
        }
        jaxbPluralAttribute.getMapKeyConverts().forEach(jaxbConvert -> XmlAnnotationHelper.applyConvert(jaxbConvert, memberDetails, "key", xmlDocumentContext));
        ColumnProcessing.applyMapKeyColumn(jaxbPluralAttribute.getMapKeyColumn(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyMapKeyJoinColumns(jaxbPluralAttribute.getMapKeyJoinColumns(), memberDetails, xmlDocumentContext);
        ForeignKeyProcessing.applyForeignKey(jaxbPluralAttribute.getMapKeyForeignKey(), memberDetails, xmlDocumentContext);
        jaxbPluralAttribute.getFilters().forEach(jaxbFilter -> XmlAnnotationHelper.applyFilter(jaxbFilter, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        XmlAnnotationHelper.applySqlRestriction(jaxbPluralAttribute.getSqlRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlInsert(), (MutableAnnotationTarget)memberDetails, SQLInsert.class, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlUpdate(), (MutableAnnotationTarget)memberDetails, SQLUpdate.class, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDelete(), (MutableAnnotationTarget)memberDetails, SQLDelete.class, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDeleteAll(), (MutableAnnotationTarget)memberDetails, SQLDeleteAll.class, xmlDocumentContext);
    }

    private static void applyOrderColumn(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbOrderColumnImpl jaxbOrderColumn = jaxbPluralAttribute.getOrderColumn();
        if (jaxbOrderColumn == null) {
            return;
        }
        MutableAnnotationUsage<OrderColumn> orderColumnAnn = XmlProcessingHelper.getOrMakeAnnotation(OrderColumn.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        AnnotationDescriptor orderColumnDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(OrderColumn.class);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::getName, "name", orderColumnAnn, orderColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::isNullable, "nullable", orderColumnAnn, orderColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::isInsertable, "insertable", orderColumnAnn, orderColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::isUpdatable, "updatable", orderColumnAnn, orderColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::getColumnDefinition, "columnDefinition", orderColumnAnn, orderColumnDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOrderColumn, JaxbOrderColumnImpl::getOptions, "options", orderColumnAnn, orderColumnDescriptor);
    }
}

