/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.Embedded;
import org.hibernate.boot.internal.Target;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class EmbeddedAttributeProcessing {
    public static MutableMemberDetails processEmbeddedAttribute(JaxbEmbeddedImpl jaxbEmbedded, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbEmbedded.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbEmbedded.getName(), accessType, declarer);
        MutableAnnotationUsage<Embedded> embeddedAnn = XmlProcessingHelper.getOrMakeAnnotation(Embedded.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbEmbedded.getTarget())) {
            MutableAnnotationUsage<Target> targetAnn = XmlProcessingHelper.getOrMakeAnnotation(Target.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            targetAnn.setAttributeValue("value", (Object)XmlAnnotationHelper.determineTargetName(jaxbEmbedded.getTarget(), xmlDocumentContext));
        }
        CommonAttributeProcessing.applyAttributeBasics(jaxbEmbedded, memberDetails, embeddedAnn, accessType, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbEmbedded.getAttributeOverrides(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAssociationOverrides(jaxbEmbedded.getAssociationOverrides(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

