/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.ManyToMany;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ManyToManyAttributeProcessing {
    public static MutableMemberDetails processManyToManyAttribute(JaxbManyToManyImpl jaxbManyToMany, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbManyToMany.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbManyToMany.getName(), accessType, declarer);
        MutableAnnotationUsage<ManyToMany> manyToManyAnn = ManyToManyAttributeProcessing.applyManyToMany(jaxbManyToMany, memberDetails, xmlDocumentContext);
        ManyToManyAttributeProcessing.applyTargetEntity(jaxbManyToMany, manyToManyAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbManyToMany.getCascade(), memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbManyToMany, memberDetails, manyToManyAnn, accessType, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbManyToMany, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbManyToMany.getMapKeyAttributeOverrides(), memberDetails, "key", xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbManyToMany.getJoinTable(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlJoinTableRestriction(jaxbManyToMany.getSqlJoinTableRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        jaxbManyToMany.getJoinTableFilters().forEach(jaxbFilter -> XmlAnnotationHelper.applyJoinTableFilter(jaxbFilter, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        return memberDetails;
    }

    private static MutableAnnotationUsage<ManyToMany> applyManyToMany(JaxbManyToManyImpl jaxbManyToMany, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<ManyToMany> manyToManyAnn = XmlProcessingHelper.getOrMakeAnnotation(ManyToMany.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        AnnotationDescriptor manyToManyDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(ManyToMany.class);
        XmlAnnotationHelper.applyOr(jaxbManyToMany, JaxbManyToManyImpl::getFetch, "fetch", manyToManyAnn, manyToManyDescriptor);
        XmlAnnotationHelper.applyOr(jaxbManyToMany, JaxbManyToManyImpl::getMappedBy, "mappedBy", manyToManyAnn, manyToManyDescriptor);
        return manyToManyAnn;
    }

    private static void applyTargetEntity(JaxbManyToManyImpl jaxbManyToMany, MutableAnnotationUsage<ManyToMany> manyToManyAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntity = jaxbManyToMany.getTargetEntity();
        if (StringHelper.isNotEmpty(targetEntity)) {
            manyToManyAnn.setAttributeValue("targetEntity", (Object)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(targetEntity));
        }
    }
}

