/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.OneToMany;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class OneToManyAttributeProcessing {
    public static MutableMemberDetails processOneToManyAttribute(JaxbOneToManyImpl jaxbOneToMany, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbOneToMany.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbOneToMany.getName(), accessType, declarer);
        MutableAnnotationUsage<OneToMany> oneToManyAnn = OneToManyAttributeProcessing.applyOneToMany(jaxbOneToMany, memberDetails, xmlDocumentContext);
        OneToManyAttributeProcessing.applyTargetEntity(jaxbOneToMany, oneToManyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbOneToMany, memberDetails, oneToManyAnn, accessType, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbOneToMany, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbOneToMany.getCascade(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOneToMany.getMapKeyAttributeOverrides(), memberDetails, "key", xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbOneToMany.getJoinTable(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlJoinTableRestriction(jaxbOneToMany.getSqlJoinTableRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        jaxbOneToMany.getJoinTableFilters().forEach(jaxbFilter -> XmlAnnotationHelper.applyJoinTableFilter(jaxbFilter, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        jaxbOneToMany.getJoinColumn().forEach(jaxbJoinColumn -> XmlAnnotationHelper.applyJoinColumn(jaxbJoinColumn, memberDetails, xmlDocumentContext));
        if (jaxbOneToMany.getOnDelete() != null) {
            XmlProcessingHelper.getOrMakeAnnotation(OnDelete.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("action", (Object)jaxbOneToMany.getOnDelete());
        }
        if (jaxbOneToMany.getNotFound() != null && jaxbOneToMany.getNotFound() != NotFoundAction.EXCEPTION) {
            XmlProcessingHelper.getOrMakeAnnotation(NotFound.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext).setAttributeValue("action", (Object)jaxbOneToMany.getNotFound());
        }
        return memberDetails;
    }

    private static MutableAnnotationUsage<OneToMany> applyOneToMany(JaxbOneToManyImpl jaxbOneToMany, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<OneToMany> oneToManyAnn = XmlProcessingHelper.getOrMakeAnnotation(OneToMany.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        AnnotationDescriptor oneToManyDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(OneToMany.class);
        XmlAnnotationHelper.applyOr(jaxbOneToMany, JaxbOneToManyImpl::getFetch, "fetch", oneToManyAnn, oneToManyDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOneToMany, JaxbOneToManyImpl::getMappedBy, "mappedBy", oneToManyAnn, oneToManyDescriptor);
        XmlAnnotationHelper.applyOr(jaxbOneToMany, JaxbOneToManyImpl::isOrphanRemoval, "orphanRemoval", oneToManyAnn, oneToManyDescriptor);
        return oneToManyAnn;
    }

    private static void applyTargetEntity(JaxbOneToManyImpl jaxbOneToMany, MutableAnnotationUsage<OneToMany> oneToManyAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntity = jaxbOneToMany.getTargetEntity();
        if (StringHelper.isNotEmpty(targetEntity)) {
            oneToManyAnn.setAttributeValue("targetEntity", (Object)xmlDocumentContext.resolveJavaType(targetEntity));
        }
    }
}

