/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.OneToOne;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class OneToOneAttributeProcessing {
    public static MutableMemberDetails processOneToOneAttribute(JaxbOneToOneImpl jaxbOneToOne, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbOneToOne.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbOneToOne.getName(), accessType, declarer);
        MutableAnnotationUsage<OneToOne> oneToOneAnn = OneToOneAttributeProcessing.applyOneToOne(memberDetails, jaxbOneToOne, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbOneToOne, memberDetails, oneToOneAnn, accessType, xmlDocumentContext);
        OneToOneAttributeProcessing.applyTarget(memberDetails, jaxbOneToOne, oneToOneAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbOneToOne.getCascade(), memberDetails, xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbOneToOne.getJoinTable(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumns(jaxbOneToOne.getJoinColumn(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyPrimaryKeyJoinColumns(jaxbOneToOne.getPrimaryKeyJoinColumn(), memberDetails, xmlDocumentContext);
        if (jaxbOneToOne.isId() == Boolean.TRUE) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.ID, xmlDocumentContext.getModelBuildingContext());
        }
        if (StringHelper.isNotEmpty(jaxbOneToOne.getMapsId())) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.MAPS_ID, usage -> usage.setAttributeValue("value", (Object)jaxbOneToOne.getMapsId()), xmlDocumentContext.getModelBuildingContext());
        }
        return memberDetails;
    }

    private static MutableAnnotationUsage<OneToOne> applyOneToOne(MutableMemberDetails memberDetails, JaxbOneToOneImpl jaxbOneToOne, XmlDocumentContext xmlDocumentContext) {
        return memberDetails.applyAnnotationUsage(JpaAnnotations.ONE_TO_ONE, usage -> {
            if (jaxbOneToOne.getFetch() != null) {
                usage.setAttributeValue("fetch", (Object)jaxbOneToOne.getFetch());
            }
            if (jaxbOneToOne.isOptional() != null) {
                usage.setAttributeValue("optional", (Object)jaxbOneToOne.isOptional());
            }
            if (StringHelper.isNotEmpty(jaxbOneToOne.getMappedBy())) {
                usage.setAttributeValue("mappedBy", (Object)jaxbOneToOne.getMappedBy());
            }
            if (jaxbOneToOne.isOrphanRemoval() != null) {
                usage.setAttributeValue("orphanRemoval", (Object)jaxbOneToOne.isOrphanRemoval());
            }
        }, xmlDocumentContext.getModelBuildingContext());
    }

    private static void applyTarget(MutableMemberDetails memberDetails, JaxbOneToOneImpl jaxbOneToOne, MutableAnnotationUsage<OneToOne> oneToOneAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntityName = jaxbOneToOne.getTargetEntity();
        if (StringHelper.isEmpty(targetEntityName)) {
            return;
        }
        MutableAnnotationUsage targetUsage = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        String targetName = XmlAnnotationHelper.determineTargetName(targetEntityName, xmlDocumentContext);
        targetUsage.setAttributeValue("value", (Object)targetName);
    }
}

