/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.MapKeyColumn;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbCheckable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumn;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnCommon;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnDefinable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnMutable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnNullable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnSizable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnStandard;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnUniqueable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbCommentable;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;

public class ColumnProcessing {
    public static <A extends Annotation> void applyColumnDetails(JaxbColumnCommon jaxbColumn, MutableAnnotationTarget target, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        ColumnProcessing.applyColumnBasics(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnNullness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnMutability(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnDefinition(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnUniqueness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnComment(jaxbColumn, columnAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCheckConstraints(jaxbColumn, target, columnAnn, xmlDocumentContext);
        if (jaxbColumn instanceof JaxbColumnSizable) {
            JaxbColumnSizable sizable = (JaxbColumnSizable)((Object)jaxbColumn);
            ColumnProcessing.applyColumnSizing(sizable, columnAnn, xmlDocumentContext);
        }
    }

    public static <A extends Annotation> void applyColumnDetails(JaxbColumnCommon jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        ColumnProcessing.applyColumnBasics(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnNullness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnMutability(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnDefinition(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnUniqueness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnComment(jaxbColumn, columnAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCheckConstraints(jaxbColumn, columnAnn, xmlDocumentContext);
        if (jaxbColumn instanceof JaxbColumnSizable) {
            JaxbColumnSizable sizable = (JaxbColumnSizable)((Object)jaxbColumn);
            ColumnProcessing.applyColumnSizing(sizable, columnAnn, xmlDocumentContext);
        }
    }

    public static <A extends Annotation> void applyColumnDetails(JaxbColumnStandard jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        ColumnProcessing.applyColumnBasics(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnNullness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnMutability(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnDefinition(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnSizing(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnUniqueness(jaxbColumn, columnAnn, xmlDocumentContext);
        ColumnProcessing.applyColumnComment(jaxbColumn, columnAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCheckConstraints(jaxbColumn, columnAnn, xmlDocumentContext);
    }

    public static <A extends Annotation> void applyColumnDetails(JaxbColumn jaxbColumn, MutableAnnotationTarget target, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        ColumnProcessing.applyColumnBasics(jaxbColumn, columnAnn, xmlDocumentContext);
        if (jaxbColumn instanceof JaxbColumnNullable) {
            JaxbColumnNullable nullable = (JaxbColumnNullable)jaxbColumn;
            ColumnProcessing.applyColumnNullness(nullable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbColumnMutable) {
            JaxbColumnMutable mutable = (JaxbColumnMutable)jaxbColumn;
            ColumnProcessing.applyColumnMutability(mutable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbColumnDefinable) {
            JaxbColumnDefinable definable = (JaxbColumnDefinable)jaxbColumn;
            ColumnProcessing.applyColumnDefinition(definable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbColumnSizable) {
            JaxbColumnSizable sizable = (JaxbColumnSizable)jaxbColumn;
            ColumnProcessing.applyColumnSizing(sizable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbColumnUniqueable) {
            JaxbColumnUniqueable uniqueable = (JaxbColumnUniqueable)jaxbColumn;
            ColumnProcessing.applyColumnUniqueness(uniqueable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbCommentable) {
            JaxbCommentable commentable = (JaxbCommentable)((Object)jaxbColumn);
            ColumnProcessing.applyColumnComment(commentable, columnAnn, xmlDocumentContext);
        }
        if (jaxbColumn instanceof JaxbCheckable) {
            JaxbCheckable checkable = (JaxbCheckable)((Object)jaxbColumn);
            XmlAnnotationHelper.applyCheckConstraints(checkable, target, columnAnn, xmlDocumentContext);
        }
    }

    private static <A extends Annotation> void applyColumnBasics(JaxbColumn jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbColumn.getName(), columnAnn);
        AnnotationUsageHelper.applyStringAttributeIfSpecified("table", jaxbColumn.getTable(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnNullness(JaxbColumnNullable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("nullable", jaxbColumn.isNullable(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnMutability(JaxbColumnMutable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("insertable", jaxbColumn.isInsertable(), columnAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("updatable", jaxbColumn.isUpdatable(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnSizing(JaxbColumnSizable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("length", jaxbColumn.getLength(), columnAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("precision", jaxbColumn.getPrecision(), columnAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("scale", jaxbColumn.getScale(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnUniqueness(JaxbColumnUniqueable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("unique", jaxbColumn.isUnique(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnDefinition(JaxbColumnDefinable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("columnDefinition", jaxbColumn.getColumnDefinition(), columnAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("options", jaxbColumn.getOptions(), columnAnn);
    }

    private static <A extends Annotation> void applyColumnComment(JaxbCommentable jaxbColumn, MutableAnnotationUsage<A> columnAnn, XmlDocumentContext xmlDocumentContext) {
        XmlProcessingHelper.applyAttributeIfSpecified("comment", jaxbColumn.getComment(), columnAnn);
    }

    public static void applyMapKeyColumn(JaxbMapKeyColumnImpl jaxbMapKeyColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbMapKeyColumn == null) {
            return;
        }
        MutableAnnotationUsage<MapKeyColumn> columnAnn = XmlProcessingHelper.getOrMakeAnnotation(MapKeyColumn.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        ColumnProcessing.applyColumnDetails(jaxbMapKeyColumn, (MutableAnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
    }
}

