/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbForeignKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbColumnJoined;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;

public class JoinColumnProcessing {
    public static void applyMapKeyJoinColumns(List<JaxbMapKeyJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        if (jaxbJoinColumns.size() == 1) {
            MutableAnnotationUsage joinColumnUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_JOIN_COLUMN, xmlDocumentContext.getModelBuildingContext());
            JoinColumnProcessing.transferJoinColumn(jaxbJoinColumns.get(0), (MutableAnnotationUsage<? extends Annotation>)joinColumnUsage, memberDetails, xmlDocumentContext);
        } else {
            MutableAnnotationUsage joinColumnsUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
            ArrayList joinColumnUsages = CollectionHelper.arrayList(jaxbJoinColumns.size());
            joinColumnsUsage.setAttributeValue("value", joinColumnUsages);
            jaxbJoinColumns.forEach(jaxbJoinColumn -> {
                MutableAnnotationUsage joinColumnUsage = JpaAnnotations.MAP_KEY_JOIN_COLUMN.createUsage((AnnotationTarget)memberDetails, xmlDocumentContext.getModelBuildingContext());
                joinColumnUsages.add(joinColumnUsage);
                JoinColumnProcessing.transferJoinColumn(jaxbJoinColumn, (MutableAnnotationUsage<? extends Annotation>)joinColumnUsage, memberDetails, xmlDocumentContext);
            });
        }
    }

    public static void applyPrimaryKeyJoinColumns(List<JaxbPrimaryKeyJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        MutableAnnotationUsage columnsUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.PRIMARY_KEY_JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
        ArrayList columnUsages = CollectionHelper.arrayList(jaxbJoinColumns.size());
        columnsUsage.setAttributeValue("value", columnUsages);
        jaxbJoinColumns.forEach(jaxbJoinColumn -> {
            MutableAnnotationUsage columnUsage = JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN.createUsage((AnnotationTarget)memberDetails, xmlDocumentContext.getModelBuildingContext());
            columnUsages.add(columnUsage);
            JoinColumnProcessing.transferJoinColumn(jaxbJoinColumn, (MutableAnnotationUsage<? extends Annotation>)columnUsage, memberDetails, xmlDocumentContext);
        });
    }

    public static void transferJoinColumn(JaxbColumnJoined jaxbJoinColumn, MutableAnnotationUsage<? extends Annotation> joinColumnUsage, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ColumnProcessing.applyColumnDetails(jaxbJoinColumn, (MutableAnnotationTarget)memberDetails, joinColumnUsage, xmlDocumentContext);
        XmlAnnotationHelper.applyOptionalAttribute(joinColumnUsage, "referencedColumnName", jaxbJoinColumn.getReferencedColumnName());
        JaxbForeignKeyImpl jaxbForeignKey = jaxbJoinColumn.getForeignKey();
        if (jaxbForeignKey != null) {
            joinColumnUsage.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbForeignKey, (MemberDetails)memberDetails, xmlDocumentContext));
        }
    }

    public static List<AnnotationUsage<JoinColumn>> transformJoinColumnList(List<JaxbJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUsage<JoinColumn>> joinColumns = new ArrayList<AnnotationUsage<JoinColumn>>(jaxbJoinColumns.size());
        jaxbJoinColumns.forEach(jaxbJoinColumn -> {
            MutableAnnotationUsage joinColumnAnn = JpaAnnotations.JOIN_COLUMN.createUsage((AnnotationTarget)memberDetails, xmlDocumentContext.getModelBuildingContext());
            JoinColumnProcessing.transferJoinColumn(jaxbJoinColumn, (MutableAnnotationUsage<? extends Annotation>)joinColumnAnn, null, xmlDocumentContext);
            joinColumns.add((AnnotationUsage<JoinColumn>)joinColumnAnn);
        });
        return joinColumns;
    }

    public static <A extends Annotation> MutableAnnotationUsage<A> createJoinColumnAnnotation(JaxbColumnJoined jaxbJoinColumn, MutableMemberDetails memberDetails, Class<A> annotationType, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage<A> joinColumnAnn = XmlProcessingHelper.getOrMakeNamedAnnotation(annotationType, jaxbJoinColumn.getName(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        JoinColumnProcessing.transferJoinColumn(jaxbJoinColumn, joinColumnAnn, memberDetails, xmlDocumentContext);
        return joinColumnAnn;
    }

    public static List<AnnotationUsage<JoinColumn>> createJoinColumns(List<JaxbJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUsage<JoinColumn>> joinColumns = new ArrayList<AnnotationUsage<JoinColumn>>(jaxbJoinColumns.size());
        jaxbJoinColumns.forEach(jaxbJoinColumn -> {
            MutableAnnotationUsage joinColumnUsage = JpaAnnotations.JOIN_COLUMN.createUsage((AnnotationTarget)memberDetails, xmlDocumentContext.getModelBuildingContext());
            JoinColumnProcessing.transferJoinColumn(jaxbJoinColumn, (MutableAnnotationUsage<? extends Annotation>)joinColumnUsage, memberDetails, xmlDocumentContext);
            joinColumns.add((AnnotationUsage<JoinColumn>)joinColumnUsage);
        });
        return joinColumns;
    }

    public static void applyJoinColumns(List<JaxbJoinColumnImpl> jaxbJoinColumns, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbJoinColumns)) {
            return;
        }
        if (jaxbJoinColumns.size() == 1) {
            XmlAnnotationHelper.applyJoinColumn(jaxbJoinColumns.get(0), memberDetails, xmlDocumentContext);
        } else {
            MutableAnnotationUsage<JoinColumns> columnsAnn = XmlProcessingHelper.makeAnnotation(JoinColumns.class, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
            columnsAnn.setAttributeValue("value", JoinColumnProcessing.createJoinColumns(jaxbJoinColumns, memberDetails, xmlDocumentContext));
        }
    }
}

